/****************************************************************************
*  Copyright (C) 1996-99 by Leo Khramov
*  email:     leo@xnc.dubna.su
*  
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
*  GNU General Public License for more details.
 ****************************************************************************/
/* $Id: panel.cxx,v 1.9 2000/12/13 13:27:41 leo Exp $ */
#include "panel.h"
#include "au/key.h"
#include "au/x_actions.h"
#include "au/au_sup.h"
#include "bookmark.h"
#include "dndtypes.h"
#include "query_windows.h"
#include "infowin.h"
#include "ftpfs.h"
#include "commonfuncs.h"
#include "systemfuncs.h"
#include "ftpcfg.h"
#include "c_externs.h"
#include "internals.h"

const Time DBLCLICK = 250;

const int DIRCOL = 7;
const int EXECOL = 8;
const int NORMCOL = 6;
const int SELECTCOL = 5;
const int EXTCOL = 9;
const int LINKCOL = 10;
const int AFSCOL = 11;


extern void try_clean_afs_cache();


Pixmap panelpixs[6]={0,0,0,0,0,0};
Pixmap panelpixmask[6];
int    panelpixl[6];
int    panelpixh[6];


Lister *dnd_creator = NULL;
int    dnd_startx = -10, dnd_starty = -10;
int    dnd_start_valid=0;
long   dnd_startm;
int    dnd_enabled = 0;

int    just_at_startup = 1;

extern int qvflag;

extern int evret, vt_show;
extern Window main_win;
extern int focus_fl;
extern void donefunc();



char  *panlist[2000];
char  *panlist2[1000];
int    psmax = 0;


///////////////////////////////////Lister class///////////////////////////////


void   Lister::delall_l(FList * n)
{
}

//----------------------------------------------------------------------------
// Insert given string into terminal and commandline widget
//----------------------------------------------------------------------------
void Lister::cmdl_insert_name(char *name)
{
  char *n2=name;
  char term[]=" ;()[]<>'?\"|*&^%$#@!`";
  while (*n2 != 0)
    if(strchr(term, *n2))
    {
      cmdl->insert('\'');
      n2=name;
      while(*n2)
	cmdl->insert(*n2++);
      tt_printf("'%s'", name);
      cmdl->insert('\'');
      return;
    } else n2++;
  n2=name;
  while(*n2)
    cmdl->insert(*n2++);
  tt_printf("%s", name);
}

//----------------------------------------------------------------------------
// Init class, create windows, texts....
//----------------------------------------------------------------------------
void   Lister::init(Window ipar)
{
  foc = 0;
  refindchr[0] = 0;
  XWindowAttributes xwa;
  XSetWindowAttributes xswa;
  parent = ipar;
  w = XCreateSimpleWindow(disp, parent, x, y, l, h, 0, 0, keyscol[1]);
  gcv.background = keyscol[1];
  gcv.font = fixfontstr->fid;
  gcw = XCreateGC(disp, w, GCBackground | GCFont, &gcv);
  fgc = XCreateGC(disp, w, GCBackground | GCFont, &gcv);
  gcv.font = lfontstr->fid;
  wgcw = XCreateGC(disp, w, GCBackground | GCFont, &gcv);
  xpmgc = XCreateGC(disp, w, 0, NULL);
  if (XGetWindowAttributes(disp, w, &xwa) != 0)
  {
    xswa.do_not_propagate_mask = xwa.do_not_propagate_mask | ButtonPressMask |
      KeyPressMask;
    XChangeWindowAttributes(disp, w, CWDontPropagate, &xswa);
  }
  else
  {
    xncdprintf(("Propagation failed\n"));
  }
  XSelectInput(disp, w, ExposureMask | ButtonPressMask | ButtonReleaseMask | 
               PointerMotionMask |
               KeyPressMask |
               FocusChangeMask | StructureNotifyMask);
  fattr1 = XTextWidth(lfontstr, "-rwxrwxrwx", 9);
  attdx = 8 + (43 - XTextWidth(fixfontstr, "0000", 4)) / 2;
  repanel(col);
  foc = 0;

  init_dnd();

  scr=new ScrollBar(l-24,28,h-28-35,this);
  scr->setrange(0,10);
  scr->init(w);

}

//----------------------------------------------------------------------------
// Recalc all sizes according to new one (resize windows event)
//----------------------------------------------------------------------------
void   Lister::repanel(int ic)
{
  col = ic;
  tdl = lfontstr->max_bounds.ascent - lfontstr->max_bounds.descent + 8;
  prflg = 0;
  //  th = (h - 60 - deltahead) / tdl;
  th = (h - 60) / tdl;
  pl = (l - 14) / col;
  rect.x = 0;
  rect.y = 30;
  rect.width = pl - 8;
  rect.height = h - 65;
  XSetClipRectangles(disp, wgcw, 0, 0, &rect, 1, Unsorted);
  rect2.x = 55;
  rect2.y = h - 29;
  rect2.width = l - 110;
  rect2.height = 20;
  XSetClipRectangles(disp, fgc, 0, 0, &rect2, 1, Unsorted);
  lastn = -1;
  lcurn = 0;
  fixl = XTextWidth(fixfontstr,"M",1);
  fixh = fixfontstr->max_bounds.ascent - fixfontstr->max_bounds.descent;
  fixy = fixfontstr->max_bounds.ascent;
  if (curn > 0)
    curn = 0;
  base = cur = dl.next;
  calc_statusbar_offsets();
}


//----------------------------------------------------------------------------
// Calculate offsets for status bar info
//----------------------------------------------------------------------------
void Lister::calc_statusbar_offsets()
{
  int stlx, stll;
  stlx=7;
  stll=l-17-STL_H-STL_H;
  if(option_bits & STATUS_ATTR)
  {
    STL_ATTR_PTR.x=stlx;
    STL_ATTR_PTR.y=h-8-STL_H;
    STL_ATTR_PTR.ty=h-STL_H-3+fixy;
    STL_ATTR_PTR.tx=STL_ATTR_PTR.x+STL_SPACE2+1;
    STL_ATTR_PTR.tlen=STL_ATTR_NCHAR;
    STL_ATTR_PTR.len=STL_ATTR_NCHAR*fixl+STL_SPACE;
    stlx+=STL_ATTR_NCHAR*fixl+STL_SPACE+1;
    stll-=STL_ATTR_NCHAR*fixl+STL_SPACE+1;
  }
  if(stll<0)
    stll=0;
  if(option_bits & STATUS_SIZE)
  {
    STL_SIZE_PTR.x=stlx+stll-STL_SIZE_NCHAR*fixl-STL_SPACE;
    STL_SIZE_PTR.y=h-8-STL_H;
    STL_SIZE_PTR.ty=h-STL_H-3+fixy;
    STL_SIZE_PTR.tx=STL_SIZE_PTR.x+STL_SPACE2+1;
    STL_SIZE_PTR.tlen=STL_SIZE_NCHAR;
    STL_SIZE_PTR.len=STL_SIZE_NCHAR*fixl+STL_SPACE;
    stll-=STL_SIZE_NCHAR*fixl+STL_SPACE+1;
    if(stll<0)
      option_bits&=~STATUS_SIZE;
  }
  if(stll<0)
    stll=0;
  if(option_bits & STATUS_TIME)
  {
    STL_TIME_PTR.x=stlx+stll-STL_TIME_NCHAR*fixl-STL_SPACE;
    STL_TIME_PTR.y=h-8-STL_H;
    STL_TIME_PTR.ty=h-STL_H-3+fixy;
    STL_TIME_PTR.tx=STL_TIME_PTR.x+STL_SPACE2+1;
    STL_TIME_PTR.tlen=STL_TIME_NCHAR;
    STL_TIME_PTR.len=STL_TIME_NCHAR*fixl+STL_SPACE;
    stll-=STL_TIME_NCHAR*fixl+STL_SPACE+1;
    if(stll<0)
      option_bits&=~STATUS_TIME;
  }
  if(stll<0)
    stll=0;
  if(option_bits & STATUS_OWNER)
  {
    STL_OWNER_PTR.x=stlx+stll-STL_OWNER_NCHAR*fixl-STL_SPACE;
    STL_OWNER_PTR.y=h-8-STL_H;
    STL_OWNER_PTR.ty=h-STL_H-3+fixy;
    STL_OWNER_PTR.tx=STL_OWNER_PTR.x+STL_SPACE2+1;
    STL_OWNER_PTR.tlen=STL_OWNER_NCHAR;
    STL_OWNER_PTR.len=STL_OWNER_NCHAR*fixl+STL_SPACE;
    stll-=STL_OWNER_NCHAR*fixl+STL_SPACE+1;
    if(stll<0)
      option_bits&=~STATUS_OWNER;
  }
  if(stll<0)
    stll=0;
  if(option_bits & STATUS_NAME)
  {
    STL_NAME_PTR.x=stlx;
    STL_NAME_PTR.y=h-8-STL_H;
    STL_NAME_PTR.tx=STL_NAME_PTR.x+STL_SPACE2+1;
    STL_NAME_PTR.ty=h-STL_H-3+fixy;
    STL_NAME_PTR.tlen=(stll-STL_SPACE)/fixl;
    STL_NAME_PTR.len=stll;
  }
}

//----------------------------------------------------------------------------
// Calls when ConfigureNotify event appears
//----------------------------------------------------------------------------
void   Lister::reconfigure(int ix, int iy, int il, int ih)
{
  x = ix;
  y = iy;
  l = il;
  h = ih;
  XMoveWindow(disp, w, x, y);
  XResizeWindow(disp, w, l, h);
  repanel(col);
  expose();
}

//----------------------------------------------------------------------------
// Same as above but don't redraw window contents 
//----------------------------------------------------------------------------
void   Lister::reconfigure_without_expose(int ix, int iy, int il, int ih)
{
  x = ix;
  y = iy;
  l = il;
  h = ih;
  XMoveWindow(disp, w, x, y);
  XResizeWindow(disp, w, l, h);
  repanel(col);
}

//----------------------------------------------------------------------------
// Draw header of Panel
//----------------------------------------------------------------------------
void   drawhead(Window w, GC gcw, int x, int y, int l, int h, int fl = 0)
{
    XSetForeground(disp, gcw, keyscol[2]);
    XDrawLine(disp, w, gcw, x, y + h, x, y + 5);
    XDrawLine(disp, w, gcw, x, y + 5, x + 5, y);
    XDrawLine(disp, w, gcw, x + 5, y, x + l - 5, y);
    if (fl)
    {
      XDrawLine(disp, w, gcw, x + 1, y + h + 1, x + 1, y + 5);
      XDrawLine(disp, w, gcw, x + 1, y + 5, x + 5, y + 1);
      XDrawLine(disp, w, gcw, x + 5, y + 1, x + l - 5, y + 1);
    }
    XSetForeground(disp, gcw, keyscol[0]);
    XDrawLine(disp, w, gcw, x + l - 5, y, x + l, y + 5);
    XDrawLine(disp, w, gcw, x + l, y + 5, x + l, y + h);
    if (fl)
    {
      XDrawLine(disp, w, gcw, x + l - 5, y + 1, x + l - 1, y + 5);
      XDrawLine(disp, w, gcw, x + l - 1, y + 5, x + l - 1, y + h + 1);
      XSetForeground(disp, gcw, cols[0]);
      XDrawLine(disp, w, gcw, x + l - 3, y + 1, x + l + 1, y + 5);
      XDrawLine(disp, w, gcw, x + l + 1, y + 6, x + l + 1, y + h - 1);
    }
}


//----------------------------------------------------------------------------
// Draw entire widget, make directory reread if need
//----------------------------------------------------------------------------
void   Lister::expose()
{
  int    i, px, lx = l / 2 + 15, l2 = l / 2;
  int    lx2 = l2 - 15;
  char  *cdir = panel2->vfs->get_dir_header();
  int    sl = strlen(cdir), vl, fl;
  fl = (l - 88) / 2;
  vl = fl / fixl;
  int    dl = 0;
  if (sl > vl)
    dl = sl - vl;
  vl = sl - dl;
  XSetForeground(disp, gcw, keyscol[2]);
  XDrawLine(disp, w, gcw, 3, h - 4, l - 4, h - 4);
  XDrawLine(disp, w, gcw, 4, h - 5, l - 5, h - 5);
  switch (lay)
  {
  case 0:
    XDrawLine(disp, w, gcw, 0, 0, 0, h);
    XDrawLine(disp, w, gcw, 1, 1, 1, h - 1);
    XDrawLine(disp, w, gcw, 0, 0, l, 0);
    XDrawLine(disp, w, gcw, 1, 1, l - 1, 1);
    XDrawLine(disp, w, gcw, l - 4, 3, l - 4, h - 4);
    XDrawLine(disp, w, gcw, l - 5, 4, l - 5, h - 5);
    break;
  case 1:
    XDrawLine(disp, w, gcw, 0, 10, 0, h);
    XDrawLine(disp, w, gcw, 1, 11, 1, h - 1);
    XDrawLine(disp, w, gcw, lx, 25, l, 25);
    XDrawLine(disp, w, gcw, lx - 1, 26, l - 1, 26);
    XDrawLine(disp, w, gcw, l - 4, 27, l - 4, h - 4);
    XDrawLine(disp, w, gcw, l - 5, 28, l - 5, h - 5);
    break;
  case 2:
    XDrawLine(disp, w, gcw, 0, 26, 0, h);
    XDrawLine(disp, w, gcw, 1, 11, 1, h - 1);
    XDrawLine(disp, w, gcw, 0, 25, lx2, 25);
    XDrawLine(disp, w, gcw, 1, 26, lx2 + 1, 26);
    XDrawLine(disp, w, gcw, l - 4, 27, l - 4, h - 4);
    XDrawLine(disp, w, gcw, l - 5, 28, l - 5, h - 5);
    break;
  };
  XSetForeground(disp, gcw, keyscol[0]);
  XDrawLine(disp, w, gcw, 0, h - 1, l, h - 1);
  XDrawLine(disp, w, gcw, 1, h - 2, l - 1, h - 2);
  switch (lay)
  {
  case 0:
    XDrawLine(disp, w, gcw, l - 1, 0, l - 1, h);
    XDrawLine(disp, w, gcw, l - 2, 1, l - 2, h - 1);
    XDrawLine(disp, w, gcw, 3, 3, l - 4, 3);
    XDrawLine(disp, w, gcw, 3, 3, 3, h - 4);
    XDrawLine(disp, w, gcw, 4, 4, l - 5, 4);
    XDrawLine(disp, w, gcw, 4, 4, 4, h - 5);
    break;
  case 1:
    XDrawLine(disp, w, gcw, l - 1, 25, l - 1, h);
    XDrawLine(disp, w, gcw, l - 2, 26, l - 2, h - 1);
    XDrawLine(disp, w, gcw, 3, 27, l - 4, 27);
    XDrawLine(disp, w, gcw, 3, 27, 3, h - 4);
    XDrawLine(disp, w, gcw, 4, 28, l - 5, 28);
    XDrawLine(disp, w, gcw, 4, 28, 4, h - 5);
    drawhead(w, gcw, lx - 10, 2, l / 2 - 8, 22);
    /*XFR
      XSetForeground(disp, gcw, keyscol[1]);
      XFillRectangle(disp, w, gcw, 2, 3, lx - 6, 23);
    */
    XClearArea(disp, w, 2, 3, lx - 6, 23, 0);
    drawhead(w, gcw, 0, 0, lx, 25, 1);
    /*XFR
      XSetForeground(disp, gcw, keyscol[1]);
      XFillRectangle(disp, w, gcw, l2 + 30, 8, l2 - 35, 17);
    */
    XClearArea(disp, w, l2 + 30, 8, l2 - 35, 17, 0);
    if(shadow)
    {
      XSetForeground(disp, gcw, cols[0]);
      XDrawString(disp, w, gcw, l2 + 31, 22, cdir + dl, vl);
    }
    XSetForeground(disp, gcw, keyscol[0]);
    XDrawString(disp, w, gcw, l2 + 30, 21, cdir + dl, vl);
    break;
  case 2:
    XDrawLine(disp, w, gcw, l - 1, 25, l - 1, h);
    XDrawLine(disp, w, gcw, l - 2, 26, l - 2, h - 1);
    XDrawLine(disp, w, gcw, 3, 27, l - 4, 27);
    XDrawLine(disp, w, gcw, 3, 27, 3, h - 4);
    XDrawLine(disp, w, gcw, 4, 28, l - 5, 28);
    XDrawLine(disp, w, gcw, 4, 28, 4, h - 5);
    drawhead(w, gcw, 1, 2, l / 2 - 8, 22);
    /*XFR
      XSetForeground(disp, gcw, keyscol[1]);
      XFillRectangle(disp, w, gcw, lx2 + 2, 3, l2, 23);
    */
    XClearArea(disp, w, lx2 + 2, 3, l2, 23, 0);
    drawhead(w, gcw, lx2, 0, l2 + 14, 25, 1);
    /*XFR
      XSetForeground(disp, gcw, keyscol[1]);
      XFillRectangle(disp, w, gcw, 6, 8, l2 - 25, 17);
    */
    XClearArea(disp, w, 6, 8, l2 - 25, 17, 0);
    if(shadow)
    {
      XSetForeground(disp, gcw, cols[0]);
      XDrawString(disp, w, gcw, 11, 22, cdir + dl, vl);
    }
    XSetForeground(disp, gcw, keyscol[0]);
    XDrawString(disp, w, gcw, 10, 21, cdir + dl, vl);
    break;
  };
  if (col > 1)
  {
    pl = (l - 14) / col;
    for (i = 0, px = pl + 7; i < col - 1; i++, px += pl)
    {
      XSetForeground(disp, gcw, keyscol[2]);
      XDrawLine(disp, w, gcw, px - 1, 29, px - 1, h - 35);
      XDrawPoint(disp, w, gcw, px, 28);
      XSetForeground(disp, gcw, keyscol[0]);
      XDrawLine(disp, w, gcw, px + 1, 29, px + 1, h - 35);
      XDrawPoint(disp, w, gcw, px, h - 34);
    }
  }

  try_reread_dir();

  /*
    urect(w, gcw, 7, h - STL_H - 8, 45, STL_H);
    urect(w, gcw, 53, h - STL_H - 8, l - 107, STL_H);
  */
  urect(w, gcw, 7, h-STL_H-8, l - 61, STL_H);
  urect(w, gcw, l - STL_H - STL_H - 9, h - STL_H - 8, STL_H, STL_H);
  urect(w, gcw, l - STL_H - 8, h - STL_H - 8, STL_H, STL_H);

  if(shadow)
  {
    XSetForeground(disp, gcw, cols[0]);
    XDrawString(disp, w, gcw, l - 47, h - 12, "<", 1);
    XDrawString(disp, w, gcw, l - 21, h - 12, ">", 1);
  }
  XSetForeground(disp, gcw, cols[5]);
  XDrawString(disp, w, gcw, l - 48, h - 13, "<", 1);
  XDrawString(disp, w, gcw, l - 22, h - 13, ">", 1);
  flen = (l - 109) / fixl;
  if (just_at_startup == 1 && panel == this)
  {
    guiSetInputFocus(disp, Main, RevertToNone, CurrentTime);
    just_at_startup = 2;
  };
  if (disable_reread != 2)
    showfinfo(cur);
  else
    disable_reread = 0;
}


//----------------------------------------------------------------------------
// Highlight fast find item in list 
//----------------------------------------------------------------------------
void   Lister::show_ff_item(int n, int fflen)
{
  int    iy, ix, piy, delta = 0;
  piy = n % th * tdl + 30;
  iy = piy + lfontstr->max_bounds.ascent;
  ix = n / th * pl + 10;
  if ((cur->mode & S_IFDIR) == S_IFDIR)
  {
    if (allow_dir_icon)
      delta = 19;
  }
  else if (allow_file_icon)
    delta = 19;
  if (lastn != n)
  {
    XSetClipOrigin(disp, wgcw, ix - 5, 0);
    lastn = n;
  };
  XSetForeground(disp, wgcw, cols[5]);
  if (brief)
    XDrawString(disp, w, wgcw, ix + 2 + delta, iy, ff_buf, fflen);
  else
    XDrawString(disp, w, wgcw, ix, iy, ff_buf, fflen);
  XFlush(disp);
}

//----------------------------------------------------------------------------
// Show one item in list
//----------------------------------------------------------------------------
void   Lister::showitem(FList * ol, int n)
{
  int    cn, iy, ix, piy, delta = 0, pixn = 0;
  char   str[80];
  char   str2[40];
  char  *str3;
  piy = n % th * tdl + 30;
  iy = piy + lfontstr->max_bounds.ascent;
  ix = n / th * pl + 10;
  if ((ol->mode & S_IFDIR) == S_IFDIR)
  {
    cn = DIRCOL;
    if (allow_dir_icon)
    {
      delta = 19;
      piy = iy - panelpixh[0];
      XSetClipMask(disp, xpmgc, panelpixmask[0]);
      XSetClipOrigin(disp, xpmgc, ix + 2, piy);
    }
  }
  else if (is_exec(ol))
  {
    cn = EXECOL;
    if (allow_file_icon)
    {
      pixn = 1;
      delta = 19;
      piy = iy - panelpixh[1];
      XSetClipMask(disp, xpmgc, panelpixmask[1]);
      XSetClipOrigin(disp, xpmgc, ix + 2, piy);
    }
  }
  else
  {
    cn = NORMCOL;
    if (allow_file_icon)
    {
      pixn = 2;
      delta = 19;
      piy = iy - panelpixh[2];
      XSetClipMask(disp, xpmgc, panelpixmask[2]);
      XSetClipOrigin(disp, xpmgc, ix + 2, piy);
    }
  };
  if (ol->options & S_EXTEND)
  {
    if (is_it_afs_file(ol->name))
    {
      cn = AFSCOL;
      if (allow_file_icon)
      {
	pixn = 4;
	delta = 19;
	piy = iy - panelpixh[4];
	XSetClipMask(disp, xpmgc, panelpixmask[4]);
	XSetClipOrigin(disp, xpmgc, ix + 2, piy);
      }
    }
    else
    {
      cn = 9;
      if (allow_file_icon)
      {
	delta = 19;
	pixn = 3;
	piy = iy - panelpixh[3];
	XSetClipMask(disp, xpmgc, panelpixmask[3]);
	XSetClipOrigin(disp, xpmgc, ix + 2, piy);
      }
    };
  };
  if ((ol->mode & S_IFLNK) == S_IFLNK)
  {
    cn = LINKCOL;
    if (allow_file_icon)
    {
      delta = 19;
      pixn = 5;
      piy = iy - panelpixh[5];
      XSetClipMask(disp, xpmgc, panelpixmask[5]);
      XSetClipOrigin(disp, xpmgc, ix + 2, piy);
    }
  }
  if (ol->options & S_SELECT)
    cn = SELECTCOL;
  if (lastn != n)
  {
    XSetClipOrigin(disp, wgcw, ix - 5, 0);
    lastn = n;
  };
  if (curn == n)
  {
    showfinfo(ol);
    if ((ol->mode & S_IFDIR) == S_IFDIR)
      if (qvflag)
      {
	qv_update(ol);
      };
    if(option_bits & FILLED_CURSOR)
    {
      XSetForeground(disp, wgcw, selectpix);
      XFillRectangle(disp, w, wgcw, ix, iy - tdl + 5, pl - 14, tdl);
    } else
    {
      /*          XSetForeground(disp, wgcw, keyscol[1]);
		  XFillRectangle(disp, w, wgcw, ix, iy - tdl + 5, pl - 14, tdl);
      */
      XClearArea(disp, w, ix, iy - tdl + 5, pl - 14, tdl, 0);
      XSetForeground(disp, wgcw, selectpix);
      XDrawRectangle(disp,w,wgcw,ix,iy-tdl+5,pl-14,tdl-1);
    }
 
  }
  else
  {
    XClearArea(disp, w, ix, iy - tdl + 5, pl - 13, tdl, 0);
  }
  XSetForeground(disp, wgcw, cols[cn]);
  if (brief)
  {
    XDrawString(disp, w, wgcw, ix + 2 + delta, iy, ol->name, strlen(ol->name));
    if (delta)
      XCopyArea(disp, panelpixs[pixn], w, xpmgc, 0, 0, (unsigned int)panelpixl[pixn], (unsigned int)panelpixh[pixn], ix + 2, piy);
  }
  else
  {
    XSetClipOrigin(disp, wgcw, ix - 2 * pl / 3 + 4, 0);
    XDrawString(disp, w, wgcw, ix, iy, ol->name, strlen(ol->name));
    XSetClipOrigin(disp, wgcw, ix - 5, 0);
    ix += pl / 3 + 20;
    printperm(str, ol->mode);
    sprintf(str2, "%s.%s", finduser(ol->uid), findgroup(ol->gid));
    str3 = ctime(&ol->time);
    XDrawString(disp, w, wgcw, ix + 2, iy, str, strlen(str));
    XDrawString(disp, w, wgcw, ix + fattr1 + 16, iy, str2, strlen(str2));
    XDrawString(disp, w, wgcw, ix + fattr1 + 120, iy, str3, strlen(str3));
  }
}

void   Lister::show()
{
  if(main_pixmap)
    XSetWindowBackgroundPixmap(disp, w, main_pixmap);
  XMapRaised(disp, w);
  addto_el(this, w);
  //  scr->show();
}

void   draw_filled_urect(Window w, GC gcw, int x, int y, int l, int h)
{
  /*
    XClearArea(disp, w, x+1, y+1, l-1, h-1, 0);

    XSetForeground(disp, gcw, keyscol[1]);
    XFillRectangle(disp, w, gcw, x+1, y+1, l-1, h-1);
  */
}

void   Lister::redraw_statusbar()
{
  XClearArea(disp, w, 8, h-STL_H-7, l - 61, STL_H-2, 0);
  urect(w, gcw, 7, h-STL_H-8, l - 61, STL_H);
  if(cur)
    showfinfo(cur);
}

void   Lister::show_string_info(char *str)
{
  int stlx=9;
  int stll=l-17-STL_H-STL_H;
  int ll=strlen(str);
  int ty=h-STL_H-3+fixy;

  if(ll>stll/fixl)
    ll=stll/fixl;
  XClearArea(disp, w, 8, h-STL_H-7, l - 61, STL_H-2, 0);
  urect(w, gcw, 7, h-STL_H-8, l - 61, STL_H);
  if(shadow)
  {
    XSetForeground(disp, gcw, cols[0]);
    XDrawString(disp, w, gcw, stlx+1,
		ty+1, str, ll);
  }
  XSetForeground(disp, gcw, cols[5]);
  XDrawString(disp, w, gcw, stlx,
	      ty, str, ll);
  XFlush(disp);
}


void   Lister::showfinfo(FList * fo)
{
  static char fname[512];
  static char flink[512];
  int    i = 0, sl, vl = 0, dl = 0, ll;
  char   chr2[30];
  char   chr1[30];
  char   tchr[256];

  XClearArea(disp, w, 8, h-STL_H-7, l - 61, STL_H-2, 0);
  urect(w, gcw, 7, h-STL_H-8, l - 61, STL_H);

  if(option_bits & STATUS_ATTR)
  {
    dig2ascii_r(chr1, fo->mode & 07777, 4, 8, '0');
    draw_filled_urect(w, gcw, STL_ATTR_PTR.x, STL_ATTR_PTR.y,
		      STL_ATTR_PTR.len, STL_H);
    if(shadow)
    {
      XSetForeground(disp, gcw, cols[0]);
      XDrawString(disp, w, gcw, STL_ATTR_PTR.tx+1,
		  STL_ATTR_PTR.ty+1, chr1, 4);
    }
    XSetForeground(disp, gcw, cols[5]);
    XDrawString(disp, w, gcw, STL_ATTR_PTR.tx,
		STL_ATTR_PTR.ty, chr1, 4);
      
  }
  if(option_bits & STATUS_TIME)
  {
    draw_filled_urect(w, gcw, STL_TIME_PTR.x, STL_TIME_PTR.y,
		      STL_TIME_PTR.len, STL_H);
    if(shadow)
    {
      XSetForeground(disp, gcw, cols[0]);
      XDrawString(disp, w, gcw, STL_TIME_PTR.tx+1,
		  STL_TIME_PTR.ty+1, fo->chr_time, STL_TIME_NCHAR);
    }
    XSetForeground(disp, gcw, cols[5]);
    XDrawString(disp, w, gcw, STL_TIME_PTR.tx,
		STL_TIME_PTR.ty, fo->chr_time, STL_TIME_NCHAR);
      
  }
  if(option_bits & STATUS_OWNER)
  {
    ll=sprintf(tchr,"%s.%s", fo->user, fo->group);
    draw_filled_urect(w, gcw, STL_OWNER_PTR.x, STL_OWNER_PTR.y,
		      STL_OWNER_PTR.len, STL_H);
    if(shadow)
    {
      XSetForeground(disp, gcw, cols[0]);
      XDrawString(disp, w, gcw, STL_OWNER_PTR.tx+1,
		  STL_OWNER_PTR.ty+1, tchr, ll);
    }
    XSetForeground(disp, gcw, cols[5]);
    XDrawString(disp, w, gcw, STL_OWNER_PTR.tx,
		STL_OWNER_PTR.ty, tchr, ll);
      
  }
  if(option_bits & STATUS_SIZE)
  {
    if (selfiles == 0)
    {
      if (fo->mode & S_IFDIR)
      {
	strcpy(chr2, ">DIR<");
	dig2ascii_r(chr2+5, fo->size, 6);
      }
      else
	dig2ascii(chr2, fo->size);
    }
    else
    {
      dig2ascii(chr2, selsize);
    }
    vl=strlen(chr2);
    dl=STL_SIZE_PTR.tlen;
      
    draw_filled_urect(w, gcw, STL_SIZE_PTR.x, STL_SIZE_PTR.y,
		      STL_SIZE_PTR.len, STL_H);
    if(shadow)
    {
      XSetForeground(disp, gcw, cols[0]);
      XDrawString(disp, w, gcw, STL_SIZE_PTR.tx+1+(dl-vl)*fixl,
		  STL_SIZE_PTR.ty+1, chr2, vl);
    }
    XSetForeground(disp, gcw, cols[5]);
    XDrawString(disp, w, gcw, STL_SIZE_PTR.tx+(dl-vl)*fixl,
		STL_SIZE_PTR.ty, chr2, vl);
  }

  if(option_bits & STATUS_NAME)
  {
    int tlen=STL_NAME_PTR.tlen;
    vl=STL_NAME_PTR.tlen;
    dl=0;
    draw_filled_urect(w, gcw, STL_NAME_PTR.x, STL_NAME_PTR.y,
		      STL_NAME_PTR.len, STL_H);
                        
    if ((fo->mode & S_IFLNK) == S_IFLNK && selfiles == 0)
    {
      vfs->ch_curdir();
      ll=vfs->readlink(fo, flink, 512);
      flink[ll]=0;
      if (ll < tlen-3)
      {
	sl = strlen(fo->name);
	if (sl + ll > tlen)
	{
	  for (i = ll; i >= 0; i--)
	    fname[tlen - 1 - ll + i] = flink[i];
	  fname[tlen - 2 - ll] = '>';
	  fname[tlen - 3 - ll] = '-';
	  for (i = sl - 1; i >= 0; i--)
	    if (tlen - 4 - sl + i < 0)
	      break;
	    else
	      fname[tlen - sl + i] = fo->name[i];
	}
	else
	{
	  strcpy(fname, fo->name);
	  strcat(fname, "->");
	  strcat(fname, flink);
	}
      }
      else
        strcpy(fname, flink + ll - tlen - 3);
      sl = strlen(fname);
      if (sl > vl)
        dl = sl - vl;
      vl = sl - dl;
      if(shadow)
      {
	XSetForeground(disp, gcw, cols[0]);
	XDrawString(disp, w, gcw, STL_NAME_PTR.tx+1, STL_NAME_PTR.ty + 1, fname + dl, vl);
      }
      XSetForeground(disp, gcw, cols[5]);
      XDrawString(disp, w, gcw, STL_NAME_PTR.tx, STL_NAME_PTR.ty, fname + dl, vl);
    }
    else
    {
      char *pname;
      if(selfiles)
      {
        pname=tchr;
        dig2ascii_r(pname, selfiles, 4);
        strcat(pname, " file(s) selected");
      }
      else
        pname=fo->name;
      
      sl = strlen(pname);
      if (sl > vl)
        dl = sl - vl;
      vl = sl - dl;
      if(shadow)
      {
	XSetForeground(disp, gcw, cols[0]);
	XDrawString(disp, w, gcw, STL_NAME_PTR.tx+1, STL_NAME_PTR.ty + 1, pname + dl, vl);
      }
      XSetForeground(disp, gcw, cols[5]);
      XDrawString(disp, w, gcw, STL_NAME_PTR.tx, STL_NAME_PTR.ty, pname + dl, vl);
    }
  }
  if(option_bits & STATUS_INODE)
    show_inodeinfo(fo);
}

void   Lister::showempty(int n)
{
  int    iy, ix;
  iy = n % th * tdl + 30 + lfontstr->max_bounds.ascent;
  ix = n / th * pl + 10;
  if (lastn != n)
  {
    XSetClipOrigin(disp, wgcw, ix - 5, 0);
    lastn = n;
  };
  XClearArea(disp, w, ix, iy - tdl + 5, pl - 8, tdl, 0);
}

void   Lister::header_blink_other()
{
  if(lay==0)
  {
    panel2->header_blink();
    return;
  }
  char  *cdir = panel2->vfs->get_dir_header();
  int    sl = strlen(cdir), vl, fl, i, l2=l/2;
  fl = (l - 88) / 2;
  vl = fl / fixl;
  int    dl = 0;
  if (sl > vl)
    dl = sl - vl;
  vl = sl - dl;
  for(i=0;i<3;i++)
    if(lay==1)
    {
      XSetForeground(disp, gcw, keyscol[1]);
      XDrawString(disp, w, gcw, l2 + 30, 21, cdir + dl, vl);
      XDrawString(disp, w, gcw, l2 + 31, 22, cdir + dl, vl);
      XSync(disp,0);
      delay(150);
      if(shadow)
      {
	XSetForeground(disp, gcw, cols[0]);
	XDrawString(disp, w, gcw, l2 + 31, 22, cdir + dl, vl);
      }
      XSetForeground(disp, gcw, keyscol[0]);
      XDrawString(disp, w, gcw, l2 + 30, 21, cdir + dl, vl);
      XSync(disp,0);
      delay(150);
    } else
    {
      XSetForeground(disp, gcw, keyscol[1]);
      XDrawString(disp, w, gcw, 11, 22, cdir + dl, vl);
      XDrawString(disp, w, gcw, 10, 21, cdir + dl, vl);
      XSync(disp,0);
      delay(150);
      if(shadow)
      {
	XSetForeground(disp, gcw, cols[0]);
	XDrawString(disp, w, gcw, 11, 22, cdir + dl, vl);
      }
      XSetForeground(disp, gcw, keyscol[0]);
      XDrawString(disp, w, gcw, 10, 21, cdir + dl, vl);
      XSync(disp,0);
      delay(150);
    }
}

void   Lister::header_blink()
{
  int i;
  char  *curdir = vfs->get_dir_header();
  int    sl = strlen(curdir), vl, fl, l2 = l / 2;
  if (lay == 0)
    fl = l - 38;
  else
    fl = (l - 38) / 2;
  vl = fl / fixl;
  int    dl = 0;
  if (sl > vl)
    dl = sl - vl;
  vl = sl - dl;
  for(i=0;i<3;i++)
  {
    switch (lay)
    {
    case 0:
      XSetForeground(disp, gcw, keyscol[1]);
      XDrawString(disp, w, gcw, 31, 22, curdir + dl, vl);
      XDrawString(disp, w, gcw, 30, 21, curdir + dl, vl);
      XSync(disp,0);
      delay(150);
      if(shadow)
      {
	XSetForeground(disp, gcw, cols[0]);
	XDrawString(disp, w, gcw, 31, 22, curdir + dl, vl);
      }
      XSetForeground(disp, gcw, cols[5]);
      XDrawString(disp, w, gcw, 30, 21, curdir + dl, vl);
      XSync(disp,0);
      delay(150);
      break;
    case 1:
      XSetForeground(disp, gcw, keyscol[1]);
      XDrawString(disp, w, gcw, 31, 22, curdir + dl, vl);
      XDrawString(disp, w, gcw, 30, 21, curdir + dl, vl);
      XSync(disp,0);
      delay(150);
      if(shadow)
      {
	XSetForeground(disp, gcw, cols[0]);
	XDrawString(disp, w, gcw, 31, 22, curdir + dl, vl);
      }
      XSetForeground(disp, gcw, cols[5]);
      XDrawString(disp, w, gcw, 30, 21, curdir + dl, vl);
      XSync(disp,0);
      delay(150);
      break;
    case 2:
      XSetForeground(disp, gcw, keyscol[1]);
      XDrawString(disp, w, gcw, l2 + 16, 22, curdir + dl, vl);
      XDrawString(disp, w, gcw, l2 + 15, 21, curdir + dl, vl);
      XSync(disp,0);
      delay(150);
      if(shadow)
      {
	XSetForeground(disp, gcw, cols[0]);
	XDrawString(disp, w, gcw, l2 + 16, 22, curdir + dl, vl);
      }
      XSetForeground(disp, gcw, cols[5]);
      XDrawString(disp, w, gcw, l2 + 15, 21, curdir + dl, vl);
      XSync(disp,0);
      delay(150);
      break;
    }
  }
}

void   Lister::showdirname()
{
  char  *curdir = vfs->get_dir_header();
  int    sl = strlen(curdir), vl, fl, l2 = l / 2;
  if (lay == 0)
    fl = l - 38;
  else
    fl = (l - 38) / 2;
  vl = fl / fixl;
  int    dl = 0;
  if (sl > vl)
    dl = sl - vl;
  vl = sl - dl;
  switch (lay)
  {
  case 0:
    urect(w, gcw, 28, 7, l - 36, 19);
    urect(w, gcw, 7, 7, 20, 19);
    prect(w, gcw, 9, 9, 16, 15);
    XSetForeground(disp, gcw, cols[1 + side]);
    XFillRectangle(disp, w, gcw, 12, 12, 11, 10);
    /*XFR
      XSetForeground(disp, gcw, keyscol[1]);
      XFillRectangle(disp, w, gcw, 30, 8, fl, 17);
    */
    XClearArea(disp, w, 30, 8, fl, 17, 0);
    if(shadow)
    {
      XSetForeground(disp, gcw, cols[0]);
      XDrawString(disp, w, gcw, 31, 22, curdir + dl, vl);
    }
    XSetForeground(disp, gcw, cols[5]);
    XDrawString(disp, w, gcw, 30, 21, curdir + dl, vl);
    break;
  case 1:
    prect(w, gcw, 7, 7, 16, 15);
    XSetForeground(disp, gcw, cols[1]);
    XFillRectangle(disp, w, gcw, 10, 10, 11, 10);
    /*XFR
      XSetForeground(disp, gcw, keyscol[1]);
      XFillRectangle(disp, w, gcw, 30, 8, fl, 17);
    */
    XClearArea(disp, w, 30, 8, fl, 17, 0);
    if(shadow)
    {
      XSetForeground(disp, gcw, cols[0]);
      XDrawString(disp, w, gcw, 31, 22, curdir + dl, vl);
    }
    XSetForeground(disp, gcw, cols[5]);
    XDrawString(disp, w, gcw, 30, 21, curdir + dl, vl);
    break;
  case 2:
    prect(w, gcw, l2 - 7, 7, 16, 15);
    XSetForeground(disp, gcw, cols[3]);
    XFillRectangle(disp, w, gcw, l2 - 4, 10, 11, 10);
    /*XFR
      XSetForeground(disp, gcw, keyscol[1]);
      XFillRectangle(disp, w, gcw, l2 + 15, 8, l2 - 20, 17);
    */
    XClearArea(disp, w, l2 + 15, 8, l2 - 20, 17, 0);
    if(shadow)
    {
      XSetForeground(disp, gcw, cols[0]);
      XDrawString(disp, w, gcw, l2 + 16, 22, curdir + dl, vl);
    }
    XSetForeground(disp, gcw, cols[5]);
    XDrawString(disp, w, gcw, l2 + 15, 21, curdir + dl, vl);
    break;
  }
}

void   Lister::showdir()
{
  FList *fo = base;
  int    i = 0, al = col * th;
  while (fo != NULL && i < al)
  {
    showitem(fo, i);
    fo = fo->next;
    i++;
  }
  xncdprintf(("Lister:showdir items %d\n",i));
  while (i < al)
  {
    showempty(i);
    i++;
  };
  showdirname();
  if (cmdl != NULL && foc)
    cmdl->setpath(curdir);
}


///////////////////////////////////FS operations//////////////////////////////
void   Lister::fserror(char *head, FList * o)
{
  show_file_error(head,o);
}

void   Lister::set_recycle_state(int state)
{
  bmark->set_recycle_image(0);
}

void   Lister::create_infowin(char *head)
{
  ::create_infowin(head);
}

void   Lister::del_infowin()
{
  ::del_infowin();
}

void   Lister::to_infowin(char *mes)
{
  ::to_infowin(mes);
}

void   Lister::infowin_set_coun(int n)
{
  infowin->set_coun(n);
}

void   Lister::infowin_update_coun(int n)
{
  infowin->set_coun(n);
}

void   Lister::flush_screen()
{
  XFlush(disp);
}

void   Lister::expose_panel()
{
  expose();
}

int   Lister::am_i_visible()
{
  return panel==this;
}


void   Lister::total_expose()
{
  if (lay == 0)
    panel2->expose();
  expose();
}

void   Lister::total_reread()
{
  if (lay == 0)
    panel2->reread();
  reread();
}

BaseCaptain* Lister::other()
{
  return panel2;
}

VFS* Lister::other_vfs()
{
  return panel2->vfs;
}

int    Lister::is_panel_vfs(VFS* vfstmp)
{
  return vfstmp == panel2->vfs;
}

void   Lister::show_item(FList * o)
{
  FList *t = base;
  int    coun = 0;
  while (t != o && t != NULL)
  {
    t = t->next;
    coun++;
  };
  if (t == o && coun < col * th)
    showitem(o, coun);
}





void   Lister::remount()
{
  char  *mntptr = findmntent(curdir);
  if (mntptr != NULL)
  {
    chdir("..");
    senddir("..");
    tt_printf("umount %s\n", mntptr);
    tt_printf("mount %s\n", mntptr);
    reread();
  }
}

void   Lister::ext_exec(char *exec)
{
  char   findchr[8192];
  char   fname[L_MAXPATH];
  char   fdir[L_MAXPATH];
  char  *s, c, *b;

  if (vfs->is_exec_supported())
  {
    char  *name = vfs->get_file_for_execute(cur->name);
    if (name == NULL)
    {
      show_vfs_error();
      return;
    }
    char  *execdir = vfs->get_execute_dir();
    if (findsubstr(exec, "%s/%s"))
    {
      chdir(panel2->curdir);
      senddir(panel2->curdir);
      sprintf(fdir, "%s/%s", execdir, name);
      quote_path(fname, fdir);
      b=strchr(fname, '/');
      *b=0;b++;
      sprintf(findchr, exec, fname, b);
    }
    else
    {
      senddir(execdir);
      quote_path(fname, name);
      sprintf(findchr, exec, fname);
    }
    s = findchr;
    while (*++s)
    {
      if (*s == '#')
      {
	*s = 0;
	break;
      }
      /*          if (*s == '\\')
		  {
		  if (++*s)
		  break;
		  }
      */  
      if (*s == '"' || *s == '\'')
      {
	c = *s;
	while (*++s)
	{
	  if (*s == c)
	  {
	    break;
	  }
	}
	if (!*s)
	  break;
      }
    }
    raise_terminal_if_need();
    flush_screen();
    tt_printf("%s\n", findchr);
    cmdl->flush();
    senddir(curdir);
    total_reread();
    flush_screen();
  }
  else
    XBell(disp, 0);
}

void   Lister::menu_exec(char *mecom)
{
  char   findchr[255];
  char  *suc;
  if (vfs->is_exec_supported())
  {
    char  *name = vfs->get_file_for_execute(cur->name);
    if (name == NULL)
    {
      show_vfs_error();
      return;
    }
    char  *execdir = vfs->get_execute_dir();
    int    i = 0;
    if ((suc = findsubstr(mecom, "%p(")))
    {
      suc += 3;
      while (*suc != ')' && *suc != 0)
	wfile[i++] = *suc++;
      wfile[i] = 0;
      newtextfile(wfile, this, 10);
    }
    else
    {
      if (findsubstr(mecom, "%s/%s"))
      {
	chdir(panel2->curdir);
	senddir(panel2->curdir);
	sprintf(findchr, mecom, execdir, name);
      }
      else
      {
	senddir(execdir);
	sprintf(findchr, mecom, name);
      };
      raise_terminal_if_need();
      flush_screen();
      tt_printf("%s\n", findchr);
      cmdl->flush();
      senddir(curdir);
      total_reread();
      flush_screen();
    }
  }
  else
    XBell(disp, 0);
}

void   Lister::wide_exec()
{
  char  *suc;
  int    i = 0;
  suc = findsubstr(menucom[comnumber], "%p(");
  while (menucom[comnumber][i] != *suc)
    combuffer[i] = menucom[comnumber][i++];
  combuffer[i] = 0;
  i = 0;
  strcat(combuffer, dbuf);
  suc += 3;
  while (*suc != ')' && *suc != 0)
    suc++;
  if (*suc != 0)
    strcat(combuffer, suc + 1);
  menu_exec(combuffer);
}

void   Lister::raise_terminal_if_need()
{
  if(!is_term_on())
    return;
  if (allow_t_raising)
  {
    focus_fl = 0;
    if (vt_show)
    {
      XRaiseWindow(disp, main_win);
      guiSetInputFocus(disp, main_win, RevertToNone, CurrentTime);
    }
    else
      XMapRaised(disp, main_win);
  }
  else
  {
    delay(100);
  }
}

void   Lister::ps_info()
{
  int    psmax = getps();
  if (psmax > 0)
    newkillpanel("Kill process!", psmax, pankill, 600);
}

void   Lister::lpr()
{
  chdir(curdir);
  tt_printf("lpr %s\n", cur->name);
}



void   Lister::view(int v)
{
  char   str[2*L_MAXPATH];
  char  *name;
  chdir(curdir);
  VFS *pvfs=vfs;
  if (strcmp(viewname, "internal") != 0)
  {
    name = vfs->get_file_for_execute(cur->name);
    if (name == NULL && pvfs->bgbit==0)
    {
      show_vfs_error();
      return;
    }
    if(pvfs->bgbit!=0)
    {
      if(pvfs->bgbit==FF_GET)
	ftp_set_bgcode((FTP*)pvfs, FF_VIE);
      return;
    }
    tt_printf("%s %s/%s\n", viewname, vfs->get_execute_dir(), name);
    raise_terminal_if_need();
    /* XLowerWindow(disp,Main);
       XFlush(disp);
       psystem(str);
       XRaiseWindow(disp,Main);
       guiSetInputFocus(disp,Main,RevertToNone,CurrentTime);
       if(lay==0) panel2->reread();
       reread(); */
  }
  else if (viewfunc != NULL && ((cur->mode & S_IFDIR) == 0) && (cur->size != 0) && v != 0 && vfs->is_exec_supported())
  {
    name = vfs->get_file_for_execute(cur->name);
    if (name == NULL && pvfs->bgbit==0)
    {
      show_vfs_error();
      return;
    }
    if(pvfs->bgbit!=0)
    {
      if(pvfs->bgbit==FF_GET)
	ftp_set_bgcode((FTP*)pvfs, FF_VIE);
      return;
    }
    sprintf(str, "%s/%s", vfs->get_execute_dir(), name);
    viewfunc(str);
  }
  else if (viewonlyfunc != NULL && ((cur->mode & S_IFDIR) == 0) && (cur->size != 0) && v == 0 && vfs->is_exec_supported())
  {
    name = vfs->get_file_for_execute(cur->name);
    if (name == NULL && pvfs->bgbit==0)
    {
      show_vfs_error();
      return;
    }
    if(pvfs->bgbit!=0)
    {
      if(pvfs->bgbit==FF_GET)
	ftp_set_bgcode((FTP*)pvfs, FF_SVI);
      return;
    }
    sprintf(str, "%s/%s", vfs->get_execute_dir(), name);
    viewonlyfunc(str);
  }
}

void   Lister::bg_view(char *name)
{
  if (strcmp(viewname, "internal") != 0)
  {
    tt_printf("%s %s\n", viewname, name);
    raise_terminal_if_need();
  }
  else
  {
    if(vfs->bgbit==FF_VIE)
      viewfunc(name);
    else
      viewonlyfunc(name);
  }
}

void   Lister::bg_edit(char *name)
{
  if (strcmp(viewname, "internal") != 0)
  {
    tt_printf("%s %s\n", editname, name);
    raise_terminal_if_need();
  }
  else
  {
    editorfunc(name);
  }
}

void   Lister::edit()
{
  char   str[1200];
  char  *name;
  chdir(curdir);
  VFS *pvfs=vfs;
  if (strcmp(editname, "internal") != 0 && vfs->is_exec_supported())
  {
    name = vfs->get_file_for_execute(cur->name);
    if (name == NULL && pvfs->bgbit==0)
    {
      show_vfs_error();
      return;
    }
    if(pvfs->bgbit!=0)
    {
      if(pvfs->bgbit==FF_GET)
	ftp_set_bgcode((FTP*)pvfs, FF_EDI);
      return;
    }
    tt_printf("%s %s/%s\n", editname, vfs->get_execute_dir(), name);
    raise_terminal_if_need();
    /* XLowerWindow(disp,Main);
       XFlush(disp);
       psystem(str);
       XRaiseWindow(disp,Main);
       guiSetInputFocus(disp,Main,RevertToNone,CurrentTime);
       if(lay==0) panel2->reread();
       reread(); */
  }
  else if (editorfunc != NULL && ((cur->mode & S_IFDIR) == 0) && vfs->is_exec_supported())
  {
    name = vfs->get_file_for_execute(cur->name);
    if (name == NULL && pvfs->bgbit==0)
    {
      show_vfs_error();
      return;
    }
    if(pvfs->bgbit!=0)
    {
      if(pvfs->bgbit==FF_GET)
	ftp_set_bgcode((FTP*)pvfs, FF_EDI);
      return;
    }
    sprintf(str, "%s/%s", vfs->get_execute_dir(), name);
    editorfunc(str);
  }
}

void   Lister::del()
{
  if (strcmp(cur->name, "..") != 0 || selfiles != 0)
  {
    vfs->ch_curdir();
    if(use_prompt & PROMPT_DEL)
    {
      bmark->set_recycle_image(0);
      initquery("Delete file?", this, panel2->vfs, 0);
    } else
    {
      set_dbuf(panel2->vfs);
      funcs(0);
    }
      
  }
}

void   Lister::copy()
{
  if (strcmp(cur->name, "..") != 0 || selfiles != 0)
  {
    vfs->ch_curdir();
    if(use_prompt & PROMPT_COPY)
    {
      if (selfiles)
        init_copymove_query("Copy files?", this, panel2->vfs, 1);
      else
        initdialog("Copy file", this, panel2->vfs, 1);
    } else
    {
      set_dbuf(panel2->vfs);
      funcs(1);
    }
  }
}

void   Lister::copy(VFS * vf)
{
  if (strcmp(cur->name, "..") != 0 || selfiles != 0)
  {
    vfs->ch_curdir();
    if(use_prompt & PROMPT_COPY)
    {
      if (selfiles)
        init_copymove_query("Copy files?", this, vf, 1);
      else
        initdialog("Copy file", this, vf, 1);
    } else
    {
      set_dbuf(vf);
      funcs(1);
    }
  }
}

//edit for movedir...

void   Lister::move()
{
  if (strcmp(cur->name, "..") != 0 || selfiles != 0)
  {
    vfs->ch_curdir();
    if(use_prompt & PROMPT_MOVE)
    {
      if (selfiles)
        init_copymove_query("Move files?", this, panel2->vfs, 2);
      else
        initdialog("Move file", this, panel2->vfs, 2);
    } else
    {
      set_dbuf(panel2->vfs);
      funcs(2);
    }
  }
}

void   Lister::move(VFS * vf)
{
  if (strcmp(cur->name, "..") != 0 || selfiles != 0)
  {
    vfs->ch_curdir();
    if(use_prompt & PROMPT_MOVE)
    {
      if (selfiles)
        init_copymove_query("Move files?", this, vf, 2);
      else
        initdialog("Move file", this, vf, 2);
    } else
    {
      set_dbuf(panel2->vfs);
      funcs(2);
    }
  }
}





void   Lister::insert_left_dir()
{
  if(this<panel2)
  {
    cmdl_insert_name(curdir);
    cmdl->insert('/');
    tt_printf("/");
  } else
    panel2->insert_left_dir();
}

void   Lister::insert_right_dir()
{
  if(this>panel2)
  {
    cmdl_insert_name(curdir);
    cmdl->insert('/');
    tt_printf("/");
  } else
    panel2->insert_right_dir();
}

void   Lister::activate()
{
  ActionKey defexact;
  char   findchr[250];
  char  *name;
  char   tname[150];
  int    findfl = 0, kn, kk, pid, ef, efn;
  FList *dub;
  ActionKey *ac = action_by_name(AExecute);
  lastscan = 0;
  if (ac == NULL)
  {
    ac = &defexact;
    ac->mods[1] = ShiftMask;
    ac->mods[2] = ControlMask;
    ac->action = AExecute;
  }
  vfs->ch_curdir();
  dub = new FList(cur->name, cur->mode, cur->size, cur->uid, cur->gid, cur->time);
  if ((ev.xkey.state & ac->mods[2]) == ac->mods[2])
  {                                /*+1 */
    pid = 0;
    if ((ev.xkey.state & ac->mods[1]) == ac->mods[1])
    {                        /*+2 */
      cmdl_insert_name(curdir);
      cmdl->insert('/');
      tt_printf("/");
    }
    else
      /*-2*/
    {                        /*+3 */
      if (cur->mode & S_IFDIR)
      {
	cmdl_insert_name(cur->name);
	cmdl->insert(' ');
	tt_printf(" ");
          
      } else
	if (vfs->is_exec_supported())
	{
	  name = vfs->get_file_for_execute(cur->name);
	  if (name == NULL)
	  {
	    show_vfs_error();
	    return;
	  }
	  if(vfs->fstype!=DFS_TYPE)
	  {
	    cmdl_insert_name(vfs->get_execute_dir());
	    cmdl->insert('/');
	    tt_printf("/");
	  }
	  cmdl_insert_name(name);
	  cmdl->insert(' ');
	  tt_printf(" ");
	}
    }
    /*-3*/
  }
  /*-1*/
  else if (cmdl->bl != 0)
  {                                /*+4 */
    cmdl->flush();
    evret = (!vfs->pass_cd_to_terminal() && (masks & PANEL_CD_DONE));
    masks&=~PANEL_CD_DONE;
    if(!evret)
      raise_terminal_if_need();
    XFlush(disp);
  }
  else
    /*-4*/ if ((cur->mode & S_IFDIR) && cmdl->bl == 0)
    {                                /*+5 */
      vfs->ch_curdir();
      get_last_content(vfs->curdir, findchr);
      if (vfs->chdir(cur->name) == 0)
      {                        /*+6 */
	if (vfs->need_change_vfs)
	{
	  if (strcmp(cur->name, "..") == 0)
	  {                /*+7 */
	    findfl = 1;
	    if (vfs->fstype == AFS_TYPE)
	      strcpy(findchr, afs.arcname);
	    else
	      get_last_content(curdir, findchr);
	  };
	  /*-7*/
	  vfs->delete_vfs_list();
	  vfs->close_fs();
	  vfs = pop_vfs();
	  vfs->ch_curdir();
	}
	else if (strcmp(cur->name, "..") == 0)
	{                        /*+7 */
	  findfl = 1;
	};
	/*-7*/
	vfs->getcwd(curdir, 1020);
	if (vfs == &dfs)
	  senddir(curdir);
	delall_l(&dl);
	dl.next = fl.next = NULL;
	if (direc(vfs->curdir) == 0)
	{                        /*+8 */
	  errno2mes();
	  fserror("Reading directory", dub);
	  vfs->chdir("..");
	  vfs->getcwd(curdir, 1020);
	  direc(curdir);
	}
	/*-8*/
	if (findfl != 0 && findchr[0] != 0)
	{                        /*+9 */
	  kn = findentry(findchr);
	  if (kn != -1)
	  {                /*+10 */
	    curn = kn % (th * col);
	    kk = kn - curn;
	    setcur(&base, kk);
	    setcur(&cur, kn);
	  }
	  /*-10*/
	}
	/*-9*/
	showdir();
      }
      else
      {
	errno2mes();
	fserror("Changing directory", dub);
      }
      /*-6*/
    }
    else
      /*-5*/ if (cur->options & S_EXTEND)
      {                                /*+15 */
	if (is_it_afs_file(cur->name) && (ev.xkey.state & ac->mods[1]) == 0)
        {
          name = vfs->get_file_for_execute(cur->name);
          if (name)
	  {
	    // *INDENT-OFF*        
	    ::chdir(vfs->get_execute_dir());
	    // *INDENT-ON*        


	    strcpy(tname, name);
	  }
          vfs->delete_vfs_list();
          push_vfs(vfs);
          vfs = &afs;
          if (name == NULL)
	  {
	    show_vfs_error();
	    strcpy(findchr, afs.arcname);
	    vfs = pop_vfs();
	    findfl = 1;
	    // *INDENT-OFF*        
	    ::chdir(curdir);
	    // *INDENT-ON*        


	  }
          else
	  {
	    if (afs.init_support(tname) == 0)                //If error we return to panels DFS

	    {
	      show_vfs_error();
	      strcpy(findchr, afs.arcname);
	      vfs = pop_vfs();
	      findfl = 1;
	    }
	    // *INDENT-OFF*        
	    ::chdir(curdir);
	    // *INDENT-ON*        


	  }
          vfs->ch_curdir();
          if (direc(curdir) == 0)
	  {                        /*+8 */
	    fserror("Reading directory", dub);
	    vfs->chdir("..");
	    vfs->getcwd(curdir, 1020);
	    direc(curdir);
	  }
	  /*-8*/
          if (findfl != 0 && findchr[0] != 0)
	  {                        /*+9 */
	    kn = findentry(findchr);
	    if (kn != -1)
	    {                /*+10 */
	      curn = kn % (th * col);
	      kk = kn - curn;
	      setcur(&base, kk);
	      setcur(&cur, kn);
	    }
	    /*-10*/
	  }
	  /*-9*/
          showdir();
        }
	else
        {
          efn = 0;
          while ((ef = ext_find2(cur->name, efn)) != -1)
            panlist[efn++] = extcom[ef];
          if (efn == 1)
            ext_exec(panlist[0]);
          else
            newpanel("Which command?", efn, panexec);
        }
      }
      else
	/*-15*/ if (is_exec(cur))
	{                                /*+11 */
	  if ((ev.xkey.state & ac->mods[1]) == 0)
	  {                        /*+12 */
	    evret = 0;
	    if (cmdl->bl == 0)
            {
              if (vfs->is_exec_supported())
	      {
		name = vfs->get_file_for_execute(cur->name);
		if (name == NULL)
		{
		  show_vfs_error();
		  return;
		}
		if (vfs->fstype != DFS_TYPE)
		  senddir(vfs->get_execute_dir());
		tt_printf("./");
		cmdl_insert_name(name);
		if (mouse)
		  tt_printf("\n");
		pid = 0;
		XFlush(disp);
	      }
            }
	    raise_terminal_if_need();
	    cmdl->flush();
	    if (vfs->fstype != DFS_TYPE)
            {
              if (mouse == 0)
                tt_printf("\n");
              senddir(curdir);
            }
	    XFlush(disp);
	  }
	  /*-12*/
	  else
	  {                        /*+14 */
	    evret = 0;
	    if (cmdl->bl == 0 && vfs->is_exec_supported())
	    {
	      cmdl_insert_name(vfs->get_file_for_execute(cur->name));
	      tt_printf(" &");
	    }
	    cmdl->flush();
	    XFlush(disp);
	  }
	  /*-14*/
	}
	else
	  /*-11*/
	{
	  for (ef = 0; ef < extmax; ef++)
	    panlist[ef] = extcom[ef];
	  newpanel("Execute with...", extmax, panexec);
	};
  delete dub;
}

void   Lister::funcs(int nn)
{
  switch (nn)
  {
  case 0:
    fdelete();
    break;
  case 1:
    fcopy();
    break;
  case 2:
    fmove();
    break;
  case 3:
    fmkdir();
    break;
  case 4:
    fedit();
    break;
  case 5:
    select_by_mask(1);
    break;
  case 6:
    select_by_mask(0);
    break;
  case 7:
    setattr();
    break;
  case 8:
    lpr();
    break;
  case 10:
    wide_exec();
    break;
  case 11:
    man_page();
    break;
  case 12:
    do_ftp_link();
    break;
  case 20:
    chowns();
    break;
  case 22:
    panmntmnt();
    break;
  }
}



void   Lister::send_dnd_message()
{
  int    cx, cy, rx, ry;
  unsigned kmask;
  Window rw, cw;
  XEvent ev;
  char   buffer[1024];


  // For now, only message for single files are supported
  if (selfiles)
    return;

  Window root = DefaultRootWindow(disp);
  XQueryPointer(disp, root, &rw, &cw, &rx, &ry, &cx, &cy, &kmask);
  ev.xclient.type = ClientMessage;
  ev.xclient.display = disp;
  ev.xclient.message_type = DndProtocol;
  ev.xclient.format = 32;
  ev.xclient.window = cw;
  ev.xclient.data.l[0] = (cur->mode & S_IFDIR) ? DndDir : DndFile;
  ev.xclient.data.l[1] = (long)dnd_startm;
  ev.xclient.data.l[2] = (long)0l;
  ev.xclient.data.l[3] = rx + 65536L * (long)ry;
  ev.xclient.data.l[4] = 1;
  sprintf(buffer, "%s/%s", curdir, cur->name);
  DndSetData(DndFile, (unsigned char*)buffer, strlen(buffer) + 1);
  XSendEvent(disp, cw, True, NoEventMask, &ev);
  ev.xclient.message_type = Old_DndProtocol;
  XSendEvent(disp, cw, True, NoEventMask, &ev);
}

void   Lister::mkdir()
{
  vfs->ch_curdir();
  newtextfile("Make directory", this, 3);
}


void   Lister::scrollup(Gui*)
{
  go_upline();
}

void   Lister::scrolldown(Gui*)
{
  go_downline();
}

void   Lister::fedit()
{
  strcpy(cur->name, dbuf);
  cur->size = 0;
  cur->mode = 0666;
  edit();
  reread();
}

void   Lister::attrib()
{
  // *INDENT-OFF*        
  if(selfiles==0) 
    ::attrib(cur,7);
  else 
    attrib2();
  // *INDENT-ON*        


}

void   Lister::try_to_add_to_bookmark(int cy)
{
  char strtmp[L_MAXPATH];
  if ((cur->mode & S_IFDIR) && strcmp("..", cur->name) != 0)
  {
    if (vfs->fstype == DFS_TYPE)
    {
      sprintf(strtmp, "%s/%s", curdir, cur->name);
      bmark->add_toempty_book_by_coord(cy, strtmp, vfs->fstype);
      return;
    }
  }
  else
    bmark->add_toempty_book_by_coord(cy, vfs->get_info_for_bookmark(), vfs->fstype);
}

extern int disable_modifiers;

void   Lister::check_dnd_dir_on_panel2(int cx, int cy, unsigned kmask)
{
  char strtmp2[L_MAXPATH];
  if (cy - panel2->y < 30)        //We dropped on title name so use current path!

  {
    if (kmask & ShiftMask)
      move();
    else
      copy();
    return;
  }
  if (panel2->vfs->fstype != DFS_TYPE)
  {
    if (kmask & ShiftMask)
      move();
    else
      copy();
  }
  else
  {
    int    k = (cy - 30 - panel2->y) / tdl + (cx - panel2->x - 8) / (pl + 4) * th;
    FList *o = panel2->base;
    VFS   *ivfs;
    int    i = 0;
    if (k < th * col)
    {
      while (i < k && o != NULL)
      {
	o = o->next;
	i++;
      }
      if (o && (o->mode & S_IFDIR))
      {
	sprintf(strtmp2, "%s/%s", panel2->curdir, o->name);
	ivfs = define_vfs("DFS", strtmp2);
	if (kmask & ShiftMask)
	  move(ivfs);
	else
	  copy(ivfs);
      }
      else if (o && (o->options & S_EXTEND) && is_it_afs_file(o->name))
      {
	sprintf(strtmp2, "%s/%s", panel2->curdir, o->name);
	ivfs = define_vfs("ARC", strtmp2);
	if (kmask & ShiftMask)
	  move(ivfs);
	else
	  copy(ivfs);
      }
      else
      {
	if (kmask & ShiftMask)
	  move();
	else
	  copy();
      }
    }
  }
}

void   Lister::check_dnd_dir(unsigned mask)
{
  char strtmp2[L_MAXPATH];
  FList *o = base;
  VFS   *ivfs;
  int    i = 0;
  if (vfs->fstype != DFS_TYPE)
  {
    XBell(disp, 0);
    return;
  };
  int    k = (ev.xbutton.y - 30) / tdl + (ev.xbutton.x - 8) / (pl + 4) * th;
  if (k < th * col)
    if (curn != k)
    {
      while (i < k && o != NULL)
      {
	o = o->next;
	i++;
      }
      if (o == NULL)
	return;
      if (o->mode & S_IFDIR)
      {
	sprintf(strtmp2, "%s/%s", curdir, o->name);
	ivfs = define_vfs("DFS", strtmp2);
	if (mask & ShiftMask)
	  move(ivfs);
	else
	  copy(ivfs);
      }
      else if (o->options & S_EXTEND)
	if (is_it_afs_file(o->name))
	{
	  sprintf(strtmp2, "%s/%s", curdir, o->name);
	  ivfs = define_vfs("ARC", strtmp2);
	  if (mask & ShiftMask)
	    move(ivfs);
	  else
	    copy(ivfs);
	}
    }
}

void   Lister::fast_find(XEvent * ev)
{
  FList *o = dl.next;
  int    kn = 0, kk = 0, l;
  KeySym ks;
  XComposeStatus cs;
  char   sym[8];
  ev->xkey.state ^= Mod1Mask;
  XLookupString(&ev->xkey, sym, 4, &ks, &cs);
  if (ks == XK_BackSpace)
  {
    l = strlen(ff_buf);
    if (l)
    {
      ff_buf[l - 1] = 0;
    }
    showitem(cur, curn);
    show_ff_item(curn, l - 1);
    return;
  }
  sym[1] = 0;
  strcat(ff_buf, sym);
  l = strlen(ff_buf);
  while (o)
    if (strncmp(o->name, ff_buf, l) == 0)
      break;
    else
    {
      o = o->next;
      kn++;
    };
  if (o != NULL)
  {
    if (o != last_ff)
    {
      base = dl.next;
      cur = o;
      lcurn = curn = kn % (th * col);
      kk = kn - curn;
      setcur(&base, kk);
      showfilelist();
      last_ff = o;
    }
  }
  else
  {
    last_ff = NULL;
    if (l)
      ff_buf[--l] = 0;
  };
  show_ff_item(curn, l);
}

void   Lister::create_ftp_link()
{
  if(vfs->fstype==FTP_TYPE)
  {
    simple_mes("Pusher","Can't switch to FTP over another one!");
    return;
  }
  vfs->ch_curdir();
  new_ftp_prompt(this,12);
  //  newtextfile("Connect to Ftp Host", this, 12);
}



void   Lister::click()
{
  int    k, i = 0, action, cx, cy, rx, ry;
  KeySym ks;
  FList *ko;
  unsigned kmask;
  Window rw, cw;
  VFS   *ivfs;
  if (ev.xany.window == w)
  {
    switch (ev.type)
    {
    case Expose:
      flush_expose(w);
      expose();
      break;
    case UnmapNotify:
      break;
    case MapNotify:
      break;
    case ButtonPress:
      dnd_startx = ev.xbutton.x;
      dnd_starty = ev.xbutton.y;
      dnd_start_valid = 1;
      clear_ff();
      switch (lay)
      {
      case 0:
	guiSetInputFocus(disp, w, RevertToNone, CurrentTime);
	if (ev.xbutton.x < 25 && ev.xbutton.y < 25 && subm != NULL)
	{
	  subm->setpos(ev.xbutton.x - 2, ev.xbutton.y - 2);
	  subm->init(w);
	  subm->show();
	};
	panel = this;
	break;
      case 1:
	if (ev.xbutton.y < 25)
	{
	  if (ev.xbutton.x > l / 2 + 20)
	  {
	    panel = panel2;
	    guiSetInputFocus(disp, panel2->w, RevertToNone, CurrentTime);
	  }
	  else if (ev.xbutton.x < 25)
	  {
	    if (subm)
	    {
	      subm->setpos(ev.xbutton.x - 2, ev.xbutton.y - 2);
	      subm->init(w);
	      subm->show();
	    };
	  }
	  else
	    guiSetInputFocus(disp, w, RevertToNone, CurrentTime);
	}
	else
	  guiSetInputFocus(disp, w, RevertToNone, CurrentTime);
	break;
      case 2:
	if (ev.xbutton.y < 25)
	{
	  if (ev.xbutton.x < l / 2 - 20)
	  {
	    panel = panel2;
	    guiSetInputFocus(disp, panel2->w, RevertToNone, CurrentTime);
	  }
	  else if (ev.xbutton.x < l / 2 + 12)
	  {
	    if (subm)
	    {
	      subm->setpos(ev.xbutton.x - 2, ev.xbutton.y - 2);
	      subm->init(w);
	      subm->show();
	    };
	  }
	  else
	    guiSetInputFocus(disp, w, RevertToNone, CurrentTime);
	}
	else
	  guiSetInputFocus(disp, w, RevertToNone, CurrentTime);
	break;
      };
      if (ev.xbutton.y > 30 && ev.xbutton.x > 8 && ev.xbutton.y < h - 30)
      {
	if (cur == NULL)
	  break;
	if (curn == -1)
	  curn = lcurn;
	k = (ev.xbutton.y - 30) / tdl + (ev.xbutton.x - 8) / (pl + 4) * th;
	if (k < th * col)
	  if (curn != k)
	  {
	    i = curn;
	    curn = k;
	    showitem(cur, i);
	    if (setcur(&cur, k - i))
	      curn = k;
	    else
	      curn = i;
	    if (ev.xbutton.button == Button3 || 
		(ev.xbutton.button == Button1 && (ev.xbutton.state & ControlMask)))
	      selected(cur);
	  }
	  else if (ev.xbutton.button == Button3 ||
		   (ev.xbutton.button == Button1 && (ev.xbutton.state & ControlMask)))
	    selected(cur);
	showitem(cur, curn);
      }
      else if (ev.xbutton.y > h - 30)
	if (ev.xbutton.x > l - 53)
	{
	  if (curn == -1)
	    curn = lcurn;
	  if (ev.xbutton.x < l - 30)
	    left();
	  else
	    right();
	}
	else if (ev.xbutton.x < 53 && (option_bits & STATUS_ATTR))
	{
	  if (ev.xbutton.state & ShiftMask)
	    init_chown_dialog(cur);
	  // *INDENT-OFF*        
	  else 
	    if(selfiles==0) 
	      ::attrib(cur,7); 
	    else 
	      attrib2();
	  // *INDENT-ON*        
	};
      prflg = 1;
      break;

    case FocusIn:
      panel = this;
      focus_fl = 1;
      XRaiseWindow(disp, w);
      if (curn == -1)
      {
	vfs->ch_curdir();
	curn = lcurn;
	if (cur == NULL)
	  reread();
	showitem(cur, curn);
      }
      if (cmdl)
      {
	cmdl->save_input();
	cmdl->setpath(curdir);
      }
      senddir(curdir);
      if(cmdl)
      {
	cmdl->restore_input();
	cmdl->expose();
      }
      foc = 1;
      break;
    case FocusOut:
      if (curn != -1)
      {
	lcurn = curn;
	curn = -1;
	if (cur != NULL)
	  showitem(cur, lcurn);
      };
      foc = 0;
      break;
    case MotionNotify:
      XQueryPointer(disp, Main, &rw, &cw, &rx, &ry, &cx, &cy, &kmask);
      if (!(kmask & ControlMask) && ((kmask & Button1Mask) || (kmask & Button2Mask)))
      {
	if (dnd_enabled)
	{
	  if (cw == bmark->w)
	    bmark->show_dir_banner(cy - 25);
	}
	else if (dnd_start_valid && (abs(dnd_starty - cy + y) > 10 || abs(dnd_startx - cx + x) > 10))
	{
	  if (selfiles)
	    XDefineCursor(disp, w, cdnd2);
	  else
	    XDefineCursor(disp, w, cdnd1);
	  dnd_enabled = 1;
	  dnd_creator = this;
	  dnd_startm = ev.xbutton.state;
	  bmark->set_recycle_image(1);
	}
      }
      else if (cw == w && ((kmask & Button3Mask) || 
			   ((kmask & Button1Mask) && (kmask & ControlMask))))
      {
	cy -= y;
	cx -= x;
	if (cy > 30 && cx > 8 && cy < h - 30)
	{
	  if (curn == -1)
	    curn = lcurn;
	  k = (cy - 30) / tdl + (cx - 8) / (pl + 4) * th;
	  if (k < th * col)
	    if (curn != k)
	    {
	      i = curn;
	      curn = k;
	      showitem(cur, i);
	      if (setcur(&cur, k - i))
		curn = k;
	      else
		curn = i;
	      selected(cur);
	      showitem(cur, curn);
	    }
	}
      }
      break;
    case ButtonRelease:
      dnd_start_valid=0;
      if (dnd_enabled)
      {
	dnd_enabled = 0;
	XUndefineCursor(disp, w);
	send_dnd_message();
	XQueryPointer(disp, Main, &rw, &cw, &rx, &ry, &cx, &cy, &kmask);
	bmark->set_recycle_image(0);
	bmark->hide_dir_banner();
	if (cw == w && ev.xbutton.y > 30)
	  check_dnd_dir(kmask);
	else if (cw == bmark->w)
	{
	  if (cy > bmark->h - 50)
	    del();
	  else
	  {
	    ivfs = bmark->get_vfs_by_coord(cy - 25);
	    if (ivfs)
	    {
	      if (kmask & ShiftMask)
		move(ivfs);
	      else
		copy(ivfs);
	    }
	    else if (dnd_starty > 25)
	      try_to_add_to_bookmark(cy - 25);
	    else
	      bmark->add_toempty_book_by_coord(cy - 25, vfs->get_info_for_bookmark(), vfs->fstype);
	  }
	}
	else if (cmdl->w == cw)
	{
	  mouse = 1;
	  activate();
	  mouse = 0;
	}
	else if (cw == panel2->w)
	{
	  check_dnd_dir_on_panel2(cx, cy, kmask);
	}
	else if (ev.xbutton.y < 25)
	{
	  switch (lay)
	  {
	  case 1:
	    if (ev.xbutton.x > l / 2 + 20)
	    {
	      if (kmask & ShiftMask)
		move();
	      else
		copy();
	    }
	    else
	      XBell(disp, 0);
	    break;
	  case 2:
	    if (ev.xbutton.x < l / 2 - 20)
	    {
	      if (kmask & ShiftMask)
		move();
	      else
		copy();
	    }
	    else
	      XBell(disp, 0);
	    break;
	  }
	};
      }
      else if (bclk)
      {
	prflg = 0;
	bclk = 0;
	if (((ev.xbutton.time - dbtime) <= DBLCLICK &&
	     abs(ev.xbutton.x - lmx) <= 10 && abs(ev.xbutton.y - lmy) <= 10 &&
	     ev.xbutton.y > 30 && ev.xbutton.x > 8 && ev.xbutton.y < h - 30) || ev.xbutton.button == Button2)

	{
	  mouse = 1;
	  activate();
	  mouse = 0;
	}

	else
	  prflg = 1;
      }
      else if (ev.xbutton.button == Button2)
      {
	mouse = 1;
	activate();
	mouse = 0;
      }
      if (prflg)
      {
	dbtime = ev.xbutton.time;
	lmx = ev.xbutton.x;
	lmy = ev.xbutton.y;
	prflg = 0;
	bclk = 1;
      }
      break;

    case KeyPress:
      action = look_for_key(&ev);
      switch (action)
      {
      case ASwitchTab:
	clear_ff();
	panel = panel2;
	guiSetInputFocus(disp, panel->w, RevertToNone, CurrentTime);
	break;
      case AExecute:
	clear_ff();
	activate();
	break;
      case AInsert:
	if (strcmp(cur->name, "..") != 0)
	{
	  selected(cur);
	  showitem(cur, curn);
	};
      case AMoveDown:
	go_downline();
	break;
      case AMoveUp:
	go_upline();
	break;
      case AMoveLeft:
	clear_ff();
	left();
	break;
      case AMoveRight:
	clear_ff();
	right();
	break;
      case AMoveHome:
	go_home();
	break;
      case AMoveEnd:
	go_end();
	break;
      case AMovePageDn:
	page_down();
	break;
      case AMovePageUp:
	page_up();
	break;
      case ACmdDown:
	cmdl->press(XK_Down);
	break;
      case ACmdUp:
	cmdl->press(XK_Up);
	break;
      case ACmdRight:
	cmdl->press(XK_Right);
	disable_modifiers = 1;
	evret = 0;
	break;
      case ACmdLeft:
	cmdl->press(XK_Left);
	disable_modifiers = 1;
	evret = 0;
	break;
      case AInvertMask:
	ko = dl.next->next;
	while (ko != NULL)
	{
	  selected(ko);
	  ko = ko->next;
	};
	showfilelist();
	break;
      case ASelectMask:
	selectmask(this, 5);
	break;
      case ADeselectMask:
	selectmask(this, 6);
	break;
      case ARemountList:
	for (i = 0; i < mntmax; i++)
	  panlist[i] = mnt[i];
	newpanel("Remount Device ?", mntmax, panmnt);
	break;
      case ARemount:
	remount();
	break;
      case AMan:
	newtextfile("Man page", this, 11);
	break;
      case AFDelete:
	clear_ff();
	del();
	break;
      case AFCopy:
	clear_ff();
	copy();
	break;
      case AFMove:
	clear_ff();
	move();
	break;
      case AQuit:
	donefunc();
	break;
      case APrint:
	initquery("Print file", this, panel2->vfs, 8);
	break;
      case AAttributes:
	// *INDENT-OFF*        
	if(selfiles==0) 
	  ::attrib(cur,7); 
	else 
	  attrib2();
	// *INDENT-ON*        


	break;
      case AKill:
	clear_ff();
	ps_info();
	break;
#ifdef NO_INTERNAL_VT
      case ARaise:
	if (lowfl)
	  XRaiseWindow(disp, Main);
	else
	  XLowerWindow(disp, Main);
	lowfl ^= 1;
	XFlush(disp);
	if (foc)
	  cmdl->setpath(curdir);
	chdir(curdir);
	break;
#endif
      case AFNewEdit:
	clear_ff();
	newtextfile("New text file", this, 4);
	break;
      case AFEdit:
	vfs->ch_curdir();
	clear_ff();
	edit();
	break;
      case AFView:
	view(1);
	break;
      case AFSimpleView:
	view(0);
	break;
      case AMenu:
	menupanel(panexec2);
	break;
      case AMakeDir:
	vfs->ch_curdir();
	newtextfile("Make directory", this, 3);
	break;
      case ARereadDir:
	lastscan = 0;
	if(vfs->fstype==FTP_TYPE)
	{
	  vfs->need_reread=1;
	  vfs->options|=REALREAD_BIT;
	}
	reread();
	break;
      case AFind:
	find_panel();
	break;
      case ADiskInfo:
	dfs_info(centerx * 2 - 40);
	break;
      case AQuickView:
	qview();
	break;
      case AMemory:
	free_info(centerx * 2 - 40);
	break;
      case ABookAdd:
	bmark->add_toempty_book(vfs->get_info_for_bookmark(), vfs->fstype);
	break;
      case ABook1:
	bmark->switch_books(0);
	break;
      case ABook2:
	bmark->switch_books(1);
	break;
      case ABook3:
	bmark->switch_books(2);
	break;
      case ABook4:
	bmark->switch_books(3);
	break;
      case ABook5:
	bmark->switch_books(4);
	break;
      case ABook6:
	bmark->switch_books(5);
	break;
      case ABook7:
	bmark->switch_books(6);
	break;
      case ABook8:
	bmark->switch_books(7);
	break;
      case ABook9:
	bmark->swap_books(8);
	break;
      case ADelBook:
	bmark->del_book(bmark->last_used);
	break;
      case AChown:
	init_chown_dialog(cur);
	break;
      case ACleanCache:
	try_clean_afs_cache();
	break;
#ifndef DISABLE_FTP
      case AFtpLink:
	create_ftp_link();
	break;
#endif
      case AInsertLeftDir:
	insert_left_dir();
	break;
      case AInsertRightDir:
	insert_right_dir();
	break;
      case ASelectFileMask:
	select_file_mask(YES);
	break;
      case ADeselectFileMask:
	select_file_mask(NO);
	break;
      case AInodeInfo:
	toggle_inodewin();
	break;
      case AQuickFInfo:
	do_quick_file();
	break;
	//    case ASwitchToTerm: raise_terminal_if_need();break;
      default:
	//              if ((ev.xkey.state & ControlMask) == 0)
	{
	  ks = XLookupKeysym(&ev.xkey, 0);
	  if ((ev.xkey.state & Mod1Mask) == 0)
	    cmdl->press(ks);
	  else
	  {
	    fast_find(&ev);
	    evret = 1;
	    break;
	  }
	};
	evret = 0;
      };
      break;
    }
  }
}
////////////////////////////////End of file/////////////////////////////////////////
