#include <stdlib.h>
#include <string.h>
#include "forms.h"
#include "Xmysql.h"
#include "XmysqlErr.h"

#define _MAIN_XMYSQL
#include "Xmysql_def.h"
#undef _MAIN_XMYSQL

int 
main (int argc, char *argv[])
{
	FD_Xmysql_main *fd_Xmysql_main;
	char title[300];
	int arg;
	char *xpm_arg = getenv ("XMYSQL_XPMPATH");
	char *hlp_arg = getenv ("XMYSQL_HELPPATH");

	fl_initialize (&argc, argv, 0, 0, 0);

	memset (CURRENT_DATABASE, 0, sizeof (CURRENT_DATABASE));
	memset (CURRENT_TABLE, 0, sizeof (CURRENT_TABLE));
	memset (CURRENT_FIELD, 0, sizeof (CURRENT_FIELD));
	memset (CURRENT_SQL_TABLE, 0, sizeof (CURRENT_SQL_TABLE));
	memset (BATCH_SQL, 0, sizeof (BATCH_SQL));
	memset (CURRENT_USER, 0, sizeof (CURRENT_USER));
	memset (CURRENT_PASSWORD, 0, sizeof (CURRENT_PASSWORD));
	memset (CURRENT_SOCKET, 0, sizeof (CURRENT_SOCKET));
	memset (CURRENT_PORT, 0, sizeof (CURRENT_PORT));
	memset (title, 0, sizeof (title));

	/* check for env override */
	if (xpm_arg)
		strcpy (CURRENT_RD, xpm_arg);
	if (hlp_arg)
		strcpy (CURRENT_HD, hlp_arg);

	strcpy (CURRENT_SERVER, "localhost");

	for (arg = 1; arg < argc; arg++) {
		if (!strcmp (argv[arg], "-host"))
			strcpy (CURRENT_SERVER, argv[++arg]);
		else if (!strcmp (argv[arg], "-user"))
			strcpy (CURRENT_USER, argv[++arg]);
		else if (!strcmp (argv[arg], "-password"))
			strcpy (CURRENT_PASSWORD, argv[++arg]);
		else if (!strcmp (argv[arg], "-qlimit"))
			QUICK_LIMIT = atoi (argv[++arg]);
		else if (!strcmp (argv[arg], "-port"))
			strcpy (CURRENT_PORT, argv[++arg]);
		else if (!strcmp (argv[arg], "-socket"))
			strcpy (CURRENT_SOCKET, argv[++arg]);
		else if (!strcmp (argv[arg], "-help")) {
			printf ("\nUSAGE:\n");
			printf ("xmysql [-host hst] [-user usr -password pw] [-port #] [-socket pth] [-qlimit #]\n");
			return -1;
		}
	}

	fd_Xmysql_main = create_form_Xmysql_main ();

	/* fill-in form initialization code */
	if (QUICK_LIMIT > 0)
		sprintf (title, "Xmysql - Server: %s   QLimit: %d",
						 CURRENT_SERVER, QUICK_LIMIT);
	else
		sprintf (title, "Xmysql - Server: %s", CURRENT_SERVER);

	/* show the first form */
	fl_show_form (Xmysql_main_screen->Xmysql_main,
								FL_PLACE_CENTER | FL_FREE_SIZE,
								FL_FULLBORDER, title);
	while (fl_do_forms ());
	return 0;
}

void 
Build_SQL (char *str, int screen)
{
	char *lines[XMYSQL_MAX_FREEFORM_LINES];
	char aLine[XMYSQL_MAX_FREEFORM_LINE];
	char fullbuffer[XMYSQL_MAX_FREEFORM_LINES * XMYSQL_MAX_FREEFORM_LINE];
	char buffer2[1024];
	int len_of_newstr = 0;
	const char *input;
	int x, c, xpos, ypos, len = 0;
	int nlines = 0;
	int topline = 0;
	char *res = 0;

	for (x = 0; x < XMYSQL_MAX_FREEFORM_LINES; x++)
		lines[x] = 0;

	memset (fullbuffer, 0, sizeof (fullbuffer));
	memset (buffer2, 0, sizeof (buffer2));
	memset (aLine, 0, sizeof (aLine));
	len_of_newstr = strlen (str);

	if (screen == 1) {
		fl_get_input_cursorpos (Xmysql_table_admin_screen->xmysql_freeform,
														&xpos, &ypos);
		nlines =
			fl_get_input_numberoflines (Xmysql_table_admin_screen->xmysql_freeform);
		topline =
			fl_get_input_topline (Xmysql_table_admin_screen->xmysql_freeform);
		input = fl_get_input (Xmysql_table_admin_screen->xmysql_freeform);
	}
	else {
		fl_get_input_cursorpos (Xmysql_sql_screen->xmysql_freeForm,
														&xpos, &ypos);
		nlines =
			fl_get_input_numberoflines (Xmysql_sql_screen->xmysql_freeForm);
		topline =
			fl_get_input_topline (Xmysql_sql_screen->xmysql_freeForm);
		input = fl_get_input (Xmysql_sql_screen->xmysql_freeForm);
	}

	if (input && input[0]) {
		strcpy (fullbuffer, input);

		res = 0;
		c = 0;
		x = 0;
		for (res = &fullbuffer[0];
				 c < (XMYSQL_MAX_FREEFORM_LINE - len_of_newstr); res++) {
			if (*res != '\0' && *res != '\n') {
				aLine[c] = *res;
				c++;
			}
			else if (*res == '\0') {
				/* reached end of line with no new line */
				/* so we must also be at the end of fulbuffer */
				aLine[c] = 0;
				len = strlen (aLine) + 1;
				lines[x] = (char *) calloc (sizeof (char), len + len_of_newstr + 10);

				strcpy (lines[x], aLine);

				/* do we want to add a \n */
				if (strlen(lines[x]) >= XMYSQL_WRAP_LENGTH)
					strcat(lines[x], "\n");
				break;
			}
			else {
				/* newline on a line by itself */
				if (c == 0) {
					lines[x] = (char *) calloc (sizeof (char), len_of_newstr + 10);

					strcpy (lines[x], "\n");
					c = 0;
					x++;
				}
				else {
					/* reached a new line */
					aLine[c] = 0;
					len = strlen (aLine) + 1;
					lines[x] = (char *) calloc (sizeof (char), len + len_of_newstr + 10);

					strcpy (lines[x], aLine);
					strcat (lines[x], "\n");
					memset (aLine, 0, sizeof (aLine));
					c = 0;
					x++;
				}
			}
			/* check on max lines */
			if (x >= XMYSQL_MAX_FREEFORM_LINES) {
				XmysqlErr ("INFO",
									 "Max number of lines reached",
									 " ",
									 " ");
				return;
			}
		}

		if (c >= XMYSQL_MAX_FREEFORM_LINE - len_of_newstr) {
			XmysqlErr ("INFO",
								 "Max line length reached",
								 " ",
								 " ");
			return;
		}

		/* now insert new str into position */
		/* this will be line ypos at xpos */
		memset (aLine, 0, sizeof (aLine));
		strncpy (aLine, lines[ypos - 1], xpos);
		strcat (aLine, str);
		if (lines[ypos - 1][xpos])
			strcpy (buffer2, &lines[ypos - 1][xpos]);
		strcat (aLine, buffer2);
		strcpy (lines[ypos - 1], aLine);

		/* now write back the lines */
		memset (fullbuffer, 0, sizeof (fullbuffer));
		for (x = 0; x < XMYSQL_MAX_FREEFORM_LINES; x++) {
			if (lines[x] != 0) {
				if (x == 0)
					strcpy (fullbuffer, lines[x]);
				else
					strcat (fullbuffer, lines[x]);
			}
		}
		input = fullbuffer;

		if (screen == 1) {
			fl_set_input (Xmysql_table_admin_screen->xmysql_freeform, input);

			/* now position cursor */
			fl_set_input_cursorpos (Xmysql_table_admin_screen->xmysql_freeform,
															xpos + len_of_newstr, ypos);
		}
		else {
			fl_set_input (Xmysql_sql_screen->xmysql_freeForm, input);

			/* now position cursor */
			fl_set_input_cursorpos (Xmysql_sql_screen->xmysql_freeForm,
															xpos + len_of_newstr, ypos);
		}

		/* now free memory */
		for (x = 0; x < XMYSQL_MAX_FREEFORM_LINES; x++) {
			if (lines[x] != 0)
				free (lines[x]);
		}
	}
	else {
		strcpy (fullbuffer, input);
		input = fullbuffer;
		strcat (fullbuffer, str);
		if (screen == 1)
			fl_set_input (Xmysql_table_admin_screen->xmysql_freeform, input);
		else
			fl_set_input (Xmysql_sql_screen->xmysql_freeForm, input);
	}
}

void 
DoHelp (char *str)
{
	if (Xmysql_help_screen != 0) {
		fl_set_input (Xmysql_help_screen->xmysql_search_string, str);
		Help_FindCB (NULL, 0);
	}
}

void 
FreeTableFieldInfo (void)
{
	int x;
	FieldInfo *f = 0;

	if (TABLEFIELDINFO.tableName)
		free (TABLEFIELDINFO.tableName);
	if (TABLEFIELDINFO.databaseName)
		free (TABLEFIELDINFO.databaseName);
	for (x = 0; x < TABLEFIELDINFO.nbrFields; x++) {
		f = TABLEFIELDINFO.fields[x];
		if (f->field.name)
			free (f->field.name);
		if (f->field.table)
			free (f->field.table);
		if (f->field.def)
			free (f->field.def);
		f->field.type = -1;
		f->field.length = 0;
		f->field.max_length = 0;
		f->field.flags = 0;
		f->field.decimals = 0;
		free (f);
	}
	free (TABLEFIELDINFO.fields);
	TABLEFIELDINFO.fields = 0;
}

int 
GetMaxFieldSize (void)
{
	int i, maxSize = 0;
	FieldInfo *f = 0;

	/* find longest field name */
	for (i = 0; i < TABLEFIELDINFO.nbrFields; i++) {
		f = TABLEFIELDINFO.fields[i];
		if (strlen (f->field.name) > maxSize)
			maxSize = strlen (f->field.name);
	}
	return maxSize;
}

void 
ChangeCursor (int cursor)
{
	if (Xmysql_main_screen &&
			Xmysql_main_screen->Xmysql_main->window)
		fl_set_cursor (Xmysql_main_screen->Xmysql_main->window,
									 cursor ? cursor : XC_top_left_arrow);

	if (Xmysql_sql_screen &&
			Xmysql_sql_screen->Xmysql_sql->window)
		fl_set_cursor (Xmysql_sql_screen->Xmysql_sql->window,
									 cursor ? cursor : XC_top_left_arrow);

	if (Xmysql_query_results_screen &&
			Xmysql_query_results_screen->Xmysql_query_results->window)
		fl_set_cursor (Xmysql_query_results_screen->Xmysql_query_results->window,
									 cursor ? cursor : XC_top_left_arrow);

	if (Xmysql_batch_query_screen &&
			Xmysql_batch_query_screen->Xmysql_batch_query->window)
		fl_set_cursor (Xmysql_batch_query_screen->Xmysql_batch_query->window,
									 cursor ? cursor : XC_top_left_arrow);

	if (Xmysql_table_admin_screen &&
			Xmysql_table_admin_screen->Xmysql_table_admin->window)
		fl_set_cursor (Xmysql_table_admin_screen->Xmysql_table_admin->window,
									 cursor ? cursor : XC_top_left_arrow);

	if (Xmysql_about_screen &&
			Xmysql_about_screen->Xmysql_about->window)
		fl_set_cursor (Xmysql_about_screen->Xmysql_about->window,
									 cursor ? cursor : XC_top_left_arrow);

	if (Xmysql_help_screen &&
			Xmysql_help_screen->Xmysql_help->window)
		fl_set_cursor (Xmysql_help_screen->Xmysql_help->window,
									 cursor ? cursor : XC_top_left_arrow);

	if (Xmysql_config_screen &&
			Xmysql_config_screen->Xmysql_config->window)
		fl_set_cursor (Xmysql_config_screen->Xmysql_config->window,
									 cursor ? cursor : XC_top_left_arrow);

	if (Xmysql_addrec_screen &&
			Xmysql_addrec_screen->Xmysql_add_record->window)
		fl_set_cursor (Xmysql_addrec_screen->Xmysql_add_record->window,
									 cursor ? cursor : XC_top_left_arrow);
}
