/*	$Csoft: sun.c,v 1.1 2001/08/31 00:09:04 vedge Exp $	*/

/*
 * Copyright (c) 2001, CubeSoft Communications, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistribution of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistribution in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of CubeSoft Communications, nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "sun.h"
#include "libxmms/configfile.h"
#include "xmms/i18n.h"
#include <errno.h>

sunAudio	audio;

OutputPlugin sun_op =
{
	NULL,
	NULL,
	NULL,			/* Description */
	sun_init,
	sun_about,
	sun_configure,
	sun_get_volume,
	sun_set_volume,
	sun_open,
	sun_write,
	sun_close,
	sun_flush,
	sun_pause,
	sun_free,
	sun_playing,
	sun_get_output_time,
	sun_get_written_time,
	sun_cleanup
};


OutputPlugin *
get_oplugin_info(void)
{
	sun_op.description = g_strdup_printf(_("Sun Driver %s"), SUN_VERSION);
	return (&sun_op);
}


void
sun_init(void)
{
	ConfigFile *cfgfile;
	char *s;

	memset(&audio, 0, sizeof(sunAudio));

	if ((cfgfile = xmms_cfg_open_default_file())) {
		/* Devices */
		xmms_cfg_read_string(cfgfile, "sun",
		    "audio_devaudio", &audio.devaudio);
		xmms_cfg_read_string(cfgfile, "sun",
		    "audio_devaudioctl", &audio.devaudioctl);
		xmms_cfg_read_string(cfgfile, "sun",
		    "audio_devmixer", &audio.devmixer);

		/* Buffering */
		xmms_cfg_read_int(cfgfile, "sun",
		    "buffer_size", &audio.req_buffer_size);
		xmms_cfg_read_int(cfgfile, "sun",
		    "prebuffer_size", &audio.req_prebuffer_size);

		/* Mixer */
		xmms_cfg_read_string(cfgfile, "sun",
		    "mixer_voldev", &audio.mixer_voldev);
		xmms_cfg_read_boolean(cfgfile, "sun",
		    "mixer_keepopen", &audio.mixer_keepopen);

		xmms_cfg_free(cfgfile);
	}
	audio.channels = 2;

	/* Audio device path */
	if ((s = getenv("AUDIODEVICE"))) {
		audio.devaudio = g_strdup(s);
	} else if (!audio.devaudio || !strcmp("", audio.devaudio)) {
		audio.devaudio = g_strdup(SUN_DEV_AUDIO);
	}

	/* Audio control device path */
	if (!audio.devaudioctl || !strcmp("", audio.devaudioctl)) {
		audio.devaudioctl = g_strdup(SUN_DEV_AUDIOCTL);
	}

	/* Mixer device path */
	if ((s = getenv("MIXERDEVICE"))) {
		audio.devmixer = g_strdup(s);
	} else if (!audio.devmixer || !strcmp("", audio.devmixer)) {
		audio.devmixer = g_strdup(SUN_DEV_MIXER);
	}

	if (!audio.mixer_voldev || !strcmp("", audio.mixer_voldev)) {
		audio.mixer_voldev = g_strdup(SUN_DEFAULT_VOLUME_DEV);
	}

	/* Default buffering settings */
	if (!audio.req_buffer_size) {
		audio.req_buffer_size = SUN_DEFAULT_BUFFER_SIZE;
	}
	if (!audio.req_prebuffer_size) {
		audio.req_prebuffer_size = SUN_DEFAULT_PREBUFFER_SIZE;
	}

	if (pthread_mutex_init(&audio.mixer_mutex, NULL) != 0) {
		perror("mixer_mutex");
	}
}


void
sun_cleanup(void)
{
	g_free(audio.devaudio);
	g_free(audio.devaudioctl);
	g_free(audio.devmixer);
	g_free(audio.mixer_voldev);

	if (!pthread_mutex_lock(&audio.mixer_mutex)) {
		if (audio.mixerfd) {
			close(audio.mixerfd);
		}
		pthread_mutex_unlock(&audio.mixer_mutex);
		pthread_mutex_destroy(&audio.mixer_mutex);
	}
}

