/*	$Csoft: resample.h,v 1.1 2001/08/31 00:09:04 vedge Exp $	*/

/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-2000  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _OUTPUT_SUN_RESAMPLE_H
#define _OUTPUT_SUN_RESAMPLE_H

#define RESAMPLE_STEREO(sample_type)				\
do {								\
    const gint shift = sizeof (sample_type);			\
    gint i, in_samples, out_samples, x, delta;			\
    sample_type *inptr = (sample_type *)ob, *outptr;		\
    guint nlen = (((length >> shift) * espeed) / speed);	\
    if (nlen == 0)						\
	break;							\
    nlen <<= shift;						\
    if((big_endian &&						\
	(audio.sun_format == AUDIO_ENCODING_SLINEAR_LE	        \
	|| audio.sun_format == AUDIO_ENCODING_ULINEAR_LE))	\
    || (!big_endian &&						\
	(audio.sun_format == AUDIO_ENCODING_SLINEAR_BE		\
	|| audio.sun_format == AUDIO_ENCODING_ULINEAR_BE)))	\
	    swap_words(ob, length >> 1);			\
    if(nlen > nbuffer_size) {					\
	nbuffer = g_realloc(nbuffer, nlen);			\
	nbuffer_size = nlen;					\
    }								\
    outptr = (sample_type *)nbuffer;				\
    in_samples = length >> shift;				\
    out_samples = nlen >> shift;				\
    delta = (in_samples << 12) / out_samples;			\
								\
    for(x = 0, i = 0; i < out_samples; i++)			\
    {								\
	gint x1, frac;						\
	x1 = (x >> 12) << 12;					\
	frac = x - x1;						\
	*outptr++ =						\
	    (sample_type)					\
	    ((inptr[(x1 >> 12) << 1] *				\
		((1<<12) - frac) +				\
		inptr[((x1 >> 12) + 1) << 1] *			\
		frac) >> 12);					\
	*outptr++ =						\
	    (sample_type)					\
	    ((inptr[((x1 >> 12) << 1) + 1] *			\
		((1<<12) - frac) +				\
		inptr[(((x1 >> 12) + 1) << 1) + 1] *		\
		frac) >> 12);					\
	x += delta;						\
    }								\
								\
    if((big_endian &&						\
	(audio.sun_format == AUDIO_ENCODING_SLINEAR_LE		\
	|| audio.sun_format == AUDIO_ENCODING_ULINEAR_LE))	\
    || (!big_endian &&						\
	(audio.sun_format == AUDIO_ENCODING_SLINEAR_BE		\
	|| audio.sun_format == AUDIO_ENCODING_ULINEAR_BE)))	\
	    swap_words(nbuffer, nlen >> 1);			\
    w = write(audio.fd, nbuffer, nlen);				\
} while (0)


#define RESAMPLE_MONO(sample_type)				\
do {								\
    const gint shift = sizeof (sample_type) - 1;		\
    gint i, x, delta, in_samples, out_samples;			\
    sample_type *inptr = (sample_type *)ob, *outptr;		\
    guint nlen = (((length >> shift) * espeed) / speed);	\
    if(nlen == 0)						\
	break;							\
    nlen <<= shift;						\
    if((big_endian &&						\
	(audio.sun_format == AUDIO_ENCODING_SLINEAR_LE		\
	|| audio.sun_format == AUDIO_ENCODING_ULINEAR_LE))	\
    || (!big_endian &&						\
	(audio.sun_format == AUDIO_ENCODING_SLINEAR_BE 	\
	|| audio.sun_format == AUDIO_ENCODING_ULINEAR_BE)))	\
	    swap_words(ob, length >> 1);			\
    if(nlen > nbuffer_size)					\
    {								\
	nbuffer = g_realloc(nbuffer, nlen);			\
	nbuffer_size = nlen;					\
    }								\
    outptr = (sample_type *)nbuffer;				\
    in_samples = length >> shift;				\
    out_samples = nlen >> shift;				\
    delta = ((length >> shift) << 12) / out_samples;		\
    for(x = 0, i = 0; i < out_samples; i++)			\
    {								\
	gint x1, frac;						\
	x1 = (x >> 12) << 12;					\
	frac = x - x1;						\
	*outptr++ =						\
	    (sample_type)					\
	    ((inptr[x1 >> 12] * ((1<<12) - frac) +		\
	    inptr[(x1 >> 12) + 1] * frac) >> 12);		\
	    x += delta;						\
    }								\
								\
    if((big_endian &&						\
	(audio.sun_format == AUDIO_ENCODING_SLINEAR_LE		\
	|| audio.sun_format == AUDIO_ENCODING_ULINEAR_LE))	\
    || (!big_endian &&						\
	(audio.sun_format == AUDIO_ENCODING_SLINEAR_BE 	\
	|| audio.sun_format == AUDIO_ENCODING_ULINEAR_BE)))	\
	    swap_words(nbuffer, nlen >> 1);			\
    w = write(audio.fd, nbuffer, nlen);				\
} while (0)

#endif /* _OUTPUT_SUN_RESAMPLE_H */
