/*	$Csoft: mixer.c,v 1.1 2001/08/31 00:09:04 vedge Exp $	*/

/*
 * Copyright (c) 2001, CubeSoft Communications, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistribution of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistribution in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of CubeSoft Communications, nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "sun.h"
#include "mixer.h"

int
sun_mixer_get_dev(int fd, int *dev, char *id)
{
	mixer_devinfo_t info;

	for (info.index = 0; ioctl(fd, AUDIO_MIXER_DEVINFO, &info) >= 0;
	     info.index++) {
		if (!strcmp(id, info.label.name)) {
			*dev = info.index;
			return (0);
		}
	}
	return (-1);
}

void
sun_get_volume(int *l, int *r)
{
	mixer_ctrl_t mixer;

	SUN_MIXER_OPEN(*l = 0; *r = 0; return;);

	if ((sun_mixer_get_dev(audio.mixerfd, &mixer.dev, audio.mixer_voldev)
	    < 0)) {
		SUN_MIXER_CLOSE;
		return;
	}
	mixer.type = AUDIO_MIXER_VALUE;
	mixer.un.value.num_channels = audio.channels;

	if (ioctl(audio.mixerfd, AUDIO_MIXER_READ, &mixer) < 0) {
		SUN_MIXER_CLOSE;
		return;
	}
	*l = (mixer.un.value.level[AUDIO_MIXER_LEVEL_LEFT] * 100) / 255;
	if (mixer.un.value.num_channels > 1) {
		*r = (mixer.un.value.level[AUDIO_MIXER_LEVEL_RIGHT] * 100) /
		    255;
	} else {
		*r = *l;
	}

	SUN_MIXER_CLOSE;
}


void
sun_set_volume(int l, int r)
{
	mixer_ctrl_t mixer;

	SUN_MIXER_OPEN(return;);

	if ((sun_mixer_get_dev(audio.mixerfd, &mixer.dev, audio.mixer_voldev)
	    < 0)) {
		if (!audio.mixer_keepopen) {
			close(audio.mixerfd);
		}
		return;
	}
	mixer.type = AUDIO_MIXER_VALUE;
	mixer.un.value.num_channels = audio.channels;

	mixer.un.value.level[AUDIO_MIXER_LEVEL_LEFT] = (l * 255) / 100;
	if (mixer.un.value.num_channels > 1) {
		mixer.un.value.level[AUDIO_MIXER_LEVEL_RIGHT] = (r * 255) / 100;
	}

	if (ioctl(audio.mixerfd, AUDIO_MIXER_WRITE, &mixer) < 0) {
		if (!audio.mixer_keepopen) {
			close(audio.mixerfd);
		}
		return;
	}
	SUN_MIXER_CLOSE;
}
