/******************************************************************************
Copyright (c) 1994, 1997 by Jin Yu.
All rights reserved.

The software provided hereunder is on an "AS IS" basis. Permission to
use, copy, modify, and distribute this software and its documentation
for any non-commercial purpose, without fee, and without written
agreement is hereby granted, provided that the above copyright notice
appears in all copies of this software.
******************************************************************************/

// include files

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <limits.h>

#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/MessageB.h>
#include <Xm/SelectioB.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/Frame.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/DragDrop.h>


// data structures

enum surface_T {Unknown, Question, Flag};

enum bottom_T {Empty, Near1, Near2, Near3, Near4, Near5, Near6, Near7, Near8,
	       Bomb};

enum game_mode_T {Easy, Medium, Hard, Customized};


class mine_hunter_T;	// forward declaration

class gui_T {	// private container class
      protected:
	friend class mine_hunter_T;

        const int mine_width; // 32 in pixels

	Widget
	  MainShellW,
	    GameDialogW,
	       NumOfMinesTextFW,
	       FieldWidthTextFW,
	       FieldHeightTextFW,
	       WarningW,
            EnterNameDialogW,
            AboutDialogW,
	    HelpDialogW,
	    HighScoreDialogW,
	       NameW[10], ScoreW[10],
	    MainWinW,
	      MenuBarW,
		FileMenuW,
		EditMenuW,
		GameMenuW,
		OptionMenuW,
		HelpMenuW,
	      CommandW,
		TimeW,
		NewGameW,
	        MineCountW,
	      FieldW,
		**BlockW,
	      MessageW;

  	XmString MessageString;

	XtAppContext AppCon;
	XtIntervalId Timer;

	Pixmap bomb_bmap, openbomb_bmap, empty_bmap, near1_bmap, near2_bmap,
               near3_bmap, near4_bmap, near5_bmap, near6_bmap, near7_bmap,
               near8_bmap, flag_bmap, wrongflag_bmap, question_bmap, cover_bmap;
	Pixmap normal_pmap, smile_pmap, cry_pmap;

	gui_T(void): mine_width(32), Timer(XtIntervalId(0)) { }
};


class app_T {	// private container class
      protected:
	friend class mine_hunter_T;

        const char *high_score_path; // default "/usr/local/lib/xminehunter"

        game_mode_T game_mode;
        Bool first_move; // user first time make an action in the field
	int field_width, field_height; // 10x10, 16x16, 15row x 30 col

	int num_of_mines; // 10, 40, 99 mines

	int time;

	int open_counter, flag_counter;

	struct state_T {
		surface_T surface;
		bottom_T bottom;
		Bool open;
	} **state;

	struct {
	  char name[80];
	  int score;
	} high_score[10];

	app_T(void): high_score_path("/usr/local/lib/xminehunter"),
                     game_mode(Medium), first_move(True),
	             field_width(16), field_height(16),
		     num_of_mines(40), time(0),
		     open_counter(0), flag_counter(0)
	  {
#ifdef MINE_SCORE_PATH
	    high_score_path = MINE_SCORE_PATH;
#endif
	  }
};


class mine_hunter_T {	// iterator class
      private:
	gui_T* gui_part;
	app_T* app_part;

	void widen(int i, int j);
	void quick(int i, int j);
	void setup_blocks(void);
	void create_pixmaps(void);
	void lose(void);
	void win(void);
	void show_bottom(int i, int j);
	void del(void);
	void get_coordinates(Widget w, int& x, int& y);
	void new_game(int mine_num, int width_of_field, int height_of_field);

	int lock(void);
	Bool unlock(int fd);
	Bool read(void);
	Bool write(void);
	int compare_score(void);
	Bool update_score(char *name);

	static void open_mine_cb(Widget w, XtPointer client_data,
				 XmAnyCallbackStruct *call_data);
	static void file_quit_cb(Widget w, XtPointer client_data,
                                 XmAnyCallbackStruct *call_data);
        static void game_dialog_ok_cb(Widget w, XtPointer client_data,
				      XmAnyCallbackStruct *call_data);
        static void enter_name_ok_cb(Widget w, XtPointer client_data,
				     XmAnyCallbackStruct *call_data);
        static void new_game_cb(Widget w, XtPointer client_data,
                                XmAnyCallbackStruct *call_data);
        static void high_score_cb(Widget w, XtPointer client_data,
				  XmAnyCallbackStruct *call_data);
	static void game_easy_cb(Widget w, XtPointer client_data,
				 XmAnyCallbackStruct *call_data);
        static void game_medium_cb(Widget w, XtPointer client_data,
                                 XmAnyCallbackStruct *call_data);
        static void game_hard_cb(Widget w, XtPointer client_data,
                                 XmAnyCallbackStruct *call_data);
        static void game_customized_cb(Widget w, XtPointer client_data,
                                       XmAnyCallbackStruct *call_data);
        static void about_cb(Widget w, XtPointer client_data,
			     XmAnyCallbackStruct *call_data);
        static void help_cb(Widget w, XtPointer client_data,
			    XmAnyCallbackStruct *call_data);
	static void put_flag_eh(Widget w, XtPointer client_data,
				XEvent *event);

      public:
	mine_hunter_T(void);
	~mine_hunter_T(void) { del(); }

	void init_gui(int argc, char **argv);
	void init_app(void);
        void run_game(void);
	static void update_time(XtPointer client_data);
};
