/******************************************************************************
Copyright (c) 1994, 1997 by Jin Yu.
All rights reserved.

The software provided hereunder is on an "AS IS" basis. Permission to
use, copy, modify, and distribute this software and its documentation
for any non-commercial purpose, without fee, and without written
agreement is hereby granted, provided that the above copyright notice
appears in all copies of this software.
******************************************************************************/

#include "xminehunter.h"


void mine_hunter_T::put_flag_eh(Widget w, XtPointer client_data,
				XEvent *event)
{
  mine_hunter_T* cd = (mine_hunter_T*) client_data;
  Arg args[1];
  int x, y;

  if (cd->app_part->first_move) {
    mine_hunter_T::update_time(XtPointer(cd));
    cd->app_part->first_move = False;
  }

  cd->get_coordinates(w, x, y);

  if (event->xbutton.button == Button2)
    if (cd->app_part->state[x][y].open)
      cd->quick(x, y);
    else
      switch (cd->app_part->state[x][y].surface) {
	case Question:
	  XtSetArg(args[0], XmNlabelPixmap, cd->gui_part->cover_bmap);
          XtSetValues(w, args, 1);
	  cd->app_part->state[x][y].surface = Unknown;
	  break;
	case Flag:
	  XBell(XtDisplay(w), 0);
          break;
	default: // Unknown
	  XtSetArg(args[0], XmNlabelPixmap, cd->gui_part->question_bmap);
          XtSetValues(w, args, 1);
	  cd->app_part->state[x][y].surface = Question;
      }

  if (event->xbutton.button == Button3)
    if (cd->app_part->state[x][y].open)
      XBell(XtDisplay(w), 0);
    else {
      switch (cd->app_part->state[x][y].surface) {
        case Question:
          XtSetArg(args[0], XmNlabelPixmap, cd->gui_part->flag_bmap);
          XtSetValues(w, args, 1);
	  cd->app_part->state[x][y].surface = Flag;
	  cd->app_part->flag_counter++;
	  break;
	case Flag:
	  XtSetArg(args[0], XmNlabelPixmap, cd->gui_part->cover_bmap);
	  XtSetValues(w, args, 1);
          cd->app_part->state[x][y].surface = Unknown;
	  cd->app_part->flag_counter--;
          break;
	default: // Unknown
          XtSetArg(args[0], XmNlabelPixmap, cd->gui_part->flag_bmap);
          XtSetValues(w, args, 1);
          cd->app_part->state[x][y].surface = Flag;
	  cd->app_part->flag_counter++;
      }

      char count_str[80];
      sprintf(count_str, "%d",
	      cd->app_part->num_of_mines - cd->app_part->flag_counter);
      XmString xm_str = XmStringCreate(count_str, "TAG1");
      XtVaSetValues(cd->gui_part->MineCountW, XmNlabelString, xm_str, NULL);
      XmStringFree(xm_str);

      if ( cd->app_part->open_counter ==
             cd->app_part->field_width * cd->app_part->field_height -
               cd->app_part->num_of_mines
	   && cd->app_part->flag_counter == cd->app_part->num_of_mines )
	cd->win();
    }

}
