/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: xresize.c                                                     *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : resize routines                                          *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * Functions    : XMdcResize()                 - Resize the dimension      *
 *                XMdcResizeSelCallbackApply() - Resize Sel Apply callback *
 *                XMdcResizeSel()              - Select the intial resize  *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id: xresize.c,v 1.1.1.1 2000/10/28 16:52:00 enlf Exp $
 */

/*
   Copyright (C) 1997-2000 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

/****************************************************************************
                              H E A D E R S
****************************************************************************/

#include "xmedcon.h"

/****************************************************************************
                              D E F I N E S
****************************************************************************/

static GtkWidget *wresize=NULL;

/****************************************************************************
                            F U N C T I O N S
****************************************************************************/

Uint32 XMdcResize(Uint32 dim)
{
  Uint32 newdim = dim;    

  /* note #1: when divide, integer round up => no pixel loss */
  /* note #2: defined division constants are negative        */

  switch (sResizeSelection.CurType) {
   case XMDC_RESIZE_ORIGINAL: 
       break;
   case XMDC_RESIZE_FOURTH  :
       newdim += (XMDC_RESIZE_FOURTH + 1); newdim /= -XMDC_RESIZE_FOURTH; 
       break;
   case XMDC_RESIZE_HALF    : 
       newdim += (XMDC_RESIZE_HALF   + 1); newdim /= -XMDC_RESIZE_HALF;   
       break;
   case XMDC_RESIZE_DOUBLE  : 
       newdim *=  XMDC_RESIZE_DOUBLE;
       break;
  }

  return(newdim);
}

void XMdcResizeSelCallbackApply(GtkWidget *widget, gpointer data)
{
  Int8 type=XMDC_RESIZE_ORIGINAL;

  MdcDebugPrint("DEBUG: Initial Resize = ");
  if (GTK_TOGGLE_BUTTON(sResizeSelection.Fourth)->active)         {
    MdcDebugPrint("Fourth\n"); type = XMDC_RESIZE_FOURTH;       
  }else if (GTK_TOGGLE_BUTTON(sResizeSelection.Half)->active)           {
    MdcDebugPrint("Half\n"); type = XMDC_RESIZE_HALF;
  }else if (GTK_TOGGLE_BUTTON(sResizeSelection.Original)->active) {
    MdcDebugPrint("Original\n"); type = XMDC_RESIZE_ORIGINAL;
  }else if (GTK_TOGGLE_BUTTON(sResizeSelection.Double)->active)   {
    MdcDebugPrint("Double\n"); type = XMDC_RESIZE_DOUBLE;
  }

  if (type != sResizeSelection.CurType) {
    sResizeSelection.CurType = type;
    if (XMDC_FILE_OPEN == MDC_YES) {
      XMdcBeginProgressBar("Resizing images:");
      XMdcViewerHide(); 
      XMdcViewerEnableAutoShrink();
      XMdcViewerReset();
      XMdcDisplayImages();
      XMdcViewerShow();
      XMdcViewerDisableAutoShrink();
      XMdcEndProgressBar();
    }
  } 
}

void XMdcResizeSel(void)
{

  GtkWidget *box1;
  GtkWidget *box2;
  GtkWidget *box3;
  GtkWidget *box4;
  GtkWidget *frame;
  GtkWidget *button;
  GtkWidget *separator;
  GSList *group;

  if (wresize == NULL) {

    wresize = gtk_window_new(GTK_WINDOW_TOPLEVEL);

    gtk_signal_connect(GTK_OBJECT(wresize),"destroy",
                       GTK_SIGNAL_FUNC(XMdcMedconQuit),NULL);
    gtk_signal_connect(GTK_OBJECT(wresize),"delete_event",
                       GTK_SIGNAL_FUNC(XMdcHandlerToHide),NULL);

    gtk_window_set_title(GTK_WINDOW(wresize),"Resize Selection");

    gtk_container_set_border_width (GTK_CONTAINER (wresize), 0);

    box1 = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (wresize), box1);
    gtk_widget_show(box1);

    /* create upper box - Initial Resize */
    box2 = gtk_vbox_new (FALSE, 5);
    gtk_box_pack_start (GTK_BOX (box1), box2, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER(box2), 5);
    gtk_widget_show(box2);
 
    box3 = gtk_hbox_new (FALSE, 5);
    gtk_box_pack_start(GTK_BOX(box2), box3, TRUE, TRUE, 0);
    gtk_widget_show(box3);

    frame = gtk_frame_new("Initial Resize");
    gtk_box_pack_start(GTK_BOX (box3), frame, TRUE, TRUE, 0);
    gtk_widget_show(frame);

    box4 = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(frame), box4);
    gtk_container_set_border_width(GTK_CONTAINER(box4), 5);
    gtk_widget_show(box4);
 
    button = gtk_radio_button_new_with_label(NULL, "[1:4] fourth");
    gtk_box_pack_start(GTK_BOX(box4), button, TRUE, TRUE, 0);
    if (sResizeSelection.CurType == XMDC_RESIZE_FOURTH);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(button), TRUE);
    gtk_widget_show(button);
    sResizeSelection.Fourth = button;

    group = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
    button = gtk_radio_button_new_with_label(group, "[1:2] half");
    gtk_box_pack_start(GTK_BOX(box4), button, TRUE, TRUE, 0);
    if (sResizeSelection.CurType == XMDC_RESIZE_HALF)
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(button), TRUE);
    gtk_widget_show(button);
    sResizeSelection.Half = button;

    group = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
    button = gtk_radio_button_new_with_label(group, "[1:1] original");
    gtk_box_pack_start (GTK_BOX(box4), button, TRUE, TRUE, 0);
    if (sResizeSelection.CurType == XMDC_RESIZE_ORIGINAL)
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(button), TRUE);
    gtk_widget_show(button);
    sResizeSelection.Original = button;

    group = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
    button = gtk_radio_button_new_with_label(group, "[2:1] double");
    gtk_box_pack_start (GTK_BOX(box4), button, TRUE, TRUE, 0);
    if (sResizeSelection.CurType == XMDC_RESIZE_DOUBLE)
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(button), TRUE);
    gtk_widget_show(button);
    sResizeSelection.Double = button;

    /* create horizontal separator */
    separator = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, FALSE, 0);
    gtk_widget_show (separator);

    /* create bottom button box */
    box2 = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start(GTK_BOX(box1), box2, TRUE, TRUE, 2);
    gtk_widget_show(box2);
 
    button = gtk_button_new_with_label("Apply");
    gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 2);
    gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
                       GTK_SIGNAL_FUNC(gtk_widget_hide), GTK_OBJECT(wresize));
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
                       GTK_SIGNAL_FUNC(XMdcResizeSelCallbackApply), NULL);
    gtk_widget_show(button);

    button = gtk_button_new_with_label ("Cancel");
    gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 2);
    gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
        GTK_SIGNAL_FUNC(gtk_widget_hide),GTK_OBJECT(wresize));
    gtk_widget_show(button);
 
  }else{
    /* set buttons to appropriate state */
    GtkWidget *b1, *b2, *b3, *b4;
   
    gtk_widget_hide(wresize);
 
    b1 = sResizeSelection.Fourth;
    b2 = sResizeSelection.Half;
    b3 = sResizeSelection.Original;
    b4 = sResizeSelection.Double;
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b1),FALSE);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b2),FALSE);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b3),FALSE);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b4),FALSE);
    switch (sResizeSelection.CurType) {
      case XMDC_RESIZE_FOURTH  :
          gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b1),TRUE); break;
      case XMDC_RESIZE_HALF    :
          gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b2),TRUE); break;
      case XMDC_RESIZE_ORIGINAL:
          gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b3),TRUE); break;
      case XMDC_RESIZE_DOUBLE  :
          gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b4),TRUE); break;
    }

  } 

  XMdcShowWidget(wresize);
}




   
