/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: xoptions.c                                                    *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : handle (X)MedCon options routines                        *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * Functions    : XMdcOptionsMedconCallbackApply() - Options Apply callback*
 *                XMdcOptionsMedconSel()           - Options Medcon select *
 *                XMdcOptionsRenderSel()           - Options Render select *
 *                XMdcOptionsResizeSel()           - Options Resize select *
 *                XMdcOptionsColorMapSel()         - Options Map    select *
 *                XMdcOptionsLabelSel()            - Options Label  select *
 *                XMdcOptionsPagesSel()            - Options Pages  select *
 *                XMdcSensitiveBitsUsed12()        - Sensitive   button    *
 *                XMdcUnsensitveBitsUsed12()       - Unsensitive button    *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id: xoptions.c,v 1.1.1.1 2000/10/28 16:51:54 enlf Exp $
 */

/*
   Copyright (C) 1997-2000 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

/****************************************************************************
                              H E A D E R S
****************************************************************************/

#include "xmedcon.h"

/****************************************************************************
                             D E F I N E S
****************************************************************************/

static GtkWidget *woption=NULL;

/****************************************************************************
                            F U N C T I O N S
****************************************************************************/
void XMdcOptionsMedconCallbackApply(GtkWidget *widget, gpointer data)
{
  /* Pixel Values */
  MDC_NEGATIVE=MDC_NO; MDC_QUANTIFY=MDC_NO; MDC_CALIBRATE=MDC_NO;
  if (GTK_TOGGLE_BUTTON(sOptionsMedCon.PixPositives)->active) {
    MDC_NEGATIVE=MDC_NO; MDC_QUANTIFY=MDC_NO; MDC_CALIBRATE=MDC_NO; /*nothing*/
  }else if (GTK_TOGGLE_BUTTON(sOptionsMedCon.PixNegatives)->active) {
    MDC_NEGATIVE=MDC_YES;
  }else if (GTK_TOGGLE_BUTTON(sOptionsMedCon.PixQuantify)->active) {
    MDC_QUANTIFY=MDC_YES;
  }else if (GTK_TOGGLE_BUTTON(sOptionsMedCon.PixCalibrate)->active) {
    MDC_CALIBRATE=MDC_YES;
  }

  /* Pixel Types */
  if (GTK_TOGGLE_BUTTON(sOptionsMedCon.PixTypeNONE)->active) {
    MDC_FORCE_INT=MDC_NO;
  }else if (GTK_TOGGLE_BUTTON(sOptionsMedCon.PixTypeBIT8_U)->active) {
    MDC_FORCE_INT=BIT8_U; 
  }else if (GTK_TOGGLE_BUTTON(sOptionsMedCon.PixTypeBIT16_S)->active) {
    MDC_FORCE_INT=BIT16_S;
  }

  if (GTK_TOGGLE_BUTTON(sOptionsMedCon.BitsUsed12)->active) {
    MDC_INT16_BITS_USED = 12;
  }else{
    MDC_INT16_BITS_USED = 16;
  }

  if (MDC_FORCE_INT != MDC_NO) {
    if (MDC_QUANTIFY || MDC_CALIBRATE) 
      XMdcDisplayWarn("Quantified values could get lost (integer pixel write)");
  } 

  /* File Endian Type */
  if (GTK_TOGGLE_BUTTON(sOptionsMedCon.FileTypeLITTLE)->active) {
    MDC_WRITE_ENDIAN = MDC_LITTLE_ENDIAN;
  }else if (GTK_TOGGLE_BUTTON(sOptionsMedCon.FileTypeBIG)->active) {
    MDC_WRITE_ENDIAN = MDC_BIG_ENDIAN;
  }

  /* Normalization */
  if (GTK_TOGGLE_BUTTON(sOptionsMedCon.NormOverFrames)->active) {
    MDC_NORM_OVER_FRAMES=MDC_YES;
  }else if (GTK_TOGGLE_BUTTON(sOptionsMedCon.NormOverAll)->active) {
    MDC_NORM_OVER_FRAMES=MDC_NO;
  }

  /* Fallback Read Format */
  if (GTK_TOGGLE_BUTTON(sOptionsMedCon.FallbackNONE)->active) {
    MDC_FALLBACK_FRMT=MDC_FRMT_BAD;
  }else if (GTK_TOGGLE_BUTTON(sOptionsMedCon.FallbackANLZ)->active) {
    MDC_FALLBACK_FRMT=MDC_FRMT_ANLZ;
  }else if (GTK_TOGGLE_BUTTON(sOptionsMedCon.FallbackDICM)->active) {
    MDC_FALLBACK_FRMT=MDC_FRMT_DICM;
  }else if (GTK_TOGGLE_BUTTON(sOptionsMedCon.FallbackECAT)->active) {
    MDC_FALLBACK_FRMT=MDC_FRMT_ECAT;
  }

  /* Analyze (SPM) */
  if (GTK_TOGGLE_BUTTON(sOptionsMedCon.AnlzRev)->active) {
    MDC_ANLZ_REV=MDC_YES;
  }else{
    MDC_ANLZ_REV=MDC_NO;
  }
  if (GTK_TOGGLE_BUTTON(sOptionsMedCon.AnlzSPM)->active) {
    MDC_ANLZ_SPM=MDC_YES;
    if ((MDC_CALIBRATE == MDC_NO) && (MDC_QUANTIFY == MDC_NO))
      XMdcDisplayWarn("For SPM scaling you should select a quantification");
  }else{
    MDC_ANLZ_SPM=MDC_NO;
  }


  /* GIF89a */
  if (GTK_TOGGLE_BUTTON(sOptionsMedCon.GifMakeGray)->active) {
    MDC_MAKE_GRAY=MDC_YES;
  }else{
    MDC_MAKE_GRAY=MDC_NO;
  }

  if (XMDC_FILE_OPEN && (XMDC_FILE_TYPE == XMDC_NORMAL))
    XMdcAskYesNo(GTK_SIGNAL_FUNC(XMdcRereadFile), NULL,"Reread current file?");

}

void XMdcOptionsMedconSel(GtkWidget *widget, gpointer data)
{
   GtkWidget *box1;
   GtkWidget *box2;
   GtkWidget *box3;
   GtkWidget *box4;
   GtkWidget *box5;
   GtkWidget *frame;
   GtkWidget *button;
   GtkWidget *separator;
   GtkWidget *label;
   GSList *group;

   if (woption == NULL) {

     woption = gtk_window_new(GTK_WINDOW_TOPLEVEL);

     gtk_signal_connect(GTK_OBJECT(woption), "destroy",
                        GTK_SIGNAL_FUNC(XMdcMedconQuit),NULL);
     gtk_signal_connect(GTK_OBJECT(woption), "delete_event",
                        GTK_SIGNAL_FUNC(XMdcHandlerToHide), NULL);

     gtk_window_set_title(GTK_WINDOW(woption),"MedCon Options");
     gtk_container_set_border_width(GTK_CONTAINER(woption),0);

     box1 = gtk_vbox_new(FALSE,0);
     gtk_container_add(GTK_CONTAINER(woption),box1);
     gtk_widget_show(box1);

     box2 = gtk_hbox_new(FALSE,5);
     gtk_box_pack_start(GTK_BOX(box1),box2,TRUE,TRUE,0);
     gtk_container_set_border_width(GTK_CONTAINER(box2),5);
     gtk_widget_show(box2);

     if (XMDC_FILE_OPEN == MDC_YES) { 
       label = gtk_label_new("* When changes applied - reread current file *");
       gtk_misc_set_alignment(GTK_MISC(label),0.5,0.5);
       gtk_box_pack_start(GTK_BOX(box2),label,TRUE,TRUE,0);
       gtk_widget_show(label);
     }

     box2 = gtk_hbox_new(FALSE,5);
     gtk_box_pack_start(GTK_BOX(box1),box2,TRUE,TRUE,0);
     gtk_container_set_border_width(GTK_CONTAINER(box2),5);
     gtk_widget_show(box2);

     /*** Column #1 ***/
     box3 = gtk_vbox_new(FALSE, 5);
     gtk_box_pack_start(GTK_BOX(box2),box3,TRUE,TRUE,0);
     gtk_widget_show(box3);

     /* Pixel Values */
     frame = gtk_frame_new("Pixel Values");
     gtk_box_pack_start(GTK_BOX(box3),frame,TRUE,TRUE,0);
     gtk_widget_show(frame);

     box4 = gtk_vbox_new(FALSE, 0);
     gtk_container_add(GTK_CONTAINER(frame),box4);
     gtk_container_set_border_width(GTK_CONTAINER(box4),5);
     gtk_widget_show(box4);

     button = gtk_radio_button_new_with_label(NULL,"positives only");
     gtk_box_pack_start(GTK_BOX(box4),button,TRUE,TRUE,0);

     if (MDC_NEGATIVE == MDC_NO &&
         MDC_QUANTIFY == MDC_NO &&
         MDC_CALIBRATE == MDC_NO)
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), TRUE);

     gtk_widget_show(button);
     sOptionsMedCon.PixPositives = button;

     group = gtk_radio_button_group(GTK_RADIO_BUTTON(button));
     button = gtk_radio_button_new_with_label(group,"positives & negatives");
     gtk_box_pack_start(GTK_BOX(box4),button,TRUE,TRUE,0);
     if (MDC_NEGATIVE == MDC_YES)
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), TRUE);
     gtk_widget_show(button);
     sOptionsMedCon.PixNegatives = button;

     group = gtk_radio_button_group(GTK_RADIO_BUTTON(button));
     button = gtk_radio_button_new_with_label(group,
                                  "quantified              (floats)");
     gtk_box_pack_start(GTK_BOX(box4),button,TRUE,TRUE,0);
     if (MDC_QUANTIFY == MDC_YES)
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), TRUE);
     gtk_widget_show(button);
     sOptionsMedCon.PixQuantify = button;

     group = gtk_radio_button_group(GTK_RADIO_BUTTON(button));
     button = gtk_radio_button_new_with_label(group,
                                  "quantified & calibrated (floats)");
     gtk_box_pack_start(GTK_BOX(box4),button,TRUE,TRUE,0);
     if (MDC_CALIBRATE == MDC_YES)
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), TRUE);
     gtk_widget_show(button);
     sOptionsMedCon.PixCalibrate = button;

     /* Normalization */
     frame = gtk_frame_new("Normalization");
     gtk_box_pack_start(GTK_BOX(box3),frame,TRUE,TRUE,0);
     gtk_widget_show(frame);
     box4 = gtk_vbox_new(FALSE,0);
     gtk_container_add(GTK_CONTAINER(frame),box4);
     gtk_container_set_border_width(GTK_CONTAINER(box4),10);
     gtk_widget_show(box4);

     button = gtk_radio_button_new_with_label(NULL, "over images in frame");
     gtk_box_pack_start(GTK_BOX(box4),button,TRUE,TRUE,0);
     if (MDC_NORM_OVER_FRAMES == MDC_YES)
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), TRUE);
     gtk_widget_show(button);
     sOptionsMedCon.NormOverFrames = button;

     group = gtk_radio_button_group(GTK_RADIO_BUTTON(button));
     button = gtk_radio_button_new_with_label(group,"over all images");
     gtk_box_pack_start(GTK_BOX(box4),button,TRUE,TRUE,0);
     if (MDC_NORM_OVER_FRAMES == MDC_NO)
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), TRUE);
     gtk_widget_show(button);
     sOptionsMedCon.NormOverAll = button;


     /* Fallback Read Format */
     frame = gtk_frame_new("Fallback Read Format");
     gtk_box_pack_start(GTK_BOX(box3),frame,TRUE,TRUE,0);
     gtk_widget_show(frame);
     box4 = gtk_vbox_new(FALSE,0);
     gtk_container_add(GTK_CONTAINER(frame),box4);
     gtk_container_set_border_width(GTK_CONTAINER(box4),10);
     gtk_widget_show(box4);

     button = gtk_radio_button_new_with_label(NULL,"without fallback");
     gtk_box_pack_start(GTK_BOX(box4),button,TRUE,TRUE,0);
     if (MDC_FALLBACK_FRMT == MDC_FRMT_BAD)
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
     gtk_widget_show(button);
     sOptionsMedCon.FallbackNONE = button;

     group = gtk_radio_button_group(GTK_RADIO_BUTTON(button));
     button = gtk_radio_button_new_with_label(group,"Analyze (SPM)");
     gtk_box_pack_start(GTK_BOX(box4),button,TRUE,TRUE,0);
     if (MDC_FALLBACK_FRMT == MDC_FRMT_ANLZ)
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
     gtk_widget_show(button);
     sOptionsMedCon.FallbackANLZ = button;
#if ! MDC_INCLUDE_ANLZ
     gtk_widget_set_sensitive(button,FALSE);
#endif

     group = gtk_radio_button_group(GTK_RADIO_BUTTON(button));
     button = gtk_radio_button_new_with_label(group,"DICOM 3.0");
     gtk_box_pack_start(GTK_BOX(box4),button,TRUE,TRUE,0);
     if (MDC_FALLBACK_FRMT == MDC_FRMT_DICM)
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
     gtk_widget_show(button);
     sOptionsMedCon.FallbackDICM = button;
#if ! MDC_INCLUDE_DICM
     gtk_widget_set_sensitive(button,FALSE);
#endif

     group = gtk_radio_button_group(GTK_RADIO_BUTTON(button));
     button = gtk_radio_button_new_with_label(group,"ECAT 6.4");
     gtk_box_pack_start(GTK_BOX(box4),button,TRUE,TRUE,0);
     if (MDC_FALLBACK_FRMT == MDC_FRMT_ECAT)
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
     gtk_widget_show(button);
     sOptionsMedCon.FallbackECAT = button;
#if ! MDC_INCLUDE_ECAT
     gtk_widget_set_sensitive(button,FALSE);
#endif

     /*** Column #2 ***/
     box3 = gtk_vbox_new(FALSE, 5);
     gtk_box_pack_start(GTK_BOX(box2),box3,TRUE,TRUE,0);
     gtk_widget_show(box3);

     /* Pixel Types   */
     frame = gtk_frame_new("Pixel Types");
     gtk_box_pack_start(GTK_BOX(box3),frame,TRUE,TRUE,0);
     gtk_widget_show(frame);

     box4 = gtk_vbox_new(FALSE,0);
     gtk_container_add(GTK_CONTAINER(frame),box4);
     gtk_container_set_border_width(GTK_CONTAINER(box4),5);
     gtk_widget_show(box4);

     button = gtk_radio_button_new_with_label(NULL,"writing default pixels");
     gtk_box_pack_start(GTK_BOX(box4),button,TRUE,TRUE,0);
     if (MDC_FORCE_INT == MDC_NO)
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), TRUE);
     gtk_signal_connect(GTK_OBJECT(button),"button-release-event",
                        GTK_SIGNAL_FUNC(XMdcUnsensitiveBitsUsed12),NULL);
     gtk_widget_show(button);
     sOptionsMedCon.PixTypeNONE = button;
 
     group = gtk_radio_button_group(GTK_RADIO_BUTTON(button));
     button = gtk_radio_button_new_with_label(group,"writing  Uint8  pixels");
     gtk_box_pack_start(GTK_BOX(box4),button,TRUE,TRUE,0);
     if (MDC_FORCE_INT == BIT8_U)
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), TRUE);
     gtk_signal_connect(GTK_OBJECT(button),"button-release-event",
                        GTK_SIGNAL_FUNC(XMdcUnsensitiveBitsUsed12),NULL);
     gtk_widget_show(button);
     sOptionsMedCon.PixTypeBIT8_U = button;

     box5 = gtk_hbox_new(FALSE,0);
     gtk_container_add(GTK_CONTAINER(box4),box5);
     gtk_container_set_border_width(GTK_CONTAINER(box5),0);
     gtk_widget_show(box5);

     group = gtk_radio_button_group(GTK_RADIO_BUTTON(button));
     button = gtk_radio_button_new_with_label(group,"writing  Int16  pixels");
     gtk_box_pack_start(GTK_BOX(box5),button,TRUE,TRUE,0);
     if (MDC_FORCE_INT == BIT16_S)
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), TRUE);
     gtk_signal_connect(GTK_OBJECT(button),"button-release-event",
                        GTK_SIGNAL_FUNC(XMdcSensitiveBitsUsed12),NULL);
     gtk_widget_show(button);
     sOptionsMedCon.PixTypeBIT16_S = button;

     button = gtk_check_button_new_with_label("12 bits used");
     gtk_box_pack_start(GTK_BOX(box5),button,TRUE,TRUE,0);
     if (MDC_INT16_BITS_USED == 12)
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
     gtk_widget_show(button);
     sOptionsMedCon.BitsUsed12 = button; 

     if (MDC_FORCE_INT == BIT16_S) {
       XMdcSensitiveBitsUsed12(NULL,NULL);
     }else{
       XMdcUnsensitiveBitsUsed12(NULL,NULL);
     }
 
     /* File Endian Type */
     frame = gtk_frame_new("File Endian Type");
     gtk_box_pack_start(GTK_BOX(box3),frame,TRUE,TRUE,0);
     gtk_widget_show(frame);
     box4 = gtk_vbox_new(FALSE,0);
     gtk_container_add(GTK_CONTAINER(frame),box4);
     gtk_container_set_border_width(GTK_CONTAINER(box4),10);
     gtk_widget_show(box4);

     button = gtk_radio_button_new_with_label(NULL, 
                                  "writing LITTLE endian (MSB last)");
     gtk_box_pack_start(GTK_BOX(box4),button,TRUE,TRUE,0);
     if (MDC_WRITE_ENDIAN == MDC_LITTLE_ENDIAN)
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), TRUE);
     gtk_widget_show(button);
     sOptionsMedCon.FileTypeLITTLE = button;

     group = gtk_radio_button_group(GTK_RADIO_BUTTON(button));
     button = gtk_radio_button_new_with_label(group,
                                  "writing  BIG   endian (MSB first)");
     gtk_box_pack_start(GTK_BOX(box4),button,TRUE,TRUE,0);
     if (MDC_WRITE_ENDIAN == MDC_BIG_ENDIAN)
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), TRUE);
     gtk_widget_show(button);
     sOptionsMedCon.FileTypeBIG = button;

     /* Analyze (SPM) */
     frame = gtk_frame_new("Analyze (SPM)");
     gtk_box_pack_start(GTK_BOX(box3),frame,TRUE,TRUE,0);
     gtk_widget_show(frame);

     box4 = gtk_vbox_new(FALSE,0);
     gtk_container_add(GTK_CONTAINER(frame),box4);
     gtk_container_set_border_width(GTK_CONTAINER(box4),10);
     gtk_widget_show(box4);

     button = gtk_check_button_new_with_label("reverse images, columns & rows");
     gtk_box_pack_start(GTK_BOX(box4),button,TRUE,TRUE,0);
     if (MDC_ANLZ_REV == MDC_YES)
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), TRUE);
     gtk_widget_show(button);
     sOptionsMedCon.AnlzRev = button;

     button =gtk_check_button_new_with_label("SPM version with scale & offset");
     gtk_box_pack_start(GTK_BOX(box4),button,TRUE,TRUE,0);
     if (MDC_ANLZ_SPM == MDC_YES)
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), TRUE);
     gtk_widget_show(button);
     sOptionsMedCon.AnlzSPM = button;

     /* GIF89a */
     frame = gtk_frame_new("GIF89a");
     gtk_box_pack_start(GTK_BOX(box3),frame,TRUE,TRUE,0);
     gtk_widget_show(frame);

     box4 = gtk_vbox_new(FALSE,0);
     gtk_container_add(GTK_CONTAINER(frame),box4);
     gtk_container_set_border_width(GTK_CONTAINER(box4),10);
     gtk_widget_show(box4);

     button = gtk_check_button_new_with_label("make gray (colors unsupported)");
     gtk_box_pack_start(GTK_BOX(box4),button,TRUE,TRUE,0);
     if (MDC_MAKE_GRAY == MDC_YES)
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), TRUE);
     gtk_widget_show(button);
     sOptionsMedCon.GifMakeGray = button;
     gtk_widget_set_sensitive(button,FALSE); /* only support GRAYSCALE ;-) */

     /* separator */
     separator = gtk_hseparator_new();
     gtk_box_pack_start(GTK_BOX(box1),separator,FALSE,FALSE,0);
     gtk_widget_show(separator);

     /* create bottom button box */
     box2 = gtk_hbox_new(FALSE,0);
     gtk_box_pack_start(GTK_BOX(box1),box2,TRUE,TRUE,2);
     gtk_widget_show(box2);

     button = gtk_button_new_with_label("Apply");
     gtk_box_pack_start(GTK_BOX(box2),button,TRUE,TRUE,2);
     gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
                        GTK_SIGNAL_FUNC(gtk_widget_hide), GTK_OBJECT(woption));
     gtk_signal_connect(GTK_OBJECT(button),"clicked",
                        GTK_SIGNAL_FUNC(XMdcOptionsMedconCallbackApply), NULL);
     gtk_widget_show(button);

     button = gtk_button_new_with_label("Cancel");
     gtk_box_pack_start(GTK_BOX(box2),button,TRUE,TRUE,2);
     gtk_signal_connect_object(GTK_OBJECT(button),"clicked",
         GTK_SIGNAL_FUNC(gtk_widget_hide),GTK_OBJECT(woption));
     gtk_widget_show(button);

  }else{
     /* set buttons to appropriate state */
     GtkWidget *b1, *b2, *b3, *b4;

     gtk_widget_hide(woption);

     b1 = sOptionsMedCon.PixQuantify;
     b2 = sOptionsMedCon.PixCalibrate;
     b3 = sOptionsMedCon.PixNegatives;
     b4 = sOptionsMedCon.PixPositives;
     gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b1), FALSE);
     gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b2), FALSE);
     gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b3), FALSE);
     gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b4), FALSE); 
     if (MDC_QUANTIFY == MDC_YES) {
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b1), TRUE);
     }else if (MDC_CALIBRATE == MDC_YES) {
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b2), TRUE);
     }else if (MDC_NEGATIVE == MDC_YES) {
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b3), TRUE);
     }else{
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b4), TRUE);
     } 

     b1 = sOptionsMedCon.NormOverFrames;
     b2 = sOptionsMedCon.NormOverAll;
     if (MDC_NORM_OVER_FRAMES == MDC_YES) {
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b1), TRUE);
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b2), FALSE);
     }else{
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b1), FALSE);
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b2), TRUE);
     }

     b1 = sOptionsMedCon.FallbackNONE;
     b2 = sOptionsMedCon.FallbackANLZ;
     b3 = sOptionsMedCon.FallbackDICM;
     b4 = sOptionsMedCon.FallbackECAT;
     gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b1), FALSE);
     gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b2), FALSE);
     gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b3), FALSE);
     gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b4), FALSE);
     switch (MDC_FALLBACK_FRMT) {
       case MDC_FRMT_BAD:     
           gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b1), TRUE);
           break;
       case MDC_FRMT_ANLZ:
           gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b2), TRUE);
           break;
       case MDC_FRMT_DICM:
           gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b3), TRUE);
           break;
       case MDC_FRMT_ECAT:
           gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b4), TRUE);
           break;
     }

     b1 = sOptionsMedCon.PixTypeNONE;  
     b2 = sOptionsMedCon.PixTypeBIT8_U;
     b3 = sOptionsMedCon.PixTypeBIT16_S;
     b4 = sOptionsMedCon.BitsUsed12;
     gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b1), FALSE);
     gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b2), FALSE);
     gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b3), FALSE);
     gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b4), FALSE);
     switch (MDC_FORCE_INT) {
       case MDC_NO:
           gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b1), TRUE); 
           XMdcUnsensitiveBitsUsed12(NULL,NULL);
           break;
       case BIT8_U:
           gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b2), TRUE);
           XMdcUnsensitiveBitsUsed12(NULL,NULL);
           break;
       case BIT16_S:
           gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b3), TRUE);
           XMdcSensitiveBitsUsed12(NULL,NULL);
           break; 
     }
     if (MDC_INT16_BITS_USED == 12)
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b4), TRUE);
     

     b1 = sOptionsMedCon.FileTypeLITTLE;
     b2 = sOptionsMedCon.FileTypeBIG;
     if (MDC_WRITE_ENDIAN == MDC_LITTLE_ENDIAN) {
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b1), TRUE);
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b2), FALSE);
     }else{
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b1), FALSE);
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b2), TRUE);
     }

     b1 = sOptionsMedCon.AnlzRev;
     if (MDC_ANLZ_REV == MDC_YES) 
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b1), TRUE);
     else
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b1), FALSE);

     b1 = sOptionsMedCon.AnlzSPM;
     if (MDC_ANLZ_SPM == MDC_YES)
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b1), TRUE);
     else
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b1), FALSE);

     b1 = sOptionsMedCon.GifMakeGray;
     if (MDC_MAKE_GRAY == MDC_YES)
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b1), TRUE);
     else
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b1), FALSE);
     
  }

  XMdcShowWidget(woption);

}

void XMdcOptionsRenderSel(GtkWidget *widget, gpointer data)
{
  XMdcRenderingSel();
}

void XMdcOptionsResizeSel(GtkWidget *widget, gpointer data)
{
  XMdcResizeSel();
}

void XMdcOptionsColorMapSel(GtkWidget *widget, gpointer data)
{
  XMdcColorMapSel();
}

void XMdcOptionsLabelSel(GtkWidget *widget, gpointer data)
{
  XMdcLabelSel();
}

void XMdcOptionsPagesSel(GtkWidget *widget, gpointer data)
{
  if (pages_to_frames == MDC_NO) {
    XMdcAskYesNo( GTK_SIGNAL_FUNC(XMdcPagesToFrames),
                  GTK_SIGNAL_FUNC(XMdcPagesNotToFrames),
                  "Link pages to number of frames?");
  }else{
    XMdcAskYesNo( GTK_SIGNAL_FUNC(XMdcPagesNotToFrames),
                  GTK_SIGNAL_FUNC(XMdcPagesToFrames),
                  "Link pages to maximum number\nof images on screen?");
  }
}

void XMdcSensitiveBitsUsed12(GtkWidget *widget, gpointer data)
{
   gtk_widget_set_sensitive(GTK_WIDGET(sOptionsMedCon.BitsUsed12),TRUE);
}

void XMdcUnsensitiveBitsUsed12(GtkWidget *widget, gpointer data)
{
   gtk_widget_set_sensitive(GTK_WIDGET(sOptionsMedCon.BitsUsed12),FALSE);
}

