/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: xextract.c                                                    *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : extract images routines                                  *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * Functions    : XMdcExtractImages()                 - Extract the images *
 *                XMdcHandleEcatList()                - Handle Ecat list   *
 *                XMdcHandleNormList()                - Handle Norm list   *
 *                XMdcGetImagesCallbackApply()        - Get Apply callback *
 *                XMdcGetImages()                     - Get the images     *
 *                XMdcExtractStyleSelCallbackApply()  - Apply   callback   * 
 *                XMdcExtractStyleSel()               - Extract Style Sel  *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id: xextract.c,v 1.1.1.1 2000/10/28 16:51:44 enlf Exp $
 */

/*
   Copyright (C) 1997-2000 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

/****************************************************************************
                              H E A D E R S
****************************************************************************/

#include "xmedcon.h"

/****************************************************************************
                              D E F I N E S 
****************************************************************************/

static int BUSSY = MDC_NO;

/****************************************************************************
                            F U N C T I O N S
****************************************************************************/

gboolean XMdcExtractNotBussy(GtkWidget *widget, gpointer data)
{
  BUSSY = MDC_NO; return(FALSE);
}

void XMdcExtractImages(void)
{
  XMdcBeginProgressBar("Extracting images:");

  XMdcViewerHide();
  XMdcViewerEnableAutoShrink();
  XMdcViewerReset();
 
  MdcExtractImages(my.fi); /* any failure has been handled */

  XMdcDisplayImages();
  XMdcViewerShow();
  XMdcViewerDisableAutoShrink();
 
  XMdcEndProgressBar();

  XMDC_FILE_TYPE = XMDC_EXTRACT;

}

int XMdcHandleEcatList(char *s, Uint32 **list, Uint32 max)
{
  Uint32 a1, a2, j, length, tmp;
  int i, SeekBegin=MDC_YES;
  char *p, *item;

  MdcDebugPrint("DEBUG: entry = <%s>\n",s);
 
  length = strlen(s);
  p = s; item = s;
  for (i=0; i<length; i++) {
     MdcDebugPrint("DEBUG: char = <%c>\n",p[i]);
     if (p[i]=='-') break;
     if (SeekBegin) {
       if (p[i]!=' ') { item = &p[i]; SeekBegin=MDC_NO; }
     }else if (p[i]==' ') {
         SeekBegin=MDC_YES;
         p[i]='\0';
         if (strstr(item,"...") != 0) {
           /* a RANGE values */
           MdcDebugPrint("DEBUG: RANGE = <%s>\n",item);
           sscanf(item,"%u...%u",&a1,&a2);
           if (a1 > max || a2 > max) {
             XMdcDisplayErr("Bad entry found in list");
             return(MDC_NO);
           }
           if ( (a1==0) || (a2==0) ) {
             for (j=1; j<=max; j++) (*list)[j]=MDC_YES;
             (*list)[0]=max;
             return(MDC_YES);
           }
           if (a1 > a2) {
             tmp = a1;
             a1  = a2;
             a2  = tmp;
           }
           for (j=a1; j<=a2; j++) {
              if ( (*list)[j] == MDC_NO) {
                (*list)[j] = MDC_YES;
                (*list)[0] += 1;
              }
           }
         }else{
           /* a SINGLE value */
           MdcDebugPrint("DEBUG: SINGLE = <%s>\n",item);
           sscanf(item,"%u",&a1);
           if (a1 > max) {
             XMdcDisplayErr("Bad entry found in list");
             return(MDC_NO);
           }
           if (a1 == 0) {
             for (j=1; j<=max; j++) (*list)[j]=MDC_YES;
             (*list)[0]=max;
             return(MDC_YES);
           }
           if ( (*list)[a1] == MDC_NO) {
             (*list)[a1] = MDC_YES;
             (*list)[0] += 1;
           }
         }
      }
  }
  return(MDC_YES);
}

 
int XMdcHandleNormList(char *s, Uint32 **inrs,Uint32 *it,Uint32 *bt,Uint32 max)
{
  Uint32 a1, a2, j, length;
  int i, SeekBegin=MDC_YES;
  char *p, *item;

  MdcDebugPrint("DEBUG: entry = <%s>\n",s);

  length = strlen(s);
  p = s; item = s;
  for (i=0; i<length; i++) {
     MdcDebugPrint("DEBUG: char = <%c>\n",p[i]);
     if (p[i]=='-') break;
     if (SeekBegin) {
       if (p[i]!=' ') { item=&p[i]; SeekBegin=MDC_NO; }
     }else if (p[i]==' ') {
         SeekBegin=MDC_YES;
         p[i]='\0';
         if (strstr(item,"...") != 0) {
           /* a RANGE values */
           MdcDebugPrint("DEBUG: RANGE = <%s>\n",item);
           sscanf(item,"%u...%u",&a1,&a2);

           if (a1 > max || a2 > max) {
             XMdcDisplayErr("Bad entry found in list");
             return(MDC_NO);
           }

           if ( (a1==0) || (a2==0) ) {
             (*inrs)[1] = 0;
             *it = 2;
             return(MDC_YES);
           }

           if (a1 > a2) {
             for (j=a1; j>=a2; j--) {
                (*inrs)[*it] = j;
                *it += 1;
                if ( (*it % MDC_BUF_ITMS) == 0 ) {
                  if (((*inrs)=(Uint32 *)MdcRealloc((*inrs),
                               (*bt)*MDC_BUF_ITMS*sizeof(Uint32)))==NULL) {
                    XMdcDisplayErr("Couldn't realloc number buffer");
                    return(MDC_NO);
                  }
                  *bt += 1;
                }
             }
           }else{
             for (j=a1; j<=a2; j++) {
                (*inrs)[*it] = j;
                *it += 1;
                if ( (*it % MDC_BUF_ITMS) == 0 ) {
                  if (((*inrs)=(Uint32 *)MdcRealloc((*inrs),
                               (*bt)*MDC_BUF_ITMS*sizeof(Uint32)))==NULL) {
                    XMdcDisplayErr("Couldn't realloc number buffer");
                    return(MDC_NO);
                  }
                  *bt += 1;
                }
             }
           }

         }else{
           /* a SINGLE value */
           MdcDebugPrint("DEBUG: SINGLE = <%s>\n",item);
           sscanf(item,"%u",&a1);
           if (a1 > max) {
             XMdcDisplayErr("Bad entry found in list",a1);
             return(MDC_NO);
           }
           if (a1 == 0) {
             (*inrs)[1] = 0;
             *it = 2;
             return(MDC_YES);
           }
           (*inrs)[*it] = a1;
           (*it) += 1;
           if ( (*it % MDC_BUF_ITMS) == 0) {
             if (((*inrs)=(Uint32 *)MdcRealloc((*inrs),
                          (*bt)*MDC_BUF_ITMS*sizeof(Uint32)))==NULL) {
               XMdcDisplayErr("Couldn't realloc number buffer");
               return(MDC_NO);
             }
             *bt += 1;
           }

         }
     }
  }

  return(MDC_YES);
} 

void XMdcGetImagesCallbackApply(GtkWidget *widget, gpointer data)
{
  MdcExtractInputStruct *input = sExtractSelection.input;
  Uint32 images=1;
  Uint32 p, f, g, b;
  Uint32 it, bt;
  Uint32 *planes, *frames, *gates, *beds;
  char *entry;

  if (XMdcNoFileOpened()) return; 

  if (input->style == MDC_INPUT_NORM_STYLE) {
    if ((input->inrs=(Uint32 *)malloc(MDC_BUF_ITMS*sizeof(Uint32)))==NULL) {
      XMdcDisplayErr("Couldn't alloc number buffer");
      return;
    }

    entry = gtk_entry_get_text(GTK_ENTRY(sExtractSelection.InputPlanes));
    
    strcpy(xmdcstr,entry);
    strcat(xmdcstr," -1");

    it = 1; bt = 2;
    if (XMdcHandleNormList(xmdcstr,&input->inrs,&it,&bt,my.fi->number) 
         != MDC_YES) {
      MdcFree(input->inrs);
      return;
    } 

  }else{
    if ( (planes=(Uint32 *)malloc((my.fi->dim[3]+1)*sizeof(Uint32)))==NULL ) {
      XMdcDisplayErr("Couldn't malloc planes buffer");
      return;
    }
    memset(planes,0,(my.fi->dim[3]+1)*sizeof(Uint32));
    if ( (frames=(Uint32 *)malloc((my.fi->dim[4]+1)*sizeof(Uint32)))==NULL ) {
      XMdcDisplayErr("Couldn't malloc frames buffer");
      MdcFree(planes);
      return;
    }
    memset(frames,0,(my.fi->dim[4]+1)*sizeof(Uint32));
    if ( (gates=(Uint32 *)malloc((my.fi->dim[5]+1)*sizeof(Uint32)))==NULL ) {
      XMdcDisplayErr("Couldn't malloc gates buffer");
      MdcFree(planes); MdcFree(frames);
      return;
    }
    memset(gates,0,(my.fi->dim[5]+1)*sizeof(Uint32));
    if ( (beds=(Uint32 *)malloc((my.fi->dim[6]+1)*sizeof(Uint32)))==NULL ) {
      XMdcDisplayErr("Couldn't malloc beds buffer");
      MdcFree(planes); MdcFree(frames); MdcFree(gates);
      return;
    }
    memset(beds,0,(my.fi->dim[6]+1)*sizeof(Uint32));

    entry = gtk_entry_get_text(GTK_ENTRY(sExtractSelection.InputPlanes));
    strcpy(xmdcstr,entry);
    strcat(xmdcstr," -1");
    if (XMdcHandleEcatList(xmdcstr,&planes,my.fi->dim[3]) != MDC_YES) {
      MdcFree(planes); MdcFree(frames); MdcFree(gates); MdcFree(beds);
      return;
    }

    entry = gtk_entry_get_text(GTK_ENTRY(sExtractSelection.InputFrames));
    strcpy(xmdcstr,entry);
    strcat(xmdcstr," -1");
    if (XMdcHandleEcatList(xmdcstr,&frames,my.fi->dim[4]) != MDC_YES) {
      MdcFree(planes); MdcFree(frames); MdcFree(gates); MdcFree(beds);
      return;
    }

    entry = gtk_entry_get_text(GTK_ENTRY(sExtractSelection.InputGates));
    strcpy(xmdcstr,entry);
    strcat(xmdcstr," -1");
    if (XMdcHandleEcatList(xmdcstr,&gates,my.fi->dim[5]) != MDC_YES) {
      MdcFree(planes); MdcFree(frames); MdcFree(gates); MdcFree(beds);
      return;
    }

    entry = gtk_entry_get_text(GTK_ENTRY(sExtractSelection.InputBeds));
    strcpy(xmdcstr,entry);
    strcat(xmdcstr," -1");
    if (XMdcHandleEcatList(xmdcstr,&beds,my.fi->dim[6]) != MDC_YES) {
      MdcFree(planes); MdcFree(frames); MdcFree(gates); MdcFree(beds);
      return;
    }

    MdcDebugPrint("DEBUG: p=%u f=%u g=%u b=%u\n",planes[0],frames[0],gates[0],beds[0]); 

    images*=planes[0]*frames[0]*gates[0]*beds[0];

    input->num_p = planes[0];
    input->num_f = frames[0];
    input->num_g = gates[0];
    input->num_b = beds[0];

    if ((input->inrs=(Uint32 *)malloc((images+1)*sizeof(Uint32)))==NULL) {
      XMdcDisplayErr("Couldn't malloc number buffer");
      MdcFree(planes); MdcFree(frames); MdcFree(gates); MdcFree(beds); 
      return;
    }

    /* get sequential image numbers (like normal selection) */
    it = 1;
    for (b=1; b<=my.fi->dim[6];b++) if (beds[b])
    for (g=1; g<=my.fi->dim[5];g++) if (gates[g])
    for (f=1; f<=my.fi->dim[4];f++) if (frames[f])
    for (p=1; p<=my.fi->dim[3];p++) if (planes[p]) {

       images = p +                     /* the image number */
                my.fi->dim[3]*( (f-1) +
                my.fi->dim[4]*( (g-1) +
                my.fi->dim[5]*( (b-1)   ) ) );
       
       input->inrs[it++]=images;  

    }

    MdcFree(planes); MdcFree(frames); MdcFree(gates); MdcFree(beds);

  }

  input->inrs[0] = it - 1;

  if (input->inrs[0] == 0) {
    XMdcDisplayWarn("No images specified");
    MdcFree(input->inrs);
    return;
  }

  XMdcExtractImages();

}



void XMdcGetImages(void)
{
   GtkWidget *window=NULL;
   GtkWidget *box1;
   GtkWidget *box2;
   GtkWidget *box3; 
   GtkWidget *table;
   GtkWidget *frame;
   GtkWidget *label;
   GtkWidget *button;
   GtkWidget *separator;
   GtkWidget *planes, *frames, *gates, *beds;
   MdcExtractInputStruct *input = sExtractSelection.input; 

   window = gtk_window_new(GTK_WINDOW_TOPLEVEL); BUSSY = MDC_YES;

   gtk_signal_connect(GTK_OBJECT(window),"destroy",
                      GTK_SIGNAL_FUNC(XMdcExtractNotBussy),NULL);
   gtk_signal_connect(GTK_OBJECT(window),"destroy",
                      GTK_SIGNAL_FUNC(gtk_widget_destroy),NULL);

   if (input->style == MDC_INPUT_NORM_STYLE) {
     gtk_window_set_title(GTK_WINDOW(window),"Extract Input Normal");
   }else{ 
     gtk_window_set_title(GTK_WINDOW(window),"Extract Input Ecat");
   } 
   gtk_container_set_border_width(GTK_CONTAINER(window),0);

   box1 = gtk_vbox_new(FALSE,5);
   gtk_container_add(GTK_CONTAINER(window),box1);
   gtk_container_set_border_width(GTK_CONTAINER(box1),5);
   gtk_widget_show(box1);

   frame = gtk_frame_new("Notes");
   gtk_box_pack_start(GTK_BOX(box1),frame,TRUE,TRUE,0);
   gtk_widget_show(frame);

   box2 = gtk_vbox_new(FALSE,5);
   gtk_container_add(GTK_CONTAINER(frame),box2);
   gtk_container_set_border_width(GTK_CONTAINER(box2),5);
   gtk_widget_show(box2);

   if (input->style == MDC_INPUT_NORM_STYLE) {
     /* create input notes */
     strcpy(mdcbufr,"a) Any number must be one-based (0 = All reversed)\n" \
                    "b) The syntax of a range: X...Y (no spaces)\n" \
                    "c) Items must be separated by spaces\n" \
                    "d) This list is sequence sensitive!\n\n" \
                    " Example: 1 3 12...6 84 31\n");

     label = gtk_label_new(mdcbufr);
     gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
     gtk_widget_set_name (label, "FixedLabel");
     gtk_box_pack_start(GTK_BOX(box2),label,TRUE,TRUE,5);
     gtk_widget_show(label);

     frame = gtk_frame_new("Entry");
     gtk_box_pack_start(GTK_BOX(box1),frame,TRUE,TRUE,0);
     gtk_widget_show(frame);

     box2 = gtk_vbox_new(FALSE,0);
     gtk_container_add(GTK_CONTAINER(frame),box2);
     gtk_container_set_border_width(GTK_CONTAINER(box2),0);
     gtk_widget_show(box2);

     box3 = gtk_hbox_new(FALSE,0);
     gtk_container_add(GTK_CONTAINER(box2),box3);
     gtk_container_set_border_width(GTK_CONTAINER(box3),0);
     gtk_widget_show(box3);

     sprintf(mdcbufr,"Images [1...%u]",my.fi->number);
     label = gtk_label_new(mdcbufr);
     gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_RIGHT);
     gtk_widget_set_name(label, "FixedLabel");
     gtk_box_pack_start(GTK_BOX(box3),label,TRUE,TRUE,0);
     gtk_widget_show(label);

     planes=gtk_entry_new_with_max_length(50);
     MdcDebugPrint("DEBUG: rc-style name = %s\n",gtk_widget_get_name(planes));
     gtk_entry_set_text(GTK_ENTRY(planes),"0");
     gtk_editable_select_region(GTK_EDITABLE(planes),0,-1);
     gtk_box_pack_start(GTK_BOX(box3),planes,TRUE,TRUE,0);
     gtk_widget_draw_default(planes);
     gtk_widget_show(planes);
     sExtractSelection.InputPlanes=planes;

   }else{
     /* create input notes */
     strcpy(mdcbufr,"a) Any number must be one-based (0 = All)\n" \
                    "b) The syntax of a range: X...Y (no spaces)\n" \
                    "c) Items must be separated by spaces\n\n" \
                    " Example: 1 3 5...10 12\n");

     label = gtk_label_new(mdcbufr);
     gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
     gtk_widget_set_name (label, "FixedLabel");
     gtk_box_pack_start(GTK_BOX(box2),label,TRUE,TRUE,5);
     gtk_widget_show(label);

     frame = gtk_frame_new("Entry");
     gtk_box_pack_start(GTK_BOX(box1),frame,TRUE,TRUE,0);
     gtk_widget_show(frame);
 
     table = gtk_table_new (4, 3, FALSE);
     gtk_container_add(GTK_CONTAINER(frame),table);
     gtk_widget_show(table);

     label = gtk_label_new("Planes");
     gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
     gtk_widget_set_name (label, "FixedLabel");
     gtk_table_attach_defaults(GTK_TABLE(table),label,0,1,0,1);
     gtk_widget_show(label);
     sprintf(mdcbufr,"[1...%u]",my.fi->dim[3]);
     label = gtk_label_new(mdcbufr);
     gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
     gtk_widget_set_name (label, "FixedLabel");
     gtk_table_attach_defaults(GTK_TABLE(table),label,1,2,0,1);
     gtk_widget_show(label);
     planes = gtk_entry_new_with_max_length(50);
     gtk_entry_set_text(GTK_ENTRY(planes),"0"); 
     gtk_editable_select_region(GTK_EDITABLE(planes),0,-1);
     gtk_table_attach_defaults(GTK_TABLE(table),planes,2,3,0,1);
     gtk_widget_show(planes);
     sExtractSelection.InputPlanes=planes;

     label = gtk_label_new("Frames");
     gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
     gtk_widget_set_name (label, "FixedLabel");
     gtk_table_attach_defaults(GTK_TABLE(table),label,0,1,1,2);
     gtk_widget_show(label);
     sprintf(mdcbufr,"[1...%u]",my.fi->dim[4]);
     label = gtk_label_new(mdcbufr);
     gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
     gtk_widget_set_name (label, "FixedLabel");
     gtk_table_attach_defaults(GTK_TABLE(table),label,1,2,1,2);
     gtk_widget_show(label);
     frames = gtk_entry_new_with_max_length(50);
     gtk_entry_set_text(GTK_ENTRY(frames),"0");
     gtk_editable_select_region(GTK_EDITABLE(frames),0,-1);
     gtk_table_attach_defaults(GTK_TABLE(table),frames,2,3,1,2);
     gtk_widget_show(frames);
     sExtractSelection.InputFrames=frames;

     label = gtk_label_new("Gates");
     gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
     gtk_widget_set_name (label, "FixedLabel");
     gtk_table_attach_defaults(GTK_TABLE(table),label,0,1,2,3);
     gtk_widget_show(label);
     sprintf(mdcbufr,"[1...%u]",my.fi->dim[5]);
     label = gtk_label_new(mdcbufr);
     gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
     gtk_widget_set_name (label, "FixedLabel");
     gtk_table_attach_defaults(GTK_TABLE(table),label,1,2,2,3);
     gtk_widget_show(label);
     gates = gtk_entry_new_with_max_length(50);
     gtk_entry_set_text(GTK_ENTRY(gates),"0");
     gtk_editable_select_region(GTK_EDITABLE(gates),0,-1);
     gtk_table_attach_defaults(GTK_TABLE(table),gates,2,3,2,3);
     gtk_widget_show(gates);
     sExtractSelection.InputGates=gates;

     label = gtk_label_new("Beds");
     gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
     gtk_widget_set_name (label, "FixedLabel");
     gtk_table_attach_defaults(GTK_TABLE(table),label,0,1,3,4);
     gtk_widget_show(label);
     sprintf(mdcbufr,"[1...%u]",my.fi->dim[6]);
     label = gtk_label_new(mdcbufr);
     gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
     gtk_widget_set_name (label, "FixedLabel");
     gtk_table_attach_defaults(GTK_TABLE(table),label,1,2,3,4);
     gtk_widget_show(label);
     beds= gtk_entry_new_with_max_length(50);
     gtk_entry_set_text(GTK_ENTRY(beds),"0");
     gtk_editable_select_region(GTK_EDITABLE(beds),0,-1);
     gtk_table_attach_defaults(GTK_TABLE(table),beds,2,3,3,4);
     gtk_widget_show(beds);
     sExtractSelection.InputBeds=beds;


   }

   /* create horizontal separator */
   separator = gtk_hseparator_new();
   gtk_box_pack_start(GTK_BOX(box1),separator,FALSE,FALSE,0);
   gtk_widget_show(separator);

   /* create bottom buttons */
   box2 = gtk_hbox_new(FALSE,0);
   gtk_box_pack_start(GTK_BOX(box1),box2,TRUE,TRUE,2);
   gtk_widget_show(box2);

   button = gtk_button_new_with_label("Apply");
   gtk_box_pack_start(GTK_BOX(box2),button,TRUE,TRUE,2);
   gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
                      GTK_SIGNAL_FUNC(gtk_widget_hide), GTK_OBJECT(window));
   gtk_signal_connect(GTK_OBJECT(button),"clicked",
                      GTK_SIGNAL_FUNC(XMdcGetImagesCallbackApply), NULL);
   gtk_signal_connect_object(GTK_OBJECT(button),"clicked",
                      GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(window));
   gtk_widget_show(button);

   button = gtk_button_new_with_label("Cancel");
   gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 2);
   gtk_signal_connect_object(GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(window));
   gtk_widget_show(button);

   XMdcShowWidget(window);
}

void XMdcExtractStyleSelCallbackApply(GtkWidget *widget, gpointer data)
{

  MdcExtractInputStruct *input = sExtractSelection.input;

  if (XMdcNoFileOpened()) return; 

  MdcDebugPrint("DEBUG: Extraction style: ");

  if (GTK_TOGGLE_BUTTON(sExtractSelection.NormStyle)->active) {
    MdcDebugPrint("Normal Style\n");  
    input->style = MDC_INPUT_NORM_STYLE;
  }else if (GTK_TOGGLE_BUTTON(sExtractSelection.EcatStyle)->active) {
    MdcDebugPrint("Ecat Style\n");
    input->style = MDC_INPUT_ECAT_STYLE;
  }

  XMdcGetImages();
 
}



void XMdcExtractStyleSel(GtkWidget *widget, gpointer data)
{
  GtkWidget *window=NULL;
  GtkWidget *box1;
  GtkWidget *box2;
  GtkWidget *box3;
  GtkWidget *box4;
  GtkWidget *frame;
  GtkWidget *button;
  GtkWidget *separator;
  GSList *group;
  MdcExtractInputStruct *input = sExtractSelection.input;

  if (XMdcNoFileOpened() || BUSSY) return;

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL); BUSSY = MDC_YES;

  gtk_signal_connect(GTK_OBJECT(window),"delete_event",
                     GTK_SIGNAL_FUNC(XMdcExtractNotBussy),NULL);
  gtk_signal_connect(GTK_OBJECT(window),"destroy",
                     GTK_SIGNAL_FUNC(gtk_widget_destroy),NULL);
  gtk_window_set_title(GTK_WINDOW(window),"Extract Selection");

  gtk_container_set_border_width (GTK_CONTAINER(window), 0);

  box1 = gtk_vbox_new(FALSE,0);
  gtk_container_add(GTK_CONTAINER(window),box1);
  gtk_widget_show(box1);

  /* create upper box - Extract Style */
  box2 = gtk_vbox_new(FALSE, 5);
  gtk_box_pack_start(GTK_BOX(box1),box2,TRUE,TRUE,0);
  gtk_container_set_border_width(GTK_CONTAINER(box2),5);
  gtk_widget_show(box2);

  box3 = gtk_hbox_new(FALSE, 5);
  gtk_box_pack_start(GTK_BOX(box2),box3,TRUE,TRUE,0);
  gtk_widget_show(box3);

  frame = gtk_frame_new("Extraction Style");
  gtk_box_pack_start(GTK_BOX(box3),frame,TRUE,TRUE,0);
  gtk_widget_show(frame);

  box4 = gtk_vbox_new(FALSE,0);
  gtk_container_add(GTK_CONTAINER(frame),box4);
  gtk_container_set_border_width(GTK_CONTAINER(box4), 5);
  gtk_widget_show(box4);

  button = gtk_radio_button_new_with_label(NULL,"Normal");
  gtk_box_pack_start(GTK_BOX(box4),button,TRUE,TRUE,0);
  if (input->style == MDC_INPUT_NORM_STYLE)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(button), TRUE);
  gtk_widget_show(button);
  sExtractSelection.NormStyle=button;

  group = gtk_radio_button_group(GTK_RADIO_BUTTON(button));
  button= gtk_radio_button_new_with_label(group,"Ecat");
  gtk_box_pack_start(GTK_BOX(box4),button,TRUE,TRUE,0);
  if (input->style == MDC_INPUT_ECAT_STYLE)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(button), TRUE);
  gtk_widget_show(button);
  sExtractSelection.EcatStyle=button;

  /* create horizontal separator */
  separator = gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(box1),separator,FALSE,FALSE,0);
  gtk_widget_show(separator);

  /* create bottom button box */
  box2 = gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(box1),box2,TRUE,TRUE,2);
  gtk_widget_show(box2);

  button = gtk_button_new_with_label("Apply");
  gtk_box_pack_start(GTK_BOX(box2),button,TRUE,TRUE,2);
  gtk_signal_connect_object(GTK_OBJECT(button),"clicked",
                     GTK_SIGNAL_FUNC(gtk_widget_hide), GTK_OBJECT(window));
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
                     GTK_SIGNAL_FUNC(XMdcExtractStyleSelCallbackApply), NULL);
  gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
                     GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(window));
  gtk_widget_show(button);

  button = gtk_button_new_with_label("Cancel");
  gtk_box_pack_start(GTK_BOX(box2),button,TRUE,TRUE,2);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
                     GTK_SIGNAL_FUNC(XMdcExtractNotBussy), NULL);
  gtk_signal_connect_object(GTK_OBJECT(button),"clicked",
                     GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(window));
  gtk_widget_show(button);

  XMdcShowWidget(window);

}

