/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: xdefs.h                                                       *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : xdefs.c header file                                      *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id: xdefs.h,v 1.1.1.1 2000/10/28 16:51:41 enlf Exp $
 */

/*
   Copyright (C) 1997-2000 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifndef __XDEFS_H__
#define __XDEFS_H__

/****************************************************************************
                              D E F I N E S 
****************************************************************************/

#define XMDC_NORMAL  1           /* file types in XMedCon         */         
#define XMDC_RAW     2           /* unsaved file                  */ 
#define XMDC_EXTRACT 3           /* unsaved file                  */
#define XMDC_SAVED   4           /* saved   file                  */

#define XMDC_FREE_BORDER 100
#define XMDC_COLORMAP_WIDTH  25
#define XMDC_COLORMAP_HEIGHT 48

#define XMDC_LABEL_RED    1
#define XMDC_LABEL_GREEN  2
#define XMDC_LABEL_BLUE   3
#define XMDC_LABEL_YELLOW 4

#define XMDC_LABEL_STYLE_ABS   1
#define XMDC_LABEL_STYLE_PAGE  2
#define XMDC_LABEL_STYLE_ECAT  3

#define XMDC_ZOOM_FACTOR       2
#define XMDC_ZOOM_MAX          8 

#define XMDC_RESIZE_ORIGINAL   1                   /* nothing       */
#define XMDC_RESIZE_FOURTH   -(XMDC_ZOOM_FACTOR*2) /* divide   by 4 */
#define XMDC_RESIZE_HALF     -(XMDC_ZOOM_FACTOR)   /* divide   by 2 */
#define XMDC_RESIZE_DOUBLE    (XMDC_ZOOM_FACTOR)   /* multiply by 2 */

#define XMDC_DEFAULT_FRMT  MDC_FRMT_RAW  /* default save format (enabled!?) */

#ifdef _WIN32
#define MDC_USE_SIGNAL_BLOCKER 1 
#endif

typedef struct SignalBlocker_t{
  guint id;
  gboolean blocked;
}SignalBlocker;

typedef struct OptionsMedConStruct_t {
        GtkWidget *PixPositives;
        GtkWidget *PixNegatives;
        GtkWidget *PixQuantify;
        GtkWidget *PixCalibrate;
        GtkWidget *PixTypeNONE;
        GtkWidget *PixTypeBIT8_U;
        GtkWidget *PixTypeBIT16_S;
        GtkWidget *BitsUsed12;
        GtkWidget *FileTypeLITTLE;
        GtkWidget *FileTypeBIG;
        GtkWidget *NormOverFrames;
        GtkWidget *NormOverAll;
        GtkWidget *FallbackNONE;
        GtkWidget *FallbackANLZ;
        GtkWidget *FallbackECAT;
        GtkWidget *FallbackDICM;
        GtkWidget *AnlzRev;
        GtkWidget *AnlzSPM;
        GtkWidget *GifMakeGray;
        GtkWidget *GifSaveWithDialog;
}OptionsMedConStruct;

typedef struct MyMainStruct_t {
    GtkWidget *mainwindow;
    GtkWidget *viewwindow;
    GtkWidget *viewbox;
    GtkWidget *pagemenu;
    GtkWidget *imgstable;
    GtkWidget *cmapbox;
    GtkWidget **image;
    GtkWidget *cmap;
    GdkPixbuf **im, *imcmap;
    GdkInterpType interp;
    GdkRgbDither dither;
    SignalBlocker *sblkr;
    gint cmap_w, cmap_h;

    FILEINFO *fi;
    Uint32 curpage, prevpage;
    Uint32 number_of_pages, images_per_page;
    Uint32 images_horizontal, images_vertical;
    Uint32 startimage, real_images_on_page;
    Uint32 *pagenumber, *imagenumber, *realnumber;
}MyMainStruct;


typedef struct ColormapSelectionStruct_t {
   gint      CurMap;
   gint      Inverted;
   GtkWidget *Gray;
   GtkWidget *GrayInvers;
   GtkWidget *Rainbow;
   GtkWidget *Combined;
   GtkWidget *Hotmetal;
   GtkWidget *Loaded;
}ColormapSelectionStruct;


typedef struct LabelSelectionStruct_t {
   gint CurState;
   gint CurColor;
   gint CurStyle;
   GdkGC *gc;
   GdkColor  *color;
   GtkWidget *On;
   GtkWidget *Off;
   GtkWidget *Red;
   GtkWidget *Blue;
   GtkWidget *Green;
   GtkWidget *Yellow;
   GtkWidget *NrAbsolute;
   GtkWidget *NrInPage;
   GtkWidget *NrEcat;
}LabelSelectionStruct;


typedef struct RenderSelectionStruct_t {
   GdkRgbDither  Dither;
   GdkInterpType Interp;
   GtkWidget *InterpNearest;
   GtkWidget *InterpTiles;
   GtkWidget *InterpBilinear;
   GtkWidget *InterpHyper;
   GtkWidget *DitherNone;
   GtkWidget *DitherNormal;
   GtkWidget *DitherMax;
}RenderSelectionStruct;

typedef struct ExtractSelectionStruct_t {
   GtkWidget *NormStyle;
   GtkWidget *EcatStyle;
   GtkWidget *InputPlanes;
   GtkWidget *InputFrames;
   GtkWidget *InputGates;
   GtkWidget *InputBeds;
   MdcExtractInputStruct *input;
}ExtractSelectionStruct;

typedef struct RawReadSelectionStruct_t {
   GtkWidget *HdrInfoWindow;
   GtkWidget *NrImages;
   GtkWidget *GenOffset;
   GtkWidget *ImgOffset;
   GtkWidget *AbsOffset;
   GtkWidget *IhdrRep, *PixSwap, *ImgSame;
   GtkWidget *ImgWidth, *ImgHeight;
   GtkWidget *typeBIT1,    *typeASCII; 
   GtkWidget *typeBIT8_S,  *typeBIT8_U;
   GtkWidget *typeBIT16_S, *typeBIT16_U;
   GtkWidget *typeBIT32_S, *typeBIT32_U;
   GtkWidget *typeBIT64_S, *typeBIT64_U;
   GtkWidget *typeFLT32,   *typeFLT64;
   Uint32 ImgCounter;
}RawReadSelectionStruct;

typedef struct ResizeSelectionStruct_t {
   Int8 CurType;
   GtkWidget *Original;
   GtkWidget *Fourth;
   GtkWidget *Half;
   GtkWidget *Double;
}ResizeSelectionStruct;

typedef struct SliderValueStruct_t {
  GtkObject  *adj;
  GtkWidget  *range;
  int        *value;
}SliderValueStruct;

typedef struct ColorModifier_t{
  guint gamma, brightness, contrast;
  Uint8 vgbc[256];
}ColorModifier;

typedef struct ColGbcCorrectStruct_t {
  GtkWidget *area;
  GdkPixmap *brightness_pmap, *brightness_mask;
  GdkPixmap *contrast_pmap, *contrast_mask;
  GdkPixmap *gamma_pmap, *gamma_mask;
  GdkPixbuf *im;
  ColorModifier mod;
  Uint32 i, nr, w, h, rw, rh;
  Uint8 *img8, vgbc[256];
}ColGbcCorrectStruct;

extern Uint8 XMDC_FILE_OPEN;
extern Uint8 XMDC_FILE_TYPE;

extern Uint8 XMDC_IMAGE_BORDER;

extern Uint8 XMDC_DOBAR;
extern gfloat pvalue;
extern GtkWidget *pbarwindow;
extern GtkWidget *pbar;

extern GdkColor Red;
extern GdkColor Green;
extern GdkColor Blue;
extern GdkColor Yellow;

extern GdkCursor *handcursor;
extern GdkCursor *fleurcursor;

extern GdkFont *sfixed;

extern MyMainStruct            my;
extern OptionsMedConStruct     sOptionsMedCon;
extern ColormapSelectionStruct sColormapSelection;
extern LabelSelectionStruct    sLabelSelection;
extern RenderSelectionStruct   sRenderSelection;
extern ExtractSelectionStruct  sExtractSelection;
extern RawReadSelectionStruct  sRawReadSelection;
extern ResizeSelectionStruct   sResizeSelection;

extern ColGbcCorrectStruct     sGbc;

extern char labelname[25];
extern Int8 pages_to_frames;
extern Uint32 write_counter;

extern char xmdcstr[MDC_2KB_OFFSET];

#endif

