/*
   XMascot Ver 2.6
   Copyright(c) 1996,1997 Go Watanabe     go@cclub.tutcc.tut.ac.jp
                          Tsuyoshi IIda   iida@cclub.tutcc.tut.ac.jp
*/

#ifndef __XMASCOT
#define __XMASCOT

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Label.h>

#include "image.h"

#define CHAIN_SIZE 8

#define DT 100				/* ߥ졼 */

#ifdef USE_DOUBLE
#define ANGLE_PI (M_PI)
#else
/* isin.c */
void isin_init(void);
int isin(int deg);
int icos(int deg);
#define ANGLE_PI (M_PI*256)
#endif

#define ROLL_DEG  (ANGLE_PI/32)
#define RAD       (M_PI/ANGLE_PI)

#define ALARM_NUM 3							/* 顼ο     */
#define ALARM_ALLNUM (ALARM_NUM+4)			/* 顼Ϣ */
#define XtRRgb	"Rgb"

/* ޥåȹ¤ */
typedef struct{
	Widget entry;	
	String title;		/* ޥå̾ */
	String fname;		/* ե̾     */
	int    col0;		/* Ʃ(pixel)  */
	int    rgb0;		/* Ʃ(rgb)    */
	float  mmag;		/* Ψ */
#ifdef SOUND
	String start_snd;	/* ư   */
	String click_snd;   /* å */
	String end_snd;		/* λ   */
#ifdef BIFF
	String mail_snd;	/* ᡼忮 */
#endif
#endif
#ifdef BIFF
	XtJustify biff_justify;	/* ᡼ޡ */
#endif
} Mascot;

/* ޥåȥ˥塼¤ */
typedef struct{
	String title;		/* ˥塼̾     */
	int n_mascots;		/* ޥå   */
	Mascot *mascots;	/* ޥåȹ¤ */
} MascotMenu;

/* 顼๽¤ */
typedef struct{
	int sw;				/* 顼ͭ */
	int hour;			/* 顼       */
	int min;			/*          ʬ        */
	String action;		/* 顼ॢ */
	XtIntervalId id;	/*  ID        */
} Alarm;

/* XMascot ܹ¤ */
typedef struct{
	Boolean	verbose;		/* ܺɽ   				*/
	int 	grav;			/*    				*/
	int 	chain_len;		/* Ĺ   				*/
	float 	f_damping;		/* 그   				*/
	double	damping;
	float	magnify;		/* Ψ					*/
	String 	search_path; 	/* ѥ 				*/
	String	pin_pat;		/* ԥΥѥե   */
	int		pcol0;			/* ԥƩǥå */
	int		prgb0;			/* ԥƩ RGB         */
	int		chain_num;		/* ο 					*/
	int		draw_timing;	/*  				*/
#ifdef USE_CHAINPAT
	String	chain_pat;		/* ɳ()Υѥե     */
	int		ccol0;			/* ɳ()Ʃǥå   */
	int		crgb0;			/* ɳ()Ʃ RGB           */
#endif
	int		menus_num;		/* ˥塼 */
	int     menu_no;		/* ư˥塼ֹ   */
	int 	no;				/* ưޥåֹ */
	String	def_act;		/* ǥեȤΥ */
	int     th;				/*   */
	Boolean random;			/* 饯Υѹ */
	int		change_time;	/* ؤޤǤλ (ʬ)  */
	Boolean all_menu;		/* ؤ˥塼         */
#ifdef BIFF
	Boolean biff_mode;		/* biff ͭ   */
	String  biff_action;	/* biff Υ */
	int	    biff_update;	/* biff ֳ     */
	Boolean biff_once;  	/* 򵯤 */
	String  biff_cmd;		/* ᥤåޥ */
	String	biff_pat;		/* biff ޡѥե           */
	String  biff_filter;	/* biff ᡼ɽѥե륿             */
	int     biff_popdown;	/* biff ᡼ξäޤǤλ   */
	int		bcol0;			/* biff ޡѥƩǥå */
	int		brgb0;			/* biff ޡѥƩ RGB         */
#ifdef YOUBIN
	char *server;			/* youbin server ۥ̾ */
	int   youbin;			/* youbin ⡼ɤɤ  */
#endif
#endif
#ifdef SOUND
	String snd_cmd;			/* ѥޥ */
#endif
#ifdef SHADOW
	int		shadow;			/* Ƥ */
#endif
	Cursor cursor_normal;
	Cursor cursor_click;
	Cursor cursor_drag;

/* XMascot ǡ */
	MascotMenu *mascot_menus;	/* ޥåȥ˥塼¤ */
	int      mascot_number;		/* Υޥå		 */
	int		 chain_disp_num;


} XMascotData, AppData, *AppDataPtr;

typedef enum {
	SOUND_START, SOUND_END, SOUND_CLICK, SOUND_MAIL
} SoundType;

/* menu.c */

void menu_add_line(Widget menu);
Widget menu_add_cascade(Widget menu,char *title,Widget cascade);
Widget menu_add_dialog(Widget menu,char *title,Widget dialog);
Widget menu_add_callback(Widget menu,char *title,XtCallbackProc callback);

Widget change_menu(Widget top,int n);
Widget preference_dialog(Widget top);
Widget alarm_dialog(Widget top);
Widget about_dialog(Widget top);
void set_new_string(String *s, String new);

/* resource.c */
void set_sim_param(void);
void get_resources(Widget top);
void usage(int *argc, char **argv);

/* etc.c */
#include "etc.h"

/* pattern.c */
void set_mas(XMascotData *adat);
void set_widget_pattern(Widget w,char *name,int c,int r);

/* timer.c */
void start_timer(void);
void stop_timer(void);
void restart_timer(void);

/* action.c */

void change_mascot(Widget w,XtPointer dat,XtPointer call);
void change_mascot_with_sound(Widget w,XtPointer dat,XtPointer call);

void RaiseAll(void);
void ExitApp(void);
void Quit(Widget w,XEvent *e,String *p,Cardinal *n);
void QuitMsg(Widget w,XEvent *e,String *p,Cardinal *n);
void MapWin(Widget w,XEvent *e,String *p,Cardinal *n);
void UnMapWin(Widget w,XEvent *e,String *p,Cardinal *n);
void ConfigWin(Widget w,XEvent *e,String *p,Cardinal *n);
void Press(Widget w,XEvent *e,String *p,Cardinal *n);
void ReleasePin(Widget w,XEvent *e,String *p,Cardinal *n);
void ReleaseMascot(Widget w,XEvent *e,String *p,Cardinal *n);
void MotionPin(Widget w,XEvent *e,String *p,Cardinal *n);
void MotionMascot(Widget w,XEvent *e,String *p,Cardinal *n);

void Sound(Widget w,XEvent *e,String *p,Cardinal *n);
void SoundStart(Widget w,XEvent *e,String *p,Cardinal *n);
void SoundClick(Widget w,XEvent *e,String *p,Cardinal *n);
void SoundEnd(Widget w,XEvent *e,String *p,Cardinal *n);
void SoundMail(Widget w,XEvent *e,String *p,Cardinal *n);

void ChangeMascot(Widget w,XEvent *e,String *p,Cardinal *n);
void ChangeMascotFile(Widget w,XEvent *e,String *p,Cardinal *n);
void ChangeMascotNext(Widget w,XEvent *e,String *p,Cardinal *n);
void ChangeMascotNextAll(Widget w,XEvent *e,String *p,Cardinal *n);
void ChangeMascotRandom(Widget w,XEvent *e,String *p,Cardinal *n);
void ChangeMascotRandomAll(Widget w,XEvent *e,String *p,Cardinal *n);

void StartMove(Widget w,XEvent *e,String *p,Cardinal *);
void System(Widget w,XEvent *e,String *p,Cardinal *n);
void ChangeParam(Widget w,XEvent *e,String *p,Cardinal *n);
void Bell(Widget w,XEvent *e,String *p,Cardinal *n);

/* sim.c */
void reset_pos(void);
void set_pos(void);
void sim(void);

#ifdef SOUND
/* sound.c */
void sound_play(char *name);
void sounds_play(char **names,int num);
void xmascot_sound(XMascotData *adat, SoundType num);
#endif

#ifdef BIFF
/* biff.c */

void set_biff(void);

void ShowBiffNotice(Widget w,XEvent *e,String *p,Cardinal *n);
void BiffEnter(Widget w,XEvent *e,String *p,Cardinal *n);

#endif

/* alarm.c */
void set_alarms(void);

/* file.c */
void get_rcfile(void);
void put_rcfile(void);
void action_parse(char *action);

enum{ NODAT, STRING, ID, SYMBOL, RESERVE } TokenType;
void set_token(char *p);
int get_token2(void);

/* main.c */
void create_chains(int num);

#endif

