/*
   XMascot Ver 2.5   image-lib
   Copyright(c) 1996 Go Watanabe     go@cclub.tutcc.tut.ac.jp
                     Tsuyoshi IIda   iida@cclub.tutcc.tut.ac.jp
*/

/* mag $B%U%!%$%k$N%m!<%I(B */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <X11/Xlib.h>
#include "image.h"

static int BITmask[8] = {1,2,4,8,16,32,64,128};

#define BIT(add,bit) ((BITmask[bit]&*(add))!=0)
#define HALF(add,bit) (((*(add))>>(bit*4))&0xf)
#define BYTE(add) (0xff&*(add))
#define WORD(add) (BYTE(add)|((BYTE((add)+1))<<8))
#define LONG(add) (WORD(add)|((WORD((add)+2))<<16))

static unsigned char *pal;		/* $B%Q%l%C%H(B */
static unsigned char *data;
#ifdef SHAPE
static unsigned char *mask;
#endif
static long head_add;
static long fa_add;
static long fa_siz;
static long fb_add;
static long fb_siz;
static long pix_add;
static long pix_siz;
static int width,height;
static int rwidth;
static int flag256;

/* $B%X%C%@$NFI$_$@$7(B */
static int getHead( FILE *fp )
{
	char head[32];
	head_add = ftell(fp);
	if( fread(head,1,32,fp) != 32 )
		return -1;
	
	flag256 = head[3]&0x80;
	width  = ((WORD(head+8)+8)/8)*8 - (WORD(head+4)/8)*8;
	rwidth = WORD(head+8) - WORD(head+4) + 1;
	height = WORD(head+10) - WORD(head+6) + 1;
	fa_add = head_add+LONG(head+12);
	fa_siz = (((flag256)?width/2:width/4)/2*height+7)/8;
	fb_add = head_add+LONG(head+16);
	fb_siz = LONG(head+20);
	pix_add = head_add+LONG(head+24);
	pix_siz = LONG(head+28);
	return 0;
}

/* $B2hA|$NE83+(B */
static int getPixel(FILE *fp)
{
	int i,j,k,l,m;
	int fa_w;
	int tabx[16] = {0,1,2,4,0,1,0,1,2,0,1,2,0,1,2,0};
	int taby[16] = {0,0,0,0,1,1,2,2,2,4,4,4,8,8,8,16};
	int tabd[16];
	unsigned char *bufa,*pa;
	unsigned char *bufb,*pb;
	unsigned char *bufp,*pp;
	unsigned char *buff,*pf;
	unsigned char *pi1,*pi2;

	for(i=0;i<16;i++)
		tabd[i] = tabx[i] * (flag256?2:4) + taby[i] * width;

	fa_w = fa_siz*8/height;

	pa = bufa = (unsigned char*)XtMalloc(fa_siz);
	pb = bufb = (unsigned char*)XtMalloc(fb_siz);
	pp = bufp = (unsigned char*)XtMalloc(pix_siz);
	pf = buff = (unsigned char*)XtMalloc(fa_w);
	
	fseek(fp,fa_add,0);
	fread(bufa,1,fa_siz,fp);
	fseek(fp,fb_add,0);
	fread(bufb,1,fb_siz,fp);
	fseek(fp,pix_add,0);
	fread(bufp,1,pix_siz,fp);

	pi1 = data = (unsigned char*)XtMalloc(width*height);

	for(i = 0;i<fa_w;i++){
		buff[i] = 0;
	}	
	
	for(k=0,j=7;k<height;k++){
		pf = buff;
		for(i=0;i<fa_w;i++,pf++){
			if(BIT(pa,j)){
				*pf ^= *pb++;
			}
			j--;
			if(j==-1){
				j = 7;
				pa++;
			}
			for(l = 1;l>=0;l--){
				if(flag256){
					if(!(m = HALF(pf,l))){
						*pi1++ = *pp++;
						*pi1++ = *pp++;
					}else{
						pi2 = pi1-tabd[m];
						*pi1++ = *pi2++;
						*pi1++ = *pi2++;
					}
				}else{
					if(!(m = HALF(pf,l))) {
						*pi1++ = 0xf & (*pp>>4);
						*pi1++ = 0xf & *pp++;
						*pi1++ = 0xf & (*pp>>4);
						*pi1++ = 0xf & *pp++;
					}else{
						pi2 = pi1-tabd[m];
						*pi1++ = *pi2++;
						*pi1++ = *pi2++;
						*pi1++ = *pi2++;
						*pi1++ = *pi2++;
					}
				}
			}
		}
	}
	XtFree((char*)bufa);
	XtFree((char*)bufb);
	XtFree((char*)bufp);
	XtFree((char*)buff);
	return 0;
}

static int getmag( FILE *fp )
{
	int ch;
	char buf[13];

	/* $B%X%C%@$N%A%'%C%/(B */
	if( fread(buf,1,12,fp) != 12 )     goto end;
	if( strncmp( buf, "MAKI02  ",8 ) ) goto end;
	/* $B%3%a%s%H$NFI$_$H$P$7(B */
	while((ch = fgetc(fp)) != 0x1a ){
		if( ch == EOF )
			goto end;
	}
	if( getHead(fp) )    goto end;
	/* $B%Q%l%C%H$NFI$_9~$_(B */
	if(flag256){
		pal = (unsigned char*)XtMalloc(3*256);
		if( fread(pal,3,256,fp) != 256 ) goto end;
	}else{
		pal = (unsigned char*)XtMalloc(3*16);
		if( fread(pal,3,16,fp)  != 16  ) goto end;
	}
	if( getPixel(fp) )   goto end;
	fclose(fp);
	return 0;
 end:
	return -1;
}

/* $B?'(B/$B%^%9%/$N@_Dj(B */
static void base( ImageData *img, int col0 )
{
	int i,j;
	unsigned short c[256];
	unsigned char *p,*o;
#ifdef SHAPE
	unsigned char *q;
	mask = (unsigned char*)XtMalloc(rwidth*height);
	q = mask;
#endif
	msg_out("making base data.");
	for(i=0;i<((flag256)?256:16);i++) {
		c[i] = 256;
	}
	o = p = data;
	
	/* $BF)L@?'<+F0H=Dj(B(^^;; */
	if( col0 == -1 )
		col0 = p[0];

	for(i=0;i<height;i++,p+=width-rwidth){
		msg_out( "\rcolor seaching line %d/%d ",i+1,height );
		for(j=0;j<rwidth;j++,p++,o++) {
#ifdef SHAPE
			*q++ = ( *p == col0 )?0:1;
#endif
			if(c[*p] == 256) {
				c[*p] = get_col(img,BYTE(pal+(*p)*3+1)
							       ,BYTE(pal+(*p)*3+0)
							       ,BYTE(pal+(*p)*3+2));
			}
			*o = c[*p];
		}
	}
	msg_out("..done.\n");
}

/* MAG $B%U%!%$%k$N%m!<%I(B */
ImageData load_mag( FILE *fp, int col0, int rgb0 )
{
	ImageData ret;

	init_image( &ret );
	if( getmag(fp) ){
		err_out("can't read MAG file!\n");
		exit(1);
	}
	msg_out("..done.\n");
	base( &ret, col0 );
	XtFree( (char*)pal );

	ret.data = data;
#ifdef SHAPE
	ret.mask = mask;
#endif
	ret.w    = rwidth;
	ret.h    = height;
	return ret;
}
