/***************************************************************************
  TI-85 driver by Krzysztof Strzecha

  Functions to emulate the video hardware of the TI-85

***************************************************************************/

#include "driver.h"
#include "artwork.h"
#include "vidhrdw/generic.h"
#include "includes/ti85.h"

static struct artwork_info *ti85_backdrop;

unsigned char ti85_palette[64][3] =
{
	{ 0x98, 0xb5, 0xa7 },	{ 0xae, 0xcd, 0xb0 },	/*0x00 */
	{ 0x92, 0xaf, 0xa4 },	{ 0xae, 0xcd, 0xb0 },	/*0x01 */
	{ 0x8c, 0xa9, 0xa2 },	{ 0xae, 0xcd, 0xb0 },	/*0x02 */
	{ 0x86, 0xa3, 0x9f },	{ 0xae, 0xcd, 0xb0 },	/*0x03 */
	{ 0x81, 0x9d, 0x9d },	{ 0xae, 0xcd, 0xb0 },	/*0x04 */
	{ 0x7b, 0x97, 0x9a },	{ 0xae, 0xcd, 0xb0 },	/*0x05 */
	{ 0x75, 0x92, 0x98 },	{ 0xae, 0xcd, 0xb0 },	/*0x06 */
	{ 0x6f, 0x8c, 0x96 },	{ 0xae, 0xcd, 0xb0 },	/*0x07 */
	{ 0x6a, 0x86, 0x93 },	{ 0xae, 0xcd, 0xb0 },	/*0x08 */
	{ 0x64, 0x80, 0x91 },	{ 0xae, 0xcd, 0xb0 },	/*0x09 */
	{ 0x5e, 0x7a, 0x8e },	{ 0xae, 0xcd, 0xb0 },	/*0x0a */
	{ 0x58, 0x74, 0x8c },	{ 0xae, 0xcd, 0xb0 },	/*0x0b */
	{ 0x53, 0x6f, 0x8a },	{ 0xae, 0xcd, 0xb0 },	/*0x0c */
	{ 0x53, 0x6f, 0x8a },	{ 0xa9, 0xc8, 0xae },	/*0x0d */
	{ 0x53, 0x6f, 0x8a },	{ 0xa4, 0xc3, 0xac },	/*0x0e */
	{ 0x53, 0x6f, 0x8a },	{ 0xa0, 0xbe, 0xaa },	/*0x0f */
	{ 0x53, 0x6f, 0x8a },	{ 0x9b, 0xba, 0xa8 },	/*0x10 */
	{ 0x53, 0x6f, 0x8a },	{ 0x97, 0xb5, 0xa6 },	/*0x11 */
	{ 0x53, 0x6f, 0x8a },	{ 0x92, 0xb0, 0xa4 },	/*0x12 */
	{ 0x53, 0x6f, 0x8a },	{ 0x8e, 0xac, 0xa2 },	/*0x13 */
	{ 0x53, 0x6f, 0x8a },	{ 0x89, 0xa7, 0xa0 },	/*0x14 */
	{ 0x53, 0x6f, 0x8a },	{ 0x85, 0xa2, 0x9e },	/*0x15 */
	{ 0x53, 0x6f, 0x8a },	{ 0x80, 0x9e, 0x9d },	/*0x16 */
	{ 0x53, 0x6f, 0x8a },	{ 0x7c, 0x99, 0x9b },	/*0x17 */
	{ 0x53, 0x6f, 0x8a },	{ 0x77, 0x94, 0x99 },	/*0x18 */
	{ 0x53, 0x6f, 0x8a },	{ 0x73, 0x90, 0x97 },	/*0x19 */
	{ 0x53, 0x6f, 0x8a },	{ 0x6e, 0x8b, 0x95 },	/*0x1a */
	{ 0x53, 0x6f, 0x8a },	{ 0x6a, 0x86, 0x93 },	/*0x1b */
	{ 0x53, 0x6f, 0x8a },	{ 0x65, 0x82, 0x91 },	/*0x1c */
	{ 0x53, 0x6f, 0x8a },	{ 0x61, 0x7d, 0x8f },	/*0x1d */
	{ 0x53, 0x6f, 0x8a },	{ 0x5c, 0x78, 0x8d },	/*0x1e */
	{ 0x53, 0x6f, 0x8a },	{ 0x57, 0x74, 0x8c }	/*0x1f */
};

unsigned short ti85_colortable[32][2] =
{
	{ 0x00, 0x01 },
	{ 0x02, 0x03 },
	{ 0x04, 0x05 },
	{ 0x06, 0x07 },
	{ 0x08, 0x09 },
	{ 0x0a, 0x0b },
	{ 0x0c, 0x0d },
	{ 0x0e, 0x0f },
	{ 0x10, 0x11 },
	{ 0x12, 0x13 },
	{ 0x14, 0x15 },
	{ 0x16, 0x17 },
	{ 0x18, 0x19 },
	{ 0x1a, 0x1b },
	{ 0x1c, 0x1d },
	{ 0x1e, 0x1f },
	{ 0x20, 0x21 },
	{ 0x22, 0x23 },
	{ 0x24, 0x25 },
	{ 0x26, 0x27 },
	{ 0x28, 0x29 },
	{ 0x2a, 0x2b },
	{ 0x2c, 0x2d },
	{ 0x2e, 0x2f },
	{ 0x30, 0x31 },
	{ 0x32, 0x33 },
	{ 0x34, 0x35 },
	{ 0x36, 0x37 },
	{ 0x38, 0x39 },
	{ 0x3a, 0x3b },
	{ 0x3c, 0x3d },
	{ 0x3e, 0x3f }
};
 
void ti85_init_palette (unsigned char *sys_palette, unsigned short *sys_colortable, const unsigned char *color_prom)
{
	char *backdrop_name;
	int used = 64;

	memcpy (sys_palette, ti85_palette, sizeof (ti85_palette));
	memcpy (sys_colortable, ti85_colortable, sizeof (ti85_colortable));

	/* try to load a backdrop for the machine */
	backdrop_name = malloc(strlen(Machine->gamedrv->name)+4+1);

	strcpy(backdrop_name, Machine->gamedrv->name);
	backdrop_name[4] = '\0';
	strcat(backdrop_name, ".png");

	artwork_load (&ti85_backdrop, backdrop_name, used, Machine->drv->total_colors - used);

	if (ti85_backdrop)
	{
		logerror("backdrop %s successfully loaded\n", backdrop_name);
		memcpy (&sys_palette[used * 3], ti85_backdrop->orig_palette, 
			ti85_backdrop->num_pens_used * 3 * sizeof (unsigned char));
	}
	else
		logerror("No backdrop loaded\n");
        free(backdrop_name);
	backdrop_name = NULL;
}


int ti85_vh_start (void)
{
	logerror("video init\n");
	if (ti85_backdrop)
		backdrop_refresh(ti85_backdrop);
	return 0;
}

void ti85_vh_stop (void)
{
	if (ti85_backdrop)
		artwork_free(&ti85_backdrop);
}


void ti85_vh_screenrefresh (struct osd_bitmap *bitmap, int full_refresh)
{
	int x,y,b;
	int pen0, pen1;
	int lcdmem;

	int x_shift = 157;
	int y_shift = 26;

        pen0 = Machine->pens[ti85_colortable[LCD_contrast&0x1f][0]];
        pen1 = Machine->pens[ti85_colortable[LCD_contrast&0x1f][1]];

	lcdmem =  ((LCD_memory & 0x3F) + 0xc0) * 0x100;

	if (ti85_backdrop)
		copybitmap (bitmap, ti85_backdrop->artwork, 0, 0, 0, 0, NULL, TRANSPARENCY_NONE, 0);

	if (!LCD_status || !timer_int_mask)
	{
        	for (y=0; y<64; y++)
			for (x=0; x<16; x++)
				for (b=0; b<8; b++)
					plot_pixel(bitmap, x_shift+x*8+b, y+y_shift, pen1);
		return;
	}
        for (y=0; y<64; y++)
		for (x=0; x<16; x++)
			for (b=0; b<8; b++)
				plot_pixel(bitmap, x_shift+x*8+b, y_shift+y, cpu_readmem16(lcdmem+y*16+x) & (0x80>>b) ? pen0 : pen1);

}
