.TH Xlife 6 
.SH NAME
Xlife - the Game of Life and other cellular automata for X
.SH SYNTAX
.BR xlife
[\fB-display \fIdisp\fR] [\fB-geometry \fIgeom\fR] [\fB-bw \fIwidth\fR] [\fB-?\fR]
.in +6
[\fB-rv\fR] [\fB-grid\fR \fIn\fR] [\fI\fIfile\fR]
.in -6
.PP
.BR lifeconv
[\fB-ACDIMPRSv\fR] [-p \fIpatternfile\fR] [\fB-g\fR \fIn\fR] \fIfile\fR
.SH DESCRIPTION
.NXR "xlife"
.B xlife
brings up an X program in which the user may experiment interactively with
cellular automata.  In its default mode, the program helps the user experiment
with John Horton Conway's `Life' game.

By default Xlife will run in a window taking up 4/5ths of your screen; you can
use your window manager's Zoom or Resize feature to make it fill the whole
screen.  This window is a viewport on a universe which is effectively unbounded
(4.2 billion cells on a side).

The -geometry option sets the Xlife window size and position as per usual for
X applications.

If an initial pattern is specified, it will be loaded and started evolving
on startup, before Xlife accepts commands.

.B lifeconv
is a format-conversion utility that translates between several different
file formats for saving patterns.  It takes a pattern file argument and
writes the conversion to standard output.  Conversion options are described
in the LOAD FILE FORMAT section below.  The `-g' option permits you to evolve 
a loaded pattern for a given number of generations before saving.  The `-v'
option enables verbose progress messages to stanard error.  The -p option
allows you to specify a pattern list file for name matching.

.SH OPTIONS
.IP \fB-display\fR 15
Set the display to use; overrides the DISPLAY environment variable.
.IP \fB-geometry\fR 15
Set xlife's window geometry as in the Xt toolkit option.  If either
window size value is negative, it will be subtracted from the value
computed by the grabFraction, and the result used as a size.
.IP \fB-rv\fR 15
Reverse the Life board to black on white.  Equivalent to setting the
\fBreverseBoard\fR resource to true.
.IP \fB-bw\fR 15
Set the border width used for window-size calculations.  This is normally
zero; you may want to set it under window managers that don't create
frame windows themselves. Overrides the \fBborderWidth\fR resource.
.IP -grid
Set the grid interval for the `L' command mesh; overrides the
\fBgridInterval\fR resource. A positive value for this option turns the
grid on by default; a negative one does not, but sets the interval
to its absolute value.
.IP \fB-?\fR 15
Emit a usage message and quit.

.SH COMMANDS
.SS Help and Bailing Out
.IP \fB?\fR 10
Help for Xlife.
.IP \fBC\fR 10
If there is a tentative pattern, clear it.  Otherwise clear the
universe and reset the generation number to 0.
.IP \fBQ\fR 10
Quit (leave Xlife).

.SS Motion and Viewport Control
.IP \fBr\fR 10
Redraw the screen.
.IP \fB8\fR 10 
Move your view of the universe up.
.IP \fB2\fR 10 
Move your view of the universe down.
.IP \fB6\fR 10
Move your view of the universe right.
.IP \fB4\fR 10
Move your view of the universe left.
.IP \fB5\fR 10
Center the average position of the live cells.
.IP \fB0\fR 10
Center the median position of the live cells.
.IP \fBJ\fR 10
Jump to (x,y) location (make it the current mouse position).
.IP \fB.\fR 10 
Center the universe view on the cursor.
.IP \fB(\ [\ {\fR 10
Set a marker at current mouse position.  There are three markers, one for
esch of these characters.
.IP \fB)\ ]\ }\fR 10
Jump to a marker (make it the current mouse position).  The marker jumped
to by each closing bracket is that set by the corresponding open-bracket 
command.
.IP \fBO\fR 10 
Set current mouse position to be the origin of displayed coordinates.

.SS Scale
At zoom scale N, cells are two to the power N pixels wide; the default cell
size is scale 4, 16 pixels on a side..  Scale range is -3 to 7; at scales -1,
-2 and -3 a single pixel represents the logical or of a square sample of 4, 16,
and 64 pixels respectively.
.IP \fB=,+\fR 10
Zoom the view in, magnifying the area around the mouse cursor.
.IP \fB\-\fR 10
Zoom the view out.

.SS Editing in Normal Mode
These are the normal button bindings.
.IP \fBButton-1\fR 10
Activate a cell, giving it the currently selected state. In a 2-state
automaton cells are always activated with state 1.  In an N-state
automaton, you pick your current color as described in N-STATE SUPPORT
below.
.IP \fBButton-2\fR 10 
If a pattern is selected, Button 2 merges the contents back into the active
pattern. If you drag the cursor with button 2 held down, then release it, the
rectangle between the press and release points is selected.  Any points in it
are made tentative (as though the region had just been loaded and not yet
incorporated).
.IP \fBButton-3\fR 10 
Delete a cell at the cursor (force it to state 0).

.SS Manipulating tentative patterns
These are the button bindings when there is a tentative pattern. 
This may happen as the result of a load command or because you have
selected a nonempty part of the on-screen pattern.  When the
tentative pattern is incorporated into the active pattern, the
button bindings revert to normal.
.IP \fBButton-1\fR 10
Translate pattern pivot to current position.
.IP \fBButton-2\fR 10 
Flip pattern about its x-axis.
.IP \fBButton-3\fR 10 
Rotate pattern clockwise about its origin.
.PP
Sometimes it may be useful to select an empty region, for use with `C' or \&`%'
or similar commands.

.SS Evolution
.IP \fBn\fR 10
Set the maximum number of generations to perform for following `g'
commands.  A zero value (the default) is interpreted as "never stop".
.IP \fBg\fR 10
Evolve.  Incorporate any tentative pattern.  Then step through generations
until something exceptional happens, like an `n' timer running out or still
life or stability or possible oscillation detection (the last only if a `p'
period is set).
.IP \fBo\fR 10
Incorporate any tentative pattern, then step forward one generation.
.IP \fBf\fR 10 
Set evolution speed for `g' to high (no delay between evolutions), the default.
.IP \fBm\fR 10 
Set evolution speed for `g' to medium (250 msec delay).
.IP \fBs\fR 10 
Set evolution speed for `g' to slow speed (500 msec delay).
.IP \fB<\fR
Slow down evolution; increase delay  by 50 msec.
.IP \fB>\fR
Speed up evolution; decrease delay by 50 msec.

.SS Reports and Decorations
.IP \fBp\fR 10
Set an oscillation check period.  You will be prompted to enter a number.
Thereafter, until you set the check period to zero with another `p' command,
`g' command evolution stops whenever it detects a cycle of the required period
in the population counts.
.IP \fBM\fR 10
Toggle display of a grid mesh overlaying the board.
.IP \fBB\fR 10
Display the xmin/xmax and ymin/ymax values of the live cells.
.IP \fBc\fR 10
Toggle showing of box counts in per-generation status line.
.IP \fB&\fR 10 
Toggle running display of mouse position in per-generation status line.
.IP \fB$\fR 10 
Toggle running display of changed-cell count in per-generation status line.
.IP \fBh\fR 10
Hide evolution.  Incorporate any tentative pattern.
Stop displaying the board state after each generation.
.IP \fB*\fR 10
Toggle pseudocolor mode.  When this is on and the automaton is 2-state,
newborn cells are shown in state 2 color and dying ones in state 3 color.
Has no effect on N-state automata.
.IP \fB~\fR 10
Change display mode (the new mode is displayed).  In display mode 0 (the
default) all live cells are displayed normally.  In display mode 1, only
cells changed from the previous generation are shown (whether alive or dead).
Your display mode is reset to zero by the `l' command or by selecting a
tentative battern.
.IP \fB#f\R 10
Change tentative-display mode.  By default the tentative-pattern cells are
displayed in normal state colors but with a bounding box.  In the alternate
(`wireframe') mode, tentative-pattern cells are displayed as open rectangles
in the load-box color, but with no bounding box.  Wireframe mode is useful
when you are trying to match a loadscript to a template active pattern.

.SS Making Soup
.IP \fB%\fR 10
Place random cells on the area of the universe on the screen (or in the
select box if there is one).  You will be prompted for a percentage
density.
.IP \fB^\fR 10
Set seed for random number generator.

.SS Unstructured Pattern Saving
These commands operate on the current pattern (the tentative
pattern if there is one, otherwise the active pattern).
.IP \fBS\fR 10
Save the current pattern to a file adding extension .l, along with
any comments created via 'A'.  Clear the internal comment area.
.IP \fBi\fR
Set the save format for the S command.  Normally the save command tries to use
`I' format.  The command `i' allows you to specify one of A D I M P R S; simply
typing Enter restores the default mode.  For details on the A D I M P R
formats, see the LOAD FILE FORMAT section below; `S' format is a sequence of P
blocks, one for each blob in the picture, with appropriate offsets for each.
.IP \fBN\fR 10
Change the internal name associated with the current pattern.

.SS Load-script commands
As you perform pattern-load (`l'), tentative-pattern movements and rotations
with the mouse, and tentative-pattern-evolution ('G') commands, the program
journals these changes.  They are appended onto a `load script' whenever you do
an incorporate `I'.  (This load script does not include cell-state changes made
manually with the mouse.)
.P
The load script remains available even after you have run `g' on the resulting
pattern, so you can save it or revert to it if the results are interesting.
.IP \fBl\fR 10
Load a tentative pattern from a file with extension .l.  This lets you overlay
multiple saved states to make for some interesting effects.  The loaded pattern
may be manipulated in various ways before incorporating it into main
pattern. (To indicate this, it's drawn in a special way, either with a bounding
box or as open rather than filled rectangles.)  Clear the universe if you want
to start from scratch.  Attempting to `load' a directory gives you a listing of
the directory.
.IP \fBL\fR 10
Immediately reload, at the cursor, a copy of the last pattern loaded.
.IP \fBG\fR 10 
Evolve tentative loaded pattern for one or more steps. (If there is no
tentative pattern, evolve the active pattern.)
.IP \fBU\fR 10 
Undo load of tentative pattern.
.IP \fBu\fR 10
Undo manipulations of the tentative pattern, but not the load (tentative
pattern is restored to the original position and indentation).
.IP \fBI\fR 10 
Force tentative pattern to be incorporated into main pattern 
(automatic with g, h, o, l, and W commands).
.IP \fBW\fR 10 
Write (and flush from memory) script of loaded patterns into a file with `.l'
extension. The origin of the written pattern will be the mouse position when
'W' is typed.  Also save to the file any comments created via 'A', and clear
the internal comment area.
.IP \fBD\fR 10 
Discard the current load script, including any tentative pattern, but leave the
cell population intact.  (Helpful for using an old pattern as a template to
construct a load script).

.SS Pattern comments
There is a comment buffer area within Xlife that you can use to associate
comments with the current pattern (active or tentative).  When you do an `S' or
`W' these comments will be written to the output file and the buffer area
cleared.  Thus, you can set up a pattern, evolve it, note interesting behavior,
evolve it more, add more comments, and save the construction and comments. 
.IP \fBA\fR 10
Add comments to the current pattern.  
.IP \fBK\fR 10
Discard comments associates with current pattern.
.IP \fBV\fR 10
View comments associated with the current pattern.

.SS Rules Editing
.IP \fBR\fR 10
Change the (2-state) rules in "stays alive on"/"born on" format. The standard
rules are 23/3 (alive on two or three neighbors, birth on three neighbors for
an empty cell).  Alternatively, enable a payoff matrix with the syntax
<float>$<float> as described in the PRISONER'S DILEMMA section.
.IP \fBF\fR 10
Load n-state rules from a given file (see the N-STATE SUPPORT section below).
A `.r' extension is supplied to the filename if it doesn't have one. It is
searched for first in the current directory, next all immediate subdirectories
of the current directory.  Then it is searched for in the same way under the
compiled-in global pattern directory (see ENVIRONMENT).
.IP \fBa\fR 10
Add transition to N-state table.  You will be prompted for a transition tuple,
6 cell-state digits (one old state, one for each orthogonal neighborhood cell,
and one new state).  Each specification you enter actually defines four
transitions, one for each possible rotation of the neighborhood.  The 
new rule will be logged to the file \fBnew.transitions\fR and the four
transitions added to the evolution function's internal table.
.IP \fBt\fR 10
Test transition.  You will be prompted for a string of 5 state digits (old
state followed by neighborhood cells). You will be shown tye result state
or an indication that the transition is undefined.

.SS Miscellaneous
.IP \fB!\fR 10
Execute a shell command which needs no input.
.IP \fB@\fR 10
Run a benchmark for a fixed number of generations.

.SH LOAD FILE FORMAT
A .l image file is an ordinary text file consisting of lines terminated by
the newline character. It is interpreted as one or more image sections
separated by section lines beginning with `#'. Lines led by `##' are
considered comments and ignored.  Files normally begin with a comment
identifying the version they were saved under.

Each image section is interpreted according to the format letter following its
section line #. The format letters are:

.SS \fBA\fR -- Absolute.
Each following line is interpreted as an absolute (x,y) coordinate pair for a
cell to be put in state 1.  This format is deprecated. and should not be used
for new patterns.  The -A option of 
.B lifeconv
emits it.

.SS \fBD\fR -- Relative to the previous coordinate pair.
Each following line is interpreted as a (x,y) coordinate pair relative to the
previous one, for a cell to be put in state 1. The first is relative to the
current mouse postion.  The -D option of 
.B lifeconv
emits it.

.SS \fBR\fR [xoff[yoff]]\fR -- Relative with optional offsets.
Each following line is interpreted as a (x,y) coordinate pair relative to the
current mouse position.  These relative image sections are normally drawn with
0,0 on the current mouse position (coordinates may be negative). This may be
changed by including a pair of whitespace-separated integers after the format
character. If this is done, these will be interpreted as a pair of x and y
offsets, and the image section will be drawn with its upper left corner
displaced from the cursor position by those offsets. This facility can be used
to write image files that will load patterns centered on the cursor. The -R
option of
.B lifeconv
emits this format.

.SS \fBM\ [xsize, ysize]\fR -- run-length encoding with optional sizes
If the size pair is present it should indicate the size of the picture bounding
box.  Each non-section line in the section is interpreted as a scan line of a
relative image which is run-length-encoded. Only the characters \fBo\fR,
\fBb\fR, \fB$\fR, \fB!\fR and the digits \fB0\fR until \fB9\fR should appear
except whitechars which are ignored.  A \fBo\fR character turns the
corresponding cell on and a \fBb\fR character turns the corresponding cell
off. A \fB$\fR character skips to the begin of the next image cell line which
is aligned just as the first image cell line that starts as the mouse
position. The \fB!\fR terminates all these data. Each of the three characters
\fBob$\fR can be led ahead by a positive integer, not staring with a \fB0\fR,
which then is interpretated as the repetation of that character. Any illegal
character will be interpretated as \fB!\fR and terminates the scan.  The -M
option of
.B lifeconv
emits this format.

.SS \fBP\ [xoff[yoff]]\fR -- Picture with optional offset coordinate pair.
Each line in the section is interpreted as a scan line of a relative image.
Each \fB*\fR character turns the corresponding cell on. All other characters
leave the corresponding cell off.  For multi-state automata, characters may
be digits, with '*' corresponding to 1.   The -P option of 
.B lifeconv
emits this format.

.SS \fBI\ name\ [xoff[yoff[rotate[flip[delay]]]]]\fR -- Include pattern.
A \fB#I\fR line should have whitespace-separated fields after the \fB#I\fR
consisting of a pattern name and five optional integer parameters. \fIname\fR
takes one of the following three forms:
.IP <file> 20
include whole file <file> (like old format)
.IP <file>:<name> 20
include pattern block <name> in <file> 
.IP :<name> 20
include pattern block <name> in current file 
.PP
.I xoff
and \fIyoff\fR are integers representing horizontal and vertical offsets;
.I rotate
is an integer that specifies the number of times the pattern is
rotated 90 degrees clockwise around the origin.  Any value (positive or 
negative) is acceptable, as all are taken modulo 4 (true mod, not "%").
.br
.I flip
is a multiplier (1 or -1) for the y coordinate that specifies a flip 
about the x-axis.  Other integers are accepted and silently mapped to 1.
Flips are done before rotations.
.br
.I delay
is an integer specifying the number of generations to perform before 
loading the pattern (negative values have same effect as 0).
.br
The named include pattern is loaded as if it had been included in the image at
this point with the current transformation applied.  Thus, loading sets of
included patterns works as one would expect.
.P
The include facility is useful for assembling `sampler'
collections of interesting patterns, as well as maintaining structured
representations of complex patterns.  The -I and -C options of 
.B lifeconv
may be useful for collecting inclusions from multiple files into a single
self-contained file.
.P
When you save a pattern in 'I' mode, the program automatically does a pattern
analysis to detect `blobs' (completely connected regions of live cells).
Repeated blobs are recognized, even if they are rotated or reflected.  
If there is only one blob, the save output is identical to #P or #S
format.  Otherwise the output is a list of blobs followed by #I lines
that will recreate the saved pattern.  This has two advantages:
duplicate blobs are only written once, and common pattern elements
are recognized and named (so the save file is also a census).  See the
description of the \fInamedPatterns\fR resource for more.

.SS \fBB\ name\fR and \fBE\fR -- Pattern blocks.  
Patterns enclosed by #B <name> and #E lines are skipped
when loading a whole file, but may be accessed by adding
:<name> to the file name.  They are useful for bundling related patterns 
into the same file.  Access is by sequentially skipping lines not in the 
block, so excessive numbers of blocks in the same file may slow down the
loading process.  Pattern blocks may not be nested.

Relative image sections are normally drawn with 0,0 on the current mouse
position (coordinates may be negative). This may be changed by including a
pair of whitespace-separated integers after the format character. If this is
done, these will be interpreted as a pair of x and y offsets, and the image
section will be drawn with its upper left corner displaced from the cursor
position by those offsets.

A leading image section with no header line is treated as though it had a `#A'
header. Thus, version 1.00 image files will load properly.

.SS \fBN\fR -- Name
This line contains the internal name of the pattern (which may differ from the
XXX.l name of the file.

.SS \fBO\fR -- Owner
This line contains information on the person who wrote the file, it is written
in the form: `id@machine date (name)', for example.

#O jb7m@andrew.cmu.edu (Jon C. R. Bennett) 1990-02-12 18:25:54 EST

Note: This timestamp line has changed format at least three times since
Xlife 1.0.  It is probably not wise to try and parse these unless you see
a format version ID (on the first line of the file) of Life5 or greater.

.SS \fBC\fR -- Comment
Lines begining with "C" are comments that the user may have automatically
written to the save file, and which may be viewed from within Xlife.

.SS \fBT\ survivedigits/borndigits\fR -- Set new transition rules
This line defines a new set of 2-state rules. \fBsurvivedigits\fR and
\fBborndigits\fR are each a sublist of digits out of the range 0 up to 8,
counting the number of neighbours when the central cell in the neighbourhood
survives/is born to state ON.  For example the default and classical rules for
Conway's \fIGame of Life\fR are:
.br
#T 23/3

.SS \fBU\ filename\fR -- Use ruleset
Format is #U followed by a filename. This directive is ignored if Xlife is in
2-state mode.  In N-state mode (see below), it loads a rule-set file just as
if the user had typed in the name.  If the named file is already loaded, it
will not be reloaded.

.SS \fBL\ [text]\fR -- Set label.
Writes the string \fBtext\fR above the upper left hand corner of the bounding
box of the current pattern or pattern block.  If there are several of these
they are stacked vertically in order; an empty #L line may be used as a
vertical spacer in sampler displays.  Labels vanish when the
tentative pattern is flipped, rotated, or incorporated, but will reappear
if it is returned to its original position.

More section formats may be added in the future.

.SH N-STATE SUPPORT

Xlife includes support for automata with up to 8 states using
the (von-Neumann-style) 4-cell rotationally symmetric neighborhood; to
invoke it, load a rule-set file using the `F' command.  Many
interesting automata including the Wireworld construct and the UCC
described in E. F. Codd's 1968 ACM monograph can be implemented by
specifying appropriate transition functions.

When Xlife is used in this mode, the program uses color to indicate states.
Pattern picture files may contain digits to specify the states of picture
cells; `*' is interpreted as 1.  Color-picker radio buttons are set up at
the right-hand side of the input window; by clicking your cursor on
a button, you set button 1 to paint with that color.  You can return
to 2-state mode with the `R' command.

Refer to the rule-set file `codd.r' for an example of transition
definition syntax.  Each line contains either a directive or 6 digits
arranged as

<old-state><neighbor><neighbor><neighbor><neighbor><new-state>

For <old-state> or <neighbor> you may also specify a \fIstate set\fR; digits
enclosed in square brackets. This wild-cards the transition in the obvious
way. Comments (begun with `#') are permitted in the file.

You can arrange for rulesets to be loaded automatically by putting a `#U' 
directive in a pattern file.  When you save a pattern, a #U is automatically
generated into the save file giving the name of the current ruleset.

The directive

	states <maxstates>

tells the code what the automaton's count of cell states is.  The default is 8.

If, while evolving a pattern, the code finds a cell and neighborhood in a state
for which no transition has been specified, the program queries the user for
a new state, and the tuple implied is added to the database. This behavior
can be modified by including a line of the form

	passive <maxstate>

which instructs the code that all combinations of cell and neighbor states up
to and including <maxstate> for which there is no explicit rule leave the cell
status unchanged.  A `passive' declaration in a rules file can be partially
overridden by later, explicit transition rules.

You can also specify rules depending on a neighbor count.  A rule line of the
form 

	S(N*C)R

with S, N, C, and R being digits, is interpreted to mean that if a cell has
state S and exactly C neighbors of state N, the result state is R. For an
example of usage, see the Wireworld rules file.

When the evolution function encounters a neighborhood for which there is no
defined transition, it stops and boxes that neighborhood.  You are prompted 
for a result state.  Once you've entered it, the evolution function continues
and the new transition rule is appended to a new-transitions file in the
current directory.

.SH PRISONER'S DILEMMA MODELS

In the June 1995 Scientific American, the article "The Arithmetic of Mutual
Help" (by Martin A. Nowak, Robert M. May and Karl Sigmund) describes an
interesting class of cellular automata that model iterated Prisoner's Dilemma
situations.  These games can illustrate stable and winning cooperate/defect
strategies for situations in which each agent repeatedly interacts with near
neighbors.  In the same issue, Alun L. Lloyd's "Mathematical Games" column
goes into more detail about these simulations.

These are two-state automata.  In Alun's implementation one state always
cooperates, one always defects (higher states could model Tit-for-Tat,
Generous Tit-for-Tat, or Pavlov).  There is a payoff matrix of the following
form:

.TS
center box tab(;);
l | c c.
Payoff;Cooperate;Defect
_
Cooperate;1;a;
Defect;b;0
.TE

To make the game interesting, b must be greater than 1.  (Lloyd's simulation
only considers the case a = 0.)  On each round, each cell first plays the game
with each of its neighbors in turn.  Then, each cell looks at the payoffs of
its neighbors (and its own payoff) and switches to the strategy with the
highest payoff).

To set up such a game, use the `R' command in the following form:

	R<b>$<a>

For example, to set up Lloyd's simulation, do `R1.85$0'.  In these 
simulations, use the following mapping between states and strategies:
.TP 5
0
Quiescent.
.TP 5
1
Live, always cooperates.
.TP 5
2
Live, always defects.
.PP
Interesting b values are in the range (1, 2]; Lloyd likes 1.85.  Different
values produce wide ranges of different behaviors, including stable end
states, statistical equilibria and cycles with large swings.  Initial
clustering of cooperators is also important; a single cooperator will 
always be snuffed by surrounding defectors, but a block of 4 or more may
be able to defend themselves and earn a high enough relative payoff to
convert neighbors.

Lloyd included illustrations of a 1.85 game starting with one defector in a sea
of cooperators.  The resulting patterns look like Persian carpets or Koch
snowflake curves.

.SH OTHER FEATURES OF RULE FILES AND EDITING
The directive

	debug 1

will enable single-step debugging of pattern evolution (so you can watch the
transition function being applied).  Diagnostic messages will be sent to
stderr.

Transition rules entered interactively are appended (commented with user
ID and timestamp) to the file \fBnew.transitions\fR in the current directory.
This file can later be selectively merged with your original ruleset using 
a text editor.

.SH STRUCTURED PATTERN EDITING
Almost all large Life patterns that exhibit well-defined behavior (such as the
breeder) are in fact composed of smaller patterns that combine in a predictable
way.  Storing such patterns as assemblies of subpatterns can greatly aid future
experimentation as well as synthesis of still more complex patterns.  Here
we'll explain the structured-editing features, and give several examples of
their use.

.SS Overview of structured editing
Structured editing should cut down on the number of Life patterns stored as
atomic images (i.e. raw bitmaps or point sets).  Once a glider gun, for
example, has been defined, there should be no need to duplicate the pattern.
It should instead be possible to refer to it by name, as a known mechanism with
well-established properties.  In fact, the glider gun itself exhibits some
structure, as it is composed of two period 30 shuttles that interact to produce
gliders.  Ultimately, the "interesting" part of the period 30 shuttle does not
seem to have any structure, and hence must be represented a picture, such as
the following:

.nf
               ..*...
               .*.*..
               *...**
               *...**
               *...**
               .*.*..
               ..*...
.fi

Unfortunately, it is not enough to merely place such a pattern at the correct
coordinates.  For example, we can rotate this pattern by multiples of 90
degrees without essentially changing its behavior.  While this particular 
pattern has mirror symmetry about its horizontal dividing line, other patterns 
may not, so we may additionally wish to take the mirror image of a pattern.  
It would be undesirable to maintain eight separate bitmaps for what is really 
the same pattern, so we would like a facility to perform basic geometric 
transformations on patterns to be included in more complex ones.

A more subtle issue is that of timing.  When placed between appropriate
stabilizing objects (such as eaters or blocks) the above pattern will oscillate
with a period of 30.  Hence, when defining a complex pattern, we may need
to insist (in addition to any geometric transformations) that it be placed
within the larger pattern at a particular phase in its cycle.

By controlling position, rotation, flip, and phase shift, we may combine
patterns in any desired manner.  The #I extensions to Xlife makes this
possible, and the structured editing features make it (relatively) convenient.

Ideally, the new editing features will make it possible to use 
the #I format without ever looking at the description file.  The advanced Life 
experimenter may, however, wish to modify #I lines with a text editor in
order to achieve very specific effects (still more advanced CAD tools would 
eliminate this need).

To attempt the following examples, you should be running Xlife.  You must
have a copy of the file ex.l, supplied with the release, in either the
directory in which you start up Xlife, or in the pattern directory.

Before trying any of the examples, type `C' to clear the workspace, if it
is not already clear.

.SS Experimenting with gun collisions.
Type `l' to load in a pattern.  Backspace over the default directory, if there
is one (probably the pattern library) and type "ex:gun".  This will load the
pattern "gun" from the file "ex.l" in either the pattern library or current
directory.  The pattern consists of a glider gun before it has produced any
gliders.

Get a feel for the movement, flip, and rotation operations performed with the
mouse buttons.  All operations are performed with respect to the origin of the
pattern, which is indicated by a single dot at the smallest scales and becomes
an X shape at the larger scales (zoom in on it to see this).

In order to place patterns such as glider guns, it is especially important to
know the direction of the outgoing glider stream.  You may preview this
by generating the loaded pattern with the `G' command (*not* the `g' command).
Initially, you will want to generate enough steps to see the stream, so type 
100 when prompted for the number of steps.

Note that the mouse buttons continue to perform transformations on
the generated pattern.  Place the pattern as desired.  It will be incorporated
into the main universe when any of the commands g, h, o, l, or W are typed.
To incorporate it without doing anything else, use `I'.

Now, load another glider gun in the same manner.  Place the two guns in
such a way that their outgoing gliders collide.  Not all collisions are 
well behaved, and you may wish to produce a specific collision, such as
a clean annihilation of gliders.  The references mentioned at the top, and some
of the patterns supplied with Xlife, are a good source of interesting 
collisions.  Use `G' on the second glider gun to control the phase difference 
between the colliding gliders.

Type `g' to let the pattern go and see what happens.  If the collision was 
chosen randomly, there is a good chance that it will merely break down into 
chaos.  Some collisions, however, produce interesting effects.  

Save your gun collision into a file using the `W' command.  Now type `C' and 
use `l' to load it back in.  Note that the result is not what you would expect 
from saving the current pattern.  That is, even if the pattern did break down 
into chaos, the pattern written by `W' corresponds to the collision as you set 
it up.  If you type `g' then you should witness the same sequence of events as 
before.

The file written by `W' is not a raw pattern image, but rather a "load script."
That is, it gives Xlife enough information to reconstruct your placement of
loaded patterns.  It does not contain any changes made by drawing or erasing 
cells with the mouse, but such changes deviate from the philosophy of pattern 
structuring and should be avoided except when drawing atomic patterns.
(In any case, the `S' command is provided for saving the whole image in an 
unstructured way.)

.SS Setting up a glider mirror.
It is possible to reflect a stream of gliders as if by a mirror, using a
period 30 shuttle with eaters at the ends.  The mirror will not work unless
the stream (from a period 30 gun) and the mirror are perfectly positioned
and in phase.  In general, this may involve some simple yet tedious calculation
or else a still more tedious process of trial and error.  In the
following, however, we will see how to use the editing features to 
produce the desired effect reasonably simply.

Load in ex:gun, as before, and let it generate (with `G') until the outgoing
stream contains 20 or so gliders.  This is the stream we will be reflecting.

Now load in ex:mircollision.  This pattern consists of a glider poised to
be reflected from a mirror.  Use rotates, flips, and `G' (one step at a 
time) until the the mirror glider is an exact copy of the glider furthest
from the gun.  Use the mouse to move the loaded pattern so that these two
gliders occupy exactly the same five cells.  It may help to zoom in on the
pattern. 

Now, simply type `g' and let the pattern go.  It you performed the above
steps correctly, you should see a stream of gliders bouncing off the mirror.
Add more mirrors, if desired, and save the result into a file using `W'

.SS Details of the structured save format
Skip the following if you are not interested in familiarizing yourself with the
details of the #I format.

Take a look at the file generated by `W' in the above.  It consists of a 
sequence of #I lines, the first containing ex:gun, and the others containing
ex:mircollision.  The latter lines each have a delay value as their final 
parameter, and these parameters will most likely be in the hundreds, as this
is the number of steps it takes to make the stream of gliders used as a 
reference.  

Note that the mirror is a period 30 oscillator, so we may replace all of 
these numbers by their values mod 30 without affecting the crucial 
phase difference between the mirror(s) and the gun.  Do this, and look at the
pattern in Xlife.  Note that it takes less time to load, and that the loaded
pattern does not contain a long stream of gliders.  Type `g' to verify that the
mirrors still work (if not, make sure you computed mod correctly). 

The resulting pattern will contain spurious gliders.  These are the gliders
that came with the pattern ex:mircollision.  Fortunately, ex:mircollision 
contains ex:mirror with no moves, flips,or rotations applied.
Hence, by replacing all instances of ex:mircollision by ex:mirror in your
file, you will obtain the same pattern as before, but without the spurious 
gliders.

This illustrates the notion of including extra parts in a pattern for 
reference and eliminating them in the final edit.  Use of this technique
can substantially reduce the need for explicit calculation when constructing
complex patterns.

.SS Constructing a Structured Pattern from a Template.
Having familiarized yourself with the use of load scripts, you may wish
to construct structured versions of old patterns you made in the previous
version of Xlife.  This can be done in a bottom-up fashion by loading
in the raw image and building up subpatterns using the initial image
as a reference.  You first need to identify the the atomic subpatterns in the
old pattern.  For example, in the mirror of the previous example, the atomic
patterns are two eaters and the period 30 oscillator (shown earlier in this
document).  

The template pattern should not be written into the load script, and this
may be prevented by using the `D' command \fBafter\fR this pattern has been
incorporated into the universe.  The effects of having the template written
to the load script are non-fatal, and may be corrected with a text editor.
However, it is best to get in the habit of typing `I' (include pattern),
'D' (discard load script) immediately upon loading a template.

The mirror in ex.l is already given in a structured way, but it will suffice
to illustrate the technique.  To place the template, load ex:mirror, and type
'I' and `D' as mentioned above.  Now, load in succession two eaters (ex:eater)
and the oscillator (ex:oscil) and place each pattern over the corresponding
part of the old image.  Use `W' to write the load script.

If the original mirror had been stored as a bitmap then you would have 
transformed a seemingly arbitrary set of points into a structured pattern.  
Patterns defined in this way can later be combined into more complex patterns, 
and at any level, the pattern can be seen to be a logical combination of 
well-understood components rather than an amorphous conglomeration of Life 
cells.   

.SS Using the `lifeconv' utility.
One seeming disadvantage of structuring patterns with the `W' command is that a
pattern that used to reside in a single file may now be spread over several
files.  There may be too many to easily keep track of them.  For the user who
wishes only to use #I as a means of collecting a structured pattern into a
single file, however, the -I and -C options of `lifeconv' utility are provided.

The lifeconv utility takes a pattern name as an argument (with the same default
directories as in the `l' command).  It writes a file to standard output that
contains an equivalent version of the pattern in a different format. Usage is:

              lifeconv pattern [-ACDIMPRS] >destination

where destination is any valid file name (a .l extension is recommended).  The
option controls the format in which the destination file is written.  These
formats are identical to those described under the `S' (save) command,
except for C.

Either -C or -I will suffice to convert a pattern with inclusions into
a single-file pattern with all the inclusions resolved.  The difference
between them is that -I does an automatic scene analysis of the file
after merging all inclusions into one big picture, while -C just resolves
the inclusions textually.  The one advantage of the latter method is that it
preserves any pattern name and structure information present in the input
file: -I renames all the pattern fragments.

Try these options on any of the files written by `W' in examples 1, 2, and 3.

.SH ENVIRONMENT
The program has a compiled-in default for its global pattern directory,
normally /usr/share/xlife.

If the variable LIFEPATH is set to a colon-separated list of directories, these
directories (and their first-level subdirectories) will be searched for
pattern-file names and rulesets.  The default list includes "." and the global
directory; that is, pattern files are searched for, by default, below the
current directory and below the global pattern directory.

The recommended way to organize your pattern directories is to have one
subdirectory per automaton.  The distribution provides the following:  
.IP life 20
contains an extensive library of interesting Life patterns.
.IP codd 20
contains transition rules and components for the universal
computer-constructor described in E.F Codd's
.I Cellular Automata
Academic Press 1968 (ACM Monograph #3).
.IP wireworld 20
contains transition rules and a test pattern for the Wireworld automaton
as described in the January 1990 issue of Scientific American (Computer
Recreations, p. 146).
.IP misc 20
contains patterns for miscellaneous other automata, including a sample
Prisoner's Dilemma game and the HighLife replicator.

These will be copied to the global pattern directory by a normal installation.
.SH EXPLORATION
Here are some 2-state rules to experiment with:
.IP 23/3 20
The default, Conway's "Game Of Life" rules.
.IP 23/36
HighLife, a variant with a simple replicator (see misc/highlife.l).
.IP 1234/3 20
Patterns "crystallize"
.IP 12345/45 20
Patterns become contained
.IP 12345/4 20
Same as above, but settles \fIvery\fR quickly
.IP 5/12 20
Floor tile patterns. Variations of this tend to be interesting as well.
.IP /2 20
Most patterns expand indefinitely, some interesting ones. Fast gliders.

.SH RESOURCES
.PP
Xlife interprets the following preferences from the X resource database:
.IP \fBgrabPercent\fR 20
What percent of your display to grab at startup.  Overridden by the 
geometry resource, if any.  Defaults to 80%.
.IP \fBautoPlace\fR 20
Normally, when your first pattern load to a clear universe is of a pattern
too large to fit on-screen, Xlife automatically changes scale and tries
to center the pattern (second and subsequent loads, or loads into a non-empty
universe, are not affected).  Set this resource to \fBfalse\fR to suppress
this behavior.
.IP \fBborderWidth\fR 20
Set the border width for Xlife's windows (may be visually useful when running
without a window manager).  May be overridden by the -bw command-line option.
.IP \fBstateColor0\fR 20
X color to use for displaying state 0.  There is also a \fBstateColor1\fR
and so forth, up to \fBstateColor\fRN where N is the maximum supported
number of states (normally 8).
.IP \fBselectBoxColor\fR 20
X color to use for the selection box boundary.  Defaults to "orange".
.IP \fBtentativeColor\fR 20
X color to use for the tentative pattern box (or cells in wireframe mode) and
pivot X.  Defaults to "cyan".
.IP \fBtransitionBoxColor\fR 20
X color to use for the selection box boundary.  Defaults to "magenta".
.IP \fBmeshGridColor\fR 20
X color to use for the mesh grid lines.  Defaults to "dark gray".
.IP \fBrefGridColor\fR 20
X color to use for the reference grid lines.  Defaults to "light gray".
.IP \fBreverseBoard\fR 20
Reverse the Life board to black-on-white.  When this option is enabled and
"Black" and "White" are in the stateColor list, they are swapped.  Enabling
this is equivalent to the -rv command-line option.
.IP \fBfalseColorMode\fR 20
If the value of this resource is "true", XLife when simulating a 2-state
automaton defaults to the false-color display mode toggled by the `*' command.
Default is "false".
.IP \fBwireframeMode\fR 20
If the value of this resource is "true", XLife defaults to the wireframe mode
toggled by the `#' command.  Default is "false".
.IP \fBruleFile\fR 20
If this resource exists, XLife will try to interpret it as the filename of a 
rule set to be loaded at startup (as though by an F command).
.IP \fBsoupDensity\fR 20
Density for primordial soups generated by the `%' command.   Defaults to 30%.
.IP \fBgridInterval\fR 20
Set the grid interval for the `L' command mesh; overriden by the \fB-grid\fR
command-line option. A positive value for this option turns the grid on by
default; a negative one does not, but sets the interval to its absolute value.
.IP \fBsaveFormat\fR 20
Preferred image format; one of ADIMPRS.  If present, sets the format to be used
for saving patterns.  Defaults to saving to the most compact format (P format
for single-piece patterns, #I for multiple-piece patterns.
.IP \fBnamedPatterns\fR 20
The default value of this resource is "named-patterns".  It specifies the name
of a file containing the names of patterns to be recognized and named when
doing I-format (structured) saves.  A leading slash distinguishes an absolute
pathname; otherwise the relative name is searched for beneath the FILEPATH
directories (as for a pattern file).  Each line of this file contains up to
three fields; a pattern name, a pattern file or file:block reference (as for
the `l' command) and a cycle length.  When the cycle length is 0, only one
recognition template is generated from each entry; when it is nonzero, one is
generated for each step in the cycle (with steps after 0 distinguished by a
number suffix on the name).  Thus, for example, an entry that reads

	glider	ss:glider	2

Will generate two recognition templates, one named `glider' and another named
`glider2'.  The cycle length is optional and defaults to 0; the second field is
optional and defaults to the value of the first.  Comments (led by #) and blank
lines are ignored.

.SH BUGS
When expose events occur and text is displayed in the life window, the window
will not be refreshed. 
.P
Old files in #P format may not have same y coordinate when read by the
new release.  For best results, use "lifeconv -p name ..." on old files. 
.P
The I save format does not yet detect duplicate blobs when they are rotated
or reflected.
.P
The `u' command does not undo generate steps.
.P
Any rule which should produce an active cell from a neighborhood with all
neighbour cells off will not be processed correctly.  It will yield no
evolution outside the 8-cell-on-a-side boxes allocated to hold the active
pattern -- this horizon will increase one step each generation into the
vacancy.

.SH AUTHORS
Fast 2-state evolution algorithm and file format enhancements: Jon Bennett
<jcrb@fore.com>.

Original X code: Chuck Silvers <cs4n@andrew.cmu.edu>.

Enhancements to #I load format and user interface: Paul Callahan
<callahan@cs.jhu.edu>.

Auto-sizing, load format enhancements, N-state support, all of the non-Life
automata, still-life detection, false-color mode, the select box, #S and #I
save formats, massive code reorganization and optimizations: Eric S. Raymond
<esr@snark.thyrsus.com>.

Many new commands, subpixel resolution, M format:
Achim Flammenkamp <achim@mathematik.uni-bielefeld.de>.

.SH SEE ALSO   
lifesearch(1), lifeconv(1). 
.\"
.\"The following sets edit modes for GNU EMACS
.\"Local Variables:
.\"mode:nroff
.\"fill-column:79
.\"End:
