/*
 * lifeconv.c -- image format conversion routines for Xlife
 */
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <getopt.h>
#include "defs.h"
#include "data.h"
#include "tile.h"

static bool verbose = FALSE;

extern char *collect(char *file, FILE *fpout);

int main(argc, argv)
int argc;
char **argv;
{
    int gens = 0, c, mode = '\0';
    char *patternlib = (char *)NULL;
    extern int optind;
    extern char *optarg;

    while ((c = getopt(argc, argv, "ACDIMPRSg:p:v")) != -1)
	switch(c)
	{
	case 'A':
	case 'C':
	case 'D':
	case 'I':
	case 'M':
	case 'P':
	case 'R':
	case 'S':
	    mode = c;
	    break;

	case 'p':
	    patternlib = optarg;
	    break;

	case 'g':
	    gens = atoi(optarg);
	    break;

	case 'v':
	    verbose = TRUE;
	    break;
	}

    if (optind != argc-1)
    {
	fprintf(stderr,	"usage: %s [-ACDIMPRS] [-g n] filename\n", argv[0]);
	exit(1);
    }

    if (mode == 'C')
    {
	char *cp;

	if ((cp = collect(argv[1], stdout)))
	{
	    fprintf(stderr, "Load of %s failed\n", cp);
	    exit(1);
	}
    }
    else /* mode is ADIMPRS */
    {
	static pattern active;

	/* life structure initialization */
	initcells(&active);
	changesize(&active, 2);
	modify_rules("23/3", &active);
	fileinit();
	saveinit(patternlib);
	xorigin = 0;
	yorigin = 0;

	loadfile(argv[optind], &active, 0, 0);

	while (gens-- > 0)
	    generate(&active);

	savepattern(stdout, &active, mode);
    }

    exit(0);
}

/* these stubs are needed for the file load and generation logic */

void announce(const char *s)
{
    if (s[0] && verbose)
	fprintf(stderr, "%s\n", s);
}

void error(const char *s)
{
    if (s[0])
    {
	fprintf(stderr, "\007%s\n", s);
	exit(1);
    }
}

int breakreq(void)
/* poll for a keyboard interrupt by the user */
{
    return(FALSE);
}

int patch_transition(coord_t x, coord_t y,
	    cell_t s, cell_t n1, cell_t n2, cell_t n3, cell_t n4)
{
    char	buf[80];

    (void) sprintf(buf, "Unknown transition %c%c%c%c%c at (%ld, %ld)\n",
		   x, y,
		   itos(s), itos(n1), itos(n2), itos(n3), itos(n4));
    fatal(buf);

    return(0);
}
