/*
  Xinvest Copyright (c)1995-98 Mark Buser,
  All Rights Reserved.

  Permission is hereby granted to copy
  and freely distribute copies of this
  program for non-commercial purposes
  without fee, provided that this notice
  appears in all copies.
  
  All redistributions must be in their
  entirety as originally distributed.
  Feel free to modify Xinvest, but
  modified versions may not be distributed
  without prior consent of the author.
  
  This software is provided 'as-is'
  without any express or implied warranty.
  In no event will the author be held
  liable for any damages resulting from
  the use of this software.

  $Revision: 2.6 $ $Date: 1998/04/30 01:11:10 $
*/
#ifndef util_h
#define util_h

void syntax(int argc, char **argv);
int path_length();

void removeFileOption ( int *, char **);  /* Remove -f from passed argc/argv */
void processFileOption ( int, char **);   /* Load -f files from argc/argv */

#define UTILCURR 1			  /* Print as currency */
#define UTILNUM  0                        /* Print as non-currency */
char *utilCurrOut (double, int);          /* Change double to string, int is
                                             currency flag. */
char *utilDateOut (long);                 /* Change long to string */

#ifdef NeXT
#include <stdlib.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

#include <strings.h>
#include <sys/dir.h>
#include <sys/param.h>
#define S_ISDIR(mode) (((mode) & 0170000) == 0040000)

char *getcwd (char *, size_t);
char *strdup( const char *);
#endif

#if defined (NEED_STRCASECMP)
int strcasecmp (char *, char *);
int strncasecmp (char *, char *, int);
#endif 

#if defined (NEED_STRPTIME)
char *strptime ( char *, char *, struct tm *);
#endif

#endif
