/*
  Xinvest Copyright (c)1995-98, 2000
  Mark Buser, All Rights Reserved.

  Permission is hereby granted to copy
  and freely distribute copies of this
  program for non-commercial purposes
  without fee, provided that this notice
  appears in all copies.
  
  All redistributions must be in their
  entirety as originally distributed.
  Feel free to modify Xinvest, but
  modified versions may not be distributed
  without prior consent of the author.
  
  This software is provided 'as-is'
  without any express or implied warranty.
  In no event will the author be held
  liable for any damages resulting from
  the use of this software.

  $Revision: 2.11 $ $Date: 2000/02/04 00:37:46 $
*/

#define T_BUY 	      1  /* For access routines, types of transactions */
#define T_SELL        2
#define T_DIST        3
#define T_PRICE       4
#define T_SPLIT       5
#define T_CURR        6
#define T_PERC        7
#define T_TITLE       8
#define T_TICK        9
#define T_CTICK      10
#define T_REINV      11
#define T_ESOP       12

#define T_NEW      1      /* For rd_trans, start new transaction history */
#define T_SAME     0      /* For rd_trans, add to existing history */

/* Access routines */
int AreTrans();           /* Are there any transactions, returns how many */

/* Parse transaction line, new file if int is non-zero */
char *rd_trans( char *, int);

void *GetTrans();    /* Return pointer to current transactions, NULL on none */

char *GetTransTitle();      /* Return title, NULL on none                */
char *GetTransTicker();     /* Return ticker symbol, NULL on none        */ 
char *GetTransCurrTicker(); /* Return exchange rate ticker, NULL on none */ 
char *GetTransETicker();     /* Return ticker modifier, NULL on none        */ 
char *GetTransCurrETicker(); /* Return exchange rate modifier, NULL on none */ 

/* The first param of the following is pointer to a TRANS structure,
** the second, the tranaction number of interest.                     */

char *GetTransDate( void *, int);    /* Date of transaction...as char */ 
long GetTransLDate( void *, int);    /* Date of transaction...as long */ 
int  GetTransType( void *, int);     /* Type of transaction e.g.T_BUY */
double GetTransNav( void *, int);    /* NAV of transaction            */
double GetTransCurrency( void *, int);  /* Currency exchange rate     */
double GetTransShares( void *, int); /* Number of transaction shares  */
double GetTransLoad( void *, int);   /* Load of transaction           */

#define TRANS_REINVEST 1
int GetTransFlag (void *, int, int); /* Value of requested flag       */

#define TRANS_MAJOR 1
#define TRANS_MINOR 2
int GetTransSplit (void *, int, int);/* Value of requested split.     */

