/*
  Xinvest Copyright (c)2000 Mark Buser,
  All Rights Reserved.

  Permission is hereby granted to copy
  and freely distribute copies of this
  program for non-commercial purposes
  without fee, provided that this notice
  appears in all copies.
  
  All redistributions must be in their
  entirety as originally distributed.
  Feel free to modify Xquote, but
  modified versions may not be distributed
  without prior consent of the author.
  
  This software is provided 'as-is'
  without any express or implied warranty.
  In no event will the author be held
  liable for any damages resulting from
  the use of this software.

  $Revision: 1.1 $ $Date: 2000/01/11 22:31:04 $
*/

#include <ctype.h>
#include <Xm/XmAll.h>

#include "resource.h"

/* Globals */
static RESOURCE_STRUCT **type_data;
static int type_num;

/* Return string associated with X resource */
char *getResource (int type, int which)
{
  static char *empty = "";
  if (type >= type_num)
     return (empty);
  if (which >= type_data[type]->num_resources)
     return (empty);
  if (type_data[type]->resources->values[which] == NULL)
     return (empty);
  return (type_data[type]->resources->values[which]);
}

/* Read all there is to know from X resources */
int readResourceDatabase (Widget Toplevel, char *appname, 
                          char *resclass, char *resname, 
                          char propnames[][7], int num_propnames)
{
  XrmDatabase	db = XtScreenDatabase(XtScreenOfObject(Toplevel));
  XrmQuark      class[5], name[5];
  XrmValue      value;
  XrmRepresentation type;
  int field;

  /* Set up for resource fetch */
  class[0] = XrmStringToQuark("Xinvest");
  class[1] = XrmStringToQuark(resclass);
  class[2] = NULLQUARK;

  name[0] = XrmStringToQuark(appname);
  name[1] = XrmStringToQuark(resname);
  name[2] = NULLQUARK;

  /* when fetching query strings, these are the end */
  class[3] = XrmStringToQuark("LabelString");
  name[3]  = XrmStringToQuark("labelString");
  class[4] = NULLQUARK;
  name[4]  = NULLQUARK;

  /* Add new resource structure */
  type_num++;
  type_data = (RESOURCE_STRUCT **) XtRealloc ((char *)type_data, type_num *
		                               sizeof(RESOURCE_STRUCT *));
  type_data[type_num-1] = (RESOURCE_STRUCT *)
                                   XtCalloc(1, sizeof(RESOURCE_STRUCT));
  type_data[type_num-1]->num_resources = num_propnames;
  type_data[type_num-1]->resources = (QUERY_STRUCT *) 
                                   XtCalloc (1, sizeof (QUERY_STRUCT));

  /* Fill in resource fields */
  for (field = 0; field < num_propnames; field++) {
    propnames[field][0] = toupper ( propnames[field][0] );
    class[2] = XrmStringToQuark (propnames[field]);
    propnames[field][0] = tolower ( propnames[field][0] );
    name[2] = XrmStringToQuark (propnames[field]);
    XrmQGetResource (db, name, class, &type, &value);
    type_data[type_num-1]->resources->values[field] = XtNewString (value.addr);
  }

  return (type_num-1);
}
