/*
  Xinvest Copyright (c)2000 
  Mark Buser, All Rights Reserved.

  Permission is hereby granted to copy
  and freely distribute copies of this
  program for non-commercial purposes
  without fee, provided that this notice
  appears in all copies.
  
  All redistributions must be in their
  entirety as originally distributed.
  Feel free to modify Xinvest, but
  modified versions may not be distributed
  without prior consent of the author.
  
  This software is provided 'as-is'
  without any express or implied warranty.
  In no event will the author be held
  liable for any damages resulting from
  the use of this software.

  $Revision: 1.2 $ $Date: 2000/01/12 22:53:53 $
*/
#ifndef reportP_h
#define reportP_h

#ifdef DEBUG
#define DEBUGXY  fprintf( stderr, "x -> %d  y -> %d\n", attrib->x, attrib->y)
#else
#define DEBUGXY
#endif

/* Border around report drawing area */
#define BORDER		      32

/* Settings of accounts to report on */
#define REPORT_ACTIVE_ACCOUNT 1
#define REPORT_ALL_ACCOUNTS   2
#define REPORT_PORTFOLIO      4

/* Settings of details to report on */
#define REPORT_DETAIL_ON      1
#define REPORT_RTN_DETAIL_ON  2
#define REPORT_SINGLEWIN_ON   4

/* Special account value when reporting on portfolio */
#define REPORT_PORTFOLIO_ACCOUNT      -1

/* Number of time frames we can report on */
#define REPORT_TIMES          12 
#define TIME_CUSTOM           REPORT_TIMES-1
#define TIME_INCEP            REPORT_TIMES-2
#define TIME_YTD              REPORT_TIMES-8

/* Width in chars of a report */
#define REPORT_CHAR_WIDTH     76

/* Resource queries for REPORT_TYPE */
#define REPVALUE   0
#define REPPRICE   1
#define REPSHARE   2
#define REPDVALUE  3
#define REPDPRICE  4
#define REPDSHARE  5
#define REPCOST    6
#define REPDEBIT   7
#define REPFEE     8
#define REPTR      9
#define REPIRR     10
#define REPYIELD   11
#define REPGAIN    12
#define REPDIST    13
#define REPNA      14
#define REPPORT    15
#define REP_NUM_QUERY_VALUES REPPORT+1

#endif
