/*
 * $Id: local.h,v 0.86 1997/03/22 06:04:08 zhao Beta $
 *
 *.
 *  This file is part of XForms package
 *  Copyright (c) 1995-1997  T.C. Zhao and Mark Overmars
 *  All rights reserved.
 *.
 *  Some machine specific stuff.
 *
 */

#ifndef FL_LOCAL_H
#define FL_LOCAL_H		/* { */

#include <unistd.h>

#define DONT_HAVE_USLEEP

#define FL_SIGRET void

/* linux and ultrix do not have strdup */

#if defined(__linux__)||defined(linux)
#define NO_STRDUP
#undef DONT_HAVE_USLEEP
#endif

#if defined(Lynx)
#define NEED_GETCWD
#endif

#if defined(__VMS)
#define NEED_GETCWD
#define fork vfork

#if __VMS_VER < 70000000
struct timezone
{
    int tz_minuteswest;		/* minutes west of Greenwich */
    int tz_dsttime;		/* type of dst correction */
};

extern int gettimeofday();
#endif /* ___VMS_VER  */

#endif /* __VMS */

#if defined(__ultrix)||defined(ultrix)
#define NO_STRDUP
#endif

/* (some) suns do not have strerror, use sys_errlist */

#if defined(sun) || defined(__sun__)
#define DONT_HAVE_STRERROR
#define DONT_HAVE_ATEXIT
#endif

/*#if defined(__sgi)
#endif
*/

/* #if defined(_HPUX_SOURCE)
#endif
*/

#if defined(M_XENIX)
#define NO_SOCK
#endif

/* #define NO_CONST     */

/* prototype is currently required */

/* #define NO_PROTOTYPE */

/********* End of Configurable stuff ***********/

#ifdef NO_STRDUP
extern char *strdup(const char *);
#endif

/* some header has XK_XP_Left etc */
#if (XlibSpecificationRelease>=6)
#define HAVE_KP_DEFINE 1
#endif

#ifdef NO_CONST
#  undef  const
#  define const
#endif

#ifndef FL_PATH_MAX
#  ifdef PATH_MAX
#    define FL_PATH_MAX   PATH_MAX
#  else
#    define FL_PATH_MAX   1024
#  endif
#endif /* FL_PATH_MAX */

#ifndef FL_FLEN
#define FL_FLEN           128
#endif

/* There are two ways to handle motion events, one is to constantly
 * query the server for mouse position, and the other is to use
 * motion events. The first way obviously is slow and expensive
 * if runs across network. The latter however suffers with stepping
 * events.
 */

/*#define NO_MSG_INFO */

#endif /* ifndef local.h } */
