/*
 *
 * This file is part of the XForms library.
 *
 * XForms is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1, or
 * (at your option) any later version.
 *
 * XForms is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with XForms; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 */


/*
 * $Id: test.c,v 0.89 1999/07/18 07:51:45 zhao Beta $
 *
 *.
 *  This file is part of XForms package
 *  Copyright (c) 1996-2001  T.C. Zhao and Mark Overmars
 *  All rights reserved.
 *.
 *
 * stupid test
 */
#include "forms.h"

#if 0
#define HintBug
#endif

static int
ffilter(const char *n, int type)
{
    /* return !strcmp(n,"."); */
    return 1;
}

static FL_FORM *tforms[7], *brform, *cntl;
static FL_OBJECT *bm, *xyplot, *mousepos, *se, *br;
int nform;
static float fx[50], fy[50], fx2[50], fy2[50];


static int
idle_cb(XEvent * xev, void *p)
{
    char buf[100];
    static int x, y;

    if (x != xev->xmotion.x || y != xev->xmotion.y)
    {
	sprintf(buf, "(%d,%d)", xev->xmotion.x, xev->xmotion.y);
	fl_set_object_label(mousepos, buf);
	x = xev->xmotion.x;
	y = xev->xmotion.y;
    }
    return 0;
}

static void
soft_edge(FL_OBJECT * ob, long p)
{
    int i;

    for (i = 0; i < nform; i++)
	fl_redraw_form(tforms[i]);
}

static void
pixel_height(FL_OBJECT * ob, long p)
{
    int i;
    FL_OBJECT *q;

    for (i = 0; i < nform; i++)
    {
	fl_freeze_form(tforms[i]);
	for (q = tforms[i]->first; q; q = q->next)
	    fl_set_object_bw(q, (fl_get_button(se) ? -p : p));
	fl_unfreeze_form(tforms[i]);
    }

}

static void
counter_cb(FL_OBJECT * ob, long q)
{
    fl_set_browser_xoffset(br, (int) fl_get_counter_value(ob));
}

static void
slider_cb(FL_OBJECT * ob, long q)
{
    fl_set_browser_xoffset(br, (int) fl_get_slider_value(ob));
}

static void
dbg_cb(FL_OBJECT * ob, long q)
{
    fl_cntl.debug = fl_get_button(ob);
}

static void
close_down(FL_OBJECT * ob, long q)
{
    static int i;

    fl_hide_form(ob->form);

    if (q)
	fl_free_form(ob->form);
    else
    {
	i++;
	if ((i % 2))
	    fl_set_initial_placement(ob->form, ob->form->x,
				     ob->form->y, ob->form->w, ob->form->h);
	fl_show_form(ob->form,
	   (i % 2) ? FL_PLACE_FREE : FL_PLACE_GEOMETRY, 1, ob->form->label);
    }
}

static void
finish_up(FL_OBJECT * ob, long p)
{
    int i;

    atexit(fl_finish);
#if 0
    for (i = 0; i < 7; i++)
    {
	if (tforms[i])
	{
	    fl_hide_form(tforms[i]);
	    fl_free_form(tforms[i]);
	    tforms[i] = 0;
	}
    }
#ifdef TC_MEMDBG
    fl_free_all_goodies();
    tc_mem_stat(10);
#endif
    fl_finish();
#endif
    exit(0);
}

static void
return_button(FL_OBJECT * ob, long p)
{
    const XEvent *xev;
    fprintf(stderr, p ? "TouchButton %d\n" : "ReturnButton%d\n",
	    fl_get_button_numb(ob));
    xev = fl_last_event();
    if (xev->type == ButtonPress || xev->type == ButtonRelease)
	fprintf(stderr, "button=%d\n", xev->xbutton.button);

}

static void
sl_val(FL_OBJECT * ob, long p)
{
#if 0
    static int first = 1;
    fprintf(stderr, "current val=%f\n", fl_get_slider_value(ob));
    if (first)
    {
	fl_set_slider_value(ob, 1.0);
	XSync(fl_display, 0);
	sleep(1);
	first = 0;
    }
#endif
}

static int
pup_cb(int k)
{
    fprintf(stderr, "PUPreturned  %d\n", k);
    return k;
}

#if 0
static int
spup_cb(int k)
{
    fprintf(stderr, "SPUPreturned  %d\n", k);
    return k;
}

#endif

static void
pup_button(FL_OBJECT * ob, long q)
{
    long m, sm, ssm;
    int n;


    ssm = fl_defpup(ob->form->window, "Subitem1%x101");

    sm = fl_defpup(ob->form->window,
	  "SubPop\tUP %t|Sub\tItem1%x100%m|SubItem%x200|Subitem%x300", ssm);
    fl_setpup_cursor(sm, XC_hand2);
    fl_setpup_mode(sm, 100, FL_PUP_GREY);

    m = fl_defpup(ob->form->window,
		  "PopUP%t%F|MenuItem\t1%s|MenuItem\t2x10%x10|MenuItem%x12",
		  pup_cb, "1");
    fl_addtopup(m, "MenuItem\t4|LongMenuItem\t1%m|LongMenuItemg%%%s|Done", sm, "g");
    fl_setpup_shortcut(m, 10, "I");
    n = fl_dopup(m);
    fprintf(stderr, "dopop returned %d\n", n);

    fl_freepup(ssm);
    fl_freepup(sm);
    fl_freepup(m);
}


static int
show_xbm(const char *s, void *data)
{
    fl_set_bitmap_file(bm, s);
    return 0;
}

void
hide_fselector_appbutt(void *a)
{
    static int i;
    char buf[20];

    sprintf(buf, "hide%d", i);
    fl_remove_fselector_appbutton(buf);
    i++;
    i %= 4;
}

static void
goodies_cb(FL_OBJECT * ob, long q)
{
    if (q == 1)
	fl_show_input("Type a String", "Default string");
    else if (q == 2)
    {
	fl_show_alert("Warning", "This message will inform you of any",
		      "problems in your program/input", 0);
	fprintf(stderr, "continuing after alert!\n");
    }
    else if (q == 3)
    {
	if (brform->visible)
	    fl_hide_form(brform);
	else
	    fl_show_form(brform, FL_PLACE_GEOMETRY, FL_FULLBORDER, brform->label);
    }
    else if (q == 4)
    {
	static int first = 1;
	fl_set_fselector_cb(show_xbm, 0);

	if (first)
	{
	    fl_add_fselector_appbutton("hide0", hide_fselector_appbutt, 0);
	    fl_add_fselector_appbutton("hide1", hide_fselector_appbutt, 0);
	    fl_add_fselector_appbutton("hide2", hide_fselector_appbutt, 0);
	    fl_add_fselector_appbutton("hide3", hide_fselector_appbutt, 0);
	    first = 0;
	}
	fl_set_fselector_fontsize(18);
	fl_set_fselector_fontstyle(FL_BOLD_STYLE);
	fl_show_file_selector("Enter BitmapFileName",
			      "", "*.x?m", "");
	fprintf(stderr, "done shown fselector\n");
    }
}

static void
change_xystyle(FL_OBJECT * ob, long q)
{
    xyplot->type++;
    xyplot->type %= (FL_EMPTY_XYPLOT + 1);
    fl_redraw_object(xyplot);
}

static int
raw_cb(FL_FORM * form, void *xevent)
{
    int save = fl_cntl.debug;

    fl_cntl.debug = 2;
    fl_xevent_name("RAW", xevent);
    fl_cntl.debug = save;
    return 0;
}

extern char *optarg;
extern int _Xdebug;

static void
draw_red_square(Window aw, int w, int h)
{
    XSetForeground(fl_display,
		   fl_state[fl_vmode].gc[8],
		   fl_get_flcolor(FL_RED));
    XDrawRectangle(fl_display, aw, fl_state[fl_vmode].gc[8], 1, 1, w - 2, h - 2);
}

static int newrb = -1;
static int
expose_handler(XEvent * xev, void *p)
{
    FL_Coord w, h;

    fprintf(stderr, "Main expose callback called\n");
    fl_get_winsize(xev->xany.window, &w, &h);
    draw_red_square(xev->xany.window, w, h);

    /* try all events */
    fl_remove_event_callback(xev->xany.window, 0);
    fl_add_event_callback(xev->xany.window, 0, expose_handler, 0);

#if 0
    if (newrb >= 0)
	fl_redraw_rubber(newrb);
#endif
    return 0;
}


static int
motion_handler(XEvent * xev, void *p)
{
    fl_print_xevent_name("MotionMain", xev);
    return 0;
}

void
main_ev_cb(XEvent * xev)
{
    FL_Coord w, h;

    fl_xevent_name("MainCB", xev);

    switch (xev->type)
    {
    case Expose:
	fl_get_winsize(xev->xany.window, &w, &h);
	draw_red_square(xev->xany.window, w, h);
	break;
#if 0
    case ButtonPress:
	if (newrb < 0)
	    newrb = fl_new_rubber(0, xev->xany.window, 10, 10, 100, 100, 0);
	fl_move_rubber(newrb, xev->xbutton.x - 50, xev->xbutton.y - 50, 100, 100, 0);
	break;
    case KeyPress:
	fl_free_rubber(newrb);
	newrb = -1;
	break;
#endif

    }
}

static void
actxy_cb(FL_OBJECT * ob, long data)
{
    static int nt = 1;
    char buf[30];

    sprintf(buf, "InsetText%d", nt - 1);
    fl_delete_xyplot_text(ob, buf);
    sprintf(buf, "InsetText%d", nt);
    fl_add_xyplot_text(ob, 6.0, 10.0, buf, FL_ALIGN_CENTER, FL_RED);
    nt++;
}

int
close_catch(FL_FORM * fm, void *data)
{
    fprintf(stderr, "trying to close %s\n", fm->label);
    return FL_IGNORE;
}

void
input_cb(FL_OBJECT * ob, long data)
{
    int x, y;
    fl_get_input_cursorpos(ob, &x, &y);
    fprintf(stderr, "X=%d y=%d\n", x, y);
}

static int
filter(FL_OBJECT * ob, const char *s, const char *new, int c)
{
    fprintf(stderr, "old=%s\n", s);
    fprintf(stderr, "new=%s\n", new);
    return (isupper(c) ? !FL_VALID : FL_VALID);
}

#include <signal.h>
void
sig_handler(int s, void *data)
{
    fprintf(stderr, "signal %d noticed\n", s);
    fl_remove_signal_callback(s);
    fl_add_signal_callback(s == SIGUSR1 ? SIGUSR2 : SIGUSR1, sig_handler, 0);
}

void
dbl_cb(FL_OBJECT * ob, long data)
{
    fprintf(stderr, "Dbl click callback: data=%ld ob->ldata=%ld\n", data,
	    ob->u_ldata);

}


int
main(int argc, char *argv[])
{
    Window aw;
    FL_OBJECT *obj;
    FL_Coord x, y, dx, dy, w = 300, h = 330;
    FL_FORM *fm;
    FL_OBJECT *ob;
    char tmpbuf[127];
    int i;


    fl_flip_yorigin();
    fl_initialize(&argc, argv, "FormDemo", 0, 0);
    fl_clear_command_log();
    fprintf(stderr, "file=%s\n", fl_get_filename());
#if 1
    {
	char *fn = "-*-elvetica-bold-r-normal-*-*-?-*-*-*-*-*-*";
	if (fl_set_font_name(FL_NORMAL_STYLE, fn) < 0)
	    fprintf(stderr, "invalid fontname: %s\n", fn);

	fn = "-*-helvetica-bold-r-normal-*-*-?-*-*-*-*-*-*";
	if (fl_set_font_name(FL_NORMAL_STYLE, fn) < 0)
	    fprintf(stderr, "invalid fontname: %s\n", fn);
    }
#endif
    fl_set_goodies_font(FL_BOLD_STYLE, 14);

    fl_add_signal_callback(SIGUSR1, sig_handler, 0);
    fl_add_signal_callback(100, sig_handler, 0);

/*    fl_set_dirlist_filter(ffilter); */

    fprintf(stderr, "XFVerson: %d\n", fl_library_version(0, 0));

    {
	char *s = "abc";
	char *s1 = "abc\t";

	fprintf(stderr, "w=%d %d\n",
	     fl_get_string_widthTAB(FL_NORMAL_STYLE, FL_DEFAULT_SIZE, s, 3),
	   fl_get_string_widthTAB(FL_NORMAL_STYLE, FL_DEFAULT_SIZE, s1, 4));
    }

    i = 3;
    fl_get_resource("level", "Level", FL_INT, "1", &i, 0);

#if 0
    for (i = 0; i < 12; i++)
    {
	fl_defpup(fl_root, "aaa");
    }
#endif
    fl_setpup_maxpup(80);

    set_msg_threshold(fl_cntl.debug);
#if 0

    {
	long a;

	fl_show_command_log(1);
	fprintf(stderr, "exe command (cat): %d\n",
		a = fl_exe_command("cat ", 0));

	fprintf(stderr, "check command: %d\n",
		fl_check_command(a));
	fprintf(stderr, "end command: %d\n",
		fl_end_command(a));
	fprintf(stderr, "check command: %d\n",
		fl_check_command(a));
    }
#endif

    {
	FILE *a;
        char buf[128];
         int s;

        fl_clear_command_log();
	fl_show_command_log(1);
	fprintf(stderr, "popen command (cat): %d\n",
		a = fl_popen("cat cmd_br.c", "r"));

        while (fgets(buf, sizeof(buf), a))
         fprintf(stderr,"buf=%s", buf);
      
        s = fl_pclose(a);
        fprintf(stderr,"status: %d\n",s);
    }


    /* init x , y */

    for (i = 0; i < 20; i++)
    {
	fx[i] = fy[i] = i + 0.1;
	fx2[i] = i + 0.4;
	fy2[i] = i + 4;
    }

    x = y = 20;
    dx = 80;
    dy = 30;

    fl_set_atclose(close_catch, 0);

    cntl = tforms[nform++] = fm = fl_bgn_form(FL_UP_BOX, 300, 330);

    ob = fl_add_button(FL_NORMAL_BUTTON, x - 2, y, dx, dy, "@Popup");
/*    ob = fl_add_frame(FL_SHADOW_FRAME, x - 5, y, dx, dy, "Button"); */
/*    fl_set_object_color(ob, FL_RED, FL_RED); */
    fl_set_object_callback(ob, pup_button, 0);
    fl_set_object_shortcut(ob, "u", 1);
    y += dy + 5;


    ob = fl_add_button(FL_PUSH_BUTTON, x - 2, y, dx, dy, "Debug");

    y += dy + 5;
    fl_set_button(ob, fl_cntl.debug);
    fl_set_object_callback(ob, dbg_cb, 0);
    fl_set_object_shortcut(ob, "#g&1gG", 1);

    ob = fl_add_roundbutton(FL_RADIO_BUTTON, x, y, dx, dy, "3Pixel");
    {
	int xx, yy;
	fprintf(stderr, "y=%d\n", y);
	fl_get_object_position(ob, &xx, &yy);
	fprintf(stderr, "y=%d\n", yy);
    }
    fl_set_object_callback(ob, pixel_height, 3);
    fl_set_button_shortcut(ob, "3", 3);
    y += dy + 5;
    fl_set_button(ob, 1);

    ob = fl_add_roundbutton(FL_RADIO_BUTTON, x, y, dx, dy, "2Pixel");
    fl_set_object_callback(ob, pixel_height, 2);
    fl_set_button_shortcut(ob, "2", 2);
    y += dy + 5;

    ob = fl_add_roundbutton(FL_RADIO_BUTTON, x, y, dx, dy, "1Pixel");
    fl_set_object_callback(ob, pixel_height, 1);
    fl_set_button_shortcut(ob, "1", 1);
    y += dy + 5;

    se = ob = fl_add_lightbutton(FL_PUSH_BUTTON, x, y, dx, dy, "Soft");
    fl_set_object_callback(ob, soft_edge, 0);
    fl_set_object_shortcut(ob, "Ss", 0);
    fl_set_object_lalign(ob, FL_ALIGN_BOTTOM);
    y += dy + 5;

    ob = fl_add_button(FL_RETURN_BUTTON, x, y, dx, dy, "RET");
    fl_set_object_callback(ob, return_button, 0);
    y += dy + 5;

    ob = fl_add_button(FL_TOUCH_BUTTON, x, y, dx, dy, "TOUCH");
    fl_set_object_callback(ob, return_button, 1);
    fl_set_object_shortcut(ob, "Tt", 1);
    y += dy + 5;

    ob = fl_add_button(FL_NORMAL_BUTTON, w - dx - 15,
		       h - dy - 15, dx, dy, "Done");
    fl_set_object_callback(ob, finish_up, 0);
    fl_set_object_shortcut(ob, "Dd\033", 1);

    y = 20;
    x = 150;

    /* test inverted slider */
    ob = fl_add_valslider(FL_VERT_FILL_SLIDER, x - 50, y, 30, 150, "");
    fl_set_slider_bounds(ob, 1.0, 0);
    fl_set_object_callback(ob, sl_val, 0);

    ob = fl_add_button(FL_NORMAL_BUTTON, x, y, 30, 30, "@->");
    fl_set_object_lcol(ob, FL_RED);
    ob = fl_add_button(FL_NORMAL_BUTTON, x + 30, y, 30, 30, "@#>");
    fl_set_object_lcol(ob, FL_RED);
    ob = fl_add_button(FL_NORMAL_BUTTON, x + 60, y, 30, 30, "@>>");
    fl_set_object_lcol(ob, FL_RED);
    ob = fl_add_button(FL_NORMAL_BUTTON, x + 90, y, 30, 30, "circle");
    fl_set_object_lcol(ob, FL_RED);
    fl_set_object_shortcut(ob, "#c", 1);
    y += dy;


    ob = fl_add_button(FL_NORMAL_BUTTON, x, y, 30, 30, "@#<-");
    fl_set_object_lcol(ob, FL_RED);
    ob = fl_add_button(FL_NORMAL_BUTTON, x + 30, y, 30, 30, "@#<");
    fl_set_object_lcol(ob, FL_RED);

    ob = fl_add_bitmapbutton(FL_NORMAL_BUTTON, x + 60, y, 30, 30, "");
    fl_set_bitmapbutton_datafile(ob, "bitmaps/warn.xbm");

    ob = fl_add_button(FL_NORMAL_BUTTON, x + 90, y, 30, 30, "@square");
    fl_set_object_lcol(ob, FL_RED);
    y += dy;

    ob = fl_add_button(FL_NORMAL_BUTTON, x, y, 30, 30, "@#8->");
    fl_set_object_lcol(ob, FL_RED);
    ob = fl_add_button(FL_NORMAL_BUTTON, x + 30, y, 30, 30, "@8>");
    fl_set_object_lcol(ob, FL_RED);
    ob = fl_add_button(FL_NORMAL_BUTTON, x + 60, y, 30, 30, "@8>>");
    fl_set_object_lcol(ob, FL_RED);
    ob = fl_add_button(FL_NORMAL_BUTTON, x + 90, y, 30, 30, "@plus");
    fl_set_object_lcol(ob, FL_RED);
    y += dy;

    ob = fl_add_button(FL_NORMAL_BUTTON, x, y, 30, 30, "@#2->");
    fl_set_object_lcol(ob, FL_RED);
    ob = fl_add_button(FL_NORMAL_BUTTON, x + 30, y, 30, 30, "@#2>");
    fl_set_object_lcol(ob, FL_RED);
    ob = fl_add_button(FL_NORMAL_BUTTON, x + 60, y, 30, 30, "@#2>>");
    fl_set_object_lcol(ob, FL_RED);
    ob = fl_add_button(FL_NORMAL_BUTTON, x + 90, y, 30, 30, "@RippleLines");
    fl_set_object_lcol(ob, FL_LEFT_BCOL);
    y += dy + 10;

    x = 130;
    dx = 130;
    dy = 25;
    ob = fl_add_counter(FL_NORMAL_COUNTER, x, y, dx, dy, "");
    fl_set_object_callback(ob, counter_cb, 0);
    y += dy + 10;
    fl_set_counter_value(ob, 10);

    ob = fl_add_valslider(FL_HOR_SLIDER, x, y, 130, dy, "");
    fl_set_slider_bounds(ob, 0, 200);
    fl_set_slider_precision(ob, 0);
    fl_set_slider_value(ob, 0);
    fl_set_object_callback(ob, slider_cb, 0);

    y += dy + 10;
    ob = fl_add_valslider(FL_HOR_FILL_SLIDER, x, y, 130, dy, "");
    fl_set_object_color(ob, FL_COL1, FL_RED);
    y += dy + 10;
    ob = fl_add_valslider(FL_HOR_NICE_SLIDER, x, y, 130, dy, "");
    fl_set_object_color(ob, FL_SLATEBLUE, FL_RED);
    fl_set_object_boxtype(ob, FL_BORDER_BOX);
    y += dy + 10;

    fl_end_form();
    fl_scale_form(fm, 0.9, 0.9);

    fl_set_initial_placement(fm, fm->w / 2, fm->h / 2, fm->w, fm->h);
    fl_set_form_minsize(fm, 50, 50);
    fl_set_form_maxsize(fm, 950, 950);

    fl_show_form(fm, FL_PLACE_CENTER | FL_FREE_SIZE, FL_FULLBORDER, "test");

#if 0
    fl_register_raw_callback(fm, FL_ALL_EVENT, raw_cb);
#endif

#if 1
    for (i = 0; i < 5; i++)
    {
	fl_set_form_position(fm, fm->x + 10, fm->y);
	fl_msleep(200);
	XFlush(fl_display);
    }
#endif

    fl_set_cursor(fm->window, XC_hand2);

#if 1				/* { */

    /* browser window */
    brform = tforms[nform++] = fm = fl_bgn_form(FL_NO_BOX, 300, 330);
    ob = fl_add_box(FL_UP_BOX, 0, 0, 300, 330, "");
    fl_set_object_color(ob, FL_WHITE, FL_WHITE);
    br = ob = fl_add_browser(FL_SELECT_BROWSER, 15, 15, 300 - 30, 300, "");
    fl_set_browser_dblclick_callback(ob, dbl_cb, 1);
    ob->u_ldata = 2;
    fprintf(stderr, "browline: %s\n", fl_get_browser_line(ob,
						       fl_get_browser(ob)));
    fl_set_object_boxtype(ob, FL_DOWN_BOX);
    fl_set_object_gravity(ob, NorthWestGravity, SouthEastGravity);
    fl_set_object_dblbuffer(ob, 0);

    fl_add_browser_line(ob, "@c@b Title");

    for (i = 0; i < 17; i++)
    {
	sprintf(tmpbuf, "this is a test line. Sequence number # %d", i);
	if (i == 3)
	{
	    fl_add_browser_line(ob, "AAA\tAAA\tAAA");
	    fl_add_browser_line(ob, "AAAA\tAAA\tAAAA");
	}
	if (i == 10)
	    fl_add_browser_line(ob, "@C1@_@@underlined ijklm");
	else if (i == 11)
	    fl_add_browser_line(ob, "|\t|\nMultiline sequence 11");
	else if (i == 9)
	    fl_add_browser_line(ob, "@-");
	else if (i == 5)
	    fl_add_browser_line(ob, "@f@b Bold fixed font and long very long"
		       "and very long long long logn and truely long line");
	else if (i == 6)
	    fl_add_browser_line(ob, "@t@b@i BoldItalic times font");
	else if (i == 7)
	    fl_add_browser_line(ob, "@n normal font");
	else if (i == 15)
	    fl_add_browser_line(ob, "long long long long and very long lines"
				"and even longer than I thought");
	else
	    fl_add_browser_line(ob, tmpbuf);
    }

    fl_add_browser_line(ob, "@C4@l Colored text bj");
    for (i = 15; i < 80; i++)
    {
	sprintf(tmpbuf, "this is a test line. Sequence number # %d", i);
	fl_add_browser_line(ob, tmpbuf);
    }

    fl_end_form();
    fl_scale_form(fm, 0.9, 0.9);
#if 1
    fl_show_form(fm, FL_PLACE_FREE, 1, "Browser");
#else
    {
	long win;
	XIconSize sz;

	win = fl_prepare_form_window(fm, FL_PLACE_ICONIC, 1, "Browser");
	sz.min_width = sz.max_width = 32;
	sz.min_height = sz.max_height = 32;
	sz.width_inc = sz.height_inc = 1;
	XSetIconSizes(fl_display, win, &sz, 1);
	fl_show_form_window(fm);
    }
#endif


    tforms[nform++] = fm = fl_bgn_form(FL_UP_BOX, w, h);
    x = 50;
    dx = 200;
    dy = 25;
    y = h - 20 - dy;
    ob = fl_add_input(FL_DATE_INPUT, x, y, dx, dy, "Input1");
    fl_set_input_scroll(ob, 0);
    fl_set_input(ob, "Preselected");
#if 1
    fl_set_input_selected(ob, 1);
#else
    fl_set_input_selected_range(ob, 0, strlen("Preselected"));
#endif
#if 0
    fl_set_input_maxchars(ob, 20);
    fl_set_input_filter(ob, filter);
#endif

#if 1
    fl_set_input_cursorpos(ob, 8, 1);
    fl_set_object_return(ob, FL_RETURN_CHANGED);
#endif
    fl_set_object_callback(ob, input_cb, 0);
    y -= dy + 5;
    ob = fl_add_input(FL_INT_INPUT, x, y, dx, dy, "Input2");
    y -= dy + 5;

    ob = fl_add_choice(FL_NORMAL_CHOICE, x, y, dx / 2, dy, "");
    fl_addto_choice(ob, "PopUpItem1");
    fl_addto_choice(ob, "\010PopUpItem2");
    fl_addto_choice(ob, "PopUpItem3 %l");
    fl_addto_choice(ob, "PopUpItem4 -- very long choice item");
    fl_set_choice_align(ob, FL_ALIGN_LEFT);
    y -= dy + 5;

    ob = fl_add_menu(FL_PULLDOWN_MENU, x, y, dx / 2, dy, "pulldown");
    fl_addto_menu(ob, "pulldown_Item1");
    fl_addto_menu(ob, "pulldown_Item2");
    fl_addto_menu(ob, "pulldown_Item3");
    fl_addto_menu(ob, "pulldown_Item4");

    y -= dy + 5 + 5;

    dy += 5;

    ob = fl_add_button(FL_NORMAL_BUTTON, x, y, dx / 2, dy, "Input");
    fl_set_object_callback(ob, goodies_cb, 1);
    y -= dy + 2;

    ob = fl_add_button(FL_NORMAL_BUTTON, x, y, dx / 2, dy, "Message");
    fl_set_object_callback(ob, goodies_cb, 2);
    y -= dy + 2;

    ob = fl_add_button(FL_NORMAL_BUTTON, x, y, dx / 2, dy, "HideBrowser");
    fl_set_object_callback(ob, goodies_cb, 3);
    fl_set_button_shortcut(ob, "#q", 1);
    y -= dy + 2;

    ob = fl_add_button(FL_NORMAL_BUTTON, x, y, dx / 2, dy, "LoadXBM");
    fl_set_object_callback(ob, goodies_cb, 4);
    y -= dy + 2;

    /* the bitmap stuff */
    bm = ob = fl_add_bitmap(FL_NORMAL_BITMAP, 10, 10, 50, 50, "");
#if 0
    fl_set_object_color(ob, FL_COL1, FL_COL1);
#endif
    fl_set_object_lcol(ob, FL_BLUE);
    fl_set_object_boxtype(ob, FL_BORDER_BOX);


    /* vertical slider */
    y = 40;
    ob = fl_add_slider(FL_VERT_SLIDER, x + dx, y, dy + 5, dx, "");
    ob = fl_add_valslider(FL_VERT_SLIDER, x + dx - dy - 5, y, dy + 5, dx, "");
    fl_end_form();

    fl_adjust_form_size(ob->form);
    fl_scale_form(fm, 0.9, 0.9);
    fl_show_form(fm, FL_PLACE_FREE, 1, "Misc");

#if 1
    tforms[nform++] = fm = fl_bgn_form(FL_UP_BOX, w, h += 60);
    ob = fl_add_button(FL_HIDDEN_BUTTON, 0, 0, w, h, "");
    fl_set_object_callback(ob, change_xystyle, 0);

    ob = fl_add_button(FL_NORMAL_BUTTON, w - 70 - 10, 10, 70, 30, "\010Hide");
    fl_set_button_shortcut(ob, "iHhd", 0);
    fl_set_object_callback(ob, close_down, 0);
    fl_set_object_gravity(ob, SouthEastGravity, SouthEastGravity);
    ob = fl_add_button(FL_NORMAL_BUTTON, w - 70 - 10, 40, 70, 30, "\010Free");
    fl_set_object_gravity(ob, SouthEastGravity, SouthEastGravity);
    fl_set_button_shortcut(ob, "Ffr", 0);
    fl_set_object_callback(ob, close_down, 1);

    ob = fl_add_pixmapbutton(FL_NORMAL_BUTTON, w - 90, 80, 80, 80, "");
    fl_set_pixmapbutton_file(ob, "porsche.xpm");
    ob = fl_add_pixmapbutton(FL_NORMAL_BUTTON, w - 80, 170, 40, 40, "");
    fl_set_pixmapbutton_file(ob, "crab.xpm");
    ob = fl_add_pixmapbutton(FL_NORMAL_BUTTON, w - 80, 220, 40, 40, "");
    fl_set_pixmapbutton_file(ob, "eye.xpm");
    ob = fl_add_pixmapbutton(FL_NORMAL_BUTTON, w - 80, 270, 40, 40, "");
    fl_set_pixmapbutton_file(ob, "xconq.xpm");

    x = 25;
    dx = h / 2 - 10;
    y = 10;
    xyplot = ob = fl_add_xyplot(FL_NORMAL_XYPLOT, x, y, dx, dx, "");
    fl_set_xyplot_data(ob, fx, fy, 20, "T\010itle of XYPLOT", "X-axis", "Y-axis");
    fl_add_xyplot_text(ob, 10, 10, "InsetText", FL_ALIGN_RIGHT, FL_BLUE);
    fl_set_xyplot_data(ob, fx, fy, 20, "T\010itle of XYPLOT", "X-axis", "Y-axis");
    fl_set_xyplot_data(ob, fx, fy, 20, "T\010itle of XYPLOT", "X-axis", "Y-axis");
    fl_set_xyplot_xscale(ob, FL_LINEAR, 10);

    y += dx + 5;
    ob = fl_add_xyplot(FL_ACTIVE_XYPLOT, x, y, dx, dx, "");
    fl_set_xyplot_data(ob, fx, fy, 20, "Title of XYPLOT", "X-axis", "Y-axis");
    fl_add_xyplot_text(ob, 1, 18, "InsetText", FL_ALIGN_LEFT, FL_BLUE);
    fl_set_xyplot_interpolate(ob, 0, 2, 0.5);
    fl_set_object_callback(ob, actxy_cb, 0);
    fl_end_form();
    fl_scale_form(fm, 0.9, 0.9);
    fl_show_form(fm, FL_PLACE_ASPECT, 1, "XYPLOT");
#endif

    tforms[nform++] = fm = fl_bgn_form(FL_NO_BOX, 150, 35);
    mousepos = fl_add_text(FL_NORMAL_TEXT, 0, 0, 150, 35, "");
    fl_set_object_boxtype(mousepos, FL_UP_BOX);
    fl_set_form_position(fm, -fm->w - 5, 5);
    fl_end_form();
    fl_show_form(fm, FL_PLACE_GEOMETRY, FL_TRANSIENT, 0);
    fl_set_idle_callback(idle_cb, 0);

    /* also open application window */

    fl_winposition(100, 200);
    fl_initial_winsize(300, 300);
    fl_win_background(0, fl_get_flcolor(FL_BLACK));

    {
	XColor xc;
	XParseColor(fl_display, fl_colormap(fl_vmode), "red", &xc);
	M_warn(0, "RedColor: %d %d %d\n", xc.red, xc.green, xc.blue);
    }

    aw = fl_winopen("TestWin");

    fl_add_event_callback(aw, Expose, expose_handler, 0);
    XSelectInput(fl_display, aw, ExposureMask);
#if 0
    fl_add_event_callback(aw, MotionNotify, motion_handler, 0);
#endif

    draw_red_square(aw, 300, 300);

#endif /* } */

    while (1)
    {
	if ((obj = fl_do_forms()) == FL_EVENT)
	{
	    XEvent xev;
	    fl_XNextEvent(&xev);
	    main_ev_cb(&xev);
	    fl_add_event_callback(aw, Expose, expose_handler, 0);
	}
    }
    return 0;
}
