/*
 *
 * This file is part of the XForms library.
 *
 * XForms is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1, or
 * (at your option) any later version.
 *
 * XForms is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with XForms; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 */


/*
 * $Id: popup.h,v 0.88 1998/08/25 04:35:44 zhao Beta $
 *
 *  Prototypes for pop-up menus
 */

#ifndef FL_POPUP_H
#define FL_POPUP_H		/* { */


#define FL_MAXPUPI     128	/* max item each pup        */
#define FL_PUP_PADH    4	/* space between each items */

typedef void (*FL_PUP_ENTERCB) (int, void *);	/* call back prototype  */
typedef void (*FL_PUP_LEAVECB) (int, void *);	/* call back prototype  */

FL_EXPORT int fl_setpup_entries(int, FL_PUP_ENTRY *);
FL_EXPORT int fl_newpup(Window);
FL_EXPORT int fl_defpup(Window, const char *,...);
FL_EXPORT int fl_addtopup(int, const char *,...);
FL_EXPORT int fl_setpup_mode(int, int, unsigned);
FL_EXPORT void fl_freepup(int);
FL_EXPORT int fl_dopup(int);

FL_EXPORT Cursor fl_setpup_default_cursor(int);

/* setpup_{colors|fontsize} etc will be removed in next revision
 * use fl_set_default_xxx instead
 */
FL_EXPORT void fl_setpup_color(FL_COLOR, FL_COLOR);
FL_EXPORT void fl_setpup_checkcolor(FL_COLOR);
FL_EXPORT int fl_setpup_fontsize(int);
FL_EXPORT int fl_setpup_fontstyle(int);

#define fl_setpup_default_fontsize    fl_setpup_fontsize
#define fl_setpup_default_fontstyle   fl_setpup_fontstyle
#define fl_setpup_default_color       fl_setpup_color
#define fl_setpup_default_checkcolor  fl_setpup_checkcolor

FL_EXPORT int fl_setpup_default_bw(int);
FL_EXPORT void fl_setpup_shortcut(int, int, const char *);
FL_EXPORT void fl_setpup_position(int, int);
FL_EXPORT void fl_setpup_selection(int, int);
FL_EXPORT void fl_setpup_shadow(int, int);
FL_EXPORT void fl_setpup_softedge(int, int);
FL_EXPORT void fl_setpup_bw(int, int);
FL_EXPORT void fl_setpup_title(int, const char *);
FL_EXPORT FL_PUP_ENTERCB fl_setpup_entercb(int, FL_PUP_ENTERCB, void *);
FL_EXPORT FL_PUP_LEAVECB fl_setpup_leavecb(int, FL_PUP_LEAVECB, void *);
FL_EXPORT void fl_setpup_pad(int, int, int);
FL_EXPORT Cursor fl_setpup_cursor(int, int);
FL_EXPORT int fl_setpup_maxpup(int);
FL_EXPORT unsigned fl_getpup_mode(int, int);
FL_EXPORT const char *fl_getpup_text(int, int);
FL_EXPORT void fl_showpup(int);
FL_EXPORT void fl_hidepup(int);
FL_EXPORT int fl_getpup_items(int);
FL_EXPORT int fl_current_pup(void);

#define fl_setpup_hotkey    fl_setpup_shortcut

FL_EXPORT FL_PUP_CB fl_setpup_itemcb(int, int, FL_PUP_CB);
FL_EXPORT FL_PUP_CB fl_setpup_menucb(int, FL_PUP_CB);
FL_EXPORT void fl_setpup_submenu(int, int, int);

#define fl_setpup    fl_setpup_mode

#endif /* Xpopup } */
