/*
 *
 * This file is part of the XForms library.
 *
 * XForms is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1, or
 * (at your option) any later version.
 *
 * XForms is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with XForms; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 */


/*
 * $Id: counter.h,v 0.89 1999/07/17 03:17:52 zhao Beta $
 *
 */

#ifndef FL_COUNTER_H
#define FL_COUNTER_H

typedef enum
{
    FL_NORMAL_COUNTER,
    FL_SIMPLE_COUNTER
}
FL_COUNTER_TYPE;

/***** Defaults *****/

#define FL_COUNTER_BOXTYPE	FL_UP_BOX
#define FL_COUNTER_COL1		FL_COL1
#define FL_COUNTER_COL2		FL_BLUE		/* ct label     */
#define FL_COUNTER_LCOL		FL_LCOL		/* ct reporting */
#define FL_COUNTER_ALIGN	FL_ALIGN_BOTTOM

/***** Others   *****/

#define FL_COUNTER_BW		(FL_BOUND_WIDTH-1)

/***** Routines *****/
FL_EXPORT FL_OBJECT *fl_create_counter(int, FL_Coord, FL_Coord, FL_Coord,
				       FL_Coord, const char *);

FL_EXPORT FL_OBJECT *fl_add_counter(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
				    const char *);

FL_EXPORT void fl_set_counter_value(FL_OBJECT *, double);
FL_EXPORT void fl_set_counter_bounds(FL_OBJECT *, double, double);
FL_EXPORT void fl_set_counter_step(FL_OBJECT *, double, double);
FL_EXPORT void fl_set_counter_precision(FL_OBJECT *, int);
FL_EXPORT void fl_set_counter_return(FL_OBJECT *, int);
FL_EXPORT double fl_get_counter_value(FL_OBJECT *);
FL_EXPORT void fl_get_counter_bounds(FL_OBJECT *, double *, double *);
FL_EXPORT void fl_get_counter_step(FL_OBJECT *, float *, float *);
FL_EXPORT void fl_set_counter_filter(FL_OBJECT *,
				 const char *(*)(FL_OBJECT *, double, int));

#endif
