/*
 *
 * This file is part of the XForms library.
 *
 * XForms is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1, or
 * (at your option) any later version.
 *
 * XForms is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with XForms; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 */


/*
 * $Id: chart.h,v 0.89 1999/07/17 03:17:52 zhao Beta $
 *
 * Object Class: Chart
 *
 */
#ifndef FL_CHART_H
#define FL_CHART_H

typedef enum
{
    FL_BAR_CHART,
    FL_HORBAR_CHART,
    FL_LINE_CHART,
    FL_FILL_CHART,
    FL_SPIKE_CHART,
    FL_PIE_CHART,
    FL_SPECIALPIE_CHART
}
FL_CHART_TYPE;

#define FL_FILLED_CHART  FL_FILL_CHART	/* compatibility */

/***** Defaults *****/

#define FL_CHART_BOXTYPE	FL_BORDER_BOX
#define FL_CHART_COL1		FL_COL1
#define FL_CHART_LCOL		FL_LCOL
#define FL_CHART_ALIGN		FL_ALIGN_BOTTOM

/***** Others   *****/

#define FL_CHART_MAX		512

/***** Routines *****/

FL_EXPORT FL_OBJECT *fl_create_chart(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
				     const char *);
FL_EXPORT FL_OBJECT *fl_add_chart(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
				  const char *);

FL_EXPORT void fl_clear_chart(FL_OBJECT *);
FL_EXPORT void fl_add_chart_value(FL_OBJECT *, double, const char *, int);
FL_EXPORT void fl_insert_chart_value(FL_OBJECT *, int, double, const char *, int);
FL_EXPORT void fl_replace_chart_value(FL_OBJECT *, int, double, const char *, int);
FL_EXPORT void fl_set_chart_bounds(FL_OBJECT *, double, double);
FL_EXPORT void fl_get_chart_bounds(FL_OBJECT *, double *, double *);
FL_EXPORT void fl_set_chart_maxnumb(FL_OBJECT *, int);
FL_EXPORT void fl_set_chart_autosize(FL_OBJECT *, int);
FL_EXPORT void fl_set_chart_lstyle(FL_OBJECT *, int);
FL_EXPORT void fl_set_chart_lsize(FL_OBJECT *, int);
FL_EXPORT void fl_set_chart_lcolor(FL_OBJECT *, FL_COLOR);
#define fl_set_chart_lcol   fl_set_chart_lcolor

#endif
