/*
 *
 * This file is part of the XForms library.
 *
 * XForms is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1, or
 * (at your option) any later version.
 *
 * XForms is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with XForms; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 */


/*
 * $Id: browser.h,v 0.89 1999/07/17 03:17:52 zhao Beta $
 *
 *  Object class Browser
 */
#ifndef FL_BROWSER_H
#define FL_BROWSER_H


/***** Types    *****/
typedef enum
{
    FL_NORMAL_BROWSER,
    FL_SELECT_BROWSER,
    FL_HOLD_BROWSER,
    FL_MULTI_BROWSER
}
FL_BROWSER_TYPE;

/***** Defaults *****/

#define FL_BROWSER_BOXTYPE	FL_DOWN_BOX
#define FL_BROWSER_COL1		FL_COL1
#define FL_BROWSER_COL2		FL_YELLOW
#define FL_BROWSER_LCOL		FL_LCOL
#define FL_BROWSER_ALIGN	FL_ALIGN_BOTTOM

/***** Others   *****/

#define FL_BROWSER_SLCOL	FL_COL1
#define FL_BROWSER_LINELENGTH	2048
#define FL_BROWSER_FONTSIZE     FL_SMALL_FONT

/***** Routines *****/

FL_EXPORT FL_OBJECT *fl_create_browser(int, FL_Coord, FL_Coord, FL_Coord,
				       FL_Coord, const char *);
FL_EXPORT FL_OBJECT *fl_add_browser(int, FL_Coord, FL_Coord, FL_Coord,
				    FL_Coord, const char *);
FL_EXPORT void fl_clear_browser(FL_OBJECT *);
FL_EXPORT void fl_add_browser_line(FL_OBJECT *, const char *);
FL_EXPORT void fl_addto_browser(FL_OBJECT *, const char *);
FL_EXPORT void fl_addto_browser_chars(FL_OBJECT *, const char *);
#define fl_append_browser  fl_addto_browser_chars
FL_EXPORT void fl_insert_browser_line(FL_OBJECT *, int, const char *);
FL_EXPORT void fl_delete_browser_line(FL_OBJECT *, int);
FL_EXPORT void fl_replace_browser_line(FL_OBJECT *, int, const char *);
FL_EXPORT const char *fl_get_browser_line(FL_OBJECT *, int);
FL_EXPORT int fl_load_browser(FL_OBJECT *, const char *);

FL_EXPORT void fl_select_browser_line(FL_OBJECT *, int);
FL_EXPORT void fl_deselect_browser_line(FL_OBJECT *, int);
FL_EXPORT void fl_deselect_browser(FL_OBJECT *);
FL_EXPORT int fl_isselected_browser_line(FL_OBJECT *, int);

FL_EXPORT int fl_get_browser_topline(FL_OBJECT *);
FL_EXPORT int fl_get_browser(FL_OBJECT *);
FL_EXPORT int fl_get_browser_maxline(FL_OBJECT *);
FL_EXPORT int fl_get_browser_screenlines(FL_OBJECT *);

FL_EXPORT void fl_set_browser_topline(FL_OBJECT *, int);
FL_EXPORT void fl_set_browser_fontsize(FL_OBJECT *, int);
FL_EXPORT void fl_set_browser_fontstyle(FL_OBJECT *, int);
FL_EXPORT void fl_set_browser_specialkey(FL_OBJECT *, int);
FL_EXPORT void fl_set_browser_vscrollbar(FL_OBJECT *, int);
FL_EXPORT void fl_set_browser_hscrollbar(FL_OBJECT *, int);
FL_EXPORT void fl_set_browser_line_selectable(FL_OBJECT *, int, int);
FL_EXPORT void fl_get_browser_dimension(FL_OBJECT *, FL_Coord *, FL_Coord *,
					FL_Coord *, FL_Coord *);
FL_EXPORT void fl_set_browser_dblclick_callback(FL_OBJECT *,
						FL_CALLBACKPTR, long);

FL_EXPORT void fl_set_browser_xoffset(FL_OBJECT *, FL_Coord);
FL_EXPORT FL_Coord fl_get_browser_xoffset(FL_OBJECT *);
FL_EXPORT void fl_set_browser_scrollbarsize(FL_OBJECT *, int, int);
FL_EXPORT void fl_show_browser_line(FL_OBJECT *, int);
FL_EXPORT int fl_set_default_browser_maxlinelength(int);

#ifndef FL_BROWSER_SCROLL_CALLBACKt
#define FL_BROWSER_SCROLL_CALLBACKt
typedef void (*FL_BROWSER_SCROLL_CALLBACK)(FL_OBJECT *ob, int, void *);
#endif

FL_EXPORT void fl_set_browser_hscroll_callback(FL_OBJECT *, 
                                     FL_BROWSER_SCROLL_CALLBACK,
                                     void *);
FL_EXPORT void fl_set_browser_vscroll_callback(FL_OBJECT *, 
                                     FL_BROWSER_SCROLL_CALLBACK,
                                     void *);

FL_EXPORT FL_BROWSER_SCROLL_CALLBACK fl_get_browser_hscroll_callback(
                                         FL_OBJECT *);
FL_EXPORT FL_BROWSER_SCROLL_CALLBACK fl_get_browser_vscroll_callback(
                                         FL_OBJECT *);
#endif
