dnl Checks for the --with-ldap option on ./configure

AC_DEFUN([LDAP], [
AC_MSG_CHECKING(whether to include ldap support)
AC_ARG_WITH(ldap, [  --with-ldap         Compile with ldap support], [
	AC_MSG_RESULT(yes)

	dnl Check for OpenLDAP include file for ldap address lookup
	AC_CHECK_HEADER(ldap.h,[
	        AC_DEFINE(HAVE_LDAP)
	        LDAP_LIBS="-lldap -llber"
	        AC_CHECK_LIB(resolv, res_query, LDAP_LIBS="$LDAP_LIBS -lresolv")
	])]
,
	AC_MSG_RESULT(no)
)
AC_SUBST(LDAP_LIBS)
])
