%define name xfmail
%define xfversion 1.5.1
%define release 2rhfull

Summary: A full-featured mail program using XForms
Name: %{name}
Version: %{xfversion}
Release: %{release}
Group: X11/Applications
Copyright: GPL
Vendor: Archimedes Team <xfmail@xfmail.org>
Url: http://www.xfmail.org
Packager: Duncan <duncan_haldane@users.sourceforge.net>
Source: %{name}-%{xfversion}.tar.bz2
Buildroot: /var/tmp/%{name}-%{version}-%{release}-root
Requires: xforms >= 0.88 xforms < 0.89  glib >= 1.2 gdbm
BuildPrereq: openldap-devel 
Requires: openldap 
BuildPrereq: esound-devel audiofile-devel
Requires: esound audiofile 
BuildPrereq: libmcrypt-devel >= 2.4
Requires: libmcrypt >= 2.4 
#Requires: redhat-release 

%description
XFMail is an X11 email client, using the XForms toolkit 
created by T.C. Zhao and Mark Overmars. It supports both
MH-style and mbox mailboxes.  XFMail can read most MH
folders and messages without any additional mh tools,
and provides most email functionality in a single package.
XFMail is now licensed under the GPL (with some LGPL components),
and with an exception allowing use of the XForms libraries.

This package includes support for sound, LDAP, and global password
encryption.

***This package requires libmcrypt-2.4.x or greater  *****
(Used to securely store encrypted e-mail account passwords;
see: http://mcrypt.hellug.gr.) (An XFMail-1.5.1  package not 
requiring libmcrypt is also available.)

%changelog
* Sat Oct 6 2001 Duncan <duncan_haldane@users.sourceforge.net>
- fixed CXXFLAGS to use $RPM_OPT_FLAGS (avoids the default -g option)
- put libraries in /usr/lib/xfmail

* Tue Oct 2 2001 Duncan <duncan_haldane@users.sourceforge.net>
- updated for 1.5.1 release

* Sun Jun 3 2001 Duncan <duncan_haldane@users.sourceforge.net>
- updated for 1.5.0 release

* Sun Apr 15 2001 Duncan <duncan_haldane@users.sourceforge.net>
- updated for 1.4.8 prelease

* Sun Feb 11 2001 Duncan <duncan_haldane@users.sourceforge.net>
- added the official xfmail-1.4.7-2.diff patch; (fixes gpg
- signature verification, config file growth problem, and provides
- libmcrypt-2.4.x support)
- add doc: mail-ssl.txt (omitted in first build).

* Sun Feb 4 2001 Duncan <duncan_haldane@users.sourceforge.net>
- adjustments to spec file for Red Hat 
- dont include ChangeLog in docs (too long, has info
- on devel branch, not relevant to this release, etc.)

%prep

%setup -n xfmail-%{xfversion}

%build
CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" ./autogen.sh  --with-faces  \
                      --with-sound --with-esd-sound  \
                      --with-ldap \
                      --enable-gpasswd \
                      --prefix=/usr --libdir=/usr/lib/xfmail
make

%install
make prefix=$RPM_BUILD_ROOT/usr libdir=$RPM_BUILD_ROOT/usr/lib/xfmail install-strip 
cd docs
rm -rf rfc
cd $RPM_BUILD_ROOT/usr/man/man1
gzip  xfmail.1

%clean
rm -r $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc README KNOWNBUGS TODO Copyright COPYING docs
%attr(755,root,root) /usr/bin/xfmail
%attr(644,root,root) /usr/man/man1/xfmail.1*
%attr(644,root,root) /usr/share/xfmail
/usr/lib/xfmail

