/* $Id: xfmail.h,v 1.7 2000/05/04 09:42:39 cfreeze Exp $ */

#ifndef _XFMAIL_H_
#define _XFMAIL_H_

#include <config.h>

#include <fmail.h>
#include <umail.h>
#include <cfgfile.h>

#ifdef USE_GPASSWD
#include <gpasswd.h>
gPasswd Passwd;
#endif

#include <X11/xpm.h>
#ifdef  HAVE_SETLOCALE
    #include <X11/Xlocale.h>
#endif
#include <choose_folder.h>
#include "configform.h"
#define MAIN_XPM
#define ATT_XPM
#include "pixmaps.h"

#ifdef HAVE_WMAKER
    #include <WMaker.h>
#endif


cfgfile Config;

FL_FORM *main_form = NULL;
FL_OBJECT *b_folders = NULL,
*b_messages = NULL,
*msgpane = NULL, *f_button = NULL, *m_button = NULL;

FL_OBJECT *inc_timer = NULL,
*send_timer = NULL,
*trash_timer = NULL,
*imap_timer = NULL,
*ttip_timer = NULL, *pgp_timer = NULL, *preview_timer = NULL, *abrt;

static FL_OBJECT *menu_file = NULL,
*menu_message = NULL,
*menu_folders = NULL,
*menu_send = NULL, *menu_imap = NULL, *status = NULL;

FL_OBJECT *menu_misc = NULL;

#define MESG_MENU     "View (Alt+V)|Edit (Alt+E)|Delete/Undelete (Alt+D)|Move to Folder (Alt+M)|Copy to Folder|Mark|Unmark|Mark Read/Unread|Print (Alt+P)|Apply Rules|Select All|Select Marked|Delete from POP|Refresh|Options|Pipe|Download"
#define SEND_MENU     "New (Alt+C)%l|Reply to Sender|Reply to All (Alt+R)|Forward (Alt+F)|Bounce%l|Send All"
#define FOLD_MENU     "Create|Create Subfolder|Delete|Rename|Open|Open Unread|Empty Trash Folder|Catch Up Unread|Search|Rescan All|Options|Expand/Collapse|Expunge"
#define ctrl(a) (a-'A'+1)

/* RESOURCES */

struct _xfdef xfdefs;

static char xfgeom[64] = "", xfmsg[127] = "", xfsubj[127] = "";
static int xficonic = 0, xfcompose = 0, xfwithhdr = 0;

char conf_name[255];
char sender_name[127];
char homedir[255];
char maildir[255];
char configdir[255] = "";
char configfile[255] = "";
char tmpdir[255];

static FL_CMD_OPT xfmail_cmdopt[] = {
    {"-geometry", "*geometry", XrmoptionSepArg, 0},
    {"-iconic", ".iconic", XrmoptionNoArg, "1"},
    {"-compose", ".compose", XrmoptionNoArg, "1"},
    {"-withhdr", ".withhdr", XrmoptionNoArg, "1"},
    {"-message", ".message", XrmoptionSepArg, 0},
    {"-subject", ".subject", XrmoptionSepArg, 0},
    {"-s", ".subject", XrmoptionSepArg, 0},
    {"-cfgdir", ".cfgdir", XrmoptionSepArg, 0},
    {"-cfgfile", ".cfgfile", XrmoptionSepArg, 0},
    {"-readonly", ".readonly", XrmoptionNoArg, "1"},
    {"-help", ".help", XrmoptionNoArg, "1"}
};

#define Ncopt (sizeof(xfmail_cmdopt)/sizeof(xfmail_cmdopt[0]))

static FL_resource xfres[] = {
    {"XFMail.geometry", "Geometry", FL_STRING, xfgeom, 0, 64},
    {"iconic", "Iconic", FL_BOOL, &xficonic, "0"},
    {"compose", "Compose", FL_BOOL, &xfcompose, "0"},
    {"withhdr", "Withhdr", FL_BOOL, &xfwithhdr, "0"},
    {"message", "Message", FL_STRING, xfmsg, 0, 127},
    {"subject", "Subject", FL_STRING, xfsubj, 0, 127},
    {"cfgdir", "Cfgdir", FL_STRING, configdir, 0, 255},
    {"cfgfile", "Cfgfile", FL_STRING, configfile, 0, 255},
    {"readonly", "Readonly", FL_BOOL, &readonly, "0"}
};

#define Nropt  (sizeof(xfres)/sizeof(xfres[0]))

int mpup, spup, fpup;

char user_n[32];


struct _mail_folder *current_folder = NULL;
struct _mail_folder *chfld = NULL;
static struct _mail_msg *current_message = NULL;

static int startup = 0;
#define STARTUP_NORMAL  0x00
#define STARTUP_COMPOSE 0x01

static int current_index = 0;
static int init = 0, nomainwindow = 0, initdone;
static int abortbutton = 0;
static int fbrowsersize = 180;
static int msgpanesize = 0;
int logging = LOG_SMTP | LOG_NNTP | LOG_NET | LOG_ERRORS;
u_int busy = 0;
u_int supress_errors = 0;
u_int supress_questions = 0;
int xofft = 0, yofft = 0;
int readonly = 0;

Pixmap iconPix_noMail, iconPix, icon_MailEdit, icon_ABook;
Pixmap iconPix_noMail_sh, iconPix_sh, icon_MailEdit_sh, icon_ABook_sh;
static int mailcur;

int show_msg[6] = { 2, 13, 5, 18, 100, 0};
int show_fld[3] = { 11, 3, 3};
int color_msg[5] = { 4, 1, 8, 0, 11};
int color_fld[9] = { 22, 5, 5, 5, 1, 10, 4, 0, 10};

FD_Help_Form *info_obj = NULL;

char *helps[] = {
    "<addrs>...                Add addresses to the recipient list",
    "-help                     this message",
    "-display host:dpy         display name",
    "-geometry geom            initial geometry",
    "-private                  private colormap",
    "-shared                   shared colormap",
    "-standard                 standard colormap",
    "-double                   double buffering",
    "-bw width                 controls border width (-3 ... 3)",
    "-iconic                   start iconic",
    "-readonly                 don't modify configuration files",
    "-cfgfile file             configuration file name",
    "-cfgdir dir               where all configuration files are",
    "-compose                  display compose window only",
    "-message file             take composed message from file (- stdin)",
    "-withhdr                  message in specified file includes header",
    "-subject subject          specify subject of composed message",
    "-s subject                same as -subject",
    0,
};


void cb_menu_messages(FL_OBJECT * obj, long arg);
void cb_messages(FL_OBJECT * obj, long arg);
void cb_menu_folders(FL_OBJECT * obj, long arg);
void cb_menu_send(FL_OBJECT * obj, long arg);
void cb_folders_dbl(FL_OBJECT * obj, long arg);

void crash_handle(int s);
void empty_trash_folders();
void expire_folders();
void template_msg(struct _mail_msg *msg);
void set_current_message(struct _mail_msg *msg, int draw);
void set_current_folder(struct _mail_folder *folder);
int msg_preview(struct _mail_msg *msg);

extern void init_coders();
extern void deinit_coders();

#endif
