/* $Id: rep_fwd.c,v 1.4 1999/12/13 08:46:56 xfmail Exp $ */

#include <config.h>
#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>
#include <cfgfile.h>
#include "configform.h"

extern cfgfile Config;

static FD_config_reply *reply_obj;

void Reply_Call(FL_OBJECT * obj, long param) {
}

void reply_conf(int set_default, FD_config_reply * form) {
    reply_obj = form;

    fl_clear_choice(reply_obj->Reply_INType);
    fl_addto_choice(reply_obj->Reply_INType, "no auto include");
    fl_addto_choice(reply_obj->Reply_INType, "indented");
    fl_addto_choice(reply_obj->Reply_INType, "not indented");
    fl_set_choice(reply_obj->Reply_INType,
                  Config.getIntDefault("include", 2, set_default));
    fl_clear_choice(reply_obj->Reply_MIME);
    fl_addto_choice(reply_obj->Reply_MIME, "never");
    fl_addto_choice(reply_obj->Reply_MIME, "always");
    fl_addto_choice(reply_obj->Reply_MIME, "ask");
    fl_set_choice(reply_obj->Reply_MIME,
                  Config.getIntDefault("inclmime", 3, set_default));
    fl_clear_choice(reply_obj->Reply_All);
    fl_addto_choice(reply_obj->Reply_All, "never");
    fl_addto_choice(reply_obj->Reply_All, "always");
    fl_addto_choice(reply_obj->Reply_All, "ask");
    fl_set_choice(reply_obj->Reply_All,
                  Config.getIntDefault("inclrecp", 3, set_default));
    fl_set_input(reply_obj->Reply_Prefix,
                 Config.getCStringDefault("prefix", ">", set_default));
    fl_set_input(reply_obj->Reply_Str,
                 Config.getCStringDefault("replystr", "On %d %f wrote:%n",
                                         set_default));
    fl_set_input(reply_obj->Reply_And,
                 Config.getCStringDefault("replyexand", "", set_default));
    fl_set_button(reply_obj->Reply_Exclude,
                  Config.getIntDefault("replyex", 1, set_default));
    fl_set_input(reply_obj->Forward_Str,
                 Config.getCStringDefault("fwdstr", "-----FW: %i-----%n%n",
                                         set_default));
    fl_set_button(reply_obj->Reply_Charset,
                  Config.getIntDefault("replykeepchset", 0, set_default));
    fl_set_button(reply_obj->Reply_Keep,
                  Config.getIntDefault("replykeep", 0, set_default));
    fl_set_button(reply_obj->Reply_Save,
                  Config.getIntDefault("replysave", 0, set_default));
    fl_clear_choice(reply_obj->Forward_INType);
    fl_addto_choice(reply_obj->Forward_INType, "do not include");
    fl_addto_choice(reply_obj->Forward_INType, "short");
    fl_addto_choice(reply_obj->Forward_INType, "full");
    fl_addto_choice(reply_obj->Forward_INType, "MIME");
    fl_set_choice(reply_obj->Forward_INType,
                  Config.getIntDefault("fwdinclude", 2, set_default));
}
void handle_reply_input(FD_config_reply * form) {
    reply_obj = form;
    Config.set("prefix", (char *) fl_get_input(reply_obj->Reply_Prefix));
    Config.set("replystr", (char *) fl_get_input(reply_obj->Reply_Str));
    Config.set("fwdstr", (char *) fl_get_input(reply_obj->Forward_Str));
    Config.set("include", fl_get_choice(reply_obj->Reply_INType));
    Config.set("inclmime", fl_get_choice(reply_obj->Reply_MIME));
    Config.set("inclrecp", fl_get_choice(reply_obj->Reply_All));
    Config.set("fwdinclude", fl_get_choice(reply_obj->Forward_INType));
    Config.set("replyex", fl_get_button(reply_obj->Reply_Exclude));
    Config.set("replyexand", (char *) fl_get_input(reply_obj->Reply_And));
    Config.set("replykeepchset", fl_get_button(reply_obj->Reply_Charset));
    Config.set("replykeep", fl_get_button(reply_obj->Reply_Keep));
    Config.set("replysave", fl_get_button(reply_obj->Reply_Save));
}
