//#define TEST

#include <config.h>

#ifdef USE_GPASSWD

#include "gpasswd.h"

gPasswd::gPasswd() {
	keysize = 16;
}

void gPasswd::init(string pkey) {

	key = new char[pkey.size()+1];

	setKey(pkey);

	td = mcrypt_module_open("twofish",NULL,"cfb",NULL);
	if(td<0) {
		mcrypt_perror(td);
		return;
	}

	IV = new char[mcrypt_get_iv_size(td)];

	for(i=0;i<mcrypt_get_iv_size(td);i++) {
		IV[i]=rand();
	}

	i = mcrypt_generic_init(td,key,keysize,IV);

	if(i<0) {
		mcrypt_perror(i);
		return;
	}
}

void gPasswd::setKey(string pKey) {
	//cerr << "Setting Master Key: " << pKey << endl;
	strcpy(key,pKey.c_str());
	memmove(key,password,strlen(password));
	return;
}

string gPasswd::encrypt(string password) {
	char * s_un = new char[password.size()+1];
	string s_en;

	strcpy(s_un,password.c_str());
	//cerr << "encrypt: s_un = " << s_un << endl;

	mcrypt_generic(td,s_un,strlen(s_un));

	s_en = string(s_un);
	//cerr << "encrypt: s_en = " << s_en << endl;
	delete [] s_un;

	return s_en;
}

string gPasswd::decrypt(string password) {
	char * s_en = new char[password.size()+1];
	string s_un;

	strcpy(s_en,password.c_str());
	//cerr << "decrypt(" << s_en << ")" << endl;

	mdecrypt_generic(td,s_en,strlen(s_en));
	s_un = string(s_en);
	delete [] s_en;

	return s_un;
}

gPasswd::~gPasswd() {
	mcrypt_generic_end(td);
	delete []IV;
	delete []key;
}


#endif

#ifdef TEST
#include <iostream.h>
#include <fstream.h>

int main(int argc, char * argv[]) {

	ifstream ifs;
	ofstream ofs;
	string s_en, s_un, key, pass;
	gPasswd Passwd;
	char p[32];

	cout << "enter key" << endl;
	cin >> key;

	Passwd.init(key);

	cout << "enter pass" << endl;
	cin >> pass;

	s_en = Passwd.encrypt(pass);
	cout << "encrypted: \"" << s_en << "\"" <<  endl;

	s_un = Passwd.decrypt(s_en);
	cout << "decrypted: \"" << s_un << "\"" <<  endl;

	cout << "Testing File I/O\n";

	ofs.open("test", ios::bin);
	ofs << s_en << endl;
	ofs.close();

	ifs.open("test", ios::bin);
	ifs >> s_en;
	ifs.close();

	cout << "encrypted: \"" << s_en << "\"" <<  endl;
	s_un = Passwd.decrypt(s_en);
	cout << "decrypted: \"" << s_un << "\"" <<  endl;

	return 0;
}
#endif
