#ifndef _CFGFILE_H_
#define _CFGFILE_H_

#include <config.h>
#include <fmail.h>
#include <umail.h>

#define SECFILEMODE 00600       /* secure mode on file */
#define HASHMINSIZE  128     /* don't make hash less then this */

#define GLOBAL_XFMAILRC "/etc/xfmailrc" /* global configuration file */
#define GLOBAL_XFDEFS   "/etc/xfdefaults"   /* global xfdefaults file */

typedef struct __tagcfl {
    char    str[SLEN];
    struct __tagcfl *next;
    u_int   flags;
} __cfl;

class cfgfile {

public:

    cfgfile();

    int save(int ask);
    int load(char * fn);
    int save_file(char * file, int nopwd);
    int check_version();
    void setFlags(char * ln,int flags);
    char * getString(char * fn,char * ln,char * def);
    int getInt(char * fn,char * ln,int def);
    int getIntDefault(char *fn, char *ln, int def, int return_default);
    char * getStringDefault(char *fn, char *ln, char *def, int return_default);
    int delString(char * fn, char * ln);
    int putInt(char * fn,char * ln,int i);
    int putString(char * fn,char * ln,char * b);
    int exist(char * ln);
    void read_xfdefaults();


private:

    unsigned int hash(char * cfgstr);
    void add(struct __tagcfl * tag);
    struct __tagcfl * find(char * cfgstr);
    int del(char * cfgstr);
    void clear();
    void destroy();
    void lock(char * fn);
    void unlock();

    FILE *cfile;
    char fname[PLEN];
    int changed;
    struct __tagcfl **hasht;
	int hashtsize;

};

#endif
