/*
 * Copyright(c) 1995-1998 by Gennady B. Sorokopud (gena@NetVision.net.il)
 *
 * This software can be freely redistributed and modified for 
 * non-commercial purposes as long as above copyright
 * message and this permission notice appear in all
 * copies of distributed source code and included as separate file
 * in binary distribution.
 *
 * Any commercial use of this software requires author's permission.
 *
 * This software is provided "as is" without expressed or implied
 * warranty of any kind.
 * Under no circumstances is the author responsible for the proper
 * functioning of this software, nor does the author assume any
 * responsibility for damages incurred with its use.
 *
 */

/* This file is based on uu[en/de]code program from
 * The Regents of the University of California.
 */

/*-
 * Copyright (c) 1983, 1993
 *      The Regents of the University of California.  All rights reserved.
 */


/* $Id: uucode.c,v 2.4 1998/03/23 15:44:26 gena Exp $
 */

#include <fmail.h>
#include <umail.h>

#define	ENC(c) ((c) ? ((c) & 077) + ' ': '`')
#define	DEC(c) (((c) - ' ') & 077)             /* single character decode */
#define IS_DEC(c) ( (((c) - ' ') >= 0) &&  (((c) - ' ') <= 077 + 1) )

int
uuencode(tfile, fin)
char *tfile;
char *fin;
{
FILE *f_in, *f_out;
struct stat sb;
int mode;

register int ch, n;
register char *p;
char buf[255], tmp[255];

 if (!fin || !tfile)
	return -1;

 if ((f_in = fopen(fin, "r")) == NULL) {
	display_msg(MSG_WARN, "uuencode", "Can not open file %s", fin);
	return -1;	}

 snprintf(tmp, sizeof(tmp), "%s_tmp", tfile);

 if (!(f_out = fopen(tmp, "w"))) {
	display_msg(MSG_WARN, "uuencode", "Can not open file %s", tmp);
        return -1;  }

 if (fstat(fileno(f_in), &sb) == -1) {
	display_msg(MSG_WARN, "uuencode", "Stat failed on %s", fin);
	return -1;	}

#define RWX     (S_IRWXU|S_IRWXG|S_IRWXO)
 mode = sb.st_mode & RWX;
 fprintf(f_out, "\nbegin %o %s\n", mode, name_path(fin));

        while ((n = fread(buf, 1, 45, f_in)) != 0) {
                ch = ENC(n);
                if (fputc(ch, f_out) == EOF)
                        break;
                for (p = buf; n > 0; n -= 3, p += 3) {
                        ch = *p >> 2;
                        ch = ENC(ch);
                        if (fputc(ch, f_out) == EOF)
                                break;
                        ch = ((*p << 4) & 060) | ((p[1] >> 4) & 017);
                        ch = ENC(ch);
                        if (fputc(ch, f_out) == EOF)
                                break;
                        ch = ((p[1] << 2) & 074) | ((p[2] >> 6) & 03);
                        ch = ENC(ch);
                        if (fputc(ch, f_out) == EOF)
                                break;
                        ch = p[2] & 077;
                        ch = ENC(ch);
                        if (fputc(ch, f_out) == EOF)
                                break;
                }
                if (fputc('\n', f_out) == EOF)
                        break;
        }
        if (ferror(stdin)) {
		display_msg(MSG_WARN, "uuencode", "Read error");
                return -1;
        }
        ch = ENC('\0');
        (void)fputc(ch, f_out);
        (void)fputc('\n', f_out);

 fprintf(f_out, "end\n");

 fclose(f_in);
 if ((f_in = fopen(tfile, "r")) == NULL) {
	display_msg(MSG_WARN, "uuencode", "Can not open open %s", tfile);
	return -1;
					}

 while(fgets(buf, 255, f_in))
	fputs(buf, f_out);

 fclose(f_in);
 fclose(f_out);

#ifdef __EMX__ /* Under OS/2 the file will not be deleted during rename() */
 if (access(tfile, 0)==0) { 
 	if (unlink(tfile)!=0) {
		display_msg(MSG_WARN, "unlink", "delete %s before moving", tfile);
	}
 }
#endif
 if (rename(tmp, tfile) == -1) {
	display_msg(MSG_WARN, "uuencode", "Can not rename %s to %s", tmp,tfile);
	unlink(tmp);
	return -1;
				}

 return 0;

}

int
uudecode(msg)
struct _mail_msg *msg;
{
struct _mime_msg *mime;
FILE *f_in, *f_out;
register int n;
register char ch, *p;
int mode, uufiles;
char buf[255];
char buf1[255];
char m_tmp_file[255];
char *fout;

 if (!msg || !msg->header)
	return -1;

 if (!msg->mime)
	mime_scan(msg);

 if (!msg->mime)
	return -1;

 if ((mime = get_text_part(msg)) == NULL) {
	display_msg(MSG_WARN, "uudecode", "no text part!");
	return -1;
					}

 strcpy(m_tmp_file, get_temp_file("uud"));
 
 if (save_part(msg, mime, m_tmp_file, 0) == -1) {
        display_msg(MSG_WARN, "uudecode", "Can not save text part!");
        unlink(m_tmp_file);
        return -1; }

 f_in = f_out = NULL;
 if ((f_in = fopen(m_tmp_file, "r")) == NULL) {
	display_msg(MSG_WARN, "uudecode", "Can not open file %s", m_tmp_file);
        return -1;  			      }

 uufiles = 0;

 /* search for header line */
nfile:
  do {
       if (!fgets(buf, sizeof(buf), f_in)) {
		fclose(f_in);
		if (f_out)
			fclose(f_out);

		if (uufiles == 0)
			display_msg(MSG_WARN, "uudecode", "No files uudecoded");
		else
			display_msg(MSG_MSG, "uudecode", "Uudecoded %d file(s)", uufiles);
        	unlink(m_tmp_file);
		return 0;		   }
     } while (strncmp(buf, "begin ", 6));

 mode = -1;
 buf1[0] = '\0';
 (void)sscanf(buf, "begin %o %255s", &mode, buf1);
 if ((mode == -1) || (buf[0] == '\0'))
	goto nfile;
 
 fl_set_fselector_title("Save uuencoded part as");
 fout = (char *)fl_show_fselector("Save as", "", "", buf1);
 if (!fout || !*fout) {
	uufiles++;
	goto nfile;   }

 if (!access(fout, F_OK) &&
	!display_msg(MSG_QUEST|MSG_DEFNO, fout, "already exists, overwrite?")) {
	uufiles++;
	goto nfile;							       }

 /* create output file, set mode */
 if ((f_out = fopen(fout, "w")) == NULL) {
	fclose(f_in);
	display_msg(MSG_WARN, "uudecode", "Can not open file %s", fout);
       	unlink(m_tmp_file);
	return -1;			 }

#ifndef __EMX__
 if (fchmod(fileno(f_out), mode&0666) == -1) 
		display_msg(MSG_WARN, "uudecode", "Can not change mode on %s to %d, ignoring", fout, mode);
#endif

 /* for each input line */
 for (;;) {
	if (!fgets(buf, sizeof(buf), f_in))	{
		display_msg(MSG_WARN, "uudecode", "Short file %s", fout);
		fclose(f_in);
		fclose(f_out);
       		unlink(m_tmp_file);
                return -1;			}

		p = buf;

                /*
                 * `n' is used to avoid writing out all the characters
                 * at the end of the file.
                 */
                if ((n = DEC(*p)) <= 0)
                        break;

		if (n/3*4 >= strlen(p))	{
			display_msg(MSG_WARN, "uudecode", "Corrupt UU file");
			fclose(f_in);
			fclose(f_out);
       			unlink(m_tmp_file);
                        return -1;	}

                for (++p; n > 0; p += 4, n -= 3)
                        if (n >= 3)			{
				if (!(IS_DEC(*p) && IS_DEC(*(p + 1)) &&
					IS_DEC(*(p + 2)) && IS_DEC(*(p + 3)))) {
				  display_msg(MSG_WARN, "uudecode", "character out of range: [%d-%d]", 1 + ' ', 077 + ' ' + 1);
				 fclose(f_in);
				 fclose(f_out);
				 unlink(m_tmp_file);
				 return -1;				       }

                                ch = DEC(p[0]) << 2 | DEC(p[1]) >> 4;
                                fputc(ch, f_out);
                                ch = DEC(p[1]) << 4 | DEC(p[2]) >> 2;
                                fputc(ch, f_out);
                                ch = DEC(p[2]) << 6 | DEC(p[3]);
                                fputc(ch, f_out);	}
                        else	{
                                if (n >= 1)			{
					if (!(IS_DEC(*p) && IS_DEC(*(p + 1)))) {
				  display_msg(MSG_WARN, "uudecode", "character out of range: [%d-%d]", 1 + ' ', 077 + ' ' + 1);
					 fclose(f_in);
					 fclose(f_out);
					 unlink(m_tmp_file);
					 return -1;			       }

                                        ch = DEC(p[0]) << 2 | DEC(p[1]) >> 4;
                                        fputc(ch, f_out);	}

                                if (n >= 2)			{
					if (!(IS_DEC(*(p + 1)) &&
						IS_DEC(*(p + 2))))	{
					 fclose(f_in);
					 fclose(f_out);
					 unlink(m_tmp_file);
					 return -1;			}

                                        ch = DEC(p[1]) << 4 | DEC(p[2]) >> 2;
                                        fputc(ch, f_out);	}

                                if (n >= 3)			{
					if (!(IS_DEC(*(p + 2)) &&
						IS_DEC(*(p + 3))))	{
					 fclose(f_in);
					 fclose(f_out);
					 unlink(m_tmp_file);
					 return -1;			}

                                        ch = DEC(p[2]) << 6 | DEC(p[3]);
                                        fputc(ch, f_out);	}
				}
        }

	fclose(f_out);
	f_out = NULL;
	uufiles++;

        if (!fgets(buf, sizeof(buf), f_in) || strcmp(buf, "end\n"))
		display_msg(MSG_WARN, "uudecode", "no \"end\" line, ignoring");

	goto nfile;

	return 0;
}

