#ifndef _TextFieldP_h
#define _TextFieldP_h

/* T. Straumann: TextFieldP.h v 1.0 96/12/24 */
/*
 *  The TextField Widget
 *  --------------------
 
 *  Copyright (C) 1997  by Till Straumann   <strauman@sun6hft.ee.tu-berlin.de>

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Library Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Library Public License for more details.

 *  You should have received a copy of the GNU General Library Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#include "TextField.h"

/* include superclass private header file */

#ifdef XAW3D
#include <X11/Xaw3d/ThreeDP.h>
#else
#include <X11/Xaw/SimpleP.h>
#endif

/* define unique representation types not found in <X11/StringDefs.h> */

typedef struct {
    int empty;
} TextFieldClassPart;

typedef struct _TextFieldClassRec {
    CoreClassPart	core_class;
    SimpleClassPart	simple_class;
#ifdef XAW3D
    ThreeDClassPart	threeD_class;
#endif
    TextFieldClassPart	textField_class;
} TextFieldClassRec;

extern TextFieldClassRec textFieldClassRec;

typedef struct {
    /* resources */
    XFontStruct*	font;
    Pixel		foreground;
    Pixel		insensitive_foreground;
    Dimension		internalHeight;
    Dimension		internalWidth;
    int			text_cursor;
    Boolean		resize;
    String		string;
    Boolean		use_string_in_place;
    XtJustify		justify;
    int			maxlen;
    Boolean		readonly;
    short		scroll_chars;
    XtCallbackList	notify_cbl,modified_cbl;
    XrmValue		value;
    String		value_type;
    String		input_format;
    String		output_format;
    Boolean		display_caret;

    /* private state */

    GC			norm, norm_hil, insens, insens_hil;
    short		visible_start,visible_end;
    unsigned long	selections;
    String		buffer;
    short		hil_start,hil_end;
    short		multiclick;
    Time		multiclick_time;
    Boolean		active_cursor;
} TextFieldPart;

typedef struct _TextFieldRec {
    CorePart		core;
    SimplePart		simple;
#ifdef XAW3D
    ThreeDPart		threeD;
#endif
    TextFieldPart	textField;
} TextFieldRec;

#endif /* _TextFieldP_h */
