#ifndef _TextField_h
#define _TextField_h

/* T. Straumann: TextField.h v 1.0 96/12/24 */
/*
 *  The TextField Widget
 *  --------------------
 
 *  Copyright (C) 1997  by Till Straumann   <strauman@sun6hft.ee.tu-berlin.de>

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Library Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Library Public License for more details.

 *  You should have received a copy of the GNU General Library Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

/****************************************************************
 *
 * TextField widget
 *
 ****************************************************************/

#ifdef  XAW3D
#include <X11/Xaw3d/Simple.h>
#else
#include <X11/Xaw/Simple.h>
#endif

/* Resources:

 Name		     	Class			RepType		Default Value		Comment
 ----		     	-----			-------		-------------		-------
 font		     	Font            	Font		XtDefaultFont
 foreground	     	Foreground		Pixel		XtDefaultForeground
 insensitiveForeground	InsensitiveForeground	Pixel		XtDefaultForeground	fg when there can't be
 											typed into the widget.

 internalHeight		Height			Dimension	2			space around the widget.
 internalWidth		Width			Dimension	2			there's additional space
											reserved for the scroll
											marks.

 insertPosition		TextPosition		Int		0			pos. of the text cursor.

 displayCaret		Output			Boolean		True			display the text cursor.

 resize			Resize			Boolean		False			widget tries to resize itself.

 string			Label			String		""
 useStringInPlace	UseStringInPlace	Boolean		False			don't use internal buffer
											but use the address passid
											in the 'string' resource.

 length			Length			Short		0			length of buffer. Must be
											set accordingly if 
											useStringInPlace is True.
											The internal buffer
											defaults to 15 chars if
											this resource is set to 0.
 justify		Justify			Justify		XtJustifyLeft

 readOnly		ReadOnly		Boolean		False			only look at the string;
											selection and scrolling
											still possible.

 scrollChars		ScrollChars		Short		4			start scrolling if the
											text cursor gets closer
											than 'scrollChars' to
											either end of the
											visible area.

 callback		Callback		Callback	NULL			called by the 'notify()'
											action.

 modifiedCallback	Callback		Callback	NULL			called upon any user
											modification of the
											string ie. successful
											- InsertChar()
											- Delete()
											- DeleteToClipboard()
											- InsertSelection()
											actions.

 valueAddress		Value			Pointer		NULL
 valueSize		Value			Int		0
 valueType		Value			String		XtRCFormat
 inputFormat		ValueFormat		String		NULL
 outputFormat		ValueFormat		String		NULL

 The last five resources provide a mechanism to connect a textField widget to a variable of
 arbitrary type, that can automatically be updated.
 The public procedures TextFieldString2Value() and TextFieldValue2String() invoke an Xt-type converter
 that converts the text string to 'valueType' at 'valueAddress' or vice versa.

 There exists the special representation type 'CFormat' that can be converted using the C-format strings
 a la sprintf()/sscanf(). If the variable is of type 'CFormat', the formatting strings to be used by the
 converter can be set via the 'inputFormat' and 'outputFormat' resources.

 As an example let's assume, there's an integer variable, which should be connected to the widget. The
 integer value should be displayed in hex-representation, but user input should be allowed in the
 usual 'val' (decimal), 0'val' (octal), 0x'val'(hex) style.
 In this case, the resources are set as shown:
	valueAddress &val
	valueSize    sizeof(int)
	valueType    CFormat
	inputFormat  %i
	outputFormat %x
 The value can now be read invoking TextFieldString2Value(wid) and written back by TextFieldValue2String().
 These convenience procedures return 'True' if the conversion was successful. This conversion can be done
 in a callback procedure thus providing automatic updating.
*/

/* Default translations:

		<Enter>:	CursorState(Active)\n\
		<Leave>:	CursorState(Inactive)\n\
	None	<Btn1Down>:	MoveCursor()\
				HighlightStart()\n\
		<Btn1Motion>:	MoveCursor()\
				HighlightExtend()\
				MakeSelection(PRIMARY)\n\
		<Btn1Up>:	MoveCursor()\
				HighlightExtend()\
				MakeSelection(PRIMARY)\n\
		<Btn2Up>  :     MoveCursor()\
				InsertSelection(PRIMARY)\n\
	Shift	<Key>Right:	MoveCursor()\
				HighlightExtend()\
				MakeSelection(PRIMARY)\n\
 	Shift	<Key>Home :	MoveCursor(Home)\
				HighlightExtend()\
				MakeSelection(PRIMARY)\n\
 	Shift	<Key>End  :	MoveCursor(End)\
				HighlightExtend()\
				MakeSelection(PRIMARY)\n\
 	Shift	<Key>Left :	MoveCursor(-1)\
				HighlightExtend()\
				MakeSelection(PRIMARY)\n\
 	Shift	<Key>Delete:	Delete(Selection,End)    \n\
 	Shift	<Key>BackSpace:	Delete(Selection,Home)  \n\
 	Alt	<Key>Delete:	Delete(Selection,All)    \n\
 	Alt	<Key>BackSpace:	Delete(Selection,All)  \n\
		<Key>Right:	MoveCursor()	\
				HighlightStart()\n\
 		<Key>Home :	MoveCursor(Home)\
				HighlightStart()\n\
 		<Key>End  :	MoveCursor(End) \
				HighlightStart()\n\
 		<Key>Left :	MoveCursor(-1)  \
				HighlightStart()\n\
 		<Key>Delete:	Delete(Selection,1)    \n\
 		<Key>BackSpace:	Delete(Selection,-1)  \n\
		<Key>SunCopy:	MakeSelection(CLIPBOARD)\n\
		<Key>SunPaste:	InsertSelection(CLIPBOARD)\n\
		<Key>SunCut:	DeleteToClipboard()\n\
		<Key>:		InsertChar()\
*/

/* Actions:
 The TextFieldWidget processes the following actions:

  (Note that only the first character of any argument is used, although more can be given for sake of
   easier reading)

 Action Name		Arguments			Comment

 MoveCursor([Home|End|<n>])	 			Move the text cursor

							If the action occured due to a Button or Motion
							event, then the cursor is moved to the pointer
							position. If the Button was pressed on one of the
							scroll marks, the cursor is moved one character.

							If any other event invoked the action the argument
							is parsed, and the cursor positioned to the left
							(Home), the right (End), or <n> chars relative to
							the actual position (<n> may be negative). No 
							argument defaults to MoveCursor(1).

 InsertChar([<string>[,True|False]])			Insert one character at the cursor position
							(KeyPress Event only). If any argument is present
							<string> is inserted instead (any event).
							The second argument indicates if the string
							should be parsed for \ escaped sequences
							(\n, \023 etc); defaults to 'True'.

 Delete([Home|End|All|<n>|Selection[,Home|End|All|<n>]])Delete from cursor pos. to left (H), to right (E)
							or relative (<n>). (A) deletes all, (S) the high
							lighted area. In this case an optional second
							argument indicates what to delete if nothing is
							highlighted. No argument defaults to Delete(1)
							
 HighlightStart()					Mark the beginning of the highlighted area.
							This is to be the pointer position (Button Event) or
							the cursor position (any other event).
							Note: No selection ownership is asserted yet.
							----
							
 HighlightExtend()					Extend the highlighted area i.e. move the beginning
							or the end of this area, whichever is closer to
							the pointer position (Button Event) or the text
							cursor (any other event). If no highlighted area
							exists the beginning is marked.
							Since Xt translations don't allow multiclicks and
							motion events to coexist, a multiclick feature is
							implemented in this action. A double click
							highlights the word (delimited by spaces) at
							the pointer position, a triple click selects the
							whole string.
							Note: No selection ownership is asserted yet.
							----

 Highlight(Word|All|End|Home)				Set the highlighted area to the whole string (A),
							to the space delimited word at the event position (W),
							or from the event position to the left (H) / right (E).
							The event position is the pointer position (Button or
							Motion event) or the text cursor position (any other
							event).
							Note: No selection ownership is asserted yet.
							----
 
 MakeSelection([Primary|Secondary|Clipboard])		Assert the ownership of the specified X-Selection.
							The selection can then be requested by other clients.
							No parameter defaults to MakeSelection(P).

 DeleteToClipboard()					Assert the ownership of the CLIPBOARD selection. Then
							wait for another client (eg. 'xclipboard') to copy the
							selected part of the string. If this is done successfully
							the selected part is deleted.

 InsertSelection([Primary|Secondary|Clipboard])		Request the specified selection value from another client,
							and insert it at the cursor position.
							No argument defaults to InsertSelection(P)

 Notify([<string>])					call the callbacks on the 'callback' resource's callback
							list. A pointer to the <string> is passed as the
							'call_data' argument to the callback procs.

 CursorState(Active|Inactive|Toggle)			Set the state of the cursor to active (A), inactive (I)
							or toggle it (T). This affects only how the cursor is
							drawn and can be used when implementing focus traversal.
*/


/* THIS FILE WAS AUTOMATICALLY GENERATED BY SCAN_STRINGS */
/************************* DO NOT EDIT *******************/

extern char	TextFieldResStrings[];
extern char	TextFieldClStrings[];
extern char	TextFieldTypeStrings[];

#ifndef XtNinsertPosition
#define XtNinsertPosition ((char *)(&TextFieldResStrings[0]))
#endif
#ifndef XtCTextPosition
#define XtCTextPosition ((char *)(&TextFieldClStrings[0]))
#endif
#ifndef XtNlength
#define XtNlength ((char *)(&TextFieldResStrings[15]))
#endif
#ifndef XtCLength
#define XtCLength ((char *)(&TextFieldClStrings[13]))
#endif
#ifndef XtNinsensitiveForeground
#define XtNinsensitiveForeground ((char *)(&TextFieldResStrings[22]))
#endif
#ifndef XtCInsensitiveForeground
#define XtCInsensitiveForeground ((char *)(&TextFieldClStrings[20]))
#endif
#ifndef XtNreadOnly
#define XtNreadOnly ((char *)(&TextFieldResStrings[44]))
#endif
#ifndef XtCReadOnly
#define XtCReadOnly ((char *)(&TextFieldClStrings[42]))
#endif
#ifndef XtNscrollChars
#define XtNscrollChars ((char *)(&TextFieldResStrings[53]))
#endif
#ifndef XtCScrollChars
#define XtCScrollChars ((char *)(&TextFieldClStrings[51]))
#endif
#ifndef XtNmodifiedCallback
#define XtNmodifiedCallback ((char *)(&TextFieldResStrings[65]))
#endif
#ifndef XtNvalueAddress
#define XtNvalueAddress ((char *)(&TextFieldResStrings[82]))
#endif
#ifndef XtNvalueSize
#define XtNvalueSize ((char *)(&TextFieldResStrings[95]))
#endif
#ifndef XtNvalueType
#define XtNvalueType ((char *)(&TextFieldResStrings[105]))
#endif
#ifndef XtNinputFormat
#define XtNinputFormat ((char *)(&TextFieldResStrings[115]))
#endif
#ifndef XtNoutputFormat
#define XtNoutputFormat ((char *)(&TextFieldResStrings[127]))
#endif
#ifndef XtNuseStringInPlace
#define XtNuseStringInPlace ((char *)(&TextFieldResStrings[140]))
#endif
#ifndef XtNdisplayCaret
#define XtNdisplayCaret ((char *)(&TextFieldResStrings[157]))
#endif
#ifndef XtCValueFormat
#define XtCValueFormat ((char *)(&TextFieldClStrings[63]))
#endif
#ifndef XtCUseStringInPlace
#define XtCUseStringInPlace ((char *)(&TextFieldClStrings[75]))
#endif
#ifndef XtCOutput
#define XtCOutput ((char *)(&TextFieldClStrings[92]))
#endif
#ifndef XtRCFormat
#define XtRCFormat ((char *)(&TextFieldTypeStrings[0]))
#endif

/* declare specific TextFieldWidget class and instance datatypes */

typedef struct _TextFieldClassRec*	TextFieldWidgetClass;
typedef struct _TextFieldRec*		TextFieldWidget;

/* declare the class constant */

extern WidgetClass textFieldWidgetClass;

/* public procedures */

/* convert the text string to the type indicated
 * by the valueType resource (valueSize must be set correctly)
 * and store the converted value at address valueAddress
 */

Boolean TextFieldString2Value(/*
TextFieldWidget tfw; */);

Boolean TextFieldValue2String(/*
TextFieldWidget tfw; */);
#endif /* _TextField_h */
