#ifndef PREFERENCES_H
#define PREFERENCES_H

#include <string.h>

#include "DialogBox.h"


// Number of modifiable colors
#define COLORS_NUM 9

// Number of themes
#define THEMES_NUM 12


struct Theme
{
    char *name;
    FXColor color[9];
    Theme()
    {
        name = "";
    };
    Theme(const char *n,FXColor base=0,FXColor bdr=0,FXColor bg=0,FXColor fg=0,
	                    FXColor selbg=0,FXColor selfg=0, FXColor listbg=0, FXColor listfg=0, FXColor listhl=0)
    {
        name = strdup(n);
        color[0] = base;
        color[1] = bdr;
        color[2] = bg;
        color[3] = fg;
        color[4] = selbg;
        color[5] = selfg;
		color[6] = listbg;
		color[7] = listfg;
 		color[7] = listfg;
  		color[8] = listhl;
  };
    FXbool operator != (const Theme&);
};

class PreferencesBox : public DialogBox
{
    FXDECLARE(PreferencesBox)
private:
    PreferencesBox()
    {}
    FXButton   *cwell;
    FXComboBox *colorsBox;
    FXComboBox *themesBox;
    FXList     *themesList;
    FXTextField *iconpath;
    FXTextField *txteditor;
    FXTextField *txtviewer;
    FXTextField *imgviewer;
    FXTextField *xterm;
    FXTextField *imgeditor;
    FXTextField *archiver;
    FXTextField *normalfont;
    FXTextField *textfont;
    FXString    oldiconpath;
    FXString    oldtxteditor;
    FXString    oldtxtviewer;
    FXString    oldimgviewer;
    FXString    oldxterm;
    FXString    oldnormalfont;
    FXString    oldtextfont;
    FXString    oldimgeditor;
    FXString    oldarchiver;
    FXCheckButton  *autosave;
    FXCheckButton  *diropen;
    FXCheckButton  *fileopen;
    FXCheckButton  *quit;
    FXCheckButton  *trashcan;
    FXCheckButton  *trashbypass;
    FXCheckButton  *del;
    FXCheckButton  *overwrite;
    FXCheckButton  *ask;
    FXCheckButton  *bg;
    FXCheckButton  *root_warning;
    FXCheckButton  *mount;
	FXCheckButton  *show_mount;
    Theme          Themes[THEMES_NUM];
    Theme          currTheme;
	FXbool		   use_sudo;
public:
    enum{
        ID_ACCEPT=DialogBox::ID_LAST,
        ID_BROWSE_TXTEDIT,
        ID_BROWSE_TXTVIEW,
		ID_BROWSE_IMGVIEW,
        ID_BROWSE_XTERM,
        ID_COLOR,
		ID_NORMALFONT,
		ID_TEXTFONT,
        ID_THEME,
        ID_BROWSE_ICON_PATH,
		ID_TRASH_BYPASS,
		ID_SU_CMD,
		ID_SUDO_CMD,
		ID_WHEELADJUST,
        ID_LAST
    };

public:
    PreferencesBox(FXWindow *win,FXColor listbackcolor=FXRGB(255,255,255), FXColor listforecolor=FXRGB(0,0,0), FXColor highlightcolor=FXRGB(238,238,238));
    long onCmdAccept(FXObject*,FXSelector,void*);
    long onCmdBrowse(FXObject*,FXSelector,void*);
    long onCmdColor (FXObject*,FXSelector,void*);
    long onUpdColor (FXObject*,FXSelector,void*);
    long onCmdTheme (FXObject*,FXSelector,void*);
    long onCmdBrowsePath(FXObject*,FXSelector,void*);
	long onCmdNormalFont(FXObject*,FXSelector,void*);
	long onCmdTextFont(FXObject*,FXSelector,void*);
	long onUpdTrashBypass(FXObject*,FXSelector,void*);
	long onCmdSuMode(FXObject*,FXSelector,void*);
	long onUpdSuMode(FXObject*,FXSelector,void*);
	long onCmdWheelAdjust(FXObject*,FXSelector,void*);
	long onUpdWheelAdjust(FXObject* sender,FXSelector,void*);

};
#endif
