#include "config.h"
#include "i18n.h"

#include <fox-1.6/fx.h>
#include <fox-1.6/fxdefs.h>
#include <fox-1.6/FXPNGIcon.h>

#include "icons.h"
#include "OverwriteBox.h"

// Padding for message box buttons
#define HORZ_PAD 30
#define VERT_PAD 2


// Map
FXDEFMAP(ConfirmOverWriteBox) ConfirmOverWriteBoxMap[]={
            FXMAPFUNCS(SEL_COMMAND,ConfirmOverWriteBox::ID_CLICKED_OVERWRITE,ConfirmOverWriteBox::ID_CLICKED_OVERWRITE_ALL,ConfirmOverWriteBox::onCmdClicked),
            FXMAPFUNCS(SEL_COMMAND,ConfirmOverWriteBox::ID_CLICKED_SKIP,ConfirmOverWriteBox::ID_CLICKED_SKIP_ALL,ConfirmOverWriteBox::onCmdClicked),
        };



// Object implementation
FXIMPLEMENT(ConfirmOverWriteBox,DialogBox,ConfirmOverWriteBoxMap,ARRAYNUMBER(ConfirmOverWriteBoxMap))


// Create message box
ConfirmOverWriteBox::ConfirmOverWriteBox(FXWindow *win,const FXString& name,const FXString& text,FXuint opts,FXint x,FXint y):
        DialogBox(win,name,opts|DECOR_TITLE|DECOR_BORDER|DECOR_RESIZE,x,y,0,0)
{
    FXVerticalFrame* content=new FXVerticalFrame(this,LAYOUT_FILL_X|LAYOUT_FILL_Y);
    FXHorizontalFrame* info=new FXHorizontalFrame(content,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,10,10,10,10);
    new FXLabel(info,FXString::null,questionbigicon,ICON_BEFORE_TEXT|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    new FXLabel(info,text,NULL,JUSTIFY_LEFT|ICON_BEFORE_TEXT|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    new FXHorizontalSeparator(content,SEPARATOR_GROOVE|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X);
    FXHorizontalFrame* buttons=new FXHorizontalFrame(content,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X|PACK_UNIFORM_WIDTH,0,0,0,0,10,10,10,10);
    new FXButton(buttons,_("&Skip"),NULL,this,ID_CLICKED_SKIP,FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    new FXButton(buttons,_("Skip A&ll"),NULL,this,ID_CLICKED_SKIP_ALL,FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    new FXButton(buttons,_("&Yes"),NULL,this,ID_CLICKED_OVERWRITE,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    new FXButton(buttons,_("Yes for &All"),NULL,this,ID_CLICKED_OVERWRITE_ALL,FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
}


// Close dialog
long ConfirmOverWriteBox::onCmdClicked(FXObject*,FXSelector sel,void*)
{
    getApp()->stopModal(this,MBOX_CLICKED_OVERWRITE+(FXSELID(sel)-ID_CLICKED_OVERWRITE));
    hide();
    return 1;
}

