// Input dialog with file browse icon

#include "config.h"
#include "i18n.h"

#include <fox-1.6/fx.h>
#include <fox-1.6/fxkeys.h>

#include "icons.h"
#include "FileDialog.h"
#include "File.h"
#include "BrowseInputDialog.h"




FXDEFMAP(BrowseInputDialog) BrowseInputDialogMap[]={
                                           FXMAPFUNC(SEL_KEYPRESS,0,BrowseInputDialog::onCmdKeyPress),
                                           FXMAPFUNC(SEL_COMMAND,BrowseInputDialog::ID_BROWSE_PATH,BrowseInputDialog::onCmdBrowsePath),
                                       };
// Object implementation
FXIMPLEMENT(BrowseInputDialog,DialogBox,BrowseInputDialogMap,ARRAYNUMBER(BrowseInputDialogMap))

// Construct a dialog box
BrowseInputDialog::BrowseInputDialog(FXWindow *win,FXString inp,FXString message,FXString title,FXString label,FXIcon *ic, int option, FXString optiontext):
        DialogBox(win,title,DECOR_TITLE|DECOR_BORDER|DECOR_STRETCHABLE)
{
    // Buttons
    FXHorizontalFrame *buttons=new FXHorizontalFrame(this,PACK_UNIFORM_WIDTH|LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X,0,0,0,0,10,10,5,5);
    
	// Accept
    new FXButton(buttons,_("&Accept"),NULL,this,ID_ACCEPT,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT,0,0,0,0,20,20);
    
	// Cancel
    new FXButton(buttons,_("&Cancel"),NULL,this,ID_CANCEL,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT,0,0,0,0,20,20);
    
	// Separator
    new FXHorizontalSeparator(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|SEPARATOR_GROOVE);

	// Optional check box
	checkbutton=new FXHorizontalFrame(this,JUSTIFY_RIGHT|LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X,0,0,0,0,10,10,0,0);
    
	if (option)
        new FXCheckButton(checkbutton,optiontext,this,ID_TOGGLE_OPTION);

    // Vertical frame
	FXVerticalFrame *contents=new FXVerticalFrame(this,LAYOUT_SIDE_TOP|FRAME_NONE|LAYOUT_FILL_X|LAYOUT_FILL_Y);

	// Display the message in a non editable text field. This allows to copy/paste the file name to the input text field

	// Icon and first line
	FXMatrix *matrix1 = new FXMatrix(contents,2,MATRIX_BY_COLUMNS|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y);
	new FXLabel(matrix1,"",ic,LAYOUT_LEFT|LAYOUT_CENTER_Y|LAYOUT_FILL_ROW);
	msg = new FXTextField(matrix1,30,0,0,LAYOUT_LEFT|LAYOUT_CENTER_Y|LAYOUT_FILL_ROW|FRAME_NONE);
	msg->setText(message);
	msg->setEditable(FALSE);

	// Label and input field
	FXMatrix *matrix2 = new FXMatrix(contents,3,MATRIX_BY_COLUMNS|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y);
	new FXLabel(matrix2,label,NULL,LAYOUT_LEFT|LAYOUT_CENTER_Y|LAYOUT_FILL_ROW);
	input = new FXTextField(matrix2,40,0,0,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X);
	input->setText(inp);
	new FXButton(matrix2,_("\tSelect destination..."),filedialogicon,this,ID_BROWSE_PATH,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
	if (!isUtf8(message.text(),message.length()))
		new FXLabel(contents,_("=> Warning: file name is not UTF-8 encoded!"),NULL,LAYOUT_LEFT|LAYOUT_CENTER_Y|LAYOUT_FILL_ROW);
}


void BrowseInputDialog::create()
{
    DialogBox::create();
    input->setFocus();
}


BrowseInputDialog::~BrowseInputDialog()
{
	delete input;
	delete msg;
}

long BrowseInputDialog::onCmdKeyPress(FXObject* sender,FXSelector sel,void* ptr)
{
    FXEvent* event=(FXEvent*)ptr;
    switch(event->code)
    {
    case KEY_Escape:
        handle(this,FXSEL(SEL_COMMAND,ID_CANCEL),NULL);
		return 1;
    case KEY_KP_Enter:
    case KEY_Return:
        handle(this,FXSEL(SEL_COMMAND,ID_ACCEPT),NULL);
		return 1;
    default:
        FXTopWindow::onKeyPress(sender,sel,ptr);
		return 1;
    }
	return 0;
}


long BrowseInputDialog::onCmdBrowsePath(FXObject* o,FXSelector s,void* p)
{
	FileDialog browse(this,_("Select path"),0,0,0,650,480);

	const FXchar *patterns[]=
		{
			_("All Files"),          "*",	NULL
		};
	browse.setFilename(input->getText());
	browse.setPatternList(patterns);
	
	// Browse files in mixed mode
	browse.setSelectMode(SELECT_FILE_MIXED);
	if(browse.execute())
	{
	  FXString path=browse.getFilename();
	  input->setText(path);
	}
	return 1;
}


void BrowseInputDialog::setMessage(FXString message)
{
	msg->setNumColumns(message.length());
	msg->setText(message);
}


FXString BrowseInputDialog::getText()
{
	return input->getText();
}


void BrowseInputDialog::setText(const FXString& text)
{
	input->setText(text);
}


void BrowseInputDialog::SelectAll()
{
	input->setSelection(0,(input->getText()).length());
};


void BrowseInputDialog::CursorEnd()
{
	input->onCmdCursorEnd(0,0,0);
}
