// Directory box


#include "config.h"
#include "i18n.h"

#include <fox-1.6/fx.h>
#include <fox-1.6/FXPNGIcon.h>

#include "xfedefs.h"
#include "File.h"
#include "DirBox.h"
#include "icons.h"


// Map
FXDEFMAP(DirBox) DirBoxMap[]={
                                 FXMAPFUNC(SEL_CHANGED,DirBox::ID_TREE,DirBox::onTreeChanged),
                                 FXMAPFUNC(SEL_CLICKED,DirBox::ID_TREE,DirBox::onTreeClicked),
                                 FXMAPFUNC(SEL_COMMAND,DirBox::ID_SETVALUE,DirBox::onCmdSetValue),
                                 FXMAPFUNC(SEL_COMMAND,DirBox::ID_SETSTRINGVALUE,DirBox::onCmdSetStringValue),
                                 FXMAPFUNC(SEL_COMMAND,DirBox::ID_GETSTRINGVALUE,DirBox::onCmdGetStringValue),
                             };


// Implementation
FXIMPLEMENT(DirBox,FXTreeListBox,DirBoxMap,ARRAYNUMBER(DirBoxMap))


// Directory box
DirBox::DirBox(FXComposite *p,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb):
        FXTreeListBox(p,tgt,sel,opts,x,y,w,h, pl,pr,pt,pb)
{
    setDirectory(ROOTDIR);
}


// Create
void DirBox::create()
{
    FXTreeListBox::create();
}


// Set the current item's text from the message
long DirBox::onCmdSetValue(FXObject*,FXSelector,void* ptr)
{
    setDirectory((char*)ptr);
    return 1;
}


// Change value
long DirBox::onCmdSetStringValue(FXObject*,FXSelector,void* ptr)
{
    setDirectory(*((FXString*)ptr));
    return 1;
}


// Obtain value
long DirBox::onCmdGetStringValue(FXObject*,FXSelector,void* ptr)
{
    *((FXString*)ptr)=getDirectory();
    return 1;
}


// Return item path
FXString DirBox::getItemPathname(FXTreeItem *item) const
{
    FXString string;
    if(item)
    {
        while(item->getParent())
        {
            string.prepend(getItemText(item));
            item=item->getParent();
            if(item->getParent())
				string.prepend(PATHSEPSTRING);
        }
        string.prepend(getItemText(item));
    }
    return string;
}


// Return the item from the absolute pathname
FXTreeItem* DirBox::getPathnameItem(const FXString& path)
{
    register FXTreeItem *item;
    register FXint beg=0;
    register FXint end=0;

    // Remove old items first
    clearItems();

    // Parse past root
    if(ISPATHSEP(path[0]))
		end++;

    // Absolute path?
    if(beg<end)
    {
        // Add root
        item=appendItem(NULL,ROOTDIR,minifoldericon,minifoldericon);

        // Add the rest
        while(end<path.length())
        {
            // Begin of path component
            beg=end;

            // Find next path separator
            while(end<path.length() && !ISPATHSEP(path[end]))
				end++;

            // Add next item under last
            item=appendItem(item,path.mid(beg,end-beg),minifoldericon,minifoldericon);

            // Skip over path separator
            if(end<path.length() && ISPATHSEP(path[end]))
				end++;
        }

        // Return leaf item
        return item;
    }
    return NULL;
}



// Forward clicked message from list to target
long DirBox::onTreeClicked(FXObject*,FXSelector,void* ptr)
{
    FXString string=getItemPathname((FXTreeItem*)ptr);
    button->handle(this,FXSEL(SEL_COMMAND,ID_UNPOST),NULL);    // Unpost the list
    if(ptr)
    {
        field->setText(tree->getItemText((FXTreeItem*)ptr));
        field->setIcon(tree->getItemClosedIcon((FXTreeItem*)ptr));
        removeItem(((FXTreeItem*)ptr)->getFirst());
        if(target)
			target->tryHandle(this,FXSEL(SEL_COMMAND,message),(void*)string.text());
    }
    return 1;
}


// Forward changed message from list to target
long DirBox::onTreeChanged(FXObject*,FXSelector,void* ptr)
{
    FXString string=getItemPathname((FXTreeItem*)ptr);
    if(target)
		target->tryHandle(this,FXSEL(SEL_CHANGED,message),(void*)string.text());
    return 1;
}


// Set directory
void DirBox::setDirectory(const FXString& pathname)
{
    setCurrentItem(getPathnameItem(FXPath::absolute(pathname)));
}


// Return current directory
FXString DirBox::getDirectory() const
{
    return getItemPathname(getCurrentItem());
}


// Delete object
DirBox::~DirBox()
{
    clearItems();
}


