#ifndef FILEPANEL_H
#define FILEPANEL_H
#include "Properties.h"
#include "FileList.h"
#include "PathLinker.h"

// Clipboard operations
enum
{	
	COPY_CLP,
	CUT_CLP,
};

class FilePanel : public FXVerticalFrame
{
    FXDECLARE(FilePanel)
    friend class XFileExplorer;
    friend class DirPanel;
    friend class PathLinker;
	friend class PropertiesBox;
protected:
    FilePanel*		current;
    FileList*	  	list;
    FilePanel*		next;
    PathLinker*		pathlink;
	FXPacker* 		statusbar;
    FXLabel*		status;
    FXString 		name;
	FXbool			ctrlkey;
	FXbool			selmult;
	FXString		homelocation;
	FXString		trashlocation;
	FXDragCorner    *corner;


public:
    FilePanel(FXchar*,FXComposite*, FXuint name_size=200, FXuint size_size=60, FXuint type_size=100, FXuint ext_size=100, 
	      FXuint modd_size=150, FXuint user_size=50, FXuint grou_size=50, FXuint attr_size=100, FXColor listbackcolor=FXRGB(255,255,255), FXColor listforecolor=FXRGB(0,0,0),
 		  FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);
    FilePanel()
    {}
    virtual void create();
    ~FilePanel();
    void focus();
    void unfocus();
    void Next(FilePanel*);
	void updateLocation();
	void showCorner(FXbool show);
    enum {
        ID_FILE_PANEL=FXVerticalFrame::ID_LAST,
        ID_DIRECTORY_UP,
        ID_VIEW,
        ID_EDIT,
        ID_PROPERTIES,
        ID_FILE_COPY,
        ID_FILE_COPYTO,
        ID_FILE_MOVE,
        ID_FILE_RENAME,
        ID_FILE_SYMLINK,
        ID_FILE_DELETE,
        ID_FILE_TRASH,
        ID_FILE_ASSOC,
		ID_MENU,
		ID_XTERM,
        ID_EXTRACT,
        ID_EXTRACT_HERE,
        ID_NEW_DIR,
        ID_NEW_FILE,
        ID_ADD_TO_ARCH,
        ID_GO_HOME,
		ID_GO_TRASH,
        ID_COPY_CLP,
        ID_CUT_CLP,
        ID_PASTE_CLP,
        ID_OPEN,
        ID_OPEN_WITH,
        ID_FILTER,
        ID_STATUS,
        ID_LABEL,
        ID_REFRESH,
        ID_SELECT_ALL,
        ID_DESELECT_ALL,
        ID_SELECT_INVERSE,
        ID_SHOW_BIG_ICONS,
        ID_SHOW_MINI_ICONS,
        ID_SHOW_DETAILS,
        ID_TOGGLE_HIDDEN,
        ID_TOGGLE_THUMBNAILS,
#if defined(linux)
        ID_MOUNT,
        ID_UMOUNT,
		ID_PKG_QUERY,
		ID_PKG_INSTALL,
		ID_PKG_UNINSTALL,
#endif
        ID_LAST,
    };
public:
    long onUpdStatus(FXObject*,FXSelector,void*);
    long onCmdItemDblClcked(FXObject*,FXSelector,void*);
    long onCmdItemFilter(FXObject*,FXSelector,void*);
    long onCmdClp(FXObject*,FXSelector,void*);
    long onCmdPaste(FXObject*,FXSelector,void*);
    long onCmdItemClcked(FXObject*,FXSelector,void*);
    long onCmdDirectoryUp(FXObject*,FXSelector,void*);
    long onCmdGoHome(FXObject*,FXSelector,void*);
	long onCmdGoTrash(FXObject*,FXSelector,void*);
    long onCmdEdit(FXObject*,FXSelector,void*);
    long onCmdProperties(FXObject*,FXSelector,void*);
    long onCmdFileMan(FXObject*,FXSelector,void*);
    long onCmdFileTrash(FXObject*,FXSelector,void*);
	long onCmdFileDelete(FXObject*,FXSelector,void*);
    long onCmdFileAssoc(FXObject*,FXSelector,void*);
    long onCmdNewDir(FXObject*,FXSelector,void*);
    long onCmdNewFile(FXObject*,FXSelector,void*);
	long onCmdOpen(FXObject*,FXSelector,void*);
    long onCmdOpenWith(FXObject*,FXSelector,void*);
	long onCmdXTerm(FXObject*,FXSelector,void*);
    long onCmdExtract(FXObject*,FXSelector,void*);
    long onCmdExtractHere(FXObject*,FXSelector,void*);
    long onRefresh(FXObject*,FXSelector,void*);
    long onCmdSelect(FXObject*,FXSelector,void*);
    long onCmdPopupMenu(FXObject*,FXSelector,void*);
    long onCmdShow(FXObject*,FXSelector,void*);
    long onUpdShow(FXObject*,FXSelector,void*);
    long onUpdUp(FXObject*,FXSelector,void*);
    long onUpdPaste(FXObject*,FXSelector,void*);
    long onCmdToggleHidden(FXObject*,FXSelector,void*);
    long onUpdToggleHidden(FXObject*,FXSelector,void*);
	long onCmdToggleThumbnails(FXObject*,FXSelector,void*);
	long onUpdToggleThumbnails(FXObject*,FXSelector,void*);
    long onCmdAddToArch(FXObject*,FXSelector,void*);
	long onUpdMenu(FXObject*,FXSelector,void*);
	long onUpdOpen(FXObject*,FXSelector,void*);
	long onUpdAddToArch(FXObject*,FXSelector,void*);
	long onUpdSelMult(FXObject*,FXSelector,void*);
	long onUpdFileDelete(FXObject*,FXSelector,void*);
	long onUpdFileTrash(FXObject*,FXSelector,void*);
	long onUpdGoTrash(FXObject* o,FXSelector sel,void*);
	void updatePathLinker();

#if defined(linux)
    long onCmdMount(FXObject*,FXSelector,void*);
    long onUpdMount(FXObject*,FXSelector,void*);
    long onUpdUnmount(FXObject*,FXSelector,void*);
    long onCmdPkgQuery(FXObject*,FXSelector,void*);
    long onUpdPkgQuery(FXObject*,FXSelector,void*);
    long onCmdPkgInstall(FXObject*,FXSelector,void*);
    long onCmdPkgUninstall(FXObject*,FXSelector,void*);
#endif
};
#endif
