/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import java.util.Map;
import jde.debugger.Application;
import jde.debugger.Debug;
import jde.debugger.JDEException;
import jde.debugger.Jdebug;
import jde.debugger.command.DebugSessionCommand;

public class AttachSocket
extends DebugSessionCommand {
    protected void doCommand() throws JDEException {
        String connectSpec = null;
        connectSpec = "com.sun.jdi.SocketAttach";
        AttachingConnector connector = (AttachingConnector)this.getConnector(connectSpec);
        if (connector == null) {
            throw new JDEException("No such connector is available: " + connectSpec);
        }
        if (this.args.size() < 1) {
            throw new JDEException("Missing arguments: specify at least the port");
        }
        try {
            Map<String, Connector.Argument> argumentMap = connector.defaultArguments();
            while (this.args.size() > 0 && this.args.get(0).toString().startsWith("-")) {
                String arg = this.args.remove(0).toString().toLowerCase();
                if (arg.equals("-host")) {
                    if (this.args.size() == 0) {
                        throw new JDEException("Missing argument to 'host'");
                    }
                    String host = this.args.remove(0).toString();
                    Connector.Argument hostArg = argumentMap.get("host");
                    hostArg.setValue(host);
                    continue;
                }
                if (arg.equals("-port")) {
                    if (this.args.size() == 0) {
                        throw new JDEException("Missing argument to 'port'");
                    }
                    String port = this.args.remove(0).toString();
                    Connector.Argument portArg = argumentMap.get("port");
                    portArg.setValue(port);
                    continue;
                }
                this.args.add(0, arg);
                break;
            }
            VirtualMachine vm = connector.attach(argumentMap);
            Application app = new Application(Jdebug.theDebugger, this.appID, vm);
            if (Jdebug.theDebugger.appExists(this.appID)) {
                app.shutdown();
                throw new JDEException("An application with the ID " + this.appID + " already exists.");
            }
            Jdebug.theDebugger.addApplication(this.appID, app);
            app.signalCommandResult(this.cmdID);
            app.signal("message", "Attached VM (socket) " + vm.description());
        }
        catch (IOException ex) {
            Debug.printIf(ex);
            throw new JDEException("I/O error occurred while attempting to attach process.");
        }
        catch (IllegalConnectorArgumentsException ex) {
            throw new JDEException("Illegal connector arguments for connector '" + connector);
        }
    }

    public Object clone() {
        return new AttachSocket();
    }
}

