/*
 *	cfg.h - interface to configuration file
 *	Copyright (C) 2000  Fred Barnes <frmb2@ukc.ac.uk>
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __CFG_H
#define __CFG_H

#define FLD_TEXT (0x0001)
#define FLD_FOREGROUND (0x0002)
#define FLD_BACKGROUND (0x0004)
#define FLD_HIGHLIGHT (0x0008)
#define FLD_SHADOW (0x0010)
#define FLD_FONT (0x0020)
#define FLD_TENTRY (0x0040)

#define DEFAULT_TEXT "missing"
#define DEFAULT_FOREGROUND "black"
#define DEFAULT_BACKGROUND "white"
#define DEFAULT_HIGHLIGHT "white"
#define DEFAULT_SHADOW "black"
#define DEFAULT_FONT "fixed"
#define DEFAULT_TENTRY "white"

typedef struct __ConfigData {
	char *text;
	char *foreground;
	char *background;
	char *highlight;
	char *shadow;
	char *font;
	char *tentry;
} GadgetConfigData;


typedef struct __GlobalConfigData {
	int hidequery;
	int allowbroadcast;
	char *startscript;
	int extratext;
	int allowctrlc;
	int ctrlcexitcode;
	int stripdomain;
	char *startscriptkill;
} GlobalConfigData;


#ifndef __CFG_C
	extern int init_config_file (GlobalConfigData *);
	extern int read_config_entry (char *, GadgetConfigData *, int);
	extern void close_config_file (void);
#endif	/* !__CFG_C */


#endif	/* !__CFG_H */

