/*********************************************************

  X De Block 

       blockmisc.c file

  *********************************************************/

#include "gameheader.h"

extern Display     *display;                   /* global display      */
extern Window      mWin;                       /* global main window  */
extern GC          gc;                         /* global gc           */
extern Pixmap      offPixmap,backPicPixmap;    /* global offscreen pixmaps */
extern XFontStruct *xfont;                     /* global font         */
extern XFontStruct *minifont;                  /* global minifont     */
extern Colormap    cmap;                       /* global cmap         */

extern XColor      black,white;

void drawText(disp,win,x,y,text,color)
     Display *disp; 
     Window  win;
     int     x;
     int     y;
     char    *text;
     int     color;
{
  int len = strlen(text);
  int plen;
  
  /* Obtain the text width so it can be centered */
  plen = XTextWidth(xfont,text,len);
  
  /* Change to the new font */
  XSetFont(disp,gc,xfont->fid);
  
  /* Change the drawing function */
  XSetForeground(disp,gc,color);
  
  /* Draw the string into the drawable */
  XDrawString(disp,win,gc,x, y +xfont->ascent,text,len);
  
  /* Just to be sure, flush the display */
  XFlush(display);
}

void drawMiniText(disp,win,x,y,text,color,shadow)
     Display *disp; 
     Window  win;
     int     x;
     int     y;
     char    *text;
     int     color;
     int     shadow;
{
  int len = strlen(text);
  int plen;
  
  /* Obtain the text width so it can be centered */
  plen = XTextWidth(minifont,text,len);
  
  /* Change to the new font */
  XSetFont(disp,gc,minifont->fid);
  
  /* draw shadow */
  if(shadow)
    {
      XSetForeground(disp,gc,black.pixel);
      XDrawString(disp,win,gc,x+2,y +minifont->ascent +2,text,len);
    }

  /* draw text */  
  XSetForeground(disp,gc,color);
  XDrawString(disp,win,gc,x,y +minifont->ascent,text,len);
  
  
  /* Just to be sure, flush the display */
  XFlush(display);
}

void drawShadowText(disp,win,x,y,text,color)
     Display *disp; 
     Window  win;
     int     x;
     int     y;
     char    *text;
     int     color;
{
  int len = strlen(text);
  int plen;
  
  /* Obtain the text width so it can be centered */
  plen = XTextWidth(xfont,text,len);
  
  /* Change to the new font */
  XSetFont(disp,gc,xfont->fid);
  
  /* draw shadow */
  
  XSetForeground(disp,gc,black.pixel);
  XDrawString(disp,win,gc,x+2,y +xfont->ascent +2,text,len);
  
  /* draw text */
  
  XSetForeground(disp,gc,color);
  XDrawString(disp,win,gc,x,y +xfont->ascent,text,len);
  

  /* Just to be sure, flush the display */
  XFlush(display);
}

void drawWithMask(disp,win,pixmap,mask,x,y,wid,hei)
     Display  *disp;
     Drawable win;
     Pixmap   pixmap;
     Pixmap   mask;
     int      x;
     int      y;
     int      wid;
     int      hei;
{

  /* Set to dest x and y clip origin */
  XSetClipOrigin(disp,gc,x,y); 
  
  /* Set the clipping mask */
  XSetClipMask(disp,gc,mask);   
  
  XCopyArea(disp,pixmap,win,gc,0,0,wid,hei,x,y);
  
  /* Unset clip (or add a clip gc) */
  XSetClipMask(disp,gc,None);

}

void setRect(rect,x,y,wid,hei)
     XRectangle*    rect;
     short          x;
     short          y;
     unsigned short wid;
     unsigned short hei;
{
  rect->x      = x;
  rect->y      = y;
  rect->width  = wid;
  rect->height = hei;
}

int ptInRect(rect,x,y)
     XRectangle*   rect;
     short         x;
     short         y;
{
  return((rect->x <= x)&&(rect->x+rect->width >= x)&&
	 (rect->y <= y)&&(rect->y+rect->height >= y));
}

unsigned long time2long(time)
     struct timeval    *time;
{
  unsigned long rtn_time;

  rtn_time = time->tv_sec;
  rtn_time <<= 16;
  rtn_time |= (time->tv_usec / 1000);

  return(rtn_time);
}

void long2time(time,rtn_time)
     long              time;
     struct timeval    *rtn_time;
{
  rtn_time->tv_usec = (time & 0x0000ffff)*1000;
  time >>= 16;
  rtn_time->tv_sec = time;
}

int  g_random(void)
{
  struct timeval    tm;

  /****   return to randam number.   ****/
  gettimeofday(&tm,NULL);
  return(((rand()- 65536/2)* tm.tv_usec)/100000);
}

void gameSleep(display, slp)
    Display *display;
    unsigned long slp;
{
    struct timeval  tm;

    if((tm.tv_sec =(slp / 10000)) <0)
      return;
    if((tm.tv_usec =(slp % 10000)*100) <0)
      return;

#ifdef SYSV
    select(1,NULL,NULL,NULL,&tm);
#else
    select(0,(void *)0, (void *)0, (void *)0,&tm);
#endif

}

void handleXPMError(errorStatus, tag)
     int errorStatus;
     char *tag;
{
  char *error = NULL;
  char *warning = NULL;
  
  /* Switch on the type of error returned by xpm library */
  switch (errorStatus) 
    {
    case XpmSuccess:
      return;
      
    case XpmColorError:
      /* The colour name passed was bung */
      warning = "Could not parse or alloc requested colour";
      break;
      
    case XpmNoMemory:
      /* Not enough memory for pixmap */
      error = "Not enough memory for pixmap creation";
      break;

    case XpmColorFailed:
      /* No more entries available in colourmap */
      error = "Colourmap is full - cannot allocate a colour";
      break;
      
    case XpmOpenFailed:
      /* Xpm could not open the pixmap file */
      error = "Unable to open pixmap file";
      break;
      
    case XpmFileInvalid:
      /* XPM file contains invalid or corrupt data */
      error = "XPM file contains invalid or corrupt data";
      break;
      
    default:
      /* Unexpected xpm error code */
      error = "Unexpected xpm error code";
      break;
    }

  /* If there is to be a warning then issue it */
  if (warning)
    fprintf(stdout, "%s - Warning: %s.\n", tag, warning);
  
  if (error) 
    {
      /* Argg. An error so tell everyone */
      fprintf(stderr, "%s - Error: %s.\n", tag, error);
      exit(1);
    }
}

