/***********************************************

	X De Block
	
		game Dialogs
		
  ***********************************************/

#include        <sys/types.h>
#include        <sys/stat.h>
#include        <sys/dir.h>

#include 	"gameheader.h"

#include        "xpm/back0.xpm"
#include        "xpm/pato.xpm"


extern Display     *display;                   /* global display      */
extern Window      mWin;                       /* global main window  */
extern GC          gc;                         /* global gc           */
extern Pixmap      offPixmap,backPicPixmap;    /* global offscreen pixmaps */
extern XFontStruct *xfont;                     /* global font         */
extern Colormap    cmap;                       /* global cmap         */

extern allDataRec  nowDataRec;
extern mapFilePtr  nowMapFile;
extern flgs   	   gameMainFlg;

extern XColor      black,white,blue,red,yellow,rgb;

void aboutDLG(void)
{

  register     	i,j;
  int           pic_x,pic_y,err,flg = True;
  Window        aboutWin;
  XEvent        event;
  XpmAttributes attributes;
  Pixmap        pic,picM;


  /****	  set window	***/
  
  aboutWin = XCreateSimpleWindow(display,mWin,
				 (dWinWidth-dAboutWidth)/2,
				 (dWinHeight-dAboutHeight)/2,
				 dAboutWidth,dAboutHeight,1,
				 black.pixel,white.pixel);

  XSelectInput(display,aboutWin,ButtonPressMask | ExposureMask);
  XStoreName(display,aboutWin,"XDeBlock About");
  XMapWindow(display,aboutWin);

  /***	set Dialog	***/

  attributes.valuemask = XpmColormap;
  attributes.colormap = cmap;

  sscanf(pato_xpm[0],"%d%d",&pic_x,&pic_y);
  err = XpmCreatePixmapFromData(display,aboutWin,pato_xpm,
				&pic,&picM,&attributes);
  handleXPMError(err,"AboutDLG back");

  XCopyArea(display,pic,aboutWin,gc,0,0,dAboutWidth,dAboutHeight,20,20);
  drawMiniText(display,aboutWin,20,260,"XDeBlock ver.1.0",blue.pixel,True);

  /****	Dialog	Event	Loop	***/
  
  while(flg)
    {
      XNextEvent(display,&event);
      switch(event.type)
	{
	case Expose:
	  reDraw(&event);
	  XCopyArea(display,offPixmap,mWin,gc,0,0,dWinWidth,dWinHeight,0,0);
	  
	  break;

	case ButtonPress:
	  flg = !handleHiScoreButton(&event);
	  break;
	}
    }

  XpmFreeAttributes(&attributes);
  XFreePixmap(display,pic);

  XUnmapWindow(display,aboutWin);
  XDestroyWindow(display,aboutWin);

}

int handleHiScoreButton(event)
     XButtonEvent   *event;
{
  switch(event->button)
    {
    case Button1:
      return(1);
      break;

    case Button2:
      return(2);
      break;

    case Button3:
      return(3);
      break;
    }
  return(False);
}

int handleInputKey(event,name,num)
     XKeyEvent *event;
     char      *name;
     int       *num;
{
  char   ch;
  KeySym keysym;

  XLookupString(event,&ch,1,&keysym,NULL);
  switch(keysym)
    {
    case XK_Up:
    case XK_Down:
      *num = 0;
      name[*num] = 0x00;
      break;

    case XK_Left:
    case XK_Right:
    case XK_Shift_L:
    case XK_Shift_R:
    case XK_Control_L:
    case XK_Control_R:
    case XK_Tab:
    case XK_Pause:
    case XK_Scroll_Lock:
    case XK_Caps_Lock:
    case XK_Num_Lock:
    case XK_Meta_L:
    case XK_Meta_R:
    case XK_Alt_L:
    case XK_Alt_R:
      break;
      
    case XK_Help:
    case XK_Return:
    case XK_Escape:
      return(True);

    case XK_Delete:
    case XK_BackSpace:
      (*num)?(--(*num)):(*num);
      name[*num] = 0x00;
      break;

    default:
      name[*num] = ch;
      name[(*num)+1] = 0x00;
      (*num < 31)?(++(*num)):(*num);
      break;
    }
  return(False);
}
      
void draw_inputname(win,name,num)
     Window win;
     char   *name;
     int    *num;
{
  int       x;

  drawShadowText(display,win,10,10,
		 "Input your name...",white.pixel);

  drawMiniText(display,win,20,120,
	       "Press RTURN or Mouse to end.",white.pixel);

  XSetForeground(display,gc,WhitePixel(display,DefaultScreen(display)));
  XDrawRectangle(display,win,gc,16,66,dInputWidth-24,34);

  strcpy(name,nowDataRec.nowMap.playerName);
  *num = strlen(name);

  x = 20;
  XClearArea(display,win,20,70,dInputWidth-30,30,False);
  drawShadowText(display,win,x,70,name,blue.pixel);
  
  x += XTextWidth(xfont,name,strlen(name));
  drawText(display,win,x,70,"|",white.pixel);

}

void nameInputDLG(void)
{
  register     	i,j;
  int           err,flg,x,num=0;
  str32         name;
  Window        inputWin;
  XEvent        event;
  XpmAttributes attributes;
  Pixmap        pic,picM;
 


  /****    set window    ****/
  
  inputWin = XCreateSimpleWindow(display,mWin,
				 (dWinWidth-dInputWidth)/2,
				 (dWinHeight-dInputHeight)/2,
				 dInputWidth,dInputHeight,1,
				 black.pixel,white.pixel);
  
  XSelectInput(display,inputWin,ButtonPressMask | ButtonRelease |
	       KeyPress | KeyRelease | ExposureMask);

  XStoreName(display,inputWin,"XDeBlock input");
  XMapWindow(display,inputWin);

  /***	set Dialog	***/
  /*  FrameRoundRect(&box,16,16);*/

  attributes.valuemask = XpmColormap;
  attributes.colormap = cmap;

  err = XpmCreatePixmapFromData(display,inputWin,back0_xpm,
				&pic,&picM,&attributes);
  handleXPMError(err,"inputnameDLG back");

  XSetWindowBackgroundPixmap(display,inputWin,pic);
  XClearArea(display,inputWin,0,0,dInputWidth,dInputHeight,False);

  /**** Draw input name DLG ****/

  draw_inputname(inputWin,name,&num);


  /****	Dialog	Event	Loop	***/
  
  while(flg)
    {
      XNextEvent(display,&event);
      
      switch(event.type)
	{
	case Expose:
	  draw_inputname(inputWin,name,&num);
	  reDraw(&event);
	  break;

	case ButtonPress:
	  if(handleHiScoreButton(&event) == 1)
	    {
	      strcpy(nowDataRec.nowMap.playerName,name);
	      flg = False;
	    }
	  else if(handleHiScoreButton(&event) == 3)
	    flg = False;

	  break;
	case KeyPress:
	  flg = !handleInputKey(&event,name,&num);

	  x = 20;
	  XClearArea(display,inputWin,20,70,dInputWidth-30,30,False);
	  drawShadowText(display,inputWin,x,70,name,blue.pixel);

	  x += XTextWidth(xfont,name,strlen(name));
	  drawText(display,inputWin,x,70,"|",white.pixel);

	  break;
	}
    }

  strcpy(nowDataRec.nowMap.playerName,name);
  gameMainFlg.inputName = True;


  XpmFreeAttributes(&attributes);
  XFreePixmap(display,pic);

  XUnmapWindow(display,inputWin);
  XDestroyWindow(display,inputWin);
	
}


void draw_hiscore(win)
     Window win;
{
  register      i,j;
  long	      	color;
  int           num,err;
  str32         tempBuf;

  /****    draw score dialogs    ****/

  drawShadowText(display,win,70,15,
		 "Top 10 Score of this map !",blue.pixel);

  drawShadowText(display,win,70,60,
		 "< NAME >",blue.pixel);
  drawShadowText(display,win,240,60,
		 "< SCORE >",blue.pixel);
  drawShadowText(display,win,360,60,
		 "<STAGE>",blue.pixel);

  drawMiniText(display,win,100,440,
	       "Press MouseButton to end.",white.pixel);

  /****	   draw HiScore name	***/
    
  for(i ^=i; i < 10;i++)
    {
      if((num = nowMapFile->hiScore[i]&0x00ffffff)==nowDataRec.nowMap.myScore)
	color = red.pixel;
      else
	color = white.pixel;

      /*****  number    *****/
      sprintf(tempBuf,"%d",i+1);
      drawShadowText(display,win,10,100+30*i,
		     tempBuf,color);

      /*****   name      *****/
      drawShadowText(display,win,50,100+30*i,
		     nowMapFile->hiScoreName[i],color);
      
      /*****   score     *****/
      sprintf(tempBuf,"%d",num);
      drawShadowText(display,win,280,100+30*i,
		     tempBuf,color);
	
      /*****   stage     *****/
      num = (nowMapFile->hiScore[i] &0xff000000) >>24;

      if(num <= nowMapFile->allMapNumber)
	{
	  sprintf(tempBuf,"%d",num);
	  drawShadowText(display,win,410,100+30*i,tempBuf,color);
	}
      else
	drawShadowText(display,win,410,100+30*i,"ALL",color);
    }
}

void hiScoreDLG(void)
{
  register     	i,j;
  int           err,flg;
  Window        hiScoreWin;
  XEvent        event;
  XpmAttributes attributes;
  Pixmap        pic,picM;


  /****	  set window	***/
  
  hiScoreWin = XCreateSimpleWindow(display,mWin,
				   (dWinWidth-dHiScoreWidth)/2,
				   (dWinHeight-dHiScoreHeight)/2,
				   dHiScoreWidth,dHiScoreHeight,1,
				   black.pixel,white.pixel);

  XSelectInput(display,hiScoreWin,ButtonPressMask | ExposureMask);
  XStoreName(display,hiScoreWin,"XDeBlock Score");
  XMapWindow(display,hiScoreWin);

  /***	set Dialog	***/
  /*  FrameRoundRect(&box,16,16);*/

  attributes.valuemask = XpmColormap;
  attributes.colormap = cmap;

  err = XpmCreatePixmapFromData(display,hiScoreWin,back0_xpm,
				&pic,&picM,&attributes);
  handleXPMError(err,"hiscoreDLG back");
  
  XSetWindowBackgroundPixmap(display,hiScoreWin,pic);
  XClearArea(display,hiScoreWin,0,0,dHiScoreWidth,dHiScoreHeight,False);

  /****	   draw HiScore name	***/

  draw_hiscore(hiScoreWin);
    
  /****	Dialog	Event	Loop	***/
  
  nowDataRec.nowMap.nowTime.tv_sec  = 0;
  nowDataRec.nowMap.nowTime.tv_usec = 0;

  while(flg)
    {
      countTime();

      XNextEvent(display,&event);
      switch(event.type)
	{
	case Expose:
	  draw_hiscore(hiScoreWin);
	  reDraw(&event);
	  break;

	case ButtonPress:
	  flg = !handleHiScoreButton(&event);
	  break;
	}

      if(gameMainFlg.demoFlg)
	if(nowDataRec.nowMap.nowTime.tv_sec > 5)
	  flg = False;
    }

  gameMainFlg.demoFlg = False;

  XpmFreeAttributes(&attributes);
  XFreePixmap(display,pic);

  XUnmapWindow(display,hiScoreWin);
  XDestroyWindow(display,hiScoreWin);
	  
}


void checkdir(dirname,fname,fflag)
     char    *dirname;
     str32   *fname;
     char    *fflag;
{
  DIR           *dp;
  struct direct *dir;
  struct stat   sbuf;
  char          newname[256];
  register      i = 0;
    
  if((dp = opendir(dirname))==NULL)
    {
      fprintf(stderr,"XDeBlock: cannot open directory [%s]\n",
	      dirname);
      exit(1);
    }

  while((dir = readdir(dp)) != NULL)
    {
      if(dir->d_ino == 0)
	continue;

      sprintf(newname,"%s/%s",dirname,dir->d_name);
      stat(newname,&sbuf);

      switch(sbuf.st_mode & S_IFMT)
	{
	case S_IFREG:
	  if(strstr(dir->d_name,".mapf")==NULL)
	    break;
	  strcpy(fname[i],dir->d_name);
	  fflag[i] = dNORMAL;
	  fflag[i+1]= 0x00;
	  if(i++ > 30){
	    closedir(dp);
	    return;}

	  break;
	case S_IFDIR:
	case S_IFLNK:
	  sprintf(newname,"%s/",dir->d_name);
	  strcpy(fname[i],newname);
	  fflag[i] = dDIR;
	  fflag[i+1]= 0x00;
	  if(i++ > 30){
	    closedir(dp);
	    return;}
	      
	  break;
	}
    }
  
  closedir(dp);
}  

void handleSelectMap(win,fname,fflag,x,y,num,push)
     Window win;
     str32  *fname;
     char   *fflag;
     short  x,y;
     int    *num,push;
{
  register     i,j,k;
  XRectangle   box;

  for(i^=i,j =-1,k^=k;fflag[i] != 0;i++)
    {
     (i % 2)?j:(j++);
     (i % 2)?(k++):(k^=k);
     setRect(&box,18 +210*k,68 +40*j,200,35);

     if(ptInRect(&box,x,y))
       {
	 if(i == *num)
	   {
	     /****   draw box    ****/  
	     XSetForeground(display,gc,white.pixel);
	     XDrawRectangles(display,win,gc,&box,1);
	   }
	 else
	   {
	     /****   clear box   ****/
	     j = *num/2;
	     (*num % 2)?(k=1):(k^=k);
	     XClearArea(display,win,18 +210*k,68+40*j,204,38,False);
	     drawShadowText(display,win,20 +210*k ,70 +40*j,fname[*num],
			    white.pixel);

	     /****   draw box    ****/
	     XSetForeground(display,gc,white.pixel);
	     XDrawRectangles(display,win,gc,&box,1);

	     *num = i;
	   }
	 
	 
       }
   }
}

void handleMapButton(win,fname,fflag,num,event)
     XButtonEvent *event;
     Window       win;
     str32        *fname;
     char         *fflag;
     int          *num;
{
 switch(event->button)
    {
    case Button1:
      handleSelectMap(win,fname,fflag,event->x,event->y,num,True);
  
    case Button2:
      break;
    case Button3:
      *num = -1;
      break;
    }
}

void handleMapMotion(win,fname,fflag,num,event)
     XPointerMovedEvent *event;
     Window             win;
     str32              *fname;
     char               *fflag;
     int                *num;
{

  handleSelectMap(win,fname,fflag,event->x,event->y,num,False);

}

void draw_dir(win,fname,fflag)
     Window   win;
     str32    *fname;
     char     *fflag;
{
  register    i,j,k;
		  
  XClearArea(display,win,0,45,
	     dSelectWidth,dSelectHeight,False);
		
  drawShadowText(display,win,150,20,
		 "Select Map file ...",white.pixel);

  drawMiniText(display,win,150,460,
	       "Press Mapfile to end.",white.pixel);

  for(i^=i,j =-1,k^=k;fflag[i] != 0;i++)
    {
      (i % 2)?j:(j++);
      (i % 2)?(k++):(k^=k);
      drawShadowText(display,win,20 +210*k ,70 + 40*j,
		     fname[i],white.pixel);
    }
}

int selectFileDLG(void)
{
  register     	i,j,k;
  long	      	color;
  int           flg = True,num = 0,ret = True,err;
  char          fflag[32],now_dir[256];
  str32         fname[32],tempBuf;
  Window        selectWin;
  XEvent        event;
  XpmAttributes attributes;
  static Pixmap pic,picM;


  /****	  set window	***/
  selectWin = XCreateSimpleWindow(display,mWin,
				  (dWinWidth-dSelectWidth)/2,
				  (dWinHeight-dSelectHeight)/2,
				  dSelectWidth,dSelectHeight,1,
				  black.pixel,white.pixel);
		    
  XSelectInput(display,selectWin,ButtonPressMask |
	       PointerMotionMask | ExposureMask);
  XStoreName(display,selectWin,"XDeBlock Map select");
  XMapWindow(display,selectWin);

  /***	set Dialog	***/

  attributes.valuemask = XpmColormap;
  attributes.colormap = cmap;

  err = XpmCreatePixmapFromData(display,selectWin,back0_xpm,
				&pic,&picM,&attributes);
  handleXPMError(err,"selectmapDLG back");
  
  XSetWindowBackgroundPixmap(display,selectWin,pic);
  XClearArea(display,selectWin,0,0,dSelectWidth,dSelectHeight,False);

  /****  set current dir  ****/

  if(nowDataRec.nowMap.dirname[0] == 0)
    strcpy(now_dir,"./mapf");
  else
    strcpy(now_dir,nowDataRec.nowMap.dirname);

  /****   check dir   ****/	

  checkdir(now_dir,fname,fflag);
  draw_dir(selectWin,fname,fflag);

  /****	Dialog	Event	Loop	***/
  
  while(flg)
    {
      XNextEvent(display,&event);
      
      switch(event.type)
	{
	case Expose:
	  draw_dir(selectWin,fname,fflag);
	  reDraw(&event);
	  break;

	case ButtonPress:
	  handleMapButton(selectWin,fname,fflag,&num,&event);
	  if(num > 0)
	    {
	      sprintf(now_dir,"%s/%s",now_dir,fname[num]);
	      if(now_dir[strlen(now_dir)-1] == '/')
		{
		  now_dir[strlen(now_dir)-1] = 0x00;
		  checkdir(now_dir,fname,fflag);
		  draw_dir(selectWin,fname,fflag);

		  num = i-1;
		}
	      else
		{
		  strcpy(nowDataRec.nowMap.filename,now_dir);
		  flg = False;
		}
	    }
	  else if(num == -1)
	    flg = ret = False;

	  break;
	case MotionNotify:
	  handleMapMotion(selectWin,fname,fflag,&num,&event);
	  break;
	}
    }

  XpmFreeAttributes(&attributes);
  XFreePixmap(display,pic);

  XUnmapWindow(display,selectWin);
  XDestroyWindow(display,selectWin);

  return(ret);
}
