.\" $Id: xclip.man,v 1.16 2001/12/17 06:14:40 kims Exp $
.\"
.\" xclip.man - xclip manpage
.\" Copyright (C) 2001 Kim Saunders
.\"
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\" You should have received a copy of the GNU General Public License
.\" along with this program; if not, write to the Free Software
.\" Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
.\"
.TH XCLIP 1 
.SH NAME
xclip \- command line interface to X selections (clipboard)
.SH SYNOPSIS
.B xclip
[OPTION] [FILE]...
.SH DESCRIPTION
Reads from standard in, or from one or more files, and makes the data available as an X selection for pasting into X applications. Prints current X selection to standard out.
.TP
\fB\-i\fR, \fB\-in\fR
read text into X selection from standard input or files (default)
.TP
\fB\-o\fR, \fB\-out\fR
prints the selection to standard out (generally for piping to a file or program)
.TP
\fB\-f\fR, \fB\-filter\fR
when xclip is invoked in the in mode with output level set to silent (the defaults), the filter option will cause xclip to print the text piped to standard in back to standard out unmodified
.TP
\fB\-l\fR, \fB\-loops\fR
number of X selection requests (pastes into X applications) to wait for before exiting, with a value of 0 (default) causing xclip to wait for an unlimited number of requests until another application (possibly another invokation xclip) takes ownership of the selection
.TP
\fB\-d\fR, \fB\-display\fR
X display to use (e.g. "localhost:0"), xclip defaults to the value in $\fBDISPLAY\fR if this option is omitted
.TP
\fB\-h\fR, \fB\-help\fR
show quick summary of options
.TP
\fB\-selection\fR
specify which X selection to use, options are "primary" to use XA_PRIMARY (default), "secondary" for XA_SECONDARY or "clipboard" for XA_CLIPBOARD
.TP
\fB\-version\fR
show version information
.TP
\fB\-silent\fR
forks into the background to wait for requests, no informational output, errors only (default)
.TP
\fB\-quiet\fR
show informational messages on the terminal and run in the foreground
.TP
\fB\-verbose\fR
provide a running commentary of what xclip is doing

.PP
xclip reads text from standard in or files and makes it available to other X applications for pasting as an X selection (traditionally with the middle mouse button). It reads from all files specified, or from standard in if no files are specified. xclip can also print the contents of a selection to standard out with the
.B
-o
option.

xclip was designed to allow tighter integration of X applications and command line programs. The default action is to silently wait in the background for X selection requests (pastes) until another X application places data in the clipboard, at which point xclip exits silently. You can use the \fB\-verbose\fR option to see if and when xclip actually recieves selection requests from other X applications.

Options can be abreviated as long as they remain unambiguous. For example, it is possible to use \fB\-d\fR or \fB\-disp\fR instead of \fB\-display\fR. However, \fB\-v\fR couldn't be used because it is ambiguous (it could be short for \fB\-verbose\fR or \fB\-version\fR), so it would be interpreted as a filename.

Note that only the first character of the selection specified with the \fB\-selection\fR option is important. This means that "p", "sec" and "clip" would have the same effect as using "primary", "secondary" or "clipboard" respectively.

.SH EXAMPLES
.PP
I hate man pages without examples!

.B
uptime | xclip
.PP
Put your uptime in the X selection. Then middle click in an X application to paste.

.B xclip -loops 10 -verbose /etc/motd
.PP
Exit after /etc/motd (message of the day) has been pasted 10 times. Show how many selection requests (pastes) have been processed.

.B xclip -o > helloworld.c
.PP
Put the contents of the selection into a file.

.SH ENVIRONMENT
.TP
.SM
\fBDISPLAY\fR
X display to use if none is specified with the
.B
-display
option.

.SH REPORTING BUGS
Please report any bugs, problems, queries, experiences, etc. directly to the author.

.SH AUTHOR
Kim Saunders <kims@debian.org>
.br
