using System;
using System.Windows.Forms;

namespace XCircuitTest
{
	public class ZoomTest : Form
	{
		private TextBox zoomtxt = null;

		public ZoomTest()
		{
			System.Drawing.Size sz = new System.Drawing.Size(200,200);
			ClientSize = sz;
			FormBorderStyle = FormBorderStyle.FixedSingle;
			Text = "Zoom .NET Control";

			Button zoomin = new Button();
			zoomin.Text = "Zoom In";
			zoomin.Top = 10;
			zoomin.Left = 10;
			zoomin.Width = sz.Width-20;
			zoomin.Click += new EventHandler(ZoomInClicked);
			this.Controls.Add(zoomin);

			Button zoomout = new Button();
			zoomout.Text = "Zoom Out";
			zoomout.Top = zoomin.Bottom+10;
			zoomout.Left = zoomin.Left;
			zoomout.Width = zoomin.Width;
			zoomout.Click += new EventHandler(ZoomOutClicked);
			this.Controls.Add(zoomout);

			Button zoomview = new Button();
			zoomview.Text = "Zoom To View";
			zoomview.Top = zoomout.Bottom+10;
			zoomview.Left = zoomin.Left;
			zoomview.Width = zoomin.Width;
			zoomview.Click += new EventHandler(ZoomViewClicked);
			this.Controls.Add(zoomview);

			Label zoomlab = new Label();
			zoomlab.AutoSize = true;
			zoomlab.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			zoomlab.Text = "Zoom:";
			zoomlab.Left = zoomin.Left;
			zoomlab.Top = zoomview.Bottom+20;
			this.Controls.Add(zoomlab);

			Button zoomapply = new Button();
			zoomapply.Text = "Apply";
			zoomapply.Left = sz.Width-10-zoomapply.Width;
			zoomapply.Top = zoomlab.Top;
			zoomapply.Click += new EventHandler(ZoomTxtChanged);
			this.Controls.Add(zoomapply);

			zoomtxt = new TextBox();
			zoomtxt.Left = zoomlab.Right+10;
			zoomtxt.Width = zoomapply.Left-zoomtxt.Left-10;
			zoomtxt.Top = zoomlab.Top;
			zoomtxt.Click += new EventHandler(UpdateZoomTxt);
			this.Controls.Add(zoomtxt);
			UpdateZoomTxt(null, null);

			zoomlab.Top += (zoomapply.Height-zoomlab.Height)/2;
			zoomtxt.Top += (zoomapply.Height-zoomtxt.Height)/2;

			XCircuit.Application.ZoomChanged += new EventHandler(ZoomChanged);
		}

		protected override void OnClosed(EventArgs e)
		{
			XCircuit.Application.ZoomChanged -= new EventHandler(ZoomChanged);
			base.OnClosed(e);
		}

		private void ZoomInClicked(object sender, EventArgs args)
		{
			XCircuit.Application.ZoomIn();
		}

		private void ZoomOutClicked(object sender, EventArgs args)
		{
			XCircuit.Application.ZoomOut();
		}

		private void ZoomViewClicked(object sender, EventArgs args)
		{
			XCircuit.Application.Zoom = "auto";
		}

		private void ZoomTxtChanged(object sender, EventArgs args)
		{
			XCircuit.Application.Zoom = (float)Single.Parse(zoomtxt.Text);
		}

		private void UpdateZoomTxt(object sender, EventArgs args)
		{
			zoomtxt.Text = XCircuit.Application.Zoom.ToString();
		}

		private void ZoomChanged(object sender, EventArgs args)
		{
			Console.WriteLine("Zoom changed");
			UpdateZoomTxt(null, null);
		}

		public static void XC_init()
		{
			ZoomTest zt = new ZoomTest();
			zt.Show();
		}
	}
}
