#ifndef _CELL_H
#define _CELL_H

#include "utils.h"
#include "data.h"
#include "bubble.h"

typedef enum { 
  EAST=0, 
  NORTH_EAST, 
  NORTH_WEST, 
  WEST,
  SOUTH_WEST, 
  SOUTH_EAST 
} Quadrant;

#define NB_CELLS       ( COLS * ROWS )
#define EMPTY_CELL     NULL
#define OUT_OF_BOUNDS  -1
#define ROW_HEIGHT     0.8660254037844386 /* sqrt(3)/2 */

struct _CellArray {
  Bubble cell[NB_CELLS];
  int tagged[NB_CELLS];
  int first_row, parity, moving_ceiling;
};

typedef struct _CellArray * CellArray;

#define row_start(A,R)    ((( 1 - A->parity )/2 + R )%2 )
#define first_cell(A)     ( A->first_row*COLS )
#define ceiling_y(A)      ( 0.5 + A->first_row*ROW_HEIGHT )
#define cell_y(C)         (( (C)/COLS )*ROW_HEIGHT + 0.5 )
#define is_not_empty(A,C) (( C != OUT_OF_BOUNDS )&&( A->cell[C] != EMPTY_CELL))

CellArray new_cell_array( int moving_ceiling );
void delete_cell_array( CellArray ca );
void empty_cell_array( CellArray ca );
int cellCL( CellArray ca, int row, int col );
int floating_cell( CellArray ca, int c );
int neighbor_cell( CellArray ca, int cell, Quadrant quadrant );
void cell_center( CellArray ca, int cell, double *x, double *y);
int target_cell( CellArray ca, double x, double y, double vx, double vy, 
		 double * target_y, Vector path );
int find_random_empty_cell( CellArray ca );
int cell_array_overflow( CellArray ca );
int cell_array_empty( CellArray ca );
void lower_cell_array( CellArray ca );
int count_floating_cells( CellArray ca, Vector floating );
int count_explosive_bubbles( CellArray ca, int cell, Set explosive, 
			     Vector explosive_depth );
 
#endif /* _CELL_H */


