//////////////////////////////////////////////////////////////////////////////
// Name:        svgview.cpp
// Purpose:     
// Author:      Alex Thuering
// Created:     15/01/2005
// RCS-ID:      $Id: svgui-test.cpp,v 1.5 2008/07/07 10:20:56 etisserant Exp $
// Copyright:   (c) Alex Thuering
// Licence:     wxWindows licence
//////////////////////////////////////////////////////////////////////////////

#if defined(__GNUG__) && !defined(__APPLE__)
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#include <wx/filename.h>
#endif

#ifndef __WXMSW__
#include <locale.h>
#endif

#include "svgui-test.h"
#include <wxSVG/svg.h>

//////////////////////////////////////////////////////////////////////////////
///////////////////////////////  Application /////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

IMPLEMENT_APP(SVGViewApp)

bool SVGViewApp::OnInit()
{
#ifndef __WXMSW__
  setlocale(LC_NUMERIC, "C");
#endif
  //wxLog::SetActiveTarget(new wxLogStderr);
  
  new MainFrame(NULL, wxT("SVG Viewer"),
  wxDefaultPosition, wxSize(500, 400));
  return true;
}

//////////////////////////////////////////////////////////////////////////////
////////////////////////////////  MainFrame //////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
enum
{
wxID_FIT = 1,
};

BEGIN_EVENT_TABLE(MainFrame, wxFrame)
  EVT_MENU(wxID_EXIT, MainFrame::OnExit)
END_EVENT_TABLE()

BEGIN_EVENT_TABLE(MySVGCanvas, SVGUIWindow)
  EVT_BUTTON (SVGUIID("bouton1"), MySVGCanvas::OnBouton1LeftDown)
  EVT_BUTTON (SVGUIID("bouton2"), MySVGCanvas::OnBouton2LeftDown)
  EVT_COMMAND_SCROLL_THUMBTRACK(SVGUIID("scrollbar"), MySVGCanvas::OnScrollBarChanged)
END_EVENT_TABLE()


MainFrame::MainFrame(wxWindow *parent, const wxString& title, const wxPoint& pos,
  const wxSize& size, long style): wxFrame(parent, wxID_ANY, title, pos, size, style)
{
  // Make a menubar
  wxMenu *fileMenu = new wxMenu;
  fileMenu->Append(wxID_EXIT, wxT("&Close"));
  
  wxMenuBar *menuBar = new wxMenuBar;
  menuBar->Append(fileMenu, wxT("&File"));
  SetMenuBar(menuBar);

  wxFileName apppath(wxTheApp->argv[0]);
  apppath.RemoveLastDir();
  wxFileName svgfilepath(apppath.GetPath(), wxT("svgui-test.svg"));
  wxFileName xmlfilepath(apppath.GetPath(), wxT("svgui-test.xml"));
  
  m_svgCtrl = new MySVGCanvas(this);
  if (wxTheApp->argc > 1)
    m_svgCtrl->LoadFiles(wxTheApp->argv[1],wxTheApp->argv[2]);
  else
    m_svgCtrl->LoadFiles(svgfilepath.GetFullPath(), xmlfilepath.GetFullPath());
  
  m_svgCtrl->InitScrollBar(0, 5, 10);
  Show(true);
  m_svgCtrl->Update();
}

void MainFrame::OnExit(wxCommandEvent& WXUNUSED(event))
{
  Close(true);
}

MySVGCanvas::MySVGCanvas(wxWindow* parent):
 SVGUIWindow(parent)
{
}

void MySVGCanvas::InitScrollBar(unsigned int position, unsigned int thumb, unsigned int range)
{
  SVGUIScrollBar* scrollbar = (SVGUIScrollBar*)GetElementByName(wxT("scrollbar"));
  scrollbar->Init_ScrollBar(position, thumb, range);
}

void MySVGCanvas::OnBouton1LeftDown(wxCommandEvent& event)
{
  SVGUITextCtrl* text = (SVGUITextCtrl*)GetElementByName(wxT("text1"));
  text->SetValue(wxT("Text with space"));
  event.Skip();
}

void MySVGCanvas::OnBouton2LeftDown(wxCommandEvent& event)
{
  SVGUITextCtrl* text = (SVGUITextCtrl*)GetElementByName(wxT("text2"));
  text->SetValue(wxT("Essai"));
  event.Skip();
}

void MySVGCanvas::OnScrollBarChanged(wxScrollEvent& event)
{
  SVGUIScrollBar* scrollbar = (SVGUIScrollBar*)GetElementByName(wxT("scrollbar"));
  SVGUITextCtrl* text = (SVGUITextCtrl*)GetElementByName(wxT("text3"));
  text->SetValue(wxString::Format(wxT("%d"), scrollbar->GetThumbPosition()));
  Update();
  event.Skip();
}
