//////////////////////////////////////////////////////////////////////////////
// Name:        calculette.h
// Purpose:     Application to make simple operations
// Author:      Laurent Bessard
// Created:     2005/05/09
// RCS-ID:      $Id: calculette.h,v 1.8 2008/04/10 17:37:19 etisserant Exp $
// Copyright:   (c) Laurent Bessard
// Licence:     wxWindows licence
//////////////////////////////////////////////////////////////////////////////

#ifndef CALCULETTE_H
#define CALCULETTE_H

#include <wx/wx.h>
#include <wxSVG/svgctrl.h>
#include <wxSVGXML/svgxml.h>
#include <wxSVG/SVGUIWindow.h>
#include <wxSVG/SVGUIButton.h>
#include <wxSVG/SVGUITextCtrl.h>
#include <wxSVG/SVGUIScrollBar.h>
#include "math.h"

class SVGViewApp: public wxApp
{
  public:
    bool OnInit();
};

enum OPERATION_TYPE
{
  NO = 0,
  PLUS = 1,
  MOINS = 2,
  MULTIPLIER = 3,
  DIVISER = 4
};

class Calculette: public SVGUIWindow
{
  public:
    Calculette(wxWindow* parent);
    wxWindow* CreateWindow(const wxString& classname);
    
    void OnBoutonACClick(wxCommandEvent& event);
    void OnChar(wxKeyEvent& event);
    void SetNombreValue(const wxString value);
    void Calculer();
    void Erase();
    void Error();
    
    // Num panel functions
    void OnBouton0Click(wxCommandEvent& event);
    void OnBouton1Click(wxCommandEvent& event);
    void OnBouton2Click(wxCommandEvent& event);
    void OnBouton3Click(wxCommandEvent& event);
    void OnBouton4Click(wxCommandEvent& event);
    void OnBouton5Click(wxCommandEvent& event);
    void OnBouton6Click(wxCommandEvent& event);
    void OnBouton7Click(wxCommandEvent& event);
    void OnBouton8Click(wxCommandEvent& event);
    void OnBouton9Click(wxCommandEvent& event);
    void OnBoutonPlusClick(wxCommandEvent& event);
    void OnBoutonMoinsClick(wxCommandEvent& event);
    void OnBoutonMultiplierClick(wxCommandEvent& event);
    void OnBoutonDiviserClick(wxCommandEvent& event);
    void OnBoutonPointClick(wxCommandEvent& event);
    void OnBoutonEgalClick(wxCommandEvent& event);
    
    // Trigo panel functions
    void RefreshTrigoValues();
    void OnBoutonCosClick(wxCommandEvent& event);
    void OnBoutonSinClick(wxCommandEvent& event);
    void OnBoutonTanClick(wxCommandEvent& event);
    void OnBoutonAnglePlusClick(wxCommandEvent& event);
    void OnBoutonAngleMoinsClick(wxCommandEvent& event);
    void OnCercleTrigoChanged(wxScrollEvent& event);

private:

    bool m_first_key;
    double m_result;
    int m_operation;
  
    DECLARE_EVENT_TABLE()
};

class MainFrame: public wxFrame
{
  public:
    MainFrame(wxWindow *parent, const wxString& title, const wxPoint& pos,
      const wxSize& size, long style = wxDEFAULT_FRAME_STYLE);

  protected:
    Calculette* m_svgCtrl;
};

#endif //CALCULETTE_H
