/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Exadel Inc - additional implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.sqlscrapbook.actions;

import java.sql.Connection;
import java.util.Iterator;
import java.util.Vector;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.sqlscrapbook.SqlscrapbookPlugin;
import org.eclipse.wst.rdb.internal.sqlscrapbook.wizards.NewSQLScrapbookFileCreationWizard;
import org.eclipse.wst.rdb.server.internal.ui.services.IServicesManager;

/**
 * Action for creating folder resources in the project explorer.
 */
public class SQLScrapbookAction implements IViewActionDelegate {

    public static final String ID = "com.ibm.datatools.sqlscrapbook.actions.SQLScrapbookAction";
    
    public static int extNumber = 0;
    Vector selectionVector;
    IStructuredSelection selection;

    public SQLScrapbookAction() {
        selectionVector = new Vector();
    }

    /**
     * The user has invoked this action
     */
    public void run(IAction action) {
        try {
            String title = getScrapbookName();

            ConnectionInfo connectionInfo = null;

            if (!this.selection.isEmpty()) {
                Iterator iter = this.selection.iterator();
                Object selectedObj = iter.next();
                if (selectedObj instanceof ConnectionInfo) {
                    connectionInfo = (ConnectionInfo) selectedObj;
                } else if (selectedObj instanceof Database) {
                    Database database = (Database) selectedObj;
                    connectionInfo = ((IConnectionNode) IServicesManager.INSTANCE
                            .getServerExplorerNavigationService().getParent(
                                    database)).getConnectionInfo();
                }
            }

            // tau 04.07.04
            // Create the wizard

            NewSQLScrapbookFileCreationWizard wizard = new NewSQLScrapbookFileCreationWizard();
            wizard.setConnectionInfo(connectionInfo);       
            // Create the wizard dialog
            WizardDialog dialog = new WizardDialog(SqlscrapbookPlugin.getActiveWorkbenchShell(), wizard);
            // Open the wizard dialog
            
            if (dialog.open() == WizardDialog.OK) {
                // System.out.println("SQLpage was created!");
            } else {
                // System.out.println("SQLpage was not created!");
            }


			//Connection connection = null;
            if (connectionInfo != null) {
                title = title + " (" + connectionInfo.getName() + " - " + connectionInfo.getDatabaseName() + ")";
				//connection = connectionInfo.getSharedConnection();				
            }

			/*
            SqlscrapbookPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(new SQLScrapbookEditorInput(null, connection),
                    "org.eclipse.wst.rdb.sqleditor.SQLEditor"); // org.eclipse.wst.rdb.internal.sqlscrapbook.views.SQLScrapbookEditor");
            */
        } catch (Exception e) {
            System.out.println("\nException: " + e);
        }
    }

    public String getScrapbookName() {
        return SqlscrapbookPlugin.getResourceString("SQLScrapbookAction.SCRAPBOOK_TITLE") + Integer.toString(++extNumber);
    }

    private Vector getAllEditors() {
        Vector editorVector = new Vector();
        IWorkbench workbench = SqlscrapbookPlugin.getDefault().getWorkbench();
        IWorkbenchWindow windows[] = workbench.getWorkbenchWindows();

        for (int i = 0; i < windows.length; i++) {
            IWorkbenchPage pages[] = windows[i].getPages();

            for (int j = 0; j < pages.length; j++) {
                WorkbenchPage page = (WorkbenchPage) pages[j];
                IEditorPart editors[] = page.getDirtyEditors();

                for (int k = 0; k < editors.length; k++) {
                    editorVector.addElement(editors[k]);
                }
            }
        }

        return editorVector;
    }

    /**
     * Returns the action ID.
     */
    public String getID() {
        return ID;
    }

    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        selectionVector.removeAllElements();
        selectionVector.add(connectionInfo);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        /*
         * IStructuredSelection structuredSelection = null; if (selection
         * instanceof IStructuredSelection) { structuredSelection =
         * (IStructuredSelection) selection; action.setEnabled(false); Object
         * element = structuredSelection.getFirstElement(); if (element
         * instanceof Connection) { setConnection((Connection)element);
         * action.setEnabled(true); } }
         */
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection) selection;
        }
    }

    public void init(IViewPart view) {
        System.out.println(view.getTitle());
    }
	
	// add tau 10.03.2005
	public class SQLScrapbookEditorInput implements IEditorInput {
		private Connection connection;
		private String title;
	
		public SQLScrapbookEditorInput(String editorTitle, Connection connect) {
			title = editorTitle;
			connection = connect;
		}
	
		public Connection getRDBConnection() {
			return connection;		
		}
		
		public boolean exists() {		
			return false;
		}
	
		public String getName() {
			return title;
		}
	
		public IPersistableElement getPersistable() {
			return null;
		}
	
		public String getToolTipText() {
			return title;
		}
	
		public ImageDescriptor getImageDescriptor() {
			return null;
		}
	
		public Object getAdapter(Class adapter) {
			return null;
		}
	}

}

